/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.FontDataTable;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.tools.subsetter.TableSubsetter;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Subsetter {
    protected final Font font;
    private FontFactory fontFactory;
    protected Set<TableSubsetter> tableSubsetters;
    private Set<Integer> removeTables;
    private List<Integer> newToOldGlyphs;
    private List<CMapTable.CMapId> cmapIds;
    private Map<Integer, Integer> oldToNewGlyphs = null;

    protected Subsetter(Font font, FontFactory fontFactory) {
        this.font = font;
        this.fontFactory = fontFactory;
    }

    public void setGlyphs(List<Integer> list) {
        this.newToOldGlyphs = new ArrayList<Integer>(list);
    }

    public void setCMaps(List<CMapTable.CMapId> list, int n) {
        this.cmapIds = new ArrayList<CMapTable.CMapId>();
        CMapTable cMapTable = (CMapTable)this.font.getTable(Tag.cmap);
        if (cMapTable == null) {
            throw new InvalidParameterException("Font has no cmap table.");
        }
        for (CMapTable.CMapId cMapId : list) {
            CMap cMap = cMapTable.cmap(cMapId);
            if (cMap == null) continue;
            this.cmapIds.add(cMap.cmapId());
            if (--n > 0) continue;
            break;
        }
        if (this.cmapIds.size() == 0) {
            this.cmapIds = null;
            throw new InvalidParameterException("CMap Id settings would generate font with no cmap sub-table.");
        }
    }

    public void setRemoveTables(Set<Integer> set) {
        this.removeTables = new HashSet<Integer>(set);
    }

    public Font.Builder subset() throws IOException {
        Font.Builder builder = this.fontFactory.newFontBuilder();
        this.setUpTables(builder);
        TreeSet<Integer> treeSet = new TreeSet<Integer>(this.font.tableMap().keySet());
        if (this.removeTables != null) {
            treeSet.removeAll(this.removeTables);
        }
        for (TableSubsetter object : this.tableSubsetters) {
            boolean bl = object.subset(this, this.font, builder);
            if (!bl) continue;
            treeSet.removeAll(object.tagsHandled());
        }
        for (Integer n : treeSet) {
            Object t = this.font.getTable(n);
            if (t == null) continue;
            builder.newTableBuilder(n, ((FontDataTable)t).readFontData());
        }
        return builder;
    }

    List<Integer> glyphMappingTable() {
        return this.newToOldGlyphs;
    }

    Map<Integer, Integer> getInverseMapping() {
        if (this.oldToNewGlyphs == null) {
            this.oldToNewGlyphs = new HashMap<Integer, Integer>();
            List<Integer> list = this.glyphMappingTable();
            for (int i = 0; i < list.size(); ++i) {
                this.oldToNewGlyphs.put(list.get(i), i);
            }
        }
        return this.oldToNewGlyphs;
    }

    List<CMapTable.CMapId> cmapId() {
        return this.cmapIds;
    }

    protected void setUpTables(Font.Builder builder) {
    }
}

