/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.build;

import com.jpexs.helpers.utf8.Utf8Helper;
import com.jpexs.helpers.utf8.Utf8PrintWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LicenseUpdater {
    public static void main(String[] args) {
        LicenseUpdater.updateLicense();
    }

    public static void updateLicense() {
        LicenseUpdater.updateLicenseInDir(new File(".\\src\\"), false);
        LicenseUpdater.updateLicenseInDir(new File(".\\test\\"), false);
        LicenseUpdater.updateLicenseInDir(new File(".\\libsrc\\ffdec_lib\\src\\com\\"), true);
        LicenseUpdater.updateLicenseInDir(new File(".\\libsrc\\ffdec_lib\\test\\"), true);
    }

    public static void updateLicenseInDir(File dir, boolean lgpl) {
        File[] files;
        int defaultStartYear = 2010;
        int defaultFinalYear = 2026;
        String defaultAuthor = "JPEXS";
        String defaultYearStr = Integer.toString(defaultStartYear);
        if (defaultFinalYear != defaultStartYear) {
            defaultYearStr = defaultYearStr + "-" + defaultFinalYear;
        }
        String gplLicense = "/*\r\n *  Copyright (C) {year} {author}\r\n * \r\n *  This program is free software: you can redistribute it and/or modify\r\n *  it under the terms of the GNU General Public License as published by\r\n *  the Free Software Foundation, either version 3 of the License, or\r\n *  (at your option) any later version.\r\n * \r\n *  This program is distributed in the hope that it will be useful,\r\n *  but WITHOUT ANY WARRANTY; without even the implied warranty of\r\n *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\r\n *  GNU General Public License for more details.\r\n * \r\n *  You should have received a copy of the GNU General Public License\r\n *  along with this program.  If not, see <http://www.gnu.org/licenses/>.\r\n */";
        String lgplLicense = "/*\r\n *  Copyright (C) {year} {author}, All rights reserved.\r\n * \r\n * This library is free software; you can redistribute it and/or\r\n * modify it under the terms of the GNU Lesser General Public\r\n * License as published by the Free Software Foundation; either\r\n * version 3.0 of the License, or (at your option) any later version.\r\n * \r\n * This library is distributed in the hope that it will be useful,\r\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\r\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\r\n * Lesser General Public License for more details.\r\n * \r\n * You should have received a copy of the GNU Lesser General Public\r\n * License along with this library.\r\n */";
        String license = lgpl ? lgplLicense : gplLicense;
        for (File f : files = dir.listFiles()) {
            Throwable throwable;
            if (f.isDirectory()) {
                LicenseUpdater.updateLicenseInDir(f, lgpl);
                continue;
            }
            if (!f.getName().endsWith(".java") || f.getName().equals("package-info.java")) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Utf8PrintWriter pw = new Utf8PrintWriter((OutputStream)baos);
            try {
                throwable = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Utf8Helper.charset));){
                    String s;
                    boolean packageFound = false;
                    String author = defaultAuthor;
                    String yearStr = defaultYearStr;
                    while ((s = br.readLine()) != null) {
                        if (!packageFound) {
                            if (s.trim().startsWith("package")) {
                                packageFound = true;
                                pw.println(license.replace("{year}", yearStr).replace("{author}", author));
                            } else {
                                Matcher mAuthor = Pattern.compile(lgpl ? "^.*Copyright \\(C\\) ([0-9]+)(-[0-9]+)? (.*), All rights reserved.*" : "^.*Copyright \\(C\\) ([0-9]+)(-[0-9]+)? (.*)$").matcher(s);
                                if (mAuthor.matches()) {
                                    author = mAuthor.group(3).trim();
                                    int startYear = Integer.parseInt(mAuthor.group(1).trim());
                                    yearStr = startYear == defaultFinalYear ? Integer.toString(startYear) : Integer.toString(startYear) + "-" + defaultFinalYear;
                                    if (!author.equals(defaultAuthor)) {
                                        System.out.println("Detected nodefault author:" + author + " in " + f.getAbsolutePath());
                                    }
                                }
                            }
                        }
                        if (!packageFound) continue;
                        pw.println(s);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                pw.close();
            }
            catch (IOException br) {
                // empty catch block
            }
            try {
                throwable = null;
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));){
                    ((OutputStream)fos).write(baos.toByteArray());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

