/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.easygui.ConvolutionPreset;
import com.jpexs.decompiler.flash.easygui.EasyStrings;
import com.jpexs.decompiler.flash.easygui.properties.ConvolutionMatrixEditor;
import com.jpexs.decompiler.flash.easygui.properties.GradientEditor;
import com.jpexs.decompiler.flash.easygui.properties.PropertyEditor;
import com.jpexs.decompiler.flash.ecma.EcmaNumberToString;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.generictageditors.BooleanEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.ColorEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.FloatEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.NumberEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ValueNormalizer;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.filters.COLORMATRIXFILTER;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import com.jpexs.decompiler.flash.types.filters.ColorMatrixConvertor;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import de.javagl.treetable.JTreeTable;
import de.javagl.treetable.TreeTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DropMode;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FiltersTreeTable
extends JTreeTable {
    private List<ActionListener> filterChangedListeners = new ArrayList<ActionListener>();
    private boolean linkEnabled = true;

    public FiltersTreeTable() {
        super(new FiltersTreeTableModel(null));
        this.getTree().setCellRenderer(new FiltersTreeCellRenderer());
        this.getTree().setRootVisible(false);
        this.getTree().setShowsRootHandles(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int parentRow;
                TreePath path;
                int selectedRow = FiltersTreeTable.this.getSelectedRow();
                JTree tree = FiltersTreeTable.this.getTree();
                if (e.getKeyCode() == 37) {
                    TreePath parentPath;
                    path = tree.getPathForRow(selectedRow);
                    if (path != null && tree.isExpanded(path)) {
                        tree.collapsePath(path);
                        parentRow = tree.getRowForPath(path);
                        FiltersTreeTable.this.changeSelection(parentRow, 0, false, false);
                    } else if (path != null && (parentPath = path.getParentPath()) != null) {
                        int parentRow2 = tree.getRowForPath(parentPath);
                        FiltersTreeTable.this.changeSelection(parentRow2, 0, false, false);
                    }
                    e.consume();
                }
                if (e.getKeyCode() == 39) {
                    path = tree.getPathForRow(selectedRow);
                    if (path != null && !tree.isExpanded(path)) {
                        tree.expandPath(path);
                        parentRow = tree.getRowForPath(path);
                        FiltersTreeTable.this.changeSelection(parentRow, 0, false, false);
                    } else {
                        TreePath childPath = tree.getPathForRow(selectedRow + 1);
                        if (childPath != null) {
                            int childRow = tree.getRowForPath(childPath);
                            FiltersTreeTable.this.changeSelection(childRow, 0, false, false);
                        }
                    }
                    e.consume();
                }
            }
        });
        this.setSelectionMode(0);
        this.setUI(new BasicTableUI());
        this.setRowHeight(18);
        this.getTree().setRowHeight(18);
        if (View.isOceanic()) {
            this.setBackground(Color.WHITE);
            this.getTree().setBackground(Color.WHITE);
        }
        this.getTableHeader().setReorderingAllowed(false);
        this.setDragEnabled(true);
        this.setTransferHandler(new TreeTransferHandler());
        this.setDropMode(DropMode.INSERT_ROWS);
    }

    public void addFilterChangedListener(ActionListener l) {
        this.filterChangedListeners.add(l);
    }

    public void removeFilterChangedListener(ActionListener l) {
        this.filterChangedListeners.remove(l);
    }

    public void fireFilterChanged() {
        ArrayList<ActionListener> listeners2 = new ArrayList<ActionListener>(this.filterChangedListeners);
        for (ActionListener l : listeners2) {
            l.actionPerformed(new ActionEvent(this, 1001, "filterChanged"));
        }
    }

    public List<FILTER> getFilters() {
        TreeModel model = this.getTree().getModel();
        if (model instanceof FiltersTreeTableModel) {
            FiltersTreeTableModel treeTableModel = (FiltersTreeTableModel)model;
            return treeTableModel.filters;
        }
        return new ArrayList<FILTER>();
    }

    public void addFilter(FILTER filter) {
        TreeModel model = this.getTree().getModel();
        if (model instanceof FiltersTreeTableModel) {
            FiltersTreeTableModel treeTableModel = (FiltersTreeTableModel)model;
            treeTableModel.addFilter(filter);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeTableModel.getRoot();
            this.getTree().expandPath(new TreePath(new Object[]{root, root.getChildAt(root.getChildCount() - 1)}));
            this.updateColumns();
            this.fireFilterChanged();
        }
    }

    public void clearFilters() {
        TreeModel model = this.getTree().getModel();
        if (model instanceof FiltersTreeTableModel) {
            this.setTreeTableModel(new FiltersTreeTableModel(new ArrayList<FILTER>()));
            this.fireFilterChanged();
        }
    }

    public boolean isFilterSelected() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getTree().getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        return node.getUserObject() instanceof FilterName;
    }

    public FILTER getSelectedFilter() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getTree().getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (!(node.getUserObject() instanceof FilterName)) {
            return null;
        }
        FilterName filterName = (FilterName)node.getUserObject();
        return filterName.filter;
    }

    public void removeSelectedFilter() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getTree().getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object object = node.getUserObject();
        if (object instanceof FilterName) {
            final DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getTree().getModel().getRoot();
            int filterIndex = root.getIndex(node);
            FiltersTreeTableModel model = (FiltersTreeTableModel)this.getTree().getModel();
            model.removeFilter(filterIndex);
            if (--filterIndex < 0) {
                filterIndex = 0;
            }
            this.fireFilterChanged();
            if (filterIndex < root.getChildCount()) {
                Timer timer = new Timer();
                final int fFilterIndex = filterIndex;
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (root.getChildCount() > fFilterIndex) {
                            FiltersTreeTable.this.getTree().setSelectionPath(new TreePath(new Object[]{root, root.getChildAt(fFilterIndex)}));
                        }
                    }
                }, 50L);
            }
        }
    }

    private void updateColumns() {
        this.getColumnModel().getColumn(0).setMinWidth(200);
        this.getColumnModel().getColumn(0).setWidth(200);
        this.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.getColumnModel().getColumn(1).setPreferredWidth(Integer.MAX_VALUE);
        this.getColumnModel().getColumn(1).setCellEditor(new FiltersValueCellEditor(this));
        this.getColumnModel().getColumn(1).setCellRenderer(new FiltersTableCellRenderer());
    }

    public void setFilters(List<FILTER> filters) {
        if (Objects.equals(this.getFilters(), filters)) {
            return;
        }
        this.setTreeTableModel(new FiltersTreeTableModel(filters));
        TreeModel ttm = this.getTree().getModel();
        Object root = ttm.getRoot();
        int childCount = ttm.getChildCount(root);
        for (int i = 0; i < childCount; ++i) {
            this.getTree().expandPath(new TreePath(new Object[]{root, ttm.getChild(root, i)}));
        }
        this.updateColumns();
    }

    private static String valueToString(String fieldName, Object value) {
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                sb.append(FiltersTreeTable.valueToString(fieldName, element));
                if (i >= length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
        if (value.getClass() == RGBA.class) {
            RGBA rgb = (RGBA)value;
            return rgb.toHexARGB();
        }
        if (value.getClass() == RGB.class) {
            RGB rgb = (RGB)value;
            return rgb.toHexRGB();
        }
        if (fieldName.equals("angle")) {
            return "" + EcmaNumberToString.stringFor((double)((double)Math.round(Math.toDegrees((Double)value) * 100.0) / 100.0));
        }
        if (fieldName.equals("strength")) {
            return "" + EcmaNumberToString.stringFor((double)(((Float)value).floatValue() * 100.0f));
        }
        if (value.getClass() == Double.class || value.getClass() == Float.class || value.getClass() == Float.TYPE || value.getClass() == Double.TYPE) {
            return EcmaScript.toString((Object)value);
        }
        return "" + value;
    }

    private static class LinkedDefaultMutableTreeNode
    extends DefaultMutableTreeNode {
        private LinkedDefaultMutableTreeNode linkedNode;

        public LinkedDefaultMutableTreeNode(Object userObject) {
            super(userObject);
        }

        public void setLinkedNode(LinkedDefaultMutableTreeNode linkedNode) {
            this.linkedNode = linkedNode;
        }

        public LinkedDefaultMutableTreeNode getLinkedNode() {
            return this.linkedNode;
        }
    }

    private static class FiltersTreeTableModel
    implements TreeTableModel {
        private final DefaultMutableTreeNode root;
        private List<FILTER> filters;
        private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

        public FiltersTreeTableModel(List<FILTER> filters) {
            this.root = new DefaultMutableTreeNode("root");
            if (filters == null) {
                DefaultMutableTreeNode indeterminate = new DefaultMutableTreeNode(EasyStrings.translate("property.instance.filters.indeterminate"));
                this.root.add(indeterminate);
                this.filters = null;
                return;
            }
            this.filters = new ArrayList<FILTER>();
            for (FILTER filter : filters) {
                this.addFilter(filter);
            }
        }

        public void addFilter(FILTER filter) {
            this.addFilter(this.filters.size(), filter);
        }

        public void addFilter(int index, FILTER filter) {
            if (this.filters == null) {
                DefaultMutableTreeNode indeterminate = (DefaultMutableTreeNode)this.root.getChildAt(0);
                this.root.remove(0);
                this.filters = new ArrayList<FILTER>();
                for (TreeModelListener l : this.listeners) {
                    l.treeNodesRemoved(new TreeModelEvent((Object)this, new Object[]{this.root}, new int[]{0}, new Object[]{indeterminate}));
                }
            }
            DefaultMutableTreeNode filterNode = new DefaultMutableTreeNode(new FilterName(filter));
            this.root.insert(filterNode, index);
            Field[] fields = filter.getClass().getFields();
            LinkedDefaultMutableTreeNode lastLinkedNode = null;
            for (Field field : fields) {
                DefaultMutableTreeNode fieldNode;
                LinkedDefaultMutableTreeNode linkedNode;
                FilterField filterField;
                if ("id".equals(field.getName()) || "enabled".equals(field.getName()) || "gradientRatio".equals(field.getName()) || filter instanceof CONVOLUTIONFILTER && ("matrixX".equals(field.getName()) || "matrixY".equals(field.getName()))) continue;
                if (filter instanceof COLORMATRIXFILTER && "matrix".equals(field.getName())) {
                    filterField = new FilterField(filter, field, 1);
                    DefaultMutableTreeNode fieldNode2 = new DefaultMutableTreeNode(filterField);
                    filterNode.add(fieldNode2);
                    filterField = new FilterField(filter, field, 2);
                    fieldNode2 = new DefaultMutableTreeNode(filterField);
                    filterNode.add(fieldNode2);
                    filterField = new FilterField(filter, field, 3);
                    fieldNode2 = new DefaultMutableTreeNode(filterField);
                    filterNode.add(fieldNode2);
                    filterField = new FilterField(filter, field, 4);
                    fieldNode2 = new DefaultMutableTreeNode(filterField);
                    filterNode.add(fieldNode2);
                    continue;
                }
                Reserved reserved = field.getAnnotation(Reserved.class);
                if (reserved != null) continue;
                filterField = new FilterField(filter, field);
                if ("blurX".equals(field.getName())) {
                    fieldNode = linkedNode = new LinkedDefaultMutableTreeNode(filterField);
                    lastLinkedNode = linkedNode;
                } else if ("blurY".equals(field.getName())) {
                    fieldNode = linkedNode = new LinkedDefaultMutableTreeNode(filterField);
                    linkedNode.setLinkedNode(lastLinkedNode);
                    lastLinkedNode.setLinkedNode(linkedNode);
                } else {
                    fieldNode = new DefaultMutableTreeNode(filterField);
                }
                filterNode.add(fieldNode);
            }
            this.filters.add(index, filter);
            for (TreeModelListener l : this.listeners) {
                l.treeNodesInserted(new TreeModelEvent((Object)this, new Object[]{this.root}, new int[]{index}, new Object[]{filterNode}));
            }
        }

        public void removeFilter(int index) {
            this.filters.remove(index);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(index);
            this.root.remove(node);
            for (TreeModelListener l : this.listeners) {
                l.treeNodesRemoved(new TreeModelEvent((Object)this, new Object[]{this.root}, new int[]{index}, new Object[]{node}));
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return EasyStrings.translate("property.instance.filters.header.property");
                }
                case 1: {
                    return EasyStrings.translate("property.instance.filters.header.value");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return TreeTableModel.class;
                }
            }
            return String.class;
        }

        @Override
        public Object getValueAt(Object node, int column) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node;
            Object o = n.getUserObject();
            switch (column) {
                case 0: {
                    return node;
                }
                case 1: {
                    if (o instanceof FilterField) {
                        FilterField filterField = (FilterField)o;
                        return new FilterValue(filterField);
                    }
                    if (o instanceof FilterName) {
                        FilterName filterName = (FilterName)o;
                        if (filterName.filter instanceof CONVOLUTIONFILTER) {
                            ConvolutionPreset preset = ConvolutionPreset.getPresetOfFilter((CONVOLUTIONFILTER)filterName.filter);
                            if (preset == null) {
                                return "";
                            }
                            return preset;
                        }
                        return "";
                    }
                    return "";
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            if (column == 0) {
                return true;
            }
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node;
            return column == 1 && n.getUserObject() instanceof FilterField;
        }

        @Override
        public void setValueAt(Object value, Object node, int column) {
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((DefaultMutableTreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((DefaultMutableTreeNode)parent).getChildCount();
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((DefaultMutableTreeNode)node).isLeaf();
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return ((DefaultMutableTreeNode)parent).getIndex((DefaultMutableTreeNode)child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }
    }

    private static class FilterName {
        private final FILTER filter;

        public FilterName(FILTER filter) {
            this.filter = filter;
        }

        public String toString() {
            String filterName = this.filter.getClass().getSimpleName();
            filterName = filterName.substring(0, filterName.length() - "FILTER".length());
            return EasyStrings.translate("filter." + filterName.toLowerCase());
        }
    }

    private static class FilterValue {
        private final FilterField filterField;

        public FilterValue(FilterField filterField) {
            this.filterField = filterField;
        }

        public Object getValue() {
            return this.filterField.getValue();
        }

        public String toString() {
            return FiltersTreeTable.valueToString(this.filterField.getField().getName(), this.filterField.getValue());
        }
    }

    private static class FilterField {
        private final FILTER filter;
        private final Field field;
        private final int special;
        public static final int SPECIAL_BRIGHTNESS = 1;
        public static final int SPECIAL_CONTRAST = 2;
        public static final int SPECIAL_SATURATION = 3;
        public static final int SPECIAL_HUE = 4;

        public FilterField(FILTER filter, Field property) {
            this(filter, property, 0);
        }

        public FilterField(FILTER filter, Field property, int special) {
            this.filter = filter;
            this.field = property;
            this.special = special;
        }

        public int getSpecial() {
            return this.special;
        }

        public FILTER getFilter() {
            return this.filter;
        }

        public Field getField() {
            return this.field;
        }

        public Object getValue() {
            try {
                return this.field.get(this.filter);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                return null;
            }
        }

        public String getIdentifier() {
            switch (this.special) {
                case 1: {
                    return "brightness";
                }
                case 2: {
                    return "contrast";
                }
                case 3: {
                    return "saturation";
                }
                case 4: {
                    return "hue";
                }
            }
            if ("gradientColors".equals(this.field.getName())) {
                return "gradient";
            }
            return this.field.getName();
        }

        public String toString() {
            return EasyStrings.translate("property.instance.filters." + this.getIdentifier());
        }
    }

    private static class FiltersTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private FiltersTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object object = node.getUserObject();
                label.setText(object.toString());
                if (object instanceof FilterName) {
                    FilterName filterName = (FilterName)object;
                    if (!((FilterName)filterName).filter.enabled) {
                        label.setIcon(View.getIcon("cross16"));
                    }
                }
            }
            if (View.isOceanic()) {
                if (this.selected) {
                    label.setBackground(this.getBackgroundSelectionColor());
                } else {
                    label.setBackground(Color.white);
                }
                label.setOpaque(true);
            }
            return label;
        }
    }

    private static class FiltersTableCellRenderer
    extends DefaultTableCellRenderer {
        JLabel label = new JLabel();

        private FiltersTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.label.setText(value.toString());
            if (table instanceof JTreeTable) {
                JTreeTable treeTable = (JTreeTable)table;
                isSelected = treeTable.isRowSelected(row);
            }
            JComponent component = this.label;
            if (value instanceof FilterValue) {
                FilterValue filterValue = (FilterValue)value;
                String units = "";
                switch (filterValue.filterField.field.getName()) {
                    case "angle": {
                        units = " \u00b0";
                        break;
                    }
                    case "blurX": 
                    case "blurY": 
                    case "distance": {
                        units = " px";
                        break;
                    }
                    case "strength": {
                        units = " %";
                    }
                }
                Object fieldValue = filterValue.getValue();
                if (filterValue.filterField.special > 0) {
                    float[] matrix = (float[])fieldValue;
                    ColorMatrixConvertor convertor = new ColorMatrixConvertor(matrix);
                    switch (filterValue.filterField.special) {
                        case 1: {
                            this.label.setText("" + convertor.getBrightness());
                            break;
                        }
                        case 2: {
                            this.label.setText("" + convertor.getContrast());
                            break;
                        }
                        case 3: {
                            this.label.setText("" + convertor.getSaturation());
                            break;
                        }
                        case 4: {
                            this.label.setText("" + convertor.getHue());
                        }
                    }
                } else {
                    this.label.setText(value.toString() + units);
                }
                if (fieldValue != null) {
                    if ("matrix".equals(filterValue.filterField.field.getName()) && filterValue.filterField.filter instanceof CONVOLUTIONFILTER) {
                        component = new ConvolutionMatrixEditor((CONVOLUTIONFILTER)filterValue.filterField.filter);
                    }
                    if ("gradientColors".equals(filterValue.filterField.field.getName())) {
                        component = new GradientEditor(filterValue.filterField.filter);
                    }
                    if (fieldValue.getClass() == Boolean.class) {
                        JPanel panel = new JPanel(new BorderLayout());
                        JCheckBox checkBox = new JCheckBox();
                        checkBox.setSelected((Boolean)fieldValue);
                        checkBox.setOpaque(false);
                        panel.add((Component)checkBox, "Center");
                        panel.setOpaque(false);
                        component = panel;
                    }
                    if (fieldValue.getClass() == RGBA.class) {
                        component = new ColorEditor(filterValue.filterField.toString(), filterValue.filterField.filter, filterValue.filterField.field, -1, RGBA.class);
                        component.setToolTipText(AppStrings.translate("button.selectcolor.hint"));
                    }
                    if ("blurX".equals(filterValue.filterField.field.getName()) || "blurY".equals(filterValue.filterField.field.getName())) {
                        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
                        JLabel blurLabel = new JLabel(this.label.getText());
                        panel.add(blurLabel);
                        blurLabel.setPreferredSize(new Dimension(50, blurLabel.getPreferredSize().height));
                        blurLabel.setMaximumSize(blurLabel.getPreferredSize());
                        JLabel linkLabel = new JLabel(View.getIcon(((FiltersTreeTable)table).linkEnabled ? "link16" : "linkbreak16"));
                        panel.add(linkLabel);
                        component = panel;
                    }
                }
            }
            if (isSelected) {
                component.setForeground(new Color(UIManager.getColor("Table.selectionForeground").getRGB(), true));
                component.setBackground(new Color(UIManager.getColor("Table.selectionBackground").getRGB(), true));
                component.setOpaque(true);
            } else {
                component.setOpaque(false);
            }
            return component;
        }
    }

    private static class FiltersValueCellEditor
    implements TableCellEditor {
        private Object value;
        private PropertyEditor editor;
        private List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
        private final FiltersTreeTable filtersTable;

        public FiltersValueCellEditor(FiltersTreeTable filtersTable) {
            this.filtersTable = filtersTable;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof FilterValue)) {
                return null;
            }
            FilterValue filterValue = (FilterValue)value;
            Object realValue = filterValue.getValue();
            this.value = value;
            final FilterField filterField = filterValue.filterField;
            this.editor = null;
            if (filterField.special > 0) {
                this.editor = new NumberEditor(filterField.toString(), filterField.filter, filterField.field, -1, Integer.TYPE, new SWFType(){

                    public BasicType value() {
                        return BasicType.SI16;
                    }

                    public BasicType alternateValue() {
                        return null;
                    }

                    public String alternateCondition() {
                        return "";
                    }

                    public int count() {
                        return 0;
                    }

                    public String countField() {
                        return "";
                    }

                    public int countAdd() {
                        return 0;
                    }

                    public boolean canAdd() {
                        return false;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return SWFType.class;
                    }
                }){

                    @Override
                    protected void saveValue(Object newValue) {
                        float[] matrix = (float[])super.loadValue();
                        ColorMatrixConvertor convertor = new ColorMatrixConvertor(matrix);
                        switch (filterField.special) {
                            case 1: {
                                convertor.setBrightness(((Integer)newValue).intValue());
                                break;
                            }
                            case 2: {
                                convertor.setContrast(((Integer)newValue).intValue());
                                break;
                            }
                            case 3: {
                                convertor.setSaturation(((Integer)newValue).intValue());
                                break;
                            }
                            case 4: {
                                convertor.setHue(((Integer)newValue).intValue());
                            }
                        }
                        matrix = convertor.getMatrix();
                        super.saveValue(matrix);
                    }

                    @Override
                    protected Object loadValue() {
                        float[] matrix = (float[])super.loadValue();
                        ColorMatrixConvertor convertor = new ColorMatrixConvertor(matrix);
                        switch (filterField.special) {
                            case 1: {
                                return convertor.getBrightness();
                            }
                            case 2: {
                                return convertor.getContrast();
                            }
                            case 3: {
                                return convertor.getSaturation();
                            }
                            case 4: {
                                return convertor.getHue();
                            }
                        }
                        return 0;
                    }
                };
            } else if ("matrix".equals(filterField.field.getName()) && filterField.filter instanceof CONVOLUTIONFILTER) {
                this.editor = new ConvolutionMatrixEditor((CONVOLUTIONFILTER)filterField.filter);
            } else if ("gradientColors".equals(filterField.field.getName())) {
                this.editor = new GradientEditor(filterField.filter);
            } else if (realValue.getClass() == Boolean.class) {
                this.editor = new BooleanEditor(filterField.toString(), filterField.filter, filterField.field, -1, Boolean.class);
                this.editor.addChangeListener(new ChangeListener(){

                    @Override
                    public void change(PropertyEditor editor) {
                        this.stopCellEditing();
                    }

                    @Override
                    public void linkChanged(boolean newValue) {
                    }
                });
            } else if (realValue.getClass() == Double.class || realValue.getClass() == Float.class) {
                this.editor = new FloatEditor(filterField.toString(), filterField.filter, filterField.field, -1, realValue.getClass(), filterField.field.getAnnotation(SWFType.class));
                if ("strength".equals(filterField.field.getName())) {
                    ((FloatEditor)this.editor).setValueNormalizer(new ValueNormalizer(){

                        @Override
                        public Object toFieldValue(Object viewValue) {
                            return Float.valueOf(((Float)viewValue).floatValue() / 100.0f);
                        }

                        @Override
                        public Object toViewValue(Object fieldValue) {
                            return Float.valueOf(((Float)fieldValue).floatValue() * 100.0f);
                        }
                    });
                }
                if ("angle".equals(filterField.field.getName())) {
                    ((FloatEditor)this.editor).setValueNormalizer(new ValueNormalizer(){

                        @Override
                        public Object toFieldValue(Object viewValue) {
                            return Math.toRadians((Double)viewValue);
                        }

                        @Override
                        public Object toViewValue(Object fieldValue) {
                            return (double)Math.round(Math.toDegrees((Double)fieldValue) * 100.0) / 100.0;
                        }
                    });
                }
                if ("blurX".equals(filterField.field.getName())) {
                    try {
                        ((FloatEditor)this.editor).setLinkedField(filterField.filter.getClass().getField("blurY"));
                        ((FloatEditor)this.editor).setLinkEnabled(this.filtersTable.linkEnabled);
                    }
                    catch (NoSuchFieldException | SecurityException exception) {
                        // empty catch block
                    }
                }
                if ("blurY".equals(filterField.field.getName())) {
                    try {
                        ((FloatEditor)this.editor).setLinkedField(filterField.filter.getClass().getField("blurX"));
                        ((FloatEditor)this.editor).setLinkEnabled(this.filtersTable.linkEnabled);
                    }
                    catch (NoSuchFieldException | SecurityException exception) {}
                }
            } else if (realValue.getClass() == Integer.TYPE || realValue.getClass() == Integer.class) {
                this.editor = new NumberEditor(filterField.toString(), filterField.filter, filterField.field, -1, realValue.getClass(), filterField.field.getAnnotation(SWFType.class));
            } else if (realValue.getClass() == RGBA.class) {
                this.editor = new ColorEditor(filterField.toString(), filterField.filter, filterField.field, -1, RGBA.class);
            }
            if (this.editor != null) {
                this.editor.addChangeListener(new ChangeListener(){

                    @Override
                    public void change(PropertyEditor editor) {
                    }

                    @Override
                    public void linkChanged(boolean newValue) {
                        filtersTable.linkEnabled = newValue;
                        this.stopCellEditing();
                        filtersTable.repaint();
                    }
                });
                if (table instanceof JTreeTable) {
                    JTreeTable treeTable = (JTreeTable)table;
                    if (treeTable.isRowSelected(row)) {
                        ((JComponent)((Object)this.editor)).setForeground(new Color(UIManager.getColor("Table.selectionForeground").getRGB(), true));
                        ((JComponent)((Object)this.editor)).setBackground(new Color(UIManager.getColor("Table.selectionBackground").getRGB(), true));
                        ((JComponent)((Object)this.editor)).setOpaque(true);
                    } else {
                        ((JComponent)((Object)this.editor)).setOpaque(false);
                    }
                }
            }
            return (Component)((Object)this.editor);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (this.value == null) {
                return true;
            }
            if (!(this.value instanceof FilterValue)) {
                return false;
            }
            FilterValue filterValue = (FilterValue)this.value;
            Object realValue = filterValue.getValue();
            if (realValue.getClass() == Double.class || realValue.getClass() == Float.class) {
                return true;
            }
            if (filterValue.filterField.special > 0) {
                return true;
            }
            if (realValue.getClass() == Boolean.class) {
                return false;
            }
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            this.editor.save();
            this.filtersTable.fireFilterChanged();
            ArrayList<CellEditorListener> listeners2 = new ArrayList<CellEditorListener>(this.listeners);
            for (CellEditorListener l : listeners2) {
                l.editingStopped(new ChangeEvent(this.editor));
            }
            this.filtersTable.repaint();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            ArrayList<CellEditorListener> listeners2 = new ArrayList<CellEditorListener>(this.listeners);
            for (CellEditorListener l : listeners2) {
                l.editingCanceled(new ChangeEvent(this.editor));
            }
            this.editor.reset();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.remove(l);
        }
    }

    private static class TreeTransferHandler
    extends TransferHandler {
        private DataFlavor nodesFlavor;
        private DefaultMutableTreeNode[] nodesToRemove;

        public TreeTransferHandler() {
            try {
                String mimeType = "application/x-java-jvm-local-objectref;class=\"" + DefaultMutableTreeNode[].class.getName() + "\"";
                this.nodesFlavor = new DataFlavor(mimeType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDrop() && support.isDataFlavorSupported(this.nodesFlavor);
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTree tree = ((FiltersTreeTable)c).getTree();
            TreePath[] paths = tree.getSelectionPaths();
            if (paths == null) {
                return null;
            }
            DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                nodes[i] = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            }
            this.nodesToRemove = nodes;
            return new NodesTransferable(nodes);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            try {
                DefaultMutableTreeNode[] nodes;
                DefaultMutableTreeNode parent;
                JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
                int rowNum = dl.getRow();
                FiltersTreeTable filterTable = (FiltersTreeTable)support.getComponent();
                TreePath path = filterTable.getTree().getPathForRow(rowNum);
                DefaultMutableTreeNode rowNode = rowNum == -1 || path == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
                int childIndex = -1;
                if (rowNum > -1 && rowNode != null) {
                    childIndex = rowNode.getParent().getIndex(rowNode);
                }
                FiltersTreeTableModel model = (FiltersTreeTableModel)filterTable.getTree().getModel();
                DefaultMutableTreeNode defaultMutableTreeNode = parent = rowNode == null ? null : (DefaultMutableTreeNode)rowNode.getParent();
                if (parent != null && parent != model.getRoot()) {
                    return false;
                }
                parent = (DefaultMutableTreeNode)filterTable.getTree().getModel().getRoot();
                for (DefaultMutableTreeNode node : nodes = (DefaultMutableTreeNode[])support.getTransferable().getTransferData(this.nodesFlavor)) {
                    if (node.getUserObject() instanceof FilterName) continue;
                    return false;
                }
                for (DefaultMutableTreeNode node : nodes) {
                    boolean expanded = filterTable.getTree().isExpanded(new TreePath(new Object[]{parent, node}));
                    FILTER filter = ((FilterName)node.getUserObject()).filter;
                    int newChildIndex = childIndex == -1 ? parent.getChildCount() : childIndex++;
                    model.addFilter(newChildIndex, filter);
                    if (!expanded) continue;
                    filterTable.getTree().expandPath(new TreePath(new Object[]{parent, parent.getChildAt(newChildIndex)}));
                }
                return true;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                return false;
            }
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 2) {
                FiltersTreeTable filtersTable = (FiltersTreeTable)source;
                FiltersTreeTableModel model = (FiltersTreeTableModel)filtersTable.getTree().getModel();
                for (DefaultMutableTreeNode node : this.nodesToRemove) {
                    model.removeFilter(node.getParent().getIndex(node));
                }
                filtersTable.fireFilterChanged();
            }
        }

        public class NodesTransferable
        implements Transferable {
            DefaultMutableTreeNode[] nodes;

            public NodesTransferable(DefaultMutableTreeNode[] nodes) {
                this.nodes = nodes;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) {
                if (!this.isDataFlavorSupported(flavor)) {
                    return null;
                }
                return this.nodes;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{TreeTransferHandler.this.nodesFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return TreeTransferHandler.this.nodesFlavor.equals(flavor);
            }
        }
    }
}

