/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.easygui.EasySwfPanel;
import com.jpexs.decompiler.flash.easygui.FrameSelectionListener;
import com.jpexs.decompiler.flash.easygui.TimelineBodyPanel;
import com.jpexs.decompiler.flash.easygui.TimelineDepthPanel;
import com.jpexs.decompiler.flash.easygui.TimelineTimePanel;
import com.jpexs.decompiler.flash.easygui.UndoManager;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;

public class TimelinePanel
extends JPanel {
    private TimelineBodyPanel timelineBodyPanel;
    private TimelineTimePanel timePanel;
    private TimelineDepthPanel depthPanel;
    private Timeline timeline;
    private Timelined timelined;
    public static final int FRAME_WIDTH = 8;
    public static final int FRAME_HEIGHT = 18;
    private final JScrollPane timelineBodyScrollPane;

    public TimelinePanel(EasySwfPanel swfPanel, UndoManager undoManager) {
        this.timelineBodyPanel = new TimelineBodyPanel(swfPanel, undoManager);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.timelineBodyScrollPane = new FasterScrollPane(this.timelineBodyPanel);
        this.depthPanel = new TimelineDepthPanel();
        this.timelineBodyPanel.addChangeListener(new Runnable(){

            @Override
            public void run() {
                TimelinePanel.this.timeline = TimelinePanel.this.timelined.getTimeline();
                TimelinePanel.this.depthPanel.setTimeline(TimelinePanel.this.timeline);
                TimelinePanel.this.timePanel.setTimeline(TimelinePanel.this.timeline);
            }
        });
        this.timePanel = new TimelineTimePanel(this.depthPanel);
        gbc.anchor = 21;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.timePanel, gbc);
        gbc.anchor = 23;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this.depthPanel, gbc);
        gbc.anchor = 23;
        ++gbc.gridx;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.timelineBodyScrollPane, gbc);
        this.timelineBodyScrollPane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                TimelinePanel.this.timePanel.scroll(e.getValue());
            }
        });
        this.timelineBodyScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                TimelinePanel.this.depthPanel.scroll(e.getValue());
            }
        });
        final TimelineTimePanel ftime = this.timePanel;
        this.timelineBodyPanel.addFrameSelectionListener(new FrameSelectionListener(){

            @Override
            public void frameSelected(int frame, List<Integer> depths) {
                ftime.frameSelect(frame);
            }
        });
        final TimelineBodyPanel ftimeline = this.timelineBodyPanel;
        this.timePanel.addFrameSelectionListener(new FrameSelectionListener(){

            @Override
            public void frameSelected(int frame, List<Integer> depths) {
                ftimeline.frameSelect(frame, depths, true);
            }
        });
    }

    public static Color getBackgroundColor() {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            return SubstanceLookAndFeel.getCurrentSkin().getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
        }
        return SystemColor.control;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public void addFrameSelectionListener(FrameSelectionListener l) {
        this.timelineBodyPanel.addFrameSelectionListener(l);
    }

    public void removeFrameSelectionListener(FrameSelectionListener l) {
        this.timelineBodyPanel.removeFrameSelectionListener(l);
    }

    public void setDepth(int depth) {
        this.timelineBodyPanel.depthSelect(depth);
    }

    public void setDepths(List<Integer> depths) {
        this.timelineBodyPanel.depthsSelect(depths);
    }

    public void setFrame(int frame, int depth) {
        this.timePanel.frameSelect(frame);
        this.timelineBodyPanel.frameSelect(frame, depth, false);
    }

    public void setFrame(int frame, List<Integer> depths) {
        this.timePanel.frameSelect(frame);
        this.timelineBodyPanel.frameSelect(frame, depths, false);
    }

    public void refresh() {
        this.timelineBodyPanel.refresh();
    }

    public void addChangeListener(Runnable l) {
        this.timelineBodyPanel.addChangeListener(l);
    }

    public void removeChangeListener(Runnable l) {
        this.timelineBodyPanel.removeChangeListener(l);
    }

    public void setTimelined(Timelined timelined) {
        this.timelined = timelined;
        if (timelined == null) {
            this.timelineBodyPanel.setTimeline(null);
            this.depthPanel.setTimeline(null);
            this.timePanel.setTimeline(null);
        } else {
            this.timelineBodyPanel.setTimeline(timelined.getTimeline());
            this.depthPanel.setTimeline(timelined.getTimeline());
            this.timePanel.setTimeline(timelined.getTimeline());
            SWF swf = timelined.getSwf();
            SwfSpecificCustomConfiguration conf = swf == null ? null : Configuration.getSwfSpecificCustomConfiguration((SWF)swf);
            int frame = conf == null ? 0 : Integer.parseInt(conf.getCustomData("easy.lastSelected.frame", "1")) - 1;
            this.timePanel.frameSelect(frame);
            this.timelineBodyPanel.frameSelect(frame, 0, false);
        }
    }

    public TimelineBodyPanel getTimelineBodyPanel() {
        return this.timelineBodyPanel;
    }
}

