/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui.properties;

import com.jpexs.decompiler.flash.easygui.properties.PropertyEditor;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class ConvolutionMatrixEditor
extends JPanel
implements PropertyEditor {
    private final JLabel previewLabel;
    private final CONVOLUTIONFILTER filter;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    private void updateLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.filter.matrixX);
        sb.append("x");
        sb.append(this.filter.matrixY);
        sb.append(" [");
        int length = this.filter.matrix.length;
        int i = 0;
        for (int y = 0; y < this.filter.matrixY; ++y) {
            if (y > 0) {
                sb.append("; ");
            }
            for (int x = 0; x < this.filter.matrixX; ++x) {
                if (x > 0) {
                    sb.append(", ");
                }
                sb.append(EcmaScript.toString((Object)Float.valueOf(this.filter.matrix[i])));
                ++i;
            }
        }
        sb.append("]");
        this.previewLabel.setText(sb.toString());
    }

    public ConvolutionMatrixEditor(final CONVOLUTIONFILTER filter) {
        this.filter = filter;
        this.setLayout(new BorderLayout());
        this.previewLabel = new JLabel();
        this.updateLabel();
        this.previewLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    final JDialog dialog = new JDialog();
                    dialog.setUndecorated(true);
                    dialog.setResizable(false);
                    dialog.getRootPane().setWindowDecorationStyle(0);
                    final MatrixEditorPanel matrixEditorPanel = new MatrixEditorPanel(dialog);
                    dialog.setContentPane(matrixEditorPanel);
                    dialog.pack();
                    Window window = SwingUtilities.getWindowAncestor(ConvolutionMatrixEditor.this);
                    dialog.setLocationRelativeTo(window);
                    Point loc = SwingUtilities.convertPoint(ConvolutionMatrixEditor.this.previewLabel, 0, 0, window);
                    if (loc.x + dialog.getWidth() > window.getWidth()) {
                        loc.x -= loc.x + dialog.getWidth() - window.getWidth();
                    }
                    if (loc.y + dialog.getHeight() > window.getHeight()) {
                        loc.y -= loc.y + dialog.getHeight() - window.getHeight();
                    }
                    SwingUtilities.convertPointToScreen(loc, window);
                    dialog.setLocation(loc);
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowDeactivated(WindowEvent e) {
                            matrixEditorPanel.stopEditing();
                            filter.matrixX = matrixEditorPanel.getMatrixX();
                            filter.matrixY = matrixEditorPanel.getMatrixY();
                            filter.matrix = matrixEditorPanel.getMatrix();
                            ConvolutionMatrixEditor.this.updateLabel();
                            dialog.setVisible(false);
                            for (ChangeListener l : ConvolutionMatrixEditor.this.changeListeners) {
                                l.change(ConvolutionMatrixEditor.this);
                            }
                        }
                    });
                    dialog.setVisible(true);
                }
            }
        });
        this.add((Component)this.previewLabel, "West");
    }

    @Override
    public boolean save() {
        return true;
    }

    @Override
    public void reset() {
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    private class MatrixEditorPanel
    extends JPanel {
        private final JTable matrixTable;
        private final JDialog dialog;
        private final JButton enlargeVerticalButton;
        private final JButton shrinkVerticalButton;
        private final JButton enlargeHorizontalButton;
        private final JButton shrinkHorizontalButton;

        public int getMatrixX() {
            return this.matrixTable.getModel().getColumnCount();
        }

        public int getMatrixY() {
            return this.matrixTable.getModel().getRowCount();
        }

        public float[] getMatrix() {
            int cols = this.getMatrixX();
            int rows = this.getMatrixY();
            float[] matrix = new float[cols * rows];
            for (int y = 0; y < rows; ++y) {
                for (int x = 0; x < cols; ++x) {
                    matrix[y * cols + x] = ((Float)this.matrixTable.getModel().getValueAt(y, x)).floatValue();
                }
            }
            return matrix;
        }

        public void stopEditing() {
            TableCellEditor editor = this.matrixTable.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
        }

        public MatrixEditorPanel(JDialog dialog) {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            DefaultTableModel model = new DefaultTableModel(((ConvolutionMatrixEditor)ConvolutionMatrixEditor.this).filter.matrixY, ((ConvolutionMatrixEditor)ConvolutionMatrixEditor.this).filter.matrixX){

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return Float.TYPE;
                }
            };
            for (int y = 0; y < ((ConvolutionMatrixEditor)ConvolutionMatrixEditor.this).filter.matrixY; ++y) {
                for (int x = 0; x < ((ConvolutionMatrixEditor)ConvolutionMatrixEditor.this).filter.matrixX; ++x) {
                    model.setValueAt(Float.valueOf(((ConvolutionMatrixEditor)ConvolutionMatrixEditor.this).filter.matrix[y * ((ConvolutionMatrixEditor)ConvolutionMatrixEditor.this).filter.matrixX + x]), y, x);
                }
            }
            this.matrixTable = new JTable(model);
            this.matrixTable.setDefaultRenderer(Float.TYPE, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    label.setText(EcmaScript.toString((Object)value));
                    return label;
                }
            });
            final JTextField textField = new JTextField();
            textField.setBorder(BorderFactory.createEmptyBorder());
            this.matrixTable.setDefaultEditor(Float.TYPE, new TableCellEditor(){
                private List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    textField.setText(EcmaScript.toString((Object)value));
                    SwingUtilities.invokeLater(() -> textField.selectAll());
                    return textField;
                }

                @Override
                public Object getCellEditorValue() {
                    String input = textField.getText();
                    try {
                        return Float.valueOf(input);
                    }
                    catch (NumberFormatException nfe) {
                        return Float.valueOf(0.0f);
                    }
                }

                @Override
                public boolean isCellEditable(EventObject anEvent) {
                    return true;
                }

                @Override
                public boolean shouldSelectCell(EventObject anEvent) {
                    return true;
                }

                @Override
                public boolean stopCellEditing() {
                    ArrayList<CellEditorListener> listeners2 = new ArrayList<CellEditorListener>(this.listeners);
                    for (CellEditorListener l : listeners2) {
                        l.editingStopped(new ChangeEvent(this));
                    }
                    return true;
                }

                @Override
                public void cancelCellEditing() {
                    ArrayList<CellEditorListener> listeners2 = new ArrayList<CellEditorListener>(this.listeners);
                    for (CellEditorListener l : listeners2) {
                        l.editingCanceled(new ChangeEvent(this));
                    }
                }

                @Override
                public void addCellEditorListener(CellEditorListener l) {
                    this.listeners.add(l);
                }

                @Override
                public void removeCellEditorListener(CellEditorListener l) {
                    this.listeners.remove(l);
                }
            });
            this.matrixTable.setTableHeader(null);
            this.matrixTable.setUI(new BasicTableUI());
            if (View.isOceanic()) {
                this.matrixTable.setBackground(Color.WHITE);
            }
            this.matrixTable.setRowSelectionAllowed(false);
            this.matrixTable.setColumnSelectionAllowed(false);
            this.matrixTable.setCellSelectionEnabled(true);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            JPanel buttonsVerticalPanel = new JPanel(new FlowLayout());
            this.enlargeVerticalButton = new JButton("+");
            this.enlargeVerticalButton.addActionListener(this::enlargeVerticalActionPerformed);
            this.enlargeVerticalButton.setPreferredSize(new Dimension(30, 30));
            this.enlargeVerticalButton.setMinimumSize(new Dimension(30, 30));
            this.shrinkVerticalButton = new JButton("-");
            this.shrinkVerticalButton.addActionListener(this::shrinkVerticalActionPerformed);
            this.shrinkVerticalButton.setPreferredSize(new Dimension(30, 30));
            this.shrinkVerticalButton.setMinimumSize(new Dimension(30, 30));
            buttonsVerticalPanel.add(this.enlargeVerticalButton);
            buttonsVerticalPanel.add(this.shrinkVerticalButton);
            JPanel buttonsHorizontalPanel = new JPanel();
            buttonsHorizontalPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            buttonsHorizontalPanel.setLayout(new BoxLayout(buttonsHorizontalPanel, 1));
            this.enlargeHorizontalButton = new JButton("+");
            this.enlargeHorizontalButton.addActionListener(this::enlargeHorizontalActionPerformed);
            this.enlargeHorizontalButton.setPreferredSize(new Dimension(30, 30));
            this.enlargeHorizontalButton.setMinimumSize(new Dimension(30, 30));
            this.shrinkHorizontalButton = new JButton("-");
            this.shrinkHorizontalButton.addActionListener(this::shrinkHorizontalActionPerformed);
            this.shrinkHorizontalButton.setPreferredSize(new Dimension(30, 30));
            this.shrinkHorizontalButton.setMinimumSize(new Dimension(30, 30));
            buttonsHorizontalPanel.add(Box.createVerticalGlue());
            buttonsHorizontalPanel.add(this.enlargeHorizontalButton);
            buttonsHorizontalPanel.add(this.shrinkHorizontalButton);
            buttonsHorizontalPanel.add(Box.createVerticalGlue());
            gbc.anchor = 10;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)this.matrixTable, gbc);
            ++gbc.gridx;
            this.add((Component)buttonsHorizontalPanel, gbc);
            gbc.gridy = 1;
            gbc.gridx = 0;
            this.add((Component)buttonsVerticalPanel, gbc);
            this.dialog = dialog;
        }

        private void updateDialogPosition() {
            Window window = SwingUtilities.getWindowAncestor(ConvolutionMatrixEditor.this);
            this.dialog.setLocationRelativeTo(window);
            Point loc = SwingUtilities.convertPoint(ConvolutionMatrixEditor.this.previewLabel, 0, 0, window);
            if (loc.x + this.dialog.getWidth() > window.getWidth()) {
                loc.x -= loc.x + this.dialog.getWidth() - window.getWidth();
            }
            if (loc.y + this.dialog.getHeight() > window.getHeight()) {
                loc.y -= loc.y + this.dialog.getHeight() - window.getHeight();
            }
            SwingUtilities.convertPointToScreen(loc, window);
            this.dialog.setLocation(loc);
        }

        private void enlargeVerticalActionPerformed(ActionEvent actionEvent) {
            int i;
            DefaultTableModel model = (DefaultTableModel)this.matrixTable.getModel();
            int columnCount = model.getColumnCount();
            int rowCount = model.getRowCount();
            model.setRowCount(rowCount + 2);
            for (i = 0; i < columnCount; ++i) {
                model.setValueAt(Float.valueOf(0.0f), rowCount, i);
                model.setValueAt(Float.valueOf(0.0f), rowCount + 1, i);
            }
            for (int y = rowCount - 1; y >= 0; --y) {
                for (int x = columnCount - 1; x >= 0; --x) {
                    model.setValueAt(model.getValueAt(y, x), y + 1, x);
                }
            }
            for (i = 0; i < columnCount; ++i) {
                model.setValueAt(Float.valueOf(0.0f), 0, i);
            }
            this.dialog.pack();
            this.updateDialogPosition();
            this.shrinkVerticalButton.setEnabled(true);
        }

        private void shrinkVerticalActionPerformed(ActionEvent aev) {
            DefaultTableModel model = (DefaultTableModel)this.matrixTable.getModel();
            int columnCount = model.getColumnCount();
            int rowCount = model.getRowCount();
            for (int y = 0; y < rowCount - 2; ++y) {
                for (int x = 0; x < columnCount; ++x) {
                    model.setValueAt(model.getValueAt(y + 1, x), y, x);
                }
            }
            model.setRowCount(rowCount - 2);
            this.dialog.pack();
            this.shrinkVerticalButton.setEnabled(rowCount - 2 > 1);
            this.updateDialogPosition();
        }

        private void enlargeHorizontalActionPerformed(ActionEvent aev) {
            int i;
            DefaultTableModel model = (DefaultTableModel)this.matrixTable.getModel();
            int columnCount = model.getColumnCount();
            int rowCount = model.getRowCount();
            model.setColumnCount(columnCount + 2);
            for (i = 0; i < rowCount; ++i) {
                model.setValueAt(Float.valueOf(0.0f), i, columnCount);
                model.setValueAt(Float.valueOf(0.0f), i, columnCount + 1);
            }
            for (int y = rowCount - 1; y >= 0; --y) {
                for (int x = columnCount - 1; x >= 0; --x) {
                    model.setValueAt(model.getValueAt(y, x), y, x + 1);
                }
            }
            for (i = 0; i < rowCount; ++i) {
                model.setValueAt(Float.valueOf(0.0f), i, 0);
            }
            this.dialog.pack();
            this.updateDialogPosition();
            this.shrinkHorizontalButton.setEnabled(true);
        }

        private void shrinkHorizontalActionPerformed(ActionEvent aev) {
            DefaultTableModel model = (DefaultTableModel)this.matrixTable.getModel();
            int columnCount = model.getColumnCount();
            int rowCount = model.getRowCount();
            for (int y = 0; y < rowCount; ++y) {
                for (int x = 0; x < columnCount - 2; ++x) {
                    model.setValueAt(model.getValueAt(y, x + 1), y, x);
                }
            }
            model.setColumnCount(columnCount - 2);
            this.dialog.pack();
            this.shrinkHorizontalButton.setEnabled(columnCount - 2 > 1);
            this.updateDialogPosition();
        }
    }
}

