/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui.properties;

import com.jpexs.decompiler.flash.easygui.properties.AbstractPropertyField;
import com.jpexs.decompiler.flash.easygui.properties.PropertyValidationInterface;

public class FloatPropertyField
extends AbstractPropertyField<Float> {
    private PropertyValidationInterface<Float> minValidation = null;
    private PropertyValidationInterface<Float> maxValidation = null;

    public FloatPropertyField(float value, float min, float max) {
        super("" + value);
        this.setMin(min);
        this.setMax(max);
    }

    public FloatPropertyField(float value) {
        super("" + value);
    }

    public void setMax(final float max) {
        if (this.maxValidation != null) {
            this.removeValidation(this.maxValidation);
        }
        this.maxValidation = new PropertyValidationInterface<Float>(){

            @Override
            public boolean validate(Float value) {
                return value.floatValue() <= max;
            }
        };
        this.addValidation(this.maxValidation);
    }

    public void setMin(final float min) {
        if (this.minValidation != null) {
            this.removeValidation(this.minValidation);
        }
        this.minValidation = new PropertyValidationInterface<Float>(){

            @Override
            public boolean validate(Float value) {
                return value.floatValue() >= min;
            }
        };
        this.addValidation(this.minValidation);
    }

    @Override
    protected Float textToValue(String text) {
        try {
            return Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    protected String valueToText(Float value) {
        String ret = "" + value;
        if (ret.endsWith(".0")) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }
}

