/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui.properties;

import com.jpexs.decompiler.flash.easygui.properties.PropertyEditor;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTBEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTGLOWFILTER;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GradientEditor
extends JPanel
implements PropertyEditor {
    private List<Color> colors = new ArrayList<Color>();
    private List<Float> ratios = new ArrayList<Float>();
    private boolean colorDialogDisplayed = false;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final FILTER filter;

    private static void drawCheckerboard(Graphics g, int tileSize, Rectangle rect) {
        GradientEditor.drawCheckerboard(g, tileSize, rect.x, rect.y, rect.width, rect.height);
    }

    private static void drawCheckerboard(Graphics g, int tileSize, int startX, int startY, int width, int height) {
        Color lightGray = new Color(238, 238, 238);
        Color darkGray = new Color(189, 189, 189);
        for (int y = 0; y < height; y += tileSize) {
            for (int x = 0; x < width; x += tileSize) {
                boolean isLight = (x / tileSize + y / tileSize) % 2 == 0;
                g.setColor(isLight ? lightGray : darkGray);
                int tileW = tileSize;
                int tileH = tileSize;
                if (x + tileSize > width) {
                    tileW = width - x;
                }
                if (y + tileSize > height) {
                    tileH = height - y;
                }
                g.fillRect(startX + x, startY + y, tileW, tileH);
            }
        }
    }

    public GradientEditor(FILTER filter) {
        this.filter = filter;
        this.setLayout(new BorderLayout());
        final JPanel miniGradientPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                GradientEditor.drawCheckerboard(g, 4, 0, 0, this.getWidth(), this.getHeight());
                float[] ratiosArr = new float[GradientEditor.this.ratios.size()];
                for (int i = 0; i < GradientEditor.this.ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)GradientEditor.this.ratios.get(i)).floatValue();
                }
                Color[] colorsArr = GradientEditor.this.colors.toArray(new Color[GradientEditor.this.colors.size()]);
                g2d.setPaint(new LinearGradientPaint(0.0f, 0.0f, this.getWidth(), 0.0f, ratiosArr, colorsArr));
                g2d.fill(new Rectangle(this.getWidth(), this.getHeight()));
                g2d.setPaint(Color.black);
                g2d.draw(new Rectangle(this.getWidth(), this.getHeight()));
            }
        };
        miniGradientPanel.setPreferredSize(new Dimension(100, 16));
        miniGradientPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    final JDialog dialog = new JDialog();
                    dialog.setUndecorated(true);
                    dialog.setResizable(false);
                    dialog.getRootPane().setWindowDecorationStyle(0);
                    dialog.setContentPane(new GradientEditorPanel());
                    dialog.pack();
                    Window window = SwingUtilities.getWindowAncestor(GradientEditor.this);
                    dialog.setLocationRelativeTo(window);
                    Point loc = SwingUtilities.convertPoint(miniGradientPanel, 0, 0, window);
                    if (loc.x + dialog.getWidth() > window.getWidth()) {
                        loc.x -= loc.x + dialog.getWidth() - window.getWidth();
                    }
                    if (loc.y + dialog.getHeight() > window.getHeight()) {
                        loc.y -= loc.y + dialog.getHeight() - window.getHeight();
                    }
                    SwingUtilities.convertPointToScreen(loc, window);
                    dialog.setLocation(loc);
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowDeactivated(WindowEvent e) {
                            if (!GradientEditor.this.colorDialogDisplayed) {
                                dialog.setVisible(false);
                                ArrayList listeners2 = new ArrayList(GradientEditor.this.listeners);
                                for (ChangeListener l : listeners2) {
                                    l.change(GradientEditor.this);
                                }
                            }
                        }
                    });
                    dialog.setVisible(true);
                }
            }
        });
        this.add((Component)miniGradientPanel, "West");
        this.reset();
    }

    private void loadParams(RGBA[] rgbaColors, int[] intRatios) {
        this.colors = new ArrayList<Color>();
        this.ratios = new ArrayList<Float>();
        int lastRatio = -1;
        for (int i = 0; i < rgbaColors.length; ++i) {
            if (i > 0 && intRatios[i - 1] == intRatios[i]) {
                if (lastRatio < 255) {
                    ++lastRatio;
                }
            } else if (intRatios[i] > lastRatio) {
                lastRatio = intRatios[i];
            } else if (lastRatio < 255) {
                ++lastRatio;
            }
            this.ratios.add(Float.valueOf((float)lastRatio / 255.0f));
            this.colors.add(rgbaColors[i].toColor());
            if (lastRatio == 255) break;
        }
        if (this.colors.size() == 1) {
            this.colors.add(this.colors.get(0));
            this.ratios.set(0, Float.valueOf(0.0f));
            this.ratios.add(Float.valueOf(1.0f));
        }
    }

    @Override
    public boolean save() {
        int[] gradientRatio = new int[this.ratios.size()];
        RGBA[] gradientColors = new RGBA[this.ratios.size()];
        for (int i = 0; i < this.ratios.size(); ++i) {
            gradientRatio[i] = Math.round(this.ratios.get(i).floatValue() * 255.0f);
            gradientColors[i] = new RGBA(this.colors.get(i));
        }
        if (this.filter instanceof GRADIENTBEVELFILTER) {
            GRADIENTBEVELFILTER bevel = (GRADIENTBEVELFILTER)this.filter;
            bevel.gradientColors = gradientColors;
            bevel.gradientRatio = gradientRatio;
        } else if (this.filter instanceof GRADIENTGLOWFILTER) {
            GRADIENTGLOWFILTER glow = (GRADIENTGLOWFILTER)this.filter;
            glow.gradientColors = gradientColors;
            glow.gradientRatio = gradientRatio;
        }
        return true;
    }

    @Override
    public void reset() {
        if (this.filter instanceof GRADIENTBEVELFILTER) {
            GRADIENTBEVELFILTER bevel = (GRADIENTBEVELFILTER)this.filter;
            this.loadParams(bevel.gradientColors, bevel.gradientRatio);
        } else if (this.filter instanceof GRADIENTGLOWFILTER) {
            GRADIENTGLOWFILTER glow = (GRADIENTGLOWFILTER)this.filter;
            this.loadParams(glow.gradientColors, glow.gradientRatio);
        } else {
            throw new RuntimeException("Invalid FILTER");
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    private class GradientEditorPanel
    extends JPanel {
        int dragIndex = -1;
        boolean draggedOut = false;
        boolean newlySelected = true;
        final int BOTTOM_HEIGHT = 15;
        final int COLOR_SIZE = 10;
        final int ARROW_HEIGHT = 4;
        int selectedColorIndex = 0;

        private Color interpolate(Color c1, Color c2, float t) {
            int r = (int)((float)c1.getRed() + t * (float)(c2.getRed() - c1.getRed()));
            int g = (int)((float)c1.getGreen() + t * (float)(c2.getGreen() - c1.getGreen()));
            int b = (int)((float)c1.getBlue() + t * (float)(c2.getBlue() - c1.getBlue()));
            int a = (int)((float)c1.getAlpha() + t * (float)(c2.getAlpha() - c1.getAlpha()));
            return new Color(r, g, b, a);
        }

        public GradientEditorPanel() {
            Dimension dim = new Dimension(300, 50);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        if (GradientEditorPanel.this.newlySelected) {
                            return;
                        }
                        List rects = GradientEditorPanel.this.getColorRects();
                        for (int r = 0; r < rects.size(); ++r) {
                            Rectangle rect = (Rectangle)rects.get(r);
                            if (!rect.contains(e.getPoint())) continue;
                            if (GradientEditorPanel.this.selectedColorIndex == r) {
                                GradientEditor.this.colorDialogDisplayed = true;
                                Color newColor = ViewMessages.showColorDialog(GradientEditorPanel.this, (Color)GradientEditor.this.colors.get(GradientEditorPanel.this.selectedColorIndex), true);
                                GradientEditor.this.colorDialogDisplayed = false;
                                if (newColor != null) {
                                    if (GradientEditorPanel.this.isFixedZeroAlphaIndex(GradientEditorPanel.this.selectedColorIndex)) {
                                        newColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), 0);
                                    }
                                    GradientEditor.this.colors.set(GradientEditorPanel.this.selectedColorIndex, newColor);
                                    GradientEditorPanel.this.repaint();
                                }
                            }
                            return;
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        List rects = GradientEditorPanel.this.getColorRects();
                        for (int r = 0; r < rects.size(); ++r) {
                            Rectangle rect = (Rectangle)rects.get(r);
                            if (!rect.contains(e.getPoint())) continue;
                            GradientEditorPanel.this.newlySelected = GradientEditorPanel.this.selectedColorIndex != r;
                            GradientEditorPanel.this.selectedColorIndex = r;
                            GradientEditorPanel.this.dragIndex = r;
                            GradientEditorPanel.this.repaint();
                            return;
                        }
                        float newRatio = (float)(e.getX() - 5) / (float)(GradientEditorPanel.this.getWidth() - 10);
                        if (newRatio >= 0.0f && newRatio <= 1.0f) {
                            GradientEditorPanel gradientEditorPanel = GradientEditorPanel.this;
                            synchronized (gradientEditorPanel) {
                                int newIndex = -1;
                                Color color1 = null;
                                Color color2 = null;
                                Float ratio1 = null;
                                Float ratio2 = null;
                                for (int i = 0; i < GradientEditor.this.ratios.size(); ++i) {
                                    float ratio = ((Float)GradientEditor.this.ratios.get(i)).floatValue();
                                    if (ratio >= newRatio) {
                                        if (newRatio == ratio) {
                                            if (Float.compare(newRatio, 0.0f) > 0) {
                                                newRatio = (float)((double)newRatio - 1.0E-7);
                                            } else {
                                                newRatio = (float)((double)newRatio + 1.0E-7);
                                                ++i;
                                            }
                                        }
                                        ratio2 = Float.valueOf(ratio);
                                        newIndex = i;
                                        color2 = (Color)GradientEditor.this.colors.get(i);
                                        break;
                                    }
                                    color1 = (Color)GradientEditor.this.colors.get(i);
                                    ratio1 = Float.valueOf(ratio);
                                }
                                if (newIndex == -1) {
                                    newIndex = GradientEditor.this.ratios.size();
                                    color2 = color1;
                                    ratio2 = Float.valueOf(1.0f);
                                }
                                GradientEditor.this.ratios.add(newIndex, Float.valueOf(newRatio));
                                float ratioDelta = (newRatio - ratio1.floatValue()) / (ratio2.floatValue() - ratio1.floatValue());
                                Color newColor = GradientEditorPanel.this.interpolate(color1, color2, ratioDelta);
                                GradientEditor.this.colors.add(newIndex, newColor);
                                GradientEditorPanel.this.dragIndex = newIndex;
                                GradientEditorPanel.this.selectedColorIndex = newIndex;
                                GradientEditorPanel.this.newlySelected = true;
                                GradientEditorPanel.this.repaint();
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseReleased(MouseEvent e) {
                    if (GradientEditorPanel.this.draggedOut && GradientEditorPanel.this.dragIndex > -1) {
                        GradientEditorPanel gradientEditorPanel = GradientEditorPanel.this;
                        synchronized (gradientEditorPanel) {
                            GradientEditor.this.colors.remove(GradientEditorPanel.this.dragIndex);
                            GradientEditor.this.ratios.remove(GradientEditorPanel.this.dragIndex);
                        }
                        GradientEditorPanel.this.repaint();
                    }
                    GradientEditorPanel.this.dragIndex = -1;
                    GradientEditorPanel.this.draggedOut = false;
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseDragged(MouseEvent e) {
                    float newRatio = (float)(e.getX() - 5) / (float)(GradientEditorPanel.this.getWidth() - 10);
                    if ((newRatio = (float)Math.round(newRatio * 255.0f) / 255.0f) < 0.0f || newRatio > 1.0f) {
                        return;
                    }
                    if (GradientEditorPanel.this.dragIndex > -1) {
                        if (GradientEditorPanel.this.isFixedZeroAlphaIndex(GradientEditorPanel.this.dragIndex)) {
                            return;
                        }
                        GradientEditorPanel.this.draggedOut = GradientEditor.this.colors.size() > 2 && e.getY() > GradientEditorPanel.this.getHeight();
                        GradientEditorPanel gradientEditorPanel = GradientEditorPanel.this;
                        synchronized (gradientEditorPanel) {
                            int newIndex = -1;
                            for (int i = 0; i < GradientEditor.this.ratios.size(); ++i) {
                                float ratio;
                                if (i == GradientEditorPanel.this.dragIndex || !((ratio = ((Float)GradientEditor.this.ratios.get(i)).floatValue()) >= newRatio)) continue;
                                if (newRatio == ratio) {
                                    if (Float.compare(newRatio, 0.0f) > 0) {
                                        newRatio = (float)((double)newRatio - 1.0E-7);
                                    } else {
                                        newRatio = (float)((double)newRatio + 1.0E-7);
                                        ++i;
                                    }
                                }
                                newIndex = i;
                                break;
                            }
                            GradientEditor.this.ratios.set(GradientEditorPanel.this.dragIndex, Float.valueOf(newRatio));
                            if (newIndex == -1) {
                                newIndex = GradientEditor.this.ratios.size();
                            }
                            GradientEditor.this.ratios.add(newIndex, Float.valueOf(newRatio));
                            GradientEditor.this.colors.add(newIndex, GradientEditor.this.colors.get(GradientEditorPanel.this.dragIndex));
                            if (newIndex <= GradientEditorPanel.this.dragIndex) {
                                ++GradientEditorPanel.this.dragIndex;
                            } else {
                                --newIndex;
                            }
                            GradientEditor.this.ratios.remove(GradientEditorPanel.this.dragIndex);
                            GradientEditor.this.colors.remove(GradientEditorPanel.this.dragIndex);
                            GradientEditorPanel.this.dragIndex = newIndex;
                        }
                        GradientEditorPanel.this.repaint();
                    }
                }
            });
        }

        private boolean isFixedZeroAlphaIndex(int index) {
            if (GradientEditor.this.filter instanceof GRADIENTGLOWFILTER && index == 0 && ((Color)GradientEditor.this.colors.get(0)).getAlpha() == 0) {
                return true;
            }
            return GradientEditor.this.filter instanceof GRADIENTBEVELFILTER && ((Float)GradientEditor.this.ratios.get(index)).floatValue() == 0.5019608f && ((Color)GradientEditor.this.colors.get(index)).getAlpha() == 0;
        }

        private List<Rectangle> getColorRects() {
            ArrayList<Rectangle> rects = new ArrayList<Rectangle>();
            for (int i = 0; i < GradientEditor.this.ratios.size(); ++i) {
                rects.add(new Rectangle(Math.round((float)(this.getWidth() - 10) * ((Float)GradientEditor.this.ratios.get(i)).floatValue()), this.getHeight() - 15 + 4, 10, 10));
            }
            return rects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            Color[] colorsArr;
            int i;
            float[] ratiosArr;
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            GradientEditor.drawCheckerboard(g, 5, 5, 0, this.getWidth() - 10, this.getHeight() - 15);
            GradientEditorPanel gradientEditorPanel = this;
            synchronized (gradientEditorPanel) {
                ratiosArr = new float[GradientEditor.this.ratios.size()];
                for (i = 0; i < GradientEditor.this.ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)GradientEditor.this.ratios.get(i)).floatValue();
                }
                colorsArr = GradientEditor.this.colors.toArray(new Color[GradientEditor.this.colors.size()]);
            }
            g2d.setPaint(new LinearGradientPaint(5.0f, 0.0f, this.getWidth() - 10, 0.0f, ratiosArr, colorsArr));
            g2d.fill(new Rectangle(5, 0, this.getWidth() - 10, this.getHeight() - 15));
            g2d.setPaint(Color.black);
            g2d.draw(new Rectangle(5, 0, this.getWidth() - 10, this.getHeight() - 15));
            List<Rectangle> rects = this.getColorRects();
            for (i = 0; i < GradientEditor.this.ratios.size(); ++i) {
                if (this.draggedOut && i == this.dragIndex) continue;
                Rectangle rect = rects.get(i);
                GradientEditor.drawCheckerboard(g, 3, rect);
                g2d.setPaint(colorsArr[i]);
                g2d.fill(rect);
                g2d.setColor(Color.black);
                g2d.draw(rect);
                g2d.setColor(this.selectedColorIndex == i ? Color.black : Color.white);
                Polygon arrow = new Polygon(new int[]{Math.round((float)(this.getWidth() - 10) * ((Float)GradientEditor.this.ratios.get(i)).floatValue()), Math.round((float)(this.getWidth() - 10) * ((Float)GradientEditor.this.ratios.get(i)).floatValue()) + 5, Math.round((float)(this.getWidth() - 10) * ((Float)GradientEditor.this.ratios.get(i)).floatValue()) + 10}, new int[]{this.getHeight() - 15 + 4, this.getHeight() - 15, this.getHeight() - 15 + 4}, 3);
                g2d.fill(arrow);
                g2d.setColor(Color.black);
                g2d.draw(arrow);
            }
        }
    }
}

