/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui.properties.panels;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFCompression;
import com.jpexs.decompiler.flash.easygui.ChangeDoableOperation;
import com.jpexs.decompiler.flash.easygui.EasyStrings;
import com.jpexs.decompiler.flash.easygui.UndoManager;
import com.jpexs.decompiler.flash.easygui.properties.FloatPropertyField;
import com.jpexs.decompiler.flash.easygui.properties.IntegerPropertyField;
import com.jpexs.decompiler.flash.easygui.properties.PropertyChangeDoableOperation;
import com.jpexs.decompiler.flash.easygui.properties.panels.AbstractPropertiesPanel;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ColorSelectionButton;
import com.jpexs.decompiler.flash.gui.ComboBoxItem;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.types.RGB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DocumentPropertiesPanel
extends AbstractPropertiesPanel {
    private final JPanel compressionEditorPanel = new JPanel();
    private final JComboBox<ComboBoxItem<SWFCompression>> compressionComboBox = new JComboBox();
    private final JPanel versionEditorPanel = new JPanel();
    private final IntegerPropertyField versionEditor = new IntegerPropertyField(10, 1, 255);
    private final JCheckBox gfxCheckBox = new JCheckBox();
    private final JCheckBox encryptedCheckBox = new JCheckBox();
    private final JPanel frameRateEditorPanel = new JPanel();
    private final FloatPropertyField frameRateEditor = new FloatPropertyField(24.0f, 0.01f, 120.0f);
    private final JPanel propertiesPanel = new JPanel();
    private final JPanel displayRectEditorPanel = new JPanel();
    private final IntegerPropertyField widthEditor = new IntegerPropertyField(550, 1, 8192);
    private final IntegerPropertyField heightEditor = new IntegerPropertyField(400, 1, 8192);
    private final ColorSelectionButton colorSelectionButton;
    private final JPanel warningPanel = new JPanel();
    private final JLabel warningLabel = new JLabel();
    private SWF swf;
    private boolean modifying = false;

    public DocumentPropertiesPanel(final UndoManager undoManager) {
        super("document");
        this.setLayout(new BorderLayout());
        JLabel documentLabel = new JLabel(EasyStrings.translate("properties.document"));
        documentLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.add((Component)documentLabel, "North");
        FlowLayout layout = new FlowLayout(7);
        layout.setHgap(0);
        layout.setVgap(0);
        this.compressionEditorPanel.setLayout(layout);
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>(AppStrings.translate("header.uncompressed"), SWFCompression.NONE));
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>("Zlib", SWFCompression.ZLIB));
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>("LZMA", SWFCompression.LZMA));
        this.compressionComboBox.addActionListener(e -> this.validateHeader());
        this.compressionEditorPanel.add(this.compressionComboBox);
        this.versionEditorPanel.setLayout(layout);
        this.versionEditor.setPreferredSize(new Dimension(80, this.versionEditor.getPreferredSize().height));
        this.versionEditor.addChangeListener(e -> this.validateHeader());
        this.versionEditorPanel.add(this.versionEditor);
        this.encryptedCheckBox.addChangeListener(e -> this.validateHeader());
        this.gfxCheckBox.addChangeListener(e -> this.validateHeader());
        this.frameRateEditorPanel.setLayout(layout);
        this.frameRateEditor.setPreferredSize(new Dimension(80, this.frameRateEditor.getPreferredSize().height));
        this.frameRateEditorPanel.add(this.frameRateEditor);
        this.displayRectEditorPanel.setLayout(layout);
        this.displayRectEditorPanel.add(this.widthEditor);
        this.displayRectEditorPanel.add(new JLabel("\u00d7    "));
        this.displayRectEditorPanel.add(this.heightEditor);
        this.displayRectEditorPanel.add(new JLabel(" px"));
        this.colorSelectionButton = new ColorSelectionButton(Color.white, null);
        this.warningLabel.setIcon(View.getIcon("warning16"));
        this.warningPanel.setLayout(layout);
        this.warningPanel.setBackground(new Color(255, 213, 29));
        this.warningPanel.add(this.warningLabel);
        GridBagLayout gridBag = new GridBagLayout();
        this.propertiesPanel.setLayout(gridBag);
        int y = 0;
        this.addToGrid(gridBag, this.propertiesPanel, new JLabel(AppStrings.translate("header.compression")), 0, ++y);
        this.addToGrid(gridBag, this.propertiesPanel, this.compressionEditorPanel, 1, y);
        this.addToGrid(gridBag, this.propertiesPanel, new JLabel(AppStrings.translate("header.version")), 0, ++y);
        this.addToGrid(gridBag, this.propertiesPanel, this.versionEditorPanel, 1, y);
        this.addToGrid(gridBag, this.propertiesPanel, new JLabel(AppStrings.translate("header.encrypted")), 0, ++y);
        this.addToGrid(gridBag, this.propertiesPanel, this.encryptedCheckBox, 1, y);
        this.addToGrid(gridBag, this.propertiesPanel, new JLabel(AppStrings.translate("header.gfx")), 0, ++y);
        this.addToGrid(gridBag, this.propertiesPanel, this.gfxCheckBox, 1, y);
        this.addToGrid(gridBag, this.propertiesPanel, new JLabel(AppStrings.translate("header.framerate")), 0, ++y);
        this.addToGrid(gridBag, this.propertiesPanel, this.frameRateEditorPanel, 1, y);
        this.addToGrid(gridBag, this.propertiesPanel, new JLabel(AppStrings.translate("header.displayrect")), 0, ++y);
        this.addToGrid(gridBag, this.propertiesPanel, this.displayRectEditorPanel, 1, y);
        this.addToGrid(gridBag, this.propertiesPanel, new JLabel(EasyStrings.translate("property.label").replace("%item%", EasyStrings.translate("property.document.backgroundColor"))), 0, ++y);
        this.addToGrid(gridBag, this.propertiesPanel, this.colorSelectionButton, 1, y);
        this.addToGrid(gridBag, this.propertiesPanel, this.warningPanel, 0, ++y, 2, 1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = ++y;
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.propertiesPanel.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = y;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.propertiesPanel.add((Component)new JPanel(), gbc);
        this.add((Component)this.propertiesPanel, "Center");
        this.warningPanel.setVisible(false);
        this.compressionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DocumentPropertiesPanel.this.modifying) {
                    return;
                }
                undoManager.doOperation(new HeaderChangeDoableOperation("compression"){
                    SWFCompression itemBefore;
                    SWFCompression itemAfter;
                    {
                        this.itemBefore = ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.compression;
                        this.itemAfter = DocumentPropertiesPanel.this.getCompression();
                    }

                    @Override
                    public void doHeaderOperation() {
                        ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.compression = this.itemAfter;
                    }

                    @Override
                    public void undoHeaderOperation() {
                        ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.compression = this.itemBefore;
                    }
                }, DocumentPropertiesPanel.this.swf);
            }
        });
        this.versionEditor.addChangeListener(e -> {
            if (this.modifying) {
                return;
            }
            undoManager.doOperation(new HeaderChangeDoableOperation("swfVersion"){
                int itemBefore;
                int itemAfter;
                {
                    this.itemBefore = ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.version;
                    this.itemAfter = (Integer)DocumentPropertiesPanel.this.versionEditor.getValue();
                }

                @Override
                public void doHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.version = this.itemAfter;
                }

                @Override
                public void undoHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.version = this.itemBefore;
                }
            }, this.swf);
        });
        this.encryptedCheckBox.addChangeListener(e -> {
            if (this.modifying) {
                return;
            }
            if (this.encryptedCheckBox.isSelected() == this.swf.encrypted) {
                return;
            }
            undoManager.doOperation(new HeaderChangeDoableOperation("encrypted"){
                boolean itemBefore;
                boolean itemAfter;
                {
                    this.itemBefore = ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.encrypted;
                    this.itemAfter = DocumentPropertiesPanel.this.encryptedCheckBox.isSelected();
                }

                @Override
                public void doHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.encrypted = this.itemAfter;
                }

                @Override
                public void undoHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.encrypted = this.itemBefore;
                }
            }, this.swf);
        });
        this.gfxCheckBox.addChangeListener(e -> {
            if (this.modifying) {
                return;
            }
            if (this.gfxCheckBox.isSelected() == this.swf.gfx) {
                return;
            }
            undoManager.doOperation(new HeaderChangeDoableOperation("gfx"){
                boolean itemBefore;
                boolean itemAfter;
                {
                    this.itemBefore = ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.gfx;
                    this.itemAfter = DocumentPropertiesPanel.this.gfxCheckBox.isSelected();
                }

                @Override
                public void doHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.gfx = this.itemAfter;
                }

                @Override
                public void undoHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.gfx = this.itemBefore;
                }
            }, this.swf);
        });
        this.frameRateEditor.addChangeListener(e -> {
            if (this.modifying) {
                return;
            }
            undoManager.doOperation(new HeaderChangeDoableOperation("frameRate"){
                float itemBefore;
                float itemAfter;
                {
                    this.itemBefore = ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.frameRate;
                    this.itemAfter = ((Float)DocumentPropertiesPanel.this.frameRateEditor.getValue()).floatValue();
                }

                @Override
                public void doHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.frameRate = this.itemAfter;
                }

                @Override
                public void undoHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.frameRate = this.itemBefore;
                }
            }, this.swf);
        });
        this.widthEditor.addChangeListener(e -> {
            if (this.modifying) {
                return;
            }
            undoManager.doOperation(new HeaderChangeDoableOperation("width"){
                int xMinBefore;
                int xMaxBefore;
                int xMaxAfter;
                {
                    this.xMinBefore = ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Xmin;
                    this.xMaxBefore = ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Xmax;
                    this.xMaxAfter = (Integer)DocumentPropertiesPanel.this.widthEditor.getValue() * 20;
                }

                @Override
                public void doHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Xmin = 0;
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Xmax = this.xMaxAfter;
                }

                @Override
                public void undoHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Xmin = this.xMinBefore;
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Xmax = this.xMaxBefore;
                }
            }, this.swf);
        });
        this.heightEditor.addChangeListener(e -> {
            if (this.modifying) {
                return;
            }
            undoManager.doOperation(new HeaderChangeDoableOperation("height"){
                int yMinBefore;
                int yMaxBefore;
                int yMaxAfter;
                {
                    this.yMinBefore = ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Ymin;
                    this.yMaxBefore = ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Ymax;
                    this.yMaxAfter = (Integer)DocumentPropertiesPanel.this.heightEditor.getValue() * 20;
                }

                @Override
                public void doHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Ymin = 0;
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Ymax = this.yMaxAfter;
                }

                @Override
                public void undoHeaderOperation() {
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Ymin = this.yMinBefore;
                    ((DocumentPropertiesPanel)DocumentPropertiesPanel.this).swf.displayRect.Ymax = this.yMaxBefore;
                }
            }, this.swf);
        });
        this.colorSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SetBackgroundColorTag backgroundColorTag = DocumentPropertiesPanel.this.swf.getBackgroundColor();
                if (backgroundColorTag == null) {
                    return;
                }
                undoManager.doOperation(new PropertyChangeDoableOperation("document.backgroundColor"){
                    final RGB prevColor;
                    final RGB newColor;
                    final boolean prevModified;
                    {
                        super(propertyIdentifier);
                        this.prevColor = backgroundColorTag.backgroundColor;
                        this.newColor = new RGB(DocumentPropertiesPanel.this.colorSelectionButton.getValue());
                        this.prevModified = backgroundColorTag.isModified();
                    }

                    @Override
                    public void doOperation() {
                        DocumentPropertiesPanel.this.modifying = true;
                        SetBackgroundColorTag backgroundColorTag2 = DocumentPropertiesPanel.this.swf.getBackgroundColor();
                        if (backgroundColorTag2 == null) {
                            return;
                        }
                        backgroundColorTag2.backgroundColor = this.newColor;
                        backgroundColorTag2.setModified(true);
                        DocumentPropertiesPanel.this.swf.resetTimeline();
                        DocumentPropertiesPanel.this.refresh();
                        DocumentPropertiesPanel.this.modifying = false;
                    }

                    @Override
                    public void undoOperation() {
                        SetBackgroundColorTag backgroundColorTag2 = DocumentPropertiesPanel.this.swf.getBackgroundColor();
                        if (backgroundColorTag2 == null) {
                            return;
                        }
                        backgroundColorTag2.backgroundColor = this.prevColor;
                        backgroundColorTag2.setModified(this.prevModified);
                        DocumentPropertiesPanel.this.swf.resetTimeline();
                        DocumentPropertiesPanel.this.refresh();
                    }
                }, DocumentPropertiesPanel.this.swf);
            }
        });
    }

    private boolean validateHeader() {
        int version = this.getVersionNumber();
        boolean gfx = this.gfxCheckBox.isSelected();
        boolean encrypted = this.encryptedCheckBox.isSelected();
        SWFCompression compression = this.getCompression();
        ArrayList<String> results = new ArrayList<String>();
        if (gfx && compression != SWFCompression.NONE && compression != SWFCompression.ZLIB) {
            results.add(AppStrings.translate("header.warning.unsupportedGfxCompression"));
        }
        if (gfx && encrypted) {
            results.add(AppStrings.translate("header.warning.unsupportedGfxEncryption"));
        }
        if (compression == SWFCompression.ZLIB && version < 6) {
            results.add(AppStrings.translate("header.warning.minimumZlibVersion"));
        }
        if (compression == SWFCompression.LZMA && version < 13) {
            results.add(AppStrings.translate("header.warning.minimumLzmaVersion"));
        }
        this.warningPanel.setVisible(!results.isEmpty());
        if (!results.isEmpty()) {
            this.warningLabel.setText("<html>" + String.join((CharSequence)"<br>", results) + "</html>");
        }
        return results.isEmpty();
    }

    private int getVersionNumber() {
        return (Integer)this.versionEditor.getValue();
    }

    private SWFCompression getCompression() {
        ComboBoxItem item = (ComboBoxItem)this.compressionComboBox.getSelectedItem();
        return (SWFCompression)item.getValue();
    }

    private void refresh() {
        this.modifying = true;
        this.propertiesPanel.setVisible(this.swf != null);
        if (this.swf == null) {
            this.modifying = false;
            return;
        }
        switch (this.swf.compression) {
            case LZMA: {
                this.compressionComboBox.setSelectedIndex(2);
                break;
            }
            case ZLIB: {
                this.compressionComboBox.setSelectedIndex(1);
                break;
            }
            case NONE: {
                this.compressionComboBox.setSelectedIndex(0);
            }
        }
        this.versionEditor.setValue(this.swf.version);
        this.encryptedCheckBox.setSelected(this.swf.encrypted);
        this.gfxCheckBox.setSelected(this.swf.gfx);
        this.frameRateEditor.setValue(Float.valueOf(this.swf.frameRate));
        this.widthEditor.setValue(this.swf.displayRect.getWidth() / 20);
        this.heightEditor.setValue(this.swf.displayRect.getHeight() / 20);
        SetBackgroundColorTag backgroundColorTag = this.swf.getBackgroundColor();
        if (backgroundColorTag != null) {
            this.colorSelectionButton.setValue(backgroundColorTag.backgroundColor.toColor());
        }
        this.modifying = false;
    }

    public void setSwf(SWF swf) {
        this.swf = swf;
        this.refresh();
    }

    abstract class HeaderChangeDoableOperation
    extends ChangeDoableOperation {
        private boolean modifiedBefore;

        public HeaderChangeDoableOperation(String itemIdentifier) {
            super(itemIdentifier);
            this.modifiedBefore = DocumentPropertiesPanel.this.swf.isHeaderModified();
        }

        @Override
        public final void doOperation() {
            DocumentPropertiesPanel.this.modifying = true;
            this.doHeaderOperation();
            DocumentPropertiesPanel.this.swf.setHeaderModified(true);
            DocumentPropertiesPanel.this.refresh();
            DocumentPropertiesPanel.this.validateHeader();
            DocumentPropertiesPanel.this.modifying = false;
        }

        @Override
        public final void undoOperation() {
            DocumentPropertiesPanel.this.modifying = true;
            this.undoHeaderOperation();
            DocumentPropertiesPanel.this.swf.setHeaderModified(this.modifiedBefore);
            DocumentPropertiesPanel.this.refresh();
            DocumentPropertiesPanel.this.validateHeader();
            DocumentPropertiesPanel.this.modifying = false;
        }

        public abstract void doHeaderOperation();

        public abstract void undoHeaderOperation();
    }
}

