/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationCategory;
import com.jpexs.decompiler.flash.configuration.ConfigurationDirectory;
import com.jpexs.decompiler.flash.configuration.ConfigurationFile;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ColorSelectionButton;
import com.jpexs.decompiler.flash.gui.ConfigurationDirectorySelection;
import com.jpexs.decompiler.flash.gui.ConfigurationFileSelection;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.HtmlLabel;
import com.jpexs.decompiler.flash.gui.OceanicSkin;
import com.jpexs.decompiler.flash.gui.SelectLanguageDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.api.skin.SkinInfo;

public class AdvancedSettingsDialog
extends AppDialog {
    private final Map<String, JLabel> labelsMap = new HashMap<String, JLabel>();
    private final Map<String, Component> componentsMap = new HashMap<String, Component>();
    private final Map<String, String> titleToNameMap = new HashMap<String, String>();
    private final Map<String, Integer> categoryCounts = new HashMap<String, Integer>();
    private final JTextField searchTextField = new JTextField(30);
    private final Map<String, Component> allComponentsMap = new HashMap<String, Component>();
    private Map<String, Component> tabs = new HashMap<String, Component>();
    private JButton cancelButton;
    private JButton okButton;
    private JButton resetButton;
    private JTabbedPane tabPane = new JTabbedPane();
    private String hilightBackgroundColorHex;
    private String hilightForegroundColorHex;

    public AdvancedSettingsDialog(Window owner, String selectedCategory) {
        super(owner);
        this.initComponents(selectedCategory);
        View.centerScreen(this);
        View.setWindowIcon(this, "settings");
        this.pack();
        Color c = UIManager.getColor("List.selectionBackground");
        this.hilightBackgroundColorHex = String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
        c = UIManager.getColor("List.selectionForeground");
        this.hilightForegroundColorHex = String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    private DefaultTableModel getModel() {
        return new DefaultTableModel(new Object[0][], new String[]{this.translate("advancedSettings.columns.name"), this.translate("advancedSettings.columns.value"), this.translate("advancedSettings.columns.description")}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class, String.class};
                this.canEdit = new boolean[]{false, true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
    }

    private void initTabPane(String filter, String selectedCategory) {
        String[] catOrder;
        this.tabPane.removeAll();
        JComboBox<SkinSelect> skinComboBox = new JComboBox<SkinSelect>();
        skinComboBox.setRenderer((ListCellRenderer<SkinSelect>)new SubstanceDefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SubstanceDefaultListCellRenderer cmp = (SubstanceDefaultListCellRenderer)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                final SkinSelect ss = (SkinSelect)value;
                cmp.setIcon(new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        Graphics2D g2 = (Graphics2D)g;
                        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        try {
                            Class<?> act = Class.forName(ss.getClassName());
                            SubstanceSkin skin = (SubstanceSkin)act.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            Color fill = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
                            Color hilight = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getBackgroundFillColor();
                            Color border = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED).getDarkColor();
                            g2.setColor(fill);
                            g2.fillOval(0, 0, 16, 16);
                            g2.setColor(hilight);
                            g2.fillArc(0, 0, 16, 16, -45, 90);
                            g2.setColor(border);
                            g2.drawOval(0, 0, 16, 16);
                        }
                        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }

                    @Override
                    public int getIconWidth() {
                        return 16;
                    }

                    @Override
                    public int getIconHeight() {
                        return 16;
                    }
                });
                return cmp;
            }
        });
        skinComboBox.addItem(new SkinSelect("Oceanic", OceanicSkin.class.getName()));
        Map skins = SubstanceLookAndFeel.getAllSkins();
        for (String skinKey : skins.keySet()) {
            SkinInfo skin = (SkinInfo)skins.get(skinKey);
            skinComboBox.addItem(new SkinSelect(skin.getDisplayName(), skin.getClassName()));
            if (!skin.getClassName().equals(Configuration.guiSkin.get())) continue;
            skinComboBox.setSelectedIndex(skinComboBox.getItemCount() - 1);
        }
        this.tabs = new LinkedHashMap<String, Component>();
        AdvancedSettingsDialog.getCategories(this.hilightBackgroundColorHex, this.hilightForegroundColorHex, this.allComponentsMap, this.categoryCounts, filter, this.titleToNameMap, this.labelsMap, this.componentsMap, this.tabs, skinComboBox, this.getResourceBundle());
        for (String cat : catOrder = new String[]{"ui", "display", "decompilation", "script", "format", "export", "import", "paths", "limit", "update", "debug", "other"}) {
            if (!this.tabs.containsKey(cat)) continue;
            int count = this.categoryCounts.get(cat);
            String countAdd = "";
            if (!filter.trim().equals("")) {
                countAdd = " (" + count + ")";
            }
            if (count > 0) {
                this.tabPane.add(this.translate("config.group.name." + cat) + countAdd, this.tabs.get(cat));
                this.tabPane.setToolTipTextAt(this.tabPane.getTabCount() - 1, this.translate("config.group.description." + cat));
                continue;
            }
            if (!cat.equals(selectedCategory)) continue;
            selectedCategory = null;
        }
        if (selectedCategory != null && this.tabs.containsKey(selectedCategory)) {
            this.tabPane.setSelectedComponent(this.tabs.get(selectedCategory));
        }
    }

    private void initComponents(String selectedCategory) {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.resetButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.translate("advancedSettings.dialog.title"));
        this.setModal(true);
        this.setPreferredSize(new Dimension(800, 500));
        this.okButton.setText(AppStrings.translate("button.ok"));
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.setText(AppStrings.translate("button.cancel"));
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        this.resetButton.setText(AppStrings.translate("button.reset"));
        this.resetButton.addActionListener(this::resetButtonActionPerformed);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        JPanel buttonsLeftPanel = new JPanel(new FlowLayout());
        buttonsLeftPanel.add((Component)this.resetButton, "West");
        buttonsPanel.add((Component)buttonsLeftPanel, "West");
        JPanel buttonsRightPanel = new JPanel(new FlowLayout());
        buttonsRightPanel.add(this.okButton);
        buttonsRightPanel.add(this.cancelButton);
        buttonsPanel.add((Component)buttonsRightPanel, "East");
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String val = AdvancedSettingsDialog.this.searchTextField.getText();
                Component selComponent = AdvancedSettingsDialog.this.tabPane.getSelectedComponent();
                String selCategory = null;
                for (String cat : AdvancedSettingsDialog.this.tabs.keySet()) {
                    if (AdvancedSettingsDialog.this.tabs.get(cat) != selComponent) continue;
                    selCategory = cat;
                    break;
                }
                AdvancedSettingsDialog.this.initTabPane(val, selCategory);
            }
        });
        JPanel searchPanel = new JPanel(new FlowLayout());
        searchPanel.add(new JLabel(this.translate("advancedSettings.search")));
        searchPanel.add(this.searchTextField);
        buttonsPanel.add((Component)searchPanel, "Center");
        cnt.add((Component)buttonsPanel, "South");
        this.initTabPane("", selectedCategory);
        cnt.add((Component)this.tabPane, "Center");
        this.pack();
        this.searchTextField.requestFocusInWindow();
    }

    public static void getCategories(String hilightBackgroundColorHex, String hilightForegroundColorHex, Map<String, Component> allComponentsMap, Map<String, Integer> categoryCounts, String filter, Map<String, String> titleToNameMap, Map<String, JLabel> labelsMap, Map<String, Component> componentsMap, Map<String, Component> tabs, JComboBox<?> skinComboBox, ResourceBundle resourceBundle) {
        HashMap categorized = new HashMap();
        Map fields = Configuration.getConfigurationFields((boolean)false, (boolean)false);
        Object[] keys = new String[fields.size()];
        keys = fields.keySet().toArray(keys);
        Arrays.sort(keys);
        for (Object name : keys) {
            String scat;
            Field field = (Field)fields.get(name);
            ConfigurationCategory cat = field.getAnnotation(ConfigurationCategory.class);
            String string = scat = cat == null || cat.value().isEmpty() ? "other" : cat.value();
            if (!categorized.containsKey(scat)) {
                categorized.put(scat, new HashMap());
            }
            ((Map)categorized.get(scat)).put(name, field);
        }
        for (String cat : categorized.keySet()) {
            JPanel configPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = -1;
            gbc.insets = new Insets(2, 2, 2, 2);
            int itemCount = 0;
            ArrayList names = new ArrayList(((Map)categorized.get(cat)).keySet());
            final HashMap<String, String> locNames = new HashMap<String, String>();
            for (String name : names) {
                String locName;
                if (resourceBundle.containsKey("config.name." + name)) {
                    locName = resourceBundle.getString("config.name." + name);
                } else {
                    Field f = (Field)fields.get(name);
                    if (!ConfigurationItem.isInternal((Field)f)) {
                        throw new RuntimeException("Missing configuration name: " + name);
                    }
                    locName = "(Internal) " + name;
                }
                locNames.put(name, locName);
            }
            Collections.sort(names, new Comparator<String>(){

                @Override
                public int compare(String name1, String name2) {
                    return ((String)locNames.get(name1)).compareTo((String)locNames.get(name2));
                }
            });
            for (String name : names) {
                Field field = (Field)((Map)categorized.get(cat)).get(name);
                String locName = (String)locNames.get(name);
                String description = "";
                if (resourceBundle.containsKey("config.description." + name)) {
                    description = resourceBundle.getString("config.description." + name);
                }
                if (!"".equals(filter.trim()) && !locName.toLowerCase().contains(filter.toLowerCase()) && !description.toLowerCase().contains(filter.toLowerCase())) continue;
                try {
                    field.setAccessible(true);
                    ConfigurationItem item = (ConfigurationItem)field.get(null);
                    ParameterizedType listType = (ParameterizedType)field.getGenericType();
                    Type itemType2 = listType.getActualTypeArguments()[0];
                    if (!(itemType2 instanceof Class)) continue;
                    Class itemType = (Class)itemType2;
                    Object defaultValue = Configuration.getDefaultValue((Field)field);
                    if (name.equals("gui.skin")) {
                        try {
                            Class<?> c = Class.forName((String)defaultValue);
                            defaultValue = c.getField("NAME").get(c);
                        }
                        catch (ClassNotFoundException | NoSuchFieldException | SecurityException ex) {
                            Logger.getLogger(AdvancedSettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (itemType == Color.class) {
                        defaultValue = ColorSelectionButton.colorToHex((Color)defaultValue);
                    }
                    String locNameHtml = locName;
                    if (!filter.trim().equals("")) {
                        locNameHtml = Pattern.compile(Pattern.quote(filter), 66).matcher(locNameHtml).replaceAll("{bold}$0{/bold}");
                    }
                    locNameHtml = "<html>" + locNameHtml.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;") + "</html>";
                    locNameHtml = locNameHtml.replace("{bold}", "<span style=\"background-color:" + hilightBackgroundColorHex + "; color: " + hilightForegroundColorHex + "\">").replace("{/bold}", "</span>");
                    if (defaultValue != null) {
                        description = description + " (" + resourceBundle.getString("default") + ": " + defaultValue + ")";
                    }
                    JLabel l = new JLabel(locNameHtml, 11);
                    titleToNameMap.put(locName, name);
                    l.setToolTipText(description);
                    gbc.gridx = 0;
                    ++gbc.gridy;
                    gbc.anchor = 22;
                    configPanel.add((Component)l, gbc);
                    JComponent c = null;
                    if (allComponentsMap.containsKey(name)) {
                        c = allComponentsMap.get(name);
                    } else {
                        JComponent cb;
                        if (name.equals("gui.skin")) {
                            skinComboBox.setToolTipText(description);
                            skinComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, skinComboBox.getPreferredSize().height));
                            c = skinComboBox;
                        } else if (itemType == String.class || itemType == Integer.class || itemType == Long.class || itemType == Double.class || itemType == Float.class || itemType == Calendar.class) {
                            Dimension dim;
                            int maxW;
                            int minW;
                            ConfigurationFile confFile = field.getAnnotation(ConfigurationFile.class);
                            ConfigurationDirectory confDirectory = field.getAnnotation(ConfigurationDirectory.class);
                            Object val = item.get();
                            if (val == null) {
                                val = "";
                            }
                            if (confFile != null) {
                                c = new ConfigurationFileSelection(item, confFile, val.toString(), description);
                                minW = 300;
                                maxW = 300;
                            } else if (confDirectory != null) {
                                c = new ConfigurationDirectorySelection(item, val.toString(), description);
                                minW = 300;
                                maxW = 300;
                            } else {
                                JTextField tf = new JTextField();
                                if (itemType == Calendar.class) {
                                    tf.setText(new SimpleDateFormat().format(((Calendar)val).getTime()));
                                } else {
                                    tf.setText(val.toString());
                                }
                                tf.setToolTipText(description);
                                c = tf;
                                minW = 100;
                                maxW = 400;
                            }
                            if (((Component)c).getPreferredSize().width > maxW) {
                                dim = new Dimension(maxW, ((Component)c).getPreferredSize().height);
                                ((Component)c).setPreferredSize(dim);
                            } else {
                                dim = new Dimension(minW, ((Component)c).getPreferredSize().height);
                                ((Component)c).setPreferredSize(dim);
                            }
                        } else if (itemType == Boolean.class) {
                            cb = new JCheckBox();
                            ((AbstractButton)cb).setSelected((Boolean)item.get());
                            cb.setToolTipText(description);
                            c = cb;
                        } else if (itemType == Color.class) {
                            cb = new ColorSelectionButton((Color)item.get(), description);
                            cb.setMaximumSize(new Dimension(Integer.MAX_VALUE, cb.getPreferredSize().height));
                            c = cb;
                        } else if (itemType.isEnum()) {
                            cb = new JComboBox();
                            EnumSet enumValues = EnumSet.allOf(itemType);
                            String stringValue = null;
                            for (Object enumValue : enumValues) {
                                String enumValueStr = enumValue.toString();
                                if (stringValue == null) {
                                    stringValue = enumValueStr;
                                }
                                ((JComboBox)cb).addItem(enumValueStr);
                            }
                            if (item.get() != null) {
                                stringValue = item.get().toString();
                            }
                            cb.setToolTipText(description);
                            ((JComboBox)cb).setSelectedItem(stringValue);
                            cb.setMaximumSize(new Dimension(Integer.MAX_VALUE, cb.getPreferredSize().height));
                            c = cb;
                        } else {
                            throw new UnsupportedOperationException("Configuration ttem type '" + itemType.getName() + "' is not supported");
                        }
                        labelsMap.put(name, l);
                        componentsMap.put(name, c);
                        allComponentsMap.put(name, c);
                    }
                    JComboBox<?> toLabelComponent = c;
                    if (toLabelComponent instanceof ConfigurationFileSelection) {
                        toLabelComponent = ((ConfigurationFileSelection)((Object)toLabelComponent)).getTextField();
                    }
                    if (toLabelComponent instanceof ConfigurationDirectorySelection) {
                        toLabelComponent = ((ConfigurationDirectorySelection)((Object)toLabelComponent)).getTextField();
                    }
                    l.setLabelFor(toLabelComponent);
                    ++gbc.gridx;
                    gbc.anchor = 21;
                    configPanel.add(c, gbc);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw new Error(ex.getMessage());
                }
                ++itemCount;
            }
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            configPanel.add((Component)new JPanel(), gbc);
            categoryCounts.put(cat, itemCount);
            if (resourceBundle.containsKey("config.group.tip." + cat)) {
                String tip = resourceBundle.getString("config.group.tip." + cat);
                String[] urls = new String[]{};
                if (resourceBundle.containsKey("config.group.link." + cat)) {
                    urls = resourceBundle.getString("config.group.link." + cat).split(" ");
                }
                for (int i = 0; i < urls.length; ++i) {
                    tip = tip.replace("%link" + (i + 1) + "%", urls[i]);
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)configPanel, "Center");
                JPanel tipPanel = new JPanel(new FlowLayout());
                tipPanel.add(new HtmlLabel("<b>" + resourceBundle.getString("tip") + "</b>" + tip));
                p.add((Component)tipPanel, "South");
                configPanel = p;
            }
            tabs.put(cat, new FasterScrollPane(configPanel));
        }
    }

    private void showRestartConfirmDialog() {
        if (ViewMessages.showConfirmDialog(this, this.translate("advancedSettings.restartConfirmation"), AppStrings.translate("message.warning"), 0) == 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(AdvancedSettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
            SelectLanguageDialog.reloadUi();
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Object value;
        Component c;
        boolean modified = false;
        Map fields = Configuration.getConfigurationFields((boolean)false, (boolean)false);
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String name : fields.keySet()) {
            block24: {
                c = this.allComponentsMap.get(name);
                value = null;
                ParameterizedType listType = (ParameterizedType)((Field)fields.get(name)).getGenericType();
                Type itemType2 = listType.getActualTypeArguments()[0];
                if (!(itemType2 instanceof Class)) continue;
                Class itemType = (Class)itemType2;
                if (c instanceof ConfigurationFileSelection) {
                    value = ((ConfigurationFileSelection)c).getValue();
                } else if (c instanceof ConfigurationDirectorySelection) {
                    value = ((ConfigurationDirectorySelection)c).getValue();
                } else if (name.equals("gui.skin")) {
                    value = ((SkinSelect)((JComboBox)c).getSelectedItem()).className;
                } else if (itemType == String.class) {
                    value = ((JTextField)c).getText();
                }
                if (itemType == Boolean.class) {
                    value = ((JCheckBox)c).isSelected();
                }
                if (itemType == Color.class) {
                    value = ((ColorSelectionButton)c).getValue();
                }
                if (itemType == Calendar.class) {
                    Calendar cal = Calendar.getInstance();
                    try {
                        cal.setTime(new SimpleDateFormat().parse(((JTextField)c).getText()));
                    }
                    catch (ParseException ex) {
                        c.requestFocusInWindow();
                        return;
                    }
                    value = cal;
                }
                if (itemType.isEnum()) {
                    String stringValue = (String)((JComboBox)c).getSelectedItem();
                    value = Enum.valueOf(itemType, stringValue);
                }
                try {
                    if (itemType == Integer.class) {
                        value = Integer.parseInt(((JTextField)c).getText());
                    }
                    if (itemType == Long.class) {
                        value = Long.parseLong(((JTextField)c).getText());
                    }
                    if (itemType == Double.class) {
                        value = Double.parseDouble(((JTextField)c).getText());
                    }
                    if (itemType == Float.class) {
                        value = Float.valueOf(Float.parseFloat(((JTextField)c).getText()));
                    }
                }
                catch (NumberFormatException nfe) {
                    if (((JTextField)c).getText().isEmpty()) break block24;
                    c.requestFocusInWindow();
                    return;
                }
            }
            values.put(name, value);
        }
        for (String name : fields.keySet()) {
            c = this.componentsMap.get(name);
            value = values.get(name);
            Field field = (Field)fields.get(name);
            ConfigurationItem item = null;
            try {
                field.setAccessible(true);
                item = (ConfigurationItem)field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new Error(ex.getMessage());
            }
            if (item.get() != null && item.get().equals(value) || !item.hasValue() && value == null) continue;
            item.set(value);
            modified = true;
        }
        Configuration.saveConfig();
        this.setVisible(false);
        if (modified) {
            this.showRestartConfirmDialog();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        Map rfields = Configuration.getConfigurationFields((boolean)false, (boolean)false);
        for (Map.Entry entry : rfields.entrySet()) {
            String name = (String)entry.getKey();
            Field field = (Field)entry.getValue();
            try {
                ConfigurationItem item = (ConfigurationItem)field.get(null);
                item.unset();
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new Error(ex.getMessage());
            }
        }
        Configuration.saveConfig();
        this.setVisible(false);
        this.showRestartConfirmDialog();
    }

    private static class SkinSelect {
        private final String name;
        private final String className;

        public SkinSelect(String name, String className) {
            this.name = name;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return this.name;
        }
    }
}

