/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.SelectTagOfTypeDialog;
import com.jpexs.decompiler.flash.gui.SelectTagPositionDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineFont4Tag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.ImportTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.timeline.Timelined;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AsLinkageDialog
extends AppDialog {
    private final JButton proceedButton = new JButton(this.translate("button.proceed"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private final JTextField identifierTextField = new JTextField(30);
    private final JTextField classNameTextField = new JTextField(30);
    private final JTextField parentClassNameTextField = new JTextField(30);
    private String selectedIdentifier = null;
    private String selectedClass = null;
    private String selectedParentClass = null;
    private ExportAssetsTag originalExportAssetsTag;
    private ExportAssetsTag selectedExportAssetsTag;
    private String originalClassName;
    private Tag selectedPosition;
    private Timelined selectedTimelined;
    private int result = -1;
    private final SWF swf;
    private final int characterId;
    private int characterFrame = -1;
    private int exportAssetsCount = 0;
    private final JLabel errorLabel = new JLabel();
    private final JLabel parentClassNameLabel = new JLabel(this.translate("class.parentname"));
    private final JRadioButton existingExportAssetsTagRadioButton = new JRadioButton(this.translate("linkage.notfound.exportAssets.where.existing"));
    private final JRadioButton newExportAssetsTagRadioButton = new JRadioButton(this.translate("linkage.notfound.exportAssets.where.new"));
    private static final Map<Class<?>, String> tagTypeToParentClass = new HashMap();
    private Set<String> existingNames = new HashSet<String>();

    public static String getParentClassFromCharacter(CharacterTag ch) {
        for (Class<?> cls : tagTypeToParentClass.keySet()) {
            if (!cls.isAssignableFrom(ch.getClass())) continue;
            return tagTypeToParentClass.get(cls);
        }
        return null;
    }

    public AsLinkageDialog(Window owner, SWF swf, int characterId) {
        super(owner);
        ExportAssetsTag ea;
        this.swf = swf;
        this.characterId = characterId;
        CharacterTag ch = swf.getCharacter(characterId);
        if (ch == null) {
            throw new RuntimeException("Character " + characterId + " not found");
        }
        int frame = 1;
        for (Tag t : swf.getTags()) {
            if (t == ch) {
                this.characterFrame = frame;
            }
            if (t instanceof ShowFrameTag) {
                ++frame;
            }
            if (t instanceof ExportAssetsTag) {
                ea = (ExportAssetsTag)t;
                this.existingNames.addAll(ea.names);
            }
            if (!(t instanceof ImportTag)) continue;
            ImportTag it = (ImportTag)t;
            this.existingNames.addAll(it.getAssets().values());
        }
        frame = 1;
        for (Tag t : swf.getTags()) {
            if (frame >= this.characterFrame && t instanceof ExportAssetsTag) {
                ea = (ExportAssetsTag)t;
                if (ea.tags.contains(characterId)) {
                    this.originalExportAssetsTag = ea;
                }
                ++this.exportAssetsCount;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            ++frame;
        }
        String originalIdentifier = ch.getExportName();
        this.identifierTextField.setText(originalIdentifier);
        this.originalClassName = ch.getAs2ClassName();
        if (this.originalClassName != null) {
            this.classNameTextField.setText(this.originalClassName);
            this.classNameTextField.setEnabled(false);
            this.identifierTextField.setEnabled(false);
        }
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title"));
        Container cnt = this.getContentPane();
        cnt.setLayout(new BoxLayout(cnt, 1));
        cnt.add(new JLabel(this.translate("identifier")));
        cnt.add(this.identifierTextField);
        cnt.add(new JLabel(this.translate("classname")));
        cnt.add(this.classNameTextField);
        if (this.originalClassName == null) {
            cnt.add(this.parentClassNameLabel);
            cnt.add(this.parentClassNameTextField);
        }
        cnt.add(this.errorLabel);
        if (this.originalClassName == null && this.originalExportAssetsTag == null) {
            ButtonGroup whereToStoreMappingButtonGroup = new ButtonGroup();
            whereToStoreMappingButtonGroup.add(this.existingExportAssetsTagRadioButton);
            whereToStoreMappingButtonGroup.add(this.newExportAssetsTagRadioButton);
            cnt.add(new JLabel(this.translate("linkage.notfound.exportAssets.where")));
            JPanel whereToStoreMappingPanel = new JPanel(new FlowLayout());
            whereToStoreMappingPanel.add(this.existingExportAssetsTagRadioButton);
            whereToStoreMappingPanel.add(this.newExportAssetsTagRadioButton);
            cnt.add(whereToStoreMappingPanel);
            this.existingExportAssetsTagRadioButton.setSelected(true);
        }
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.proceedButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(this.proceedButton);
        buttonsPanel.add(this.cancelButton);
        cnt.add(buttonsPanel);
        this.setCentralAlignment((JComponent)cnt);
        if (this.exportAssetsCount == 0) {
            this.newExportAssetsTagRadioButton.setSelected(true);
            this.newExportAssetsTagRadioButton.setEnabled(false);
            this.existingExportAssetsTagRadioButton.setEnabled(false);
        }
        this.existingExportAssetsTagRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AsLinkageDialog.this.checkEnabled();
            }
        });
        this.newExportAssetsTagRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AsLinkageDialog.this.checkEnabled();
            }
        });
        DocumentListener updateDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AsLinkageDialog.this.checkEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AsLinkageDialog.this.checkEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AsLinkageDialog.this.checkEnabled();
            }
        };
        this.identifierTextField.getDocument().addDocumentListener(updateDocumentListener);
        this.classNameTextField.getDocument().addDocumentListener(updateDocumentListener);
        this.parentClassNameTextField.getDocument().addDocumentListener(updateDocumentListener);
        this.classNameTextField.addActionListener(this::okButtonActionPerformed);
        this.checkEnabled();
        this.pack();
        this.setModal(true);
        this.setResizable(false);
        View.setWindowIcon(this);
        View.centerScreen(this);
    }

    private void setCentralAlignment(JComponent container) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setAlignmentX(0.5f);
        }
    }

    private void checkEnabled() {
        String oldClassName;
        boolean ok = true;
        CharacterTag ch = this.swf.getCharacter(this.characterId);
        String oldIdentifier = ch.getExportName();
        String newIdentifier = this.identifierTextField.getText();
        String newClassName = this.classNameTextField.getText();
        if (this.originalClassName != null) {
            ok = false;
            this.proceedButton.setText(this.translate("button.ok"));
            this.errorLabel.setText("");
        }
        if (!this.classNameTextField.isEnabled() && newIdentifier.isEmpty()) {
            ok = false;
            this.proceedButton.setText(this.translate("button.ok"));
            this.errorLabel.setText(this.translate("error.cannotRemoveIdentifierClassExists"));
        }
        if (newClassName.endsWith(".")) {
            ok = false;
            this.proceedButton.setText(this.translate("button.ok"));
            this.errorLabel.setText("");
        }
        if (newIdentifier.isEmpty() && !newClassName.isEmpty()) {
            ok = false;
            this.proceedButton.setText(this.translate("button.ok"));
            this.errorLabel.setText("");
        }
        if (!newIdentifier.isEmpty() && oldIdentifier != null && !oldIdentifier.equals(newIdentifier) && this.existingNames.contains(newIdentifier)) {
            ok = false;
            this.proceedButton.setText(this.translate("button.ok"));
            this.errorLabel.setText("");
        }
        if (ok && (oldClassName = ch.getAs2ClassName()) == null && newClassName != null && ch.getSwf().getCharacterByExportName("__Packages." + newClassName) != null) {
            ok = false;
            this.errorLabel.setText(this.translate("error.alreadyExistsClass"));
        }
        if (ok) {
            if (this.originalExportAssetsTag != null) {
                this.proceedButton.setText(this.translate("button.ok"));
            } else if (this.existingExportAssetsTagRadioButton.isSelected() && this.exportAssetsCount == 1) {
                this.proceedButton.setText(this.translate("button.ok"));
            } else {
                this.proceedButton.setText(this.translate("button.proceed"));
            }
        } else {
            this.proceedButton.setText(this.translate("button.ok"));
        }
        this.proceedButton.setEnabled(ok);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!this.proceedButton.isEnabled()) {
            return;
        }
        this.setVisible(false);
        if (this.originalExportAssetsTag != null) {
            this.selectedExportAssetsTag = this.originalExportAssetsTag;
        } else {
            if (this.existingExportAssetsTagRadioButton.isSelected()) {
                SelectTagOfTypeDialog selectExportAssetsDialog = new SelectTagOfTypeDialog(this.owner, this.swf, ExportAssetsTag.class, "ExportAssets", this.characterFrame);
                this.selectedExportAssetsTag = (ExportAssetsTag)selectExportAssetsDialog.showDialog();
                if (this.selectedExportAssetsTag == null) {
                    this.cancelButtonActionPerformed(evt);
                    return;
                }
            }
            if (this.newExportAssetsTagRadioButton.isSelected()) {
                SelectTagPositionDialog selectTagPositionDialog = new SelectTagPositionDialog(this.owner, this.swf, false, "ExportAssets", this.characterFrame);
                if (selectTagPositionDialog.showDialog() != 0) {
                    this.cancelButtonActionPerformed(evt);
                    return;
                }
                this.selectedPosition = selectTagPositionDialog.getSelectedTag();
                this.selectedTimelined = selectTagPositionDialog.getSelectedTimelined();
            }
        }
        this.result = 0;
        this.selectedIdentifier = this.identifierTextField.getText();
        this.selectedClass = this.classNameTextField.getText();
        this.selectedParentClass = this.parentClassNameTextField.getText();
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.selectedIdentifier = null;
        this.selectedClass = null;
        this.selectedParentClass = null;
        this.selectedPosition = null;
        this.selectedTimelined = null;
        this.selectedExportAssetsTag = null;
        this.characterFrame = -1;
        this.result = 1;
        this.setVisible(false);
    }

    public int showDialog() {
        this.selectedIdentifier = null;
        this.selectedClass = null;
        this.selectedParentClass = null;
        this.selectedPosition = null;
        this.selectedTimelined = null;
        this.selectedExportAssetsTag = null;
        this.setVisible(true);
        return this.result;
    }

    public Tag getSelectedPosition() {
        return this.selectedPosition;
    }

    public String getSelectedClass() {
        return this.selectedClass;
    }

    public String getSelectedParentClass() {
        return this.selectedParentClass;
    }

    public ExportAssetsTag getSelectedExportAssetsTag() {
        return this.selectedExportAssetsTag;
    }

    public Timelined getSelectedTimelined() {
        return this.selectedTimelined;
    }

    public int getCharacterFrame() {
        return this.characterFrame;
    }

    public String getSelectedIdentifier() {
        return this.selectedIdentifier;
    }

    static {
        tagTypeToParentClass.put(SoundTag.class, "flash.media.Sound");
        tagTypeToParentClass.put(ImageTag.class, "flash.display.Bitmap");
        tagTypeToParentClass.put(FontTag.class, "flash.text.Font");
        tagTypeToParentClass.put(DefineFont4Tag.class, "flash.text.Font");
        tagTypeToParentClass.put(DefineBinaryDataTag.class, "flash.utils.ByteArray");
        tagTypeToParentClass.put(DefineSpriteTag.class, "flash.display.Sprite");
    }
}

