/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.hexview.HexView;
import com.jpexs.decompiler.flash.tags.base.BinaryDataInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class BinaryPanel
extends JPanel {
    public HexView hexEditor = new HexView();
    private byte[] data;
    private JPanel swfOrPackedDataInsidePanel;
    private BinaryDataInterface binaryData = null;
    private final MainPanel mainPanel;
    private final JLabel swfOrPackedDataInsideLabel;

    public BinaryPanel(final MainPanel mainPanel) {
        super(new BorderLayout());
        this.mainPanel = mainPanel;
        this.add((Component)new FasterScrollPane(this.hexEditor), "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        bottomPanel.add((Component)buttonsPanel, "East");
        this.add((Component)bottomPanel, "South");
        this.swfOrPackedDataInsideLabel = new JLabel(AppStrings.translate("binarydata.swfInside"));
        this.swfOrPackedDataInsidePanel = new JPanel();
        this.swfOrPackedDataInsidePanel.setBackground(new Color(253, 205, 137));
        this.swfOrPackedDataInsidePanel.setCursor(Cursor.getPredefinedCursor(12));
        this.swfOrPackedDataInsidePanel.add(this.swfOrPackedDataInsideLabel);
        this.swfOrPackedDataInsidePanel.setFocusable(true);
        this.swfOrPackedDataInsidePanel.setBorder(BorderFactory.createBevelBorder(0));
        this.swfOrPackedDataInsidePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (BinaryPanel.this.binaryData.getUsedPacker() != null) {
                    BinaryPanel.this.binaryData.unpack(BinaryPanel.this.binaryData.getUsedPacker(), BinaryPanel.this.binaryData.getPackerKey());
                }
                mainPanel.loadFromBinaryTag(BinaryPanel.this.binaryData);
                BinaryPanel.this.swfOrPackedDataInsidePanel.setVisible(false);
            }
        });
        this.add((Component)this.swfOrPackedDataInsidePanel, "North");
        this.swfOrPackedDataInsidePanel.setVisible(false);
    }

    public void setBinaryData(BinaryDataInterface binaryData) {
        this.binaryData = binaryData;
        byte[] byArray = this.data = binaryData == null ? null : binaryData.getDataBytes().getRangeData();
        if (this.data != null) {
            this.hexEditor.setData(this.data, null, null);
            boolean isSwfData = binaryData.isSwfData();
            if (isSwfData) {
                this.swfOrPackedDataInsideLabel.setText(AppStrings.translate("binarydata.swfInside"));
            } else {
                binaryData.detectPacker();
                if (binaryData.getUsedPacker() != null) {
                    this.swfOrPackedDataInsideLabel.setText(AppStrings.translate("binarydata.dataInside.packer").replace("%packer%", binaryData.getUsedPacker().getName()));
                }
            }
            this.swfOrPackedDataInsidePanel.setVisible(binaryData.getSub() == null && binaryData.getUsedPacker() != null || isSwfData && binaryData.getInnerSwf() == null);
        } else {
            this.hexEditor.setData(new byte[0], null, null);
            this.swfOrPackedDataInsidePanel.setVisible(false);
        }
        this.hexEditor.revalidate();
        this.hexEditor.repaint();
    }
}

