/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.debugger.flash.Variable;
import com.jpexs.debugger.flash.messages.in.InConstantPool;
import com.jpexs.debugger.flash.messages.in.InFrame;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.DebuggerHandler;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.HeaderLabel;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.abc.ABCPanel;
import com.jpexs.helpers.Helper;
import de.hameister.treetable.MyTreeTable;
import de.hameister.treetable.MyTreeTableCellRenderer;
import de.hameister.treetable.MyTreeTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;

public class DebugPanel
extends JPanel {
    private MyTreeTable debugRegistersTable;
    private MyTreeTable debugLocalsTable;
    private MyTreeTable debugScopeTable;
    private JTable constantPoolTable;
    private JTabbedPane varTabs;
    private DebuggerHandler.BreakListener breakListener;
    private DebuggerHandler.FrameChangeListener frameChangeListener;
    private JTextArea traceLogTextarea;
    private int logLength = 0;
    private List<SelectedTab> tabTypes = new ArrayList<SelectedTab>();
    private boolean loading = false;
    public ABCPanel.VariablesTableModel localsTable;
    private SelectedTab selectedTab = null;

    public synchronized boolean isLoading() {
        return this.loading;
    }

    public synchronized void setLoading(boolean loading) {
        this.loading = loading;
    }

    private void safeSetTreeModel(MyTreeTable tt, MyTreeTableModel tmodel) {
        int i;
        List<List<String>> expanded = View.getExpandedNodes((JTree)tt.getTree());
        int[] selRows = tt.getSelectedRows();
        TreePath[] selPaths = new TreePath[selRows.length];
        for (i = 0; i < selRows.length; ++i) {
            selPaths[i] = tt.getTree().getPathForRow(selRows[i]);
        }
        tt.setTreeModel(tmodel);
        View.expandTreeNodes((JTree)tt.getTree(), expanded);
        for (i = 0; i < selRows.length; ++i) {
            selRows[i] = tt.getTree().getRowForPath(selPaths[i]);
            if (selRows[i] == -1) continue;
            if (i == 0) {
                tt.setRowSelectionInterval(selRows[i], selRows[i]);
                continue;
            }
            tt.addRowSelectionInterval(selRows[i], selRows[i]);
        }
        int ROW_HEIGHT = new JLabel((String)"A").getPreferredSize().height;
        MyTreeTableCellRenderer tree = tt.getTree();
        tree.setRowHeight(ROW_HEIGHT);
        for (int i2 = 0; i2 < tt.getRowCount(); ++i2) {
            tt.setRowHeight(i2, ROW_HEIGHT);
        }
    }

    private void logAdd(String message) {
        boolean wasEmpty = this.logLength == 0;
        String add = message + "\r\n";
        this.logLength += add.length();
        this.traceLogTextarea.append(add);
        try {
            this.traceLogTextarea.setCaretPosition(this.logLength);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (wasEmpty) {
            this.refresh();
        }
    }

    public DebugPanel() {
        super(new BorderLayout());
        this.debugRegistersTable = new MyTreeTable((MyTreeTableModel)new ABCPanel.VariablesTableModel(this.debugRegistersTable, new ArrayList<Variable>()), false);
        this.debugLocalsTable = new MyTreeTable((MyTreeTableModel)new ABCPanel.VariablesTableModel(this.debugLocalsTable, new ArrayList<Variable>()), false);
        MouseAdapter watchHandler = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.dopop(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.dopop(e);
                }
            }

            private void dopop(MouseEvent e) {
                if (DebugPanel.this.debugLocalsTable.getSelectedRow() == -1) {
                    return;
                }
                Object node = DebugPanel.this.debugLocalsTable.getTree().getPathForRow(DebugPanel.this.debugLocalsTable.getSelectedRow()).getLastPathComponent();
                if (!(node instanceof ABCPanel.VariableNode)) {
                    return;
                }
                ABCPanel.VariableNode vn = (ABCPanel.VariableNode)node;
                Variable v = vn.varInsideGetter != null ? vn.varInsideGetter : vn.var;
                JPopupMenu pm = new JPopupMenu();
                boolean isByteArray = false;
                for (Variable t : vn.traits) {
                    if (!"flash.utils::ByteArray".equals(t.name)) continue;
                    isByteArray = true;
                    break;
                }
                if (isByteArray) {
                    JMenu exportMenu = new JMenu(AppStrings.translate("debug.export").replace("%name%", v.name));
                    JMenuItem exportByteArrayMenuItem = new JMenuItem(AppStrings.translate("debug.export.bytearray"));
                    exportByteArrayMenuItem.addActionListener(e1 -> {
                        JFileChooser fc = new JFileChooser();
                        fc.setCurrentDirectory(new File((String)Configuration.lastExportDir.get()));
                        if (fc.showSaveDialog(Main.getDefaultMessagesComponent()) == 0) {
                            File file = Helper.fixDialogFile((File)fc.getSelectedFile());
                            try {
                                Variable debugConnectionClass = Main.getDebugHandler().getVariable((long)0L, (String)new StringBuilder().append((String)Main.currentDebuggerPackage).append((String)"::DebugConnection").toString(), (boolean)false, (boolean)false).parent;
                                String dataStr = (String)((Variable)Main.getDebugHandler().callMethod((Variable)debugConnectionClass, (String)"readCommaSeparatedFromByteArray", Arrays.asList(new Object[]{v})).variables.get((int)0)).value;
                                String[] parts = dataStr.split(",");
                                byte[] data = new byte[parts.length];
                                for (int i = 0; i < parts.length; ++i) {
                                    data[i] = (byte)Integer.parseInt(parts[i]);
                                }
                                try (FileOutputStream fos = new FileOutputStream(file);){
                                    fos.write(data);
                                    Configuration.lastExportDir.set((Object)file.getParentFile().getAbsolutePath());
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(DebugPanel.class.getName()).log(Level.SEVERE, null, ex);
                                    ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("error.file.save") + ": " + ex.getLocalizedMessage(), AppStrings.translate("error"), 0);
                                }
                            }
                            catch (DebuggerHandler.ActionScriptException ex) {
                                Logger.getLogger(DebugPanel.class.getName()).log(Level.SEVERE, "Error exporting ByteArray", ex);
                            }
                        }
                    });
                    exportMenu.add(exportByteArrayMenuItem);
                    pm.add(exportMenu);
                    JMenu importMenu = new JMenu(AppStrings.translate("debug.import").replace("%name%", v.name));
                    JMenuItem importByteArrayMenuItem = new JMenuItem(AppStrings.translate("debug.import.bytearray"));
                    importByteArrayMenuItem.addActionListener(e1 -> {
                        JFileChooser fc = new JFileChooser();
                        fc.setCurrentDirectory(new File((String)Configuration.lastOpenDir.get()));
                        if (fc.showOpenDialog(Main.getDefaultMessagesComponent()) == 0) {
                            File file = Helper.fixDialogFile((File)fc.getSelectedFile());
                            Configuration.lastOpenDir.set((Object)file.getParentFile().getAbsolutePath());
                            try {
                                byte[] data = Helper.readFileEx((String[])new String[]{file.getAbsolutePath()});
                                String splitter = "";
                                StringBuilder sb = new StringBuilder();
                                for (int i = 0; i < data.length; ++i) {
                                    sb.append(splitter);
                                    sb.append(data[i] & 0xFF);
                                    splitter = ",";
                                }
                                String dataStr = sb.toString();
                                Variable debugConnectionClass = Main.getDebugHandler().getVariable((long)0L, (String)new StringBuilder().append((String)Main.currentDebuggerPackage).append((String)"::DebugConnection").toString(), (boolean)false, (boolean)false).parent;
                                try {
                                    Main.getDebugHandler().callMethod(debugConnectionClass, "writeCommaSeparatedToByteArray", Arrays.asList(dataStr, v));
                                }
                                catch (DebuggerHandler.ActionScriptException ex) {
                                    Logger.getLogger(DebugPanel.class.getName()).log(Level.SEVERE, "Error exporting ByteArray", ex);
                                }
                            }
                            catch (IOException ex) {
                                Logger.getLogger(DebugPanel.class.getName()).log(Level.SEVERE, null, ex);
                                ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("error.file.save") + ": " + ex.getLocalizedMessage(), AppStrings.translate("error"), 0);
                            }
                        }
                    });
                    importMenu.add(importByteArrayMenuItem);
                    pm.add(importMenu);
                }
                long watchParentId = vn.parentObjectId;
                JMenu addWatchMenu = new JMenu(AppStrings.translate("debug.watch.add").replace("%name%", v.name));
                JMenuItem watchReadMenuItem = new JMenuItem(AppStrings.translate("debug.watch.add.read"));
                watchReadMenuItem.addActionListener(e1 -> {
                    if (!Main.addWatch(v, watchParentId, true, false)) {
                        ViewMessages.showMessageDialog(DebugPanel.this, AppStrings.translate("error.debug.watch.add"), AppStrings.translate("error"), 0);
                    }
                });
                JMenuItem watchWriteMenuItem = new JMenuItem(AppStrings.translate("debug.watch.add.write"));
                watchWriteMenuItem.addActionListener(e1 -> {
                    if (!Main.addWatch(v, watchParentId, false, true)) {
                        ViewMessages.showMessageDialog(DebugPanel.this, AppStrings.translate("error.debug.watch.add"), AppStrings.translate("error"), 0);
                    }
                });
                JMenuItem watchReadWriteMenuItem = new JMenuItem(AppStrings.translate("debug.watch.add.readwrite"));
                watchReadWriteMenuItem.addActionListener(e1 -> {
                    if (!Main.addWatch(v, watchParentId, true, true)) {
                        ViewMessages.showMessageDialog(DebugPanel.this, AppStrings.translate("error.debug.watch.add"), AppStrings.translate("error"), 0);
                    }
                });
                addWatchMenu.add(watchReadMenuItem);
                addWatchMenu.add(watchWriteMenuItem);
                addWatchMenu.add(watchReadWriteMenuItem);
                pm.add(addWatchMenu);
                pm.show(e.getComponent(), e.getX(), e.getY());
            }
        };
        this.debugLocalsTable.addMouseListener((MouseListener)watchHandler);
        this.debugScopeTable = new MyTreeTable((MyTreeTableModel)new ABCPanel.VariablesTableModel(this.debugScopeTable, new ArrayList<Variable>()), false);
        this.constantPoolTable = new JTable();
        this.traceLogTextarea = new JTextArea();
        this.traceLogTextarea.setEditable(false);
        this.traceLogTextarea.setOpaque(false);
        this.traceLogTextarea.setFont(new JLabel().getFont());
        if (View.isOceanic()) {
            this.traceLogTextarea.setBackground(Color.white);
        }
        Main.getDebugHandler().addTraceListener(new DebuggerHandler.TraceListener(){

            @Override
            public void trace(String ... val) {
                for (String s : val) {
                    DebugPanel.this.logAdd("trace: " + s);
                }
            }
        });
        Main.getDebugHandler().addErrorListener(new DebuggerHandler.ErrorListener(){

            @Override
            public void errorException(String message, Variable thrownVar) {
                DebugPanel.this.logAdd("unhandled exception: " + message);
                DebugPanel.this.selectedTab = (SelectedTab)((Object)DebugPanel.this.tabTypes.get(DebugPanel.this.tabTypes.size() - 1));
                DebugPanel.this.refresh();
            }
        });
        Main.getDebugHandler().addConnectionListener(new DebuggerHandler.ConnectionListener(){

            @Override
            public void connected() {
            }

            @Override
            public void disconnected() {
                DebugPanel.this.refresh();
            }
        });
        this.frameChangeListener = new DebuggerHandler.FrameChangeListener(){

            @Override
            public void frameChanged() {
                View.execInEventDispatchLater(new Runnable(){

                    @Override
                    public void run() {
                        DebugPanel.this.refresh();
                    }
                });
            }
        };
        Main.getDebugHandler().addFrameChangeListener(this.frameChangeListener);
        this.breakListener = new DebuggerHandler.BreakListener(){

            @Override
            public void doContinue() {
                View.execInEventDispatch(new Runnable(){

                    @Override
                    public void run() {
                        DebugPanel.this.refresh();
                    }
                });
            }

            @Override
            public void breakAt(String scriptName, int line, int classIndex, int traitIndex, int methodIndex) {
            }
        };
        Main.getDebugHandler().addBreakListener(this.breakListener);
        this.varTabs = new JTabbedPane();
        this.varTabs.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == DebugPanel.this.varTabs) {
                    if (DebugPanel.this.isLoading()) {
                        return;
                    }
                    DebugPanel debugPanel = DebugPanel.this;
                    synchronized (debugPanel) {
                        int si = DebugPanel.this.varTabs.getSelectedIndex();
                        if (si > -1 && si < DebugPanel.this.tabTypes.size()) {
                            DebugPanel.this.selectedTab = (SelectedTab)((Object)DebugPanel.this.tabTypes.get(si));
                        }
                    }
                }
            }
        });
        this.add((Component)new HeaderLabel(AppStrings.translate("debugpanel.header")), "North");
        this.add((Component)this.varTabs, "Center");
    }

    public void refresh() {
        View.execInEventDispatch(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DebugPanel.this.setLoading(true);
                DebugPanel debugPanel = DebugPanel.this;
                synchronized (debugPanel) {
                    boolean newVisible;
                    JPanel pa;
                    SelectedTab oldSel = DebugPanel.this.selectedTab;
                    DebugPanel.this.localsTable = null;
                    SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
                    if (swf == null) {
                        return;
                    }
                    boolean as3 = swf.isAS3();
                    InFrame f = Main.getDebugHandler().getFrame();
                    if (f != null) {
                        ArrayList<Variable> locals = new ArrayList<Variable>();
                        Map<String, Long> placedObjects = Main.getDebugHandler().getPlacedObjects();
                        for (String poName : placedObjects.keySet()) {
                            Variable placedVar;
                            String realName = poName;
                            if ("/".equals(realName)) {
                                realName = "_root";
                            } else if (realName.startsWith("/")) continue;
                            if ((placedVar = Main.getDebugHandler().getVariable((long)0L, (String)realName, (boolean)false, (boolean)false).parent) == null) continue;
                            locals.add(placedVar);
                        }
                        DebugPanel.this.safeSetTreeModel(DebugPanel.this.debugRegistersTable, new ABCPanel.VariablesTableModel(DebugPanel.this.debugRegistersTable, f.registers));
                        locals.addAll(f.arguments);
                        locals.addAll(f.variables);
                        DebugPanel.this.localsTable = new ABCPanel.VariablesTableModel(DebugPanel.this.debugLocalsTable, locals);
                        DebugPanel.this.safeSetTreeModel(DebugPanel.this.debugLocalsTable, DebugPanel.this.localsTable);
                        DebugPanel.this.safeSetTreeModel(DebugPanel.this.debugScopeTable, new ABCPanel.VariablesTableModel(DebugPanel.this.debugScopeTable, f.scopeChain));
                        TreeModelListener refreshListener = new TreeModelListener(){

                            @Override
                            public void treeNodesChanged(TreeModelEvent e) {
                                Main.getDebugHandler().refreshFrame();
                                DebugPanel.this.refresh();
                            }

                            @Override
                            public void treeNodesInserted(TreeModelEvent e) {
                                Main.getDebugHandler().refreshFrame();
                                DebugPanel.this.refresh();
                            }

                            @Override
                            public void treeNodesRemoved(TreeModelEvent e) {
                                Main.getDebugHandler().refreshFrame();
                                DebugPanel.this.refresh();
                            }

                            @Override
                            public void treeStructureChanged(TreeModelEvent e) {
                                Main.getDebugHandler().refreshFrame();
                                DebugPanel.this.refresh();
                            }
                        };
                        DebugPanel.this.debugLocalsTable.getTreeTableModel().addTreeModelListener(refreshListener);
                        DebugPanel.this.debugScopeTable.getTreeTableModel().addTreeModelListener(refreshListener);
                    } else {
                        DebugPanel.this.debugRegistersTable.setTreeModel((MyTreeTableModel)new ABCPanel.VariablesTableModel(DebugPanel.this.debugRegistersTable, new ArrayList<Variable>()));
                        DebugPanel.this.debugLocalsTable.setTreeModel((MyTreeTableModel)new ABCPanel.VariablesTableModel(DebugPanel.this.debugLocalsTable, new ArrayList<Variable>()));
                        DebugPanel.this.debugScopeTable.setTreeModel((MyTreeTableModel)new ABCPanel.VariablesTableModel(DebugPanel.this.debugScopeTable, new ArrayList<Variable>()));
                    }
                    InConstantPool cpool = Main.getDebugHandler().getConstantPool();
                    if (cpool != null) {
                        Object[][] data2 = new Object[cpool.vars.size()][2];
                        for (int i = 0; i < cpool.vars.size(); ++i) {
                            data2[i][0] = cpool.ids.get(i);
                            data2[i][1] = ((Variable)cpool.vars.get((int)i)).value;
                        }
                        DebugPanel.this.constantPoolTable.setModel(new DefaultTableModel(data2, new Object[]{AppStrings.translate("constantpool.header.id"), AppStrings.translate("constantpool.header.value")}){

                            @Override
                            public boolean isCellEditable(int row, int column) {
                                return false;
                            }
                        });
                    } else {
                        DebugPanel.this.constantPoolTable.setModel(new DefaultTableModel());
                    }
                    DebugPanel.this.varTabs.removeAll();
                    DebugPanel.this.tabTypes.clear();
                    if (DebugPanel.this.debugRegistersTable.getRowCount() > 0) {
                        DebugPanel.this.tabTypes.add(SelectedTab.REGISTERS);
                        pa = new JPanel(new BorderLayout());
                        pa.add((Component)new FasterScrollPane((Component)DebugPanel.this.debugRegistersTable), "Center");
                        DebugPanel.this.varTabs.addTab(AppStrings.translate("variables.header.registers"), pa);
                    }
                    if (DebugPanel.this.debugLocalsTable.getRowCount() > 0) {
                        DebugPanel.this.tabTypes.add(SelectedTab.LOCALS);
                        pa = new JPanel(new BorderLayout());
                        pa.add((Component)new FasterScrollPane((Component)DebugPanel.this.debugLocalsTable), "Center");
                        DebugPanel.this.varTabs.addTab(AppStrings.translate("variables.header.locals"), pa);
                    }
                    if (DebugPanel.this.debugScopeTable.getRowCount() > 0) {
                        DebugPanel.this.tabTypes.add(SelectedTab.SCOPECHAIN);
                        pa = new JPanel(new BorderLayout());
                        pa.add((Component)new FasterScrollPane((Component)DebugPanel.this.debugScopeTable), "Center");
                        DebugPanel.this.varTabs.addTab(AppStrings.translate("variables.header.scopeChain"), pa);
                    }
                    if (DebugPanel.this.constantPoolTable.getRowCount() > 0) {
                        DebugPanel.this.tabTypes.add(SelectedTab.CONSTANTPOOL);
                        pa = new JPanel(new BorderLayout());
                        pa.add((Component)new FasterScrollPane(DebugPanel.this.constantPoolTable), "Center");
                        DebugPanel.this.varTabs.addTab(AppStrings.translate("constantpool.header"), pa);
                    }
                    if (DebugPanel.this.logLength > 0) {
                        DebugPanel.this.tabTypes.add(SelectedTab.LOG);
                        pa = new JPanel(new BorderLayout());
                        pa.add((Component)new FasterScrollPane(DebugPanel.this.traceLogTextarea), "Center");
                        JButton clearButton = new JButton(AppStrings.translate("debuglog.button.clear"));
                        clearButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DebugPanel.this.traceLogTextarea.setText("");
                                DebugPanel.this.logLength = 0;
                                DebugPanel.this.refresh();
                            }
                        });
                        JPanel butPanel = new JPanel(new FlowLayout());
                        butPanel.add(clearButton);
                        pa.add((Component)butPanel, "South");
                        DebugPanel.this.varTabs.addTab(AppStrings.translate("debuglog.header"), pa);
                    }
                    boolean bl = newVisible = !DebugPanel.this.tabTypes.isEmpty();
                    if (newVisible != DebugPanel.this.isVisible()) {
                        DebugPanel.this.setVisible(newVisible);
                    }
                    if (!DebugPanel.this.tabTypes.isEmpty() && oldSel != null && !DebugPanel.this.tabTypes.contains((Object)oldSel)) {
                        oldSel = null;
                    }
                    if (oldSel != null) {
                        DebugPanel.this.selectedTab = oldSel;
                        DebugPanel.this.varTabs.setSelectedIndex(DebugPanel.this.tabTypes.indexOf((Object)DebugPanel.this.selectedTab));
                    }
                    DebugPanel.this.setLoading(false);
                }
            }
        });
    }

    public void dispose() {
        Main.getDebugHandler().removeBreakListener(this.breakListener);
        Main.getDebugHandler().removeFrameChangeListener(this.frameChangeListener);
    }

    public static enum SelectedTab {
        LOG,
        STACK,
        SCOPECHAIN,
        LOCALS,
        REGISTERS,
        CALLSTACK,
        CONSTANTPOOL;

    }
}

