/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.debugger.flash.messages.in.InBreakAtExt;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.DebuggerHandler;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class DebugStackPanel
extends JPanel {
    private JTable stackTable;
    private boolean active = false;
    private int depth = 0;
    private String[] swfHashes = new String[0];
    private int[] classIndices = new int[0];
    private int[] methodIndices = new int[0];
    private int[] traitIndices = new int[0];

    public DebugStackPanel() {
        this.stackTable = new JTable();
        Main.getDebugHandler().addFrameChangeListener(new DebuggerHandler.FrameChangeListener(){

            @Override
            public void frameChanged() {
                DebugStackPanel.this.depth = Main.getDebugHandler().getDepth();
                DebugStackPanel.this.refresh();
            }
        });
        Main.getDebugHandler().addBreakListener(new DebuggerHandler.BreakListener(){

            @Override
            public void breakAt(String scriptName, int line, int classIndex, int traitIndex, int methodIndex) {
            }

            @Override
            public void doContinue() {
                DebugStackPanel.this.clear();
            }
        });
        Main.getDebugHandler().addConnectionListener(new DebuggerHandler.ConnectionListener(){

            @Override
            public void connected() {
            }

            @Override
            public void disconnected() {
                DebugStackPanel.this.clear();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)new FasterScrollPane(this.stackTable), "Center");
        this.stackTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && (row = DebugStackPanel.this.stackTable.rowAtPoint(e.getPoint())) >= 0) {
                    String swfHash = DebugStackPanel.this.swfHashes[row];
                    String scriptName = (String)DebugStackPanel.this.stackTable.getModel().getValueAt(row, 1);
                    int line = (Integer)DebugStackPanel.this.stackTable.getModel().getValueAt(row, 2);
                    SWF swf = swfHash == null ? Main.getRunningSWF() : Main.getSwfByHash(swfHash);
                    Main.getMainFrame().getPanel().gotoScriptLine(swf, scriptName, line, DebugStackPanel.this.classIndices[row], DebugStackPanel.this.traitIndices[row], DebugStackPanel.this.methodIndices[row], Main.isDebugPCode());
                    Main.getDebugHandler().setDepth(row);
                }
            }
        });
    }

    public void clear() {
        this.stackTable.setModel(new DefaultTableModel());
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void refresh() {
        InBreakAtExt info = Main.getDebugHandler().getBreakInfo();
        if (info == null) {
            this.clear();
            return;
        }
        this.active = true;
        Object[][] data = new Object[info.files.size()][4];
        String[] newSwfHashes = new String[info.files.size()];
        int[] newClassIndices = new int[info.files.size()];
        int[] newMethodIndices = new int[info.files.size()];
        int[] newTraitIndices = new int[info.files.size()];
        for (int i = 0; i < info.files.size(); ++i) {
            int f = (Integer)info.files.get(i);
            String moduleName = Main.getDebugHandler().moduleToString(f);
            String swfHash = null;
            if (moduleName.contains(":")) {
                swfHash = moduleName.substring(0, moduleName.indexOf(":"));
                moduleName = moduleName.substring(moduleName.indexOf(":") + 1);
            }
            newSwfHashes[i] = swfHash;
            data[i][0] = swfHash == null ? "unknown" : Main.getSwfByHash(swfHash).toString();
            data[i][1] = moduleName;
            data[i][2] = info.lines.get(i);
            data[i][3] = info.stacks.get(i);
            Integer newClassIndex = Main.getDebugHandler().moduleToClassIndex(f);
            newClassIndices[i] = newClassIndex == null ? -1 : newClassIndex;
            Integer newMethodIndex = Main.getDebugHandler().moduleToMethodIndex(f);
            newMethodIndices[i] = newMethodIndex == null ? -1 : newMethodIndex;
            Integer newTraitIndex = Main.getDebugHandler().moduleToTraitIndex(f);
            newTraitIndices[i] = newTraitIndex == null ? -1 : newTraitIndex;
        }
        DefaultTableModel tm = new DefaultTableModel(data, new Object[]{AppStrings.translate("callStack.header.swf"), AppStrings.translate("callStack.header.file"), AppStrings.translate("callStack.header.line"), AppStrings.translate("stack.header.item")}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.stackTable.setModel(tm);
        this.swfHashes = newSwfHashes;
        this.classIndices = newClassIndices;
        this.methodIndices = newMethodIndices;
        this.traitIndices = newTraitIndices;
        View.execInEventDispatchLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (row == DebugStackPanel.this.depth) {
                            label.setFont(label.getFont().deriveFont(1));
                        }
                        return label;
                    }
                };
                DebugStackPanel.this.stackTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
                DebugStackPanel.this.stackTable.getColumnModel().getColumn(1).setCellRenderer(renderer);
                DebugStackPanel.this.stackTable.getColumnModel().getColumn(2).setCellRenderer(renderer);
                DebugStackPanel.this.repaint();
            }
        });
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

