/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.debugger.flash.DebugConnectionListener;
import com.jpexs.debugger.flash.DebugMessageListener;
import com.jpexs.debugger.flash.DebuggerCommands;
import com.jpexs.debugger.flash.DebuggerConnection;
import com.jpexs.debugger.flash.InDebuggerMessage;
import com.jpexs.debugger.flash.OutDebuggerMessage;
import com.jpexs.debugger.flash.Variable;
import com.jpexs.debugger.flash.messages.in.InBreakAt;
import com.jpexs.debugger.flash.messages.in.InBreakAtExt;
import com.jpexs.debugger.flash.messages.in.InBreakReason;
import com.jpexs.debugger.flash.messages.in.InCallFunction;
import com.jpexs.debugger.flash.messages.in.InConstantPool;
import com.jpexs.debugger.flash.messages.in.InContinue;
import com.jpexs.debugger.flash.messages.in.InErrorException;
import com.jpexs.debugger.flash.messages.in.InFrame;
import com.jpexs.debugger.flash.messages.in.InGetVariable;
import com.jpexs.debugger.flash.messages.in.InNumScript;
import com.jpexs.debugger.flash.messages.in.InPlaceObject;
import com.jpexs.debugger.flash.messages.in.InProcessTag;
import com.jpexs.debugger.flash.messages.in.InScript;
import com.jpexs.debugger.flash.messages.in.InSetBreakpoint;
import com.jpexs.debugger.flash.messages.in.InSwfInfo;
import com.jpexs.debugger.flash.messages.in.InTrace;
import com.jpexs.debugger.flash.messages.in.InVersion;
import com.jpexs.debugger.flash.messages.out.OutAddWatch2;
import com.jpexs.debugger.flash.messages.out.OutGetBreakReason;
import com.jpexs.debugger.flash.messages.out.OutPlay;
import com.jpexs.debugger.flash.messages.out.OutProcessedTag;
import com.jpexs.debugger.flash.messages.out.OutRewind;
import com.jpexs.debugger.flash.messages.out.OutSwfInfo;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.graph.DottedChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DebuggerHandler
implements DebugConnectionListener {
    private boolean connected = false;
    private DebuggerCommands commands = null;
    private boolean paused = true;
    private Map<Integer, String> modulePaths = new HashMap<Integer, String>();
    private Map<Integer, Integer> moduleToSwfIndex = new HashMap<Integer, Integer>();
    private Set<Integer> swfIndicesCommitted = new HashSet<Integer>();
    private Map<Integer, String> swfIndicesNewToSwfHash = new HashMap<Integer, String>();
    private Map<String, Integer> scriptToModule = new HashMap<String, Integer>();
    private Map<Integer, Integer> moduleToTraitIndex = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> moduleToClassIndex = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> moduleToMethodIndex = new HashMap<Integer, Integer>();
    private Map<SWF, Map<String, Set<Integer>>> toAddBPointMap = new WeakHashMap<SWF, Map<String, Set<Integer>>>();
    private Map<SWF, Map<String, Set<Integer>>> confirmedPointMap = new WeakHashMap<SWF, Map<String, Set<Integer>>>();
    private Map<SWF, Map<String, Set<Integer>>> invalidBreakPointMap = new WeakHashMap<SWF, Map<String, Set<Integer>>>();
    private Map<SWF, Map<String, Set<Integer>>> toRemoveBPointMap = new WeakHashMap<SWF, Map<String, Set<Integer>>>();
    private int breakIp = -1;
    private String breakScriptName = null;
    private List<String> stackScriptNames = new ArrayList<String>();
    private List<Integer> stackLines = new ArrayList<Integer>();
    private List<SWF> debuggedSwfs = new ArrayList<SWF>();
    private Map<String, Long> placedObjects = new LinkedHashMap<String, Long>();
    private int watchTag = 1;
    private InFrame frame;
    private int depth;
    private InConstantPool pool;
    private InBreakAtExt breakInfo;
    private InBreakReason breakReason;
    private final List<BreakListener> breakListeners = new CopyOnWriteArrayList<BreakListener>();
    private final List<TraceListener> traceListeners = new ArrayList<TraceListener>();
    private final List<ErrorListener> errorListeners = new ArrayList<ErrorListener>();
    private final List<FrameChangeListener> frameChangeListeners = new ArrayList<FrameChangeListener>();
    private final List<ConnectionListener> clisteners = new ArrayList<ConnectionListener>();

    public void setMainDebuggedSwf(SWF debuggedSwf) {
        this.debuggedSwfs.clear();
    }

    public List<SWF> getDebuggedSwfs() {
        return this.debuggedSwfs;
    }

    public int getBreakIp() {
        if (!this.isPaused()) {
            return -1;
        }
        return this.breakIp;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getBreakScriptName() {
        if (!this.isPaused()) {
            return "-";
        }
        return this.breakScriptName;
    }

    public synchronized List<String> getStackScripts() {
        if (!this.isPaused()) {
            return new ArrayList<String>();
        }
        return this.stackScriptNames;
    }

    public synchronized List<Integer> getStackLines() {
        if (!this.isPaused()) {
            return new ArrayList<Integer>();
        }
        return this.stackLines;
    }

    public InGetVariable getVariable(long parentId, String varName, boolean children, boolean useGetter) {
        try {
            return this.commands.getVariable(parentId, varName, useGetter, children);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void setVariable(long parentId, String varName, int valueType, Object value) {
        try {
            String svalue = "";
            switch (valueType) {
                case 2: {
                    svalue = "" + value;
                    break;
                }
                case 0: {
                    svalue = "" + value;
                    break;
                }
                case 1: {
                    svalue = (Boolean)value != false ? "true" : "false";
                    break;
                }
                case 7: {
                    svalue = "undefined";
                    break;
                }
                case 6: {
                    svalue = "undefined";
                }
            }
            this.commands.setVariable(parentId, varName, valueType, svalue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void removeBreakPoint(SWF swf, String scriptName, int line) {
        if (this.isBreakpointInvalid(swf, scriptName, line)) {
            this.invalidBreakPointMap.get(swf).get(scriptName).remove(line);
            if (this.invalidBreakPointMap.get(swf).get(scriptName).isEmpty()) {
                this.invalidBreakPointMap.get(swf).remove(scriptName);
            }
            return;
        }
        if (this.isBreakpointToAdd(swf, scriptName, line)) {
            this.toAddBPointMap.get(swf).get(scriptName).remove(line);
            if (this.toAddBPointMap.get(swf).get(scriptName).isEmpty()) {
                this.toAddBPointMap.get(swf).remove(scriptName);
            }
        } else if (this.isBreakpointConfirmed(swf, scriptName, line)) {
            if (!this.toRemoveBPointMap.containsKey(swf)) {
                this.toRemoveBPointMap.put(swf, new HashMap());
            }
            if (!this.toRemoveBPointMap.get(swf).containsKey(scriptName)) {
                this.toRemoveBPointMap.get(swf).put(scriptName, new TreeSet());
            }
            this.toRemoveBPointMap.get(swf).get(scriptName).add(line);
        }
        try {
            this.sendBreakPoints();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized DebuggerCommands.Watch addWatch(Variable v, long v_id, boolean watchRead, boolean watchWrite) {
        int tag = this.watchTag++;
        try {
            return this.commands.addWatch(v_id, v.name, (watchRead ? OutAddWatch2.FLAG_READ : 0) | (watchWrite ? OutAddWatch2.FLAG_WRITE : 0), tag);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public synchronized Set<Integer> getBreakPoints(SWF swf, String scriptName, boolean onlyValid) {
        TreeSet<Integer> lines = new TreeSet<Integer>();
        if (this.confirmedPointMap.containsKey(swf) && this.confirmedPointMap.get(swf).containsKey(scriptName)) {
            lines.addAll((Collection<Integer>)this.confirmedPointMap.get(swf).get(scriptName));
        }
        if (this.toAddBPointMap.containsKey(swf) && this.toAddBPointMap.get(swf).containsKey(scriptName)) {
            lines.addAll((Collection<Integer>)this.toAddBPointMap.get(swf).get(scriptName));
        }
        if (!onlyValid && this.invalidBreakPointMap.containsKey(swf) && this.invalidBreakPointMap.get(swf).containsKey(scriptName)) {
            lines.addAll((Collection<Integer>)this.invalidBreakPointMap.get(swf).get(scriptName));
        }
        return lines;
    }

    public synchronized void clearBreakPoints(SWF swf) {
        Map<String, Set<Integer>> breakpoints = this.getAllBreakPoints(swf, false);
        for (String scriptName : breakpoints.keySet()) {
            for (int line : breakpoints.get(scriptName)) {
                this.removeBreakPoint(swf, scriptName, line);
            }
        }
    }

    public synchronized void makeBreakPointsUnconfirmed(SWF swf) {
        if (this.confirmedPointMap.containsKey(swf)) {
            for (String scriptName : this.confirmedPointMap.get(swf).keySet()) {
                if (!this.toAddBPointMap.containsKey(swf)) {
                    this.toAddBPointMap.put(swf, new HashMap());
                }
                if (!this.toAddBPointMap.get(swf).containsKey(scriptName)) {
                    this.toAddBPointMap.get(swf).put(scriptName, new TreeSet());
                }
                this.toAddBPointMap.get(swf).get(scriptName).addAll((Collection<Integer>)this.confirmedPointMap.get(swf).get(scriptName));
            }
            this.confirmedPointMap.get(swf).clear();
        }
        if (this.invalidBreakPointMap.containsKey(swf)) {
            for (String scriptName : this.invalidBreakPointMap.get(swf).keySet()) {
                if (!this.toAddBPointMap.containsKey(swf)) {
                    this.toAddBPointMap.put(swf, new HashMap());
                }
                if (!this.toAddBPointMap.get(swf).containsKey(scriptName)) {
                    this.toAddBPointMap.get(swf).put(scriptName, new TreeSet());
                }
                this.toAddBPointMap.get(swf).get(scriptName).addAll((Collection<Integer>)this.invalidBreakPointMap.get(swf).get(scriptName));
            }
            this.invalidBreakPointMap.get(swf).clear();
        }
    }

    public synchronized Map<String, Set<Integer>> getAllBreakPoints(SWF swf, boolean validOnly) {
        HashMap<String, Set<Integer>> ret = new HashMap<String, Set<Integer>>();
        if (this.confirmedPointMap.containsKey(swf)) {
            for (String scriptName : this.confirmedPointMap.get(swf).keySet()) {
                TreeSet lines = new TreeSet();
                lines.addAll(this.confirmedPointMap.get(swf).get(scriptName));
                ret.put(scriptName, lines);
            }
        }
        if (this.toAddBPointMap.containsKey(swf)) {
            for (String scriptName : this.toAddBPointMap.get(swf).keySet()) {
                if (!ret.containsKey(scriptName)) {
                    ret.put(scriptName, new TreeSet());
                }
                ((Set)ret.get(scriptName)).addAll((Collection)this.toAddBPointMap.get(swf).get(scriptName));
            }
        }
        if (!validOnly && this.invalidBreakPointMap.containsKey(swf)) {
            for (String scriptName : this.invalidBreakPointMap.get(swf).keySet()) {
                if (!ret.containsKey(scriptName)) {
                    ret.put(scriptName, new TreeSet());
                }
                ((Set)ret.get(scriptName)).addAll((Collection)this.invalidBreakPointMap.get(swf).get(scriptName));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBreakPoint(SWF swf, String scriptName, int line) {
        DebuggerHandler debuggerHandler = this;
        synchronized (debuggerHandler) {
            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "adding bp {0}:{1}", new Object[]{scriptName, line});
            if (this.isBreakpointToRemove(swf, scriptName, line)) {
                this.toRemoveBPointMap.get(swf).get(scriptName).remove(line);
                if (this.toRemoveBPointMap.get(swf).get(scriptName).isEmpty()) {
                    this.toRemoveBPointMap.get(swf).remove(scriptName);
                }
            }
            if (this.isBreakpointConfirmed(swf, scriptName, line)) {
                Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "bp {0}:{1} already confirmed", new Object[]{scriptName, line});
                return true;
            }
            if (this.isBreakpointInvalid(swf, scriptName, line)) {
                Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "bp {0}:{1} already invalid", new Object[]{scriptName, line});
                return false;
            }
            if (!this.toAddBPointMap.containsKey(swf)) {
                this.toAddBPointMap.put(swf, new HashMap());
            }
            if (!this.toAddBPointMap.get(swf).containsKey(scriptName)) {
                this.toAddBPointMap.get(swf).put(scriptName, new TreeSet());
            }
            this.toAddBPointMap.get(swf).get(scriptName).add(line);
            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "bp {0}:{1} added to todo", new Object[]{scriptName, line});
        }
        try {
            this.sendBreakPoints();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public synchronized boolean isBreakpointConfirmed(SWF swf, String scriptName, int line) {
        return this.confirmedPointMap.containsKey(swf) && this.confirmedPointMap.get(swf).containsKey(scriptName) && this.confirmedPointMap.get(swf).get(scriptName).contains(line);
    }

    public synchronized boolean isBreakpointToAdd(SWF swf, String scriptName, int line) {
        return this.toAddBPointMap.containsKey(swf) && this.toAddBPointMap.get(swf).containsKey(scriptName) && this.toAddBPointMap.get(swf).get(scriptName).contains(line);
    }

    public synchronized boolean isBreakpointToRemove(SWF swf, String scriptName, int line) {
        return this.toRemoveBPointMap.containsKey(swf) && this.toRemoveBPointMap.get(swf).containsKey(scriptName) && this.toRemoveBPointMap.get(swf).get(scriptName).contains(line);
    }

    public synchronized boolean isBreakpointInvalid(SWF swf, String scriptName, int line) {
        return this.invalidBreakPointMap.containsKey(swf) && this.invalidBreakPointMap.get(swf).containsKey(scriptName) && this.invalidBreakPointMap.get(swf).get(scriptName).contains(line);
    }

    private synchronized void markBreakPointInvalid(SWF swf, String scriptName, int line) {
        if (!this.invalidBreakPointMap.containsKey(swf)) {
            this.invalidBreakPointMap.put(swf, new HashMap());
        }
        if (!this.invalidBreakPointMap.get(swf).containsKey(scriptName)) {
            this.invalidBreakPointMap.get(swf).put(scriptName, new TreeSet());
        }
        this.invalidBreakPointMap.get(swf).get(scriptName).add(line);
    }

    private synchronized void markBreakPointConfirmed(SWF swf, String scriptName, int line) {
        if (!this.confirmedPointMap.containsKey(swf)) {
            this.confirmedPointMap.put(swf, new HashMap());
        }
        if (!this.confirmedPointMap.get(swf).containsKey(scriptName)) {
            this.confirmedPointMap.get(swf).put(scriptName, new TreeSet());
        }
        this.confirmedPointMap.get(swf).get(scriptName).add(line);
    }

    private synchronized void markBreakPointValid(SWF swf, String scriptName, int line) {
        if (!this.invalidBreakPointMap.containsKey(swf)) {
            return;
        }
        if (!this.invalidBreakPointMap.get(swf).containsKey(scriptName)) {
            return;
        }
        this.invalidBreakPointMap.get(swf).get(scriptName).remove(line);
        if (this.invalidBreakPointMap.get(swf).get(scriptName).isEmpty()) {
            this.invalidBreakPointMap.get(swf).remove(scriptName);
        }
        if (this.invalidBreakPointMap.get(swf).isEmpty()) {
            this.invalidBreakPointMap.remove(swf);
        }
    }

    public void setDepth(int depth) {
        this.depth = depth;
        this.refreshFrame();
    }

    public String moduleToString(int file) {
        if (!this.modulePaths.containsKey(file)) {
            return "unknown";
        }
        return this.modulePaths.get(file);
    }

    public Integer moduleToMethodIndex(int file) {
        return this.moduleToMethodIndex.get(file);
    }

    public Integer moduleToClassIndex(int file) {
        return this.moduleToClassIndex.get(file);
    }

    public Integer moduleToTraitIndex(int file) {
        return this.moduleToTraitIndex.get(file);
    }

    public synchronized InBreakAtExt getBreakInfo() {
        if (!this.paused) {
            return null;
        }
        return this.breakInfo;
    }

    public synchronized InBreakReason getBreakReason() {
        if (!this.paused) {
            return null;
        }
        return this.breakReason;
    }

    public void addBreakListener(BreakListener l) {
        this.breakListeners.add(l);
    }

    public void addFrameChangeListener(FrameChangeListener l) {
        this.frameChangeListeners.add(l);
    }

    public void removeFrameChangeListener(FrameChangeListener l) {
        this.frameChangeListeners.remove(l);
    }

    public void addTraceListener(TraceListener l) {
        this.traceListeners.add(l);
    }

    public void removeTraceListener(TraceListener l) {
        this.traceListeners.remove(l);
    }

    public void addErrorListener(ErrorListener l) {
        this.errorListeners.add(l);
    }

    public void removeErrorListener(ErrorListener l) {
        this.errorListeners.remove(l);
    }

    public void removeBreakListener(BreakListener l) {
        this.breakListeners.remove(l);
    }

    public void addConnectionListener(ConnectionListener l) {
        this.clisteners.add(l);
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.clisteners.remove(l);
    }

    public synchronized void refreshFrame() {
        if (!this.paused) {
            return;
        }
        try {
            this.frame = this.commands.getFrame(this.depth);
            this.pool = this.commands.getConstantPool(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (FrameChangeListener l : this.frameChangeListeners) {
            l.frameChanged();
        }
    }

    public synchronized InFrame getFrame() {
        if (!this.paused) {
            return null;
        }
        return this.frame;
    }

    public synchronized int moduleIdOf(String packWithHash) {
        if (!this.scriptToModule.containsKey(packWithHash)) {
            return -1;
        }
        return this.scriptToModule.get(packWithHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        if (!this.isConnected()) {
            return false;
        }
        DebuggerHandler debuggerHandler = this;
        synchronized (debuggerHandler) {
            return this.paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.frame = null;
        this.pool = null;
        this.breakInfo = null;
        this.breakReason = null;
        this.connected = false;
        if (this.commands != null) {
            this.commands.disconnect();
        }
        this.commands = null;
        DebuggerHandler debuggerHandler = this;
        synchronized (debuggerHandler) {
            for (SWF debuggedSwf : this.debuggedSwfs) {
                if (this.confirmedPointMap.containsKey(debuggedSwf)) {
                    for (String scriptName : this.confirmedPointMap.get(debuggedSwf).keySet()) {
                        if (!this.toAddBPointMap.containsKey(debuggedSwf)) {
                            this.toAddBPointMap.put(debuggedSwf, new HashMap());
                        }
                        if (!this.toAddBPointMap.get(debuggedSwf).containsKey(scriptName)) {
                            this.toAddBPointMap.get(debuggedSwf).put(scriptName, new TreeSet());
                        }
                        this.toAddBPointMap.get(debuggedSwf).get(scriptName).addAll((Collection<Integer>)this.confirmedPointMap.get(debuggedSwf).get(scriptName));
                    }
                    this.confirmedPointMap.get(debuggedSwf).clear();
                }
                if (!this.invalidBreakPointMap.containsKey(debuggedSwf)) continue;
                for (String scriptName : this.invalidBreakPointMap.get(debuggedSwf).keySet()) {
                    if (!this.toAddBPointMap.containsKey(debuggedSwf)) {
                        this.toAddBPointMap.put(debuggedSwf, new HashMap());
                    }
                    if (!this.toAddBPointMap.get(debuggedSwf).containsKey(scriptName)) {
                        this.toAddBPointMap.get(debuggedSwf).put(scriptName, new TreeSet());
                    }
                    this.toAddBPointMap.get(debuggedSwf).get(scriptName).addAll((Collection<Integer>)this.invalidBreakPointMap.get(debuggedSwf).get(scriptName));
                }
                this.invalidBreakPointMap.get(debuggedSwf).clear();
            }
        }
        for (ConnectionListener l : this.clisteners) {
            l.disconnected();
        }
        this.debuggedSwfs.clear();
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public DebuggerCommands getCommands() throws IOException {
        if (!this.isConnected() || this.commands == null) {
            throw new IOException("Not connected");
        }
        return this.commands;
    }

    public void failedListen(IOException ex) {
        View.execInEventDispatch(new Runnable(){

            @Override
            public void run() {
                DebuggerHandler.this.disconnect();
                Main.stopRun();
                Main.stopWork();
                ViewMessages.showMessageDialog(Main.getMainFrame().getPanel(), AppStrings.translate("error.debug.listen").replace("%port%", "7935"));
                Main.getMainFrame().getPanel().updateMenu();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(final DebuggerConnection con) {
        Main.startWork(AppStrings.translate("work.debugging"), null);
        DebuggerHandler debuggerHandler = this;
        synchronized (debuggerHandler) {
            this.paused = false;
        }
        Main.getMainFrame().getPanel().updateMenu();
        try {
            con.getMessage(InVersion.class);
        }
        catch (IOException ex) {
            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        con.addMessageListener((DebugMessageListener)new DebugMessageListener<InProcessTag>(){

            public void message(InProcessTag message) {
                try {
                    con.writeMessage((OutDebuggerMessage)new OutProcessedTag(con));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.swfIndicesCommitted.clear();
        this.swfIndicesNewToSwfHash.clear();
        final HashMap moduleNames = new HashMap();
        final Pattern patAS3 = Pattern.compile("^(.*);(.*);(.*)\\.as$");
        final Pattern patAS3PCode = Pattern.compile("^(?<hash>[0-9a-z_]+):#PCODE abc:(?<abc>[0-9]+),script:(?<script>[0-9]+),class:(?<class>-?[0-9]+),trait:(?<trait>-?[0-9]+),method:(?<method>[0-9]+),body:(?<body>[0-9]+);(.*)$");
        boolean isAS3 = Main.getRunningSWF().isAS3();
        try {
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InErrorException>(){

                public void message(InErrorException t) {
                    for (ErrorListener l : DebuggerHandler.this.errorListeners) {
                        l.errorException(t.exceptionMessage, t.thrownVar);
                    }
                    con.dropMessage((InDebuggerMessage)t);
                }
            });
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InNumScript>(){

                public void message(InNumScript t) {
                    con.dropMessage((InDebuggerMessage)t);
                }
            });
            this.modulePaths.clear();
            this.scriptToModule.clear();
            moduleNames.clear();
            this.moduleToClassIndex.clear();
            this.moduleToTraitIndex.clear();
            this.moduleToMethodIndex.clear();
            this.moduleToSwfIndex.clear();
            this.placedObjects.clear();
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InScript>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void message(InScript sc) {
                    DebuggerHandler debuggerHandler = DebuggerHandler.this;
                    synchronized (debuggerHandler) {
                        moduleNames.put(sc.module, sc.name);
                        int file = sc.module;
                        String name = sc.name;
                        int swfIndex = sc.swfIndex;
                        name = name.replaceAll("\\[(invalid_utf8=[0-9]+)\\]", "{$1}");
                        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "Received script added - index {0} name: {1}", new Object[]{file, name});
                        String swfHash = "main";
                        Matcher m = patAS3.matcher(name);
                        if (m.matches()) {
                            String clsNameWithSuffix = m.group(3).replace("{{semicolon}}", ";");
                            String pkg = m.group(2).replace("{{semicolon}}", ";").replace("\\", ".");
                            m = patAS3PCode.matcher(name);
                            if (m.matches()) {
                                DebuggerHandler.this.moduleToClassIndex.put(file, Integer.parseInt(m.group("class")));
                                DebuggerHandler.this.moduleToTraitIndex.put(file, Integer.parseInt(m.group("trait")));
                                DebuggerHandler.this.moduleToMethodIndex.put(file, Integer.parseInt(m.group("method")));
                                name = DottedChain.parseWithSuffix((String)pkg).addWithSuffix(clsNameWithSuffix).toString();
                                swfHash = m.group("hash");
                                name = swfHash + ":#PCODE abc:" + m.group("abc") + ",body:" + m.group("body") + ";" + name;
                            } else {
                                if (pkg.contains(":")) {
                                    swfHash = pkg.substring(0, pkg.indexOf(":"));
                                    pkg = pkg.substring(pkg.indexOf(":") + 1);
                                }
                                name = swfHash + ":" + DottedChain.parseWithSuffix((String)pkg).addWithSuffix(clsNameWithSuffix).toPrintableString(new LinkedHashSet(), Main.getRunningSWF(), con.isAS3);
                            }
                        } else if (name.contains(":")) {
                            swfHash = name.substring(0, name.indexOf(":"));
                        }
                        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "Script added - index {0} name: {1}", new Object[]{file, name});
                        DebuggerHandler.this.modulePaths.put(file, name);
                        DebuggerHandler.this.scriptToModule.put(name, file);
                        DebuggerHandler.this.moduleToSwfIndex.put(file, swfIndex);
                        if (swfIndex > DebuggerHandler.this.debuggedSwfs.size() - 1) {
                            SWF swf = Main.getSwfByHash(swfHash);
                            if (swf == null) {
                                Logger.getLogger(DebuggerHandler.class.getName()).log(Level.WARNING, "SWF with hash {0} not found", swfHash);
                            } else {
                                Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "adding {0} to debugSwfs", swfIndex);
                                DebuggerHandler.this.swfIndicesCommitted.add(swfIndex);
                                DebuggerHandler.this.debuggedSwfs.add(swf);
                            }
                        } else {
                            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "Swf index already committed");
                        }
                    }
                    con.dropMessage((InDebuggerMessage)sc);
                }
            });
            this.commands = new DebuggerCommands(con);
            this.commands.stopWarning();
            this.commands.setStopOnFault();
            this.commands.setEnumerateOverride();
            this.commands.setNotifyFailure();
            this.commands.setInvokeSetters();
            this.commands.setSwfLoadNotify();
            this.commands.setGetterTimeout(1500);
            this.commands.setSetterTimeout(5000);
            con.isAS3 = isAS3;
            if (isAS3) {
                con.wideLines = this.commands.getOption("wide_line_player", "false").equals("true");
                if (con.wideLines) {
                    this.commands.setOption("wide_line_debugger", "on");
                }
            }
            this.commands.squelch(true);
            con.writeMessage((OutDebuggerMessage)new OutSwfInfo(con, 0));
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InSwfInfo>(){

                public void message(InSwfInfo t) {
                    con.dropMessage((InDebuggerMessage)t);
                }
            });
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InPlaceObject>(){

                public void message(InPlaceObject t) {
                    DebuggerHandler.this.placedObjects.put(t.path, t.objId);
                    con.dropMessage((InDebuggerMessage)t);
                }
            });
            InSetBreakpoint isb = (InSetBreakpoint)con.getMessage(InSetBreakpoint.class);
            Object object = this;
            synchronized (object) {
                for (int i = 0; i < isb.files.size(); ++i) {
                    String sname = (String)moduleNames.get(isb.files.get(i));
                    SWF debuggedSwf = this.debuggedSwfs.get(this.moduleToSwfIndex.get(isb.files.get(i)));
                    if (!this.confirmedPointMap.containsKey(debuggedSwf)) {
                        this.confirmedPointMap.put(debuggedSwf, new HashMap());
                    }
                    if (!this.confirmedPointMap.get(debuggedSwf).containsKey(sname)) {
                        this.confirmedPointMap.get(debuggedSwf).put(sname, new TreeSet());
                    }
                    if (this.toAddBPointMap.containsKey(debuggedSwf) && this.toAddBPointMap.get(debuggedSwf).containsKey(sname)) {
                        this.toAddBPointMap.get(debuggedSwf).get(sname).remove(isb.lines.get(i));
                        if (this.toAddBPointMap.get(debuggedSwf).get(sname).isEmpty()) {
                            this.toAddBPointMap.get(debuggedSwf).remove(sname);
                        }
                    }
                    this.confirmedPointMap.get(debuggedSwf).get(sname).add((Integer)isb.lines.get(i));
                    Logger.getLogger(DebuggerHandler.class.getName()).log(Level.INFO, "Breakpoint {0}:{1} submitted successfully", new Object[]{sname, isb.lines.get(i)});
                }
            }
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InContinue>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void message(InContinue msg) {
                    DebuggerHandler debuggerHandler = DebuggerHandler.this;
                    synchronized (debuggerHandler) {
                        DebuggerHandler.this.paused = false;
                        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "continued");
                    }
                    for (BreakListener bl : DebuggerHandler.this.breakListeners) {
                        bl.doContinue();
                    }
                }
            });
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InBreakAt>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void message(InBreakAt message) {
                    DebuggerHandler debuggerHandler = DebuggerHandler.this;
                    synchronized (debuggerHandler) {
                        DebuggerHandler.this.paused = true;
                        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "paused");
                    }
                    try {
                        String[] reasonNames;
                        con.getMessage(InSetBreakpoint.class, 750L);
                        DebuggerHandler.this.breakInfo = (InBreakAtExt)con.getMessage(InBreakAtExt.class, 750L);
                        DebuggerHandler.this.breakReason = (InBreakReason)con.sendMessageWithTimeout((OutDebuggerMessage)new OutGetBreakReason(con), InBreakReason.class);
                        int reasonInt = DebuggerHandler.this.breakReason == null ? 0 : ((DebuggerHandler)DebuggerHandler.this).breakReason.reason;
                        String newBreakScriptName = "unknown";
                        String userBreakScriptName = "unknown";
                        if (DebuggerHandler.this.modulePaths.containsKey(message.file)) {
                            userBreakScriptName = newBreakScriptName = (String)DebuggerHandler.this.modulePaths.get(message.file);
                            if (newBreakScriptName.contains(":")) {
                                String swfHash = newBreakScriptName.substring(0, newBreakScriptName.indexOf(":"));
                                SWF swf = Main.getSwfByHash(swfHash);
                                userBreakScriptName = swf.toString() + ": " + newBreakScriptName.substring(newBreakScriptName.indexOf(":") + 1);
                            }
                        } else if (reasonInt != InBreakReason.REASON_SCRIPT_LOADED) {
                            Logger.getLogger(DebuggerCommands.class.getName()).log(Level.SEVERE, "Invalid file: {0}", message.file);
                        }
                        String reason = reasonInt < (reasonNames = new String[]{"unknown", "breakpoint", "watch", "fault", "stopRequest", "step", "halt", "scriptLoaded"}).length ? reasonNames[reasonInt] : reasonNames[0];
                        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "break at {0}:{1}, reason: {2}", new Object[]{newBreakScriptName, message.line, reason});
                        try {
                            DebuggerHandler.this.sendBreakPoints();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "send breakpoints exception: " + ex.getMessage());
                        }
                        DebuggerHandler debuggerHandler2 = DebuggerHandler.this;
                        synchronized (debuggerHandler2) {
                            DebuggerHandler.this.breakScriptName = newBreakScriptName;
                            DebuggerHandler.this.breakIp = message.line;
                            if (DebuggerHandler.this.breakInfo != null) {
                                ArrayList<String> files = new ArrayList<String>();
                                for (int i = 0; i < ((DebuggerHandler)DebuggerHandler.this).breakInfo.files.size(); ++i) {
                                    files.add(Main.getDebugHandler().moduleToString((Integer)((DebuggerHandler)DebuggerHandler.this).breakInfo.files.get(i)));
                                }
                                DebuggerHandler.this.stackScriptNames = files;
                                ArrayList lines = new ArrayList(((DebuggerHandler)DebuggerHandler.this).breakInfo.lines);
                                DebuggerHandler.this.stackLines = lines;
                            }
                        }
                        if (reasonInt == InBreakReason.REASON_SCRIPT_LOADED) {
                            if (!((Boolean)Configuration.debugHalt.get()).booleanValue()) {
                                DebuggerHandler.this.commands.sendContinue();
                                return;
                            }
                            Main.startWork(AppStrings.translate("work.halted"), null);
                        } else {
                            Main.startWork(AppStrings.translate("work.breakat") + userBreakScriptName + ":" + message.line + " " + AppStrings.translate("debug.break.reason." + reason), null);
                        }
                        DebuggerHandler.this.depth = 0;
                        DebuggerHandler.this.refreshFrame();
                        for (BreakListener l : DebuggerHandler.this.breakListeners) {
                            l.breakAt(newBreakScriptName, message.line, DebuggerHandler.this.moduleToClassIndex.containsKey(message.file) ? (Integer)DebuggerHandler.this.moduleToClassIndex.get(message.file) : -1, DebuggerHandler.this.moduleToTraitIndex.containsKey(message.file) ? (Integer)DebuggerHandler.this.moduleToTraitIndex.get(message.file) : -1, DebuggerHandler.this.moduleToMethodIndex.containsKey(message.file) ? (Integer)DebuggerHandler.this.moduleToMethodIndex.get(message.file) : -1);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            object = this;
            synchronized (object) {
                this.connected = true;
            }
            for (ConnectionListener l : this.clisteners) {
                l.connected();
            }
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InTrace>(){

                public synchronized void message(InTrace tr) {
                    for (TraceListener l : DebuggerHandler.this.traceListeners) {
                        l.trace(tr.text);
                    }
                }
            });
            if (!isAS3) {
                Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINER, "End of connect - sending continue");
                con.writeMessage((OutDebuggerMessage)new OutRewind(con));
                con.writeMessage((OutDebuggerMessage)new OutPlay(con));
                this.commands.sendContinue();
            }
        }
        catch (IOException ex) {
            DebuggerHandler debuggerHandler2 = this;
            synchronized (debuggerHandler2) {
                this.connected = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBreakPoints() throws IOException {
        if (!this.isConnected()) {
            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINEST, "not sending bps, not connected");
            return;
        }
        DebuggerHandler debuggerHandler = this;
        synchronized (debuggerHandler) {
            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINEST, "sending breakpoints of {0} swfs", this.debuggedSwfs.size());
            for (int swfIndex = 0; swfIndex < this.debuggedSwfs.size(); ++swfIndex) {
                if (!this.swfIndicesCommitted.contains(swfIndex)) continue;
                SWF debuggedSwf = this.debuggedSwfs.get(swfIndex);
                String hash = Main.getSwfHash(debuggedSwf);
                Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINEST, "sending breakpoints of ", hash);
                if (this.toRemoveBPointMap.containsKey(debuggedSwf)) {
                    for (String scriptName : this.toRemoveBPointMap.get(debuggedSwf).keySet()) {
                        int file;
                        if (scriptName.startsWith("#PCODE") != Main.isDebugPCode() || (file = this.moduleIdOf(hash + ":" + scriptName)) <= -1) continue;
                        for (int line : this.toRemoveBPointMap.get(debuggedSwf).get(scriptName)) {
                            if (this.isBreakpointConfirmed(debuggedSwf, scriptName, line)) {
                                this.commands.removeBreakPoint(file, line);
                                this.confirmedPointMap.get(debuggedSwf).get(scriptName).remove(line);
                                if (this.confirmedPointMap.get(debuggedSwf).get(scriptName).isEmpty()) {
                                    this.confirmedPointMap.get(debuggedSwf).remove(scriptName);
                                }
                            }
                            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.INFO, "Breakpoint {0}:{1} removed", new Object[]{scriptName, line});
                        }
                    }
                    this.toRemoveBPointMap.get(debuggedSwf).clear();
                    if (this.toRemoveBPointMap.get(debuggedSwf).isEmpty()) {
                        this.toRemoveBPointMap.remove(debuggedSwf);
                    }
                }
                if (!this.toAddBPointMap.containsKey(debuggedSwf)) continue;
                HashSet<String> toAddScripts = new HashSet<String>(this.toAddBPointMap.get(debuggedSwf).keySet());
                for (String scriptName : toAddScripts) {
                    if (scriptName.startsWith("#PCODE") != Main.isDebugPCode()) continue;
                    Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINEST, "searching for module of {0}:{1}", new Object[]{hash, scriptName});
                    int file = this.moduleIdOf(hash + ":" + scriptName);
                    Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINEST, "module = {0}", file);
                    if (file > -1) {
                        HashSet lines = new HashSet(this.toAddBPointMap.get(debuggedSwf).get(scriptName));
                        Iterator iterator = lines.iterator();
                        while (iterator.hasNext()) {
                            int line = (Integer)iterator.next();
                            if (this.commands.addBreakPoint(file, line)) {
                                Logger.getLogger(DebuggerHandler.class.getName()).log(Level.INFO, "Breakpoint {0}:{1} submitted successfully", new Object[]{scriptName, line});
                                this.markBreakPointConfirmed(debuggedSwf, scriptName, line);
                                this.markBreakPointValid(debuggedSwf, scriptName, line);
                                this.toAddBPointMap.get(debuggedSwf).get(scriptName).remove(line);
                                if (this.toAddBPointMap.get(debuggedSwf).get(scriptName).isEmpty()) {
                                    this.toAddBPointMap.get(debuggedSwf).remove(scriptName);
                                }
                                if (!this.toAddBPointMap.get(debuggedSwf).isEmpty()) continue;
                                this.toAddBPointMap.remove(debuggedSwf);
                                continue;
                            }
                            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.INFO, "Breakpoint {0}:{1} unable to submit", new Object[]{scriptName, line});
                            this.markBreakPointInvalid(debuggedSwf, scriptName, line);
                        }
                        continue;
                    }
                    for (int line : this.toAddBPointMap.get(debuggedSwf).get(scriptName)) {
                        this.markBreakPointInvalid(debuggedSwf, scriptName, line);
                    }
                }
            }
        }
        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINEST, "sending bps finished");
    }

    public synchronized InConstantPool getConstantPool() {
        if (!this.paused) {
            return null;
        }
        return this.pool;
    }

    public synchronized InCallFunction callMethod(Variable object, String methodName, List<Object> args) throws ActionScriptException {
        return this.callFunction(false, methodName, object, args);
    }

    public synchronized InCallFunction callMethod(String object, String methodName, List<Object> args) throws ActionScriptException {
        InGetVariable igv = this.getVariable(0L, object, false, false);
        return this.callMethod(igv.parent, methodName, args);
    }

    private static String typeAsStr(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Long || value instanceof Integer) {
            return "int";
        }
        if (value instanceof Number) {
            return "Number";
        }
        if (value instanceof String) {
            return "String";
        }
        if (value instanceof Variable) {
            Variable v = (Variable)value;
            return v.getTypeAsStr();
        }
        return "String";
    }

    private static String valueAsStr(Object value) {
        long longValue;
        double doubleValue;
        if (value == null) {
            return "null";
        }
        if (value instanceof Double && (doubleValue = ((Double)value).doubleValue()) == (double)(longValue = (long)doubleValue)) {
            return Long.toString(longValue);
        }
        if (value instanceof Variable) {
            Variable v = (Variable)value;
            return DebuggerHandler.valueAsStr(v.value);
        }
        return "" + value;
    }

    public synchronized InCallFunction callFunction(boolean isConstructor, String funcName, Variable thisValue, List<Object> args) throws ActionScriptException {
        ArrayList<String> argTypes = new ArrayList<String>();
        ArrayList<String> argValues = new ArrayList<String>();
        for (Object value : args) {
            argTypes.add(DebuggerHandler.typeAsStr(value));
            argValues.add(DebuggerHandler.valueAsStr(value));
        }
        String thisType = DebuggerHandler.typeAsStr(thisValue);
        String thisValueStr = DebuggerHandler.valueAsStr(thisValue);
        try {
            InCallFunction icf = this.commands.callFunction(isConstructor, funcName, thisType, thisValueStr, argTypes, argValues);
            if (!icf.variables.isEmpty() && (((Variable)icf.variables.get((int)0)).flags & 0x40000) > 0) {
                throw new ActionScriptException("" + ((Variable)icf.variables.get((int)0)).value);
            }
            return icf;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Map<String, Long> getPlacedObjects() {
        return new LinkedHashMap<String, Long>(this.placedObjects);
    }

    public static interface BreakListener {
        public void breakAt(String var1, int var2, int var3, int var4, int var5);

        public void doContinue();
    }

    public static interface FrameChangeListener {
        public void frameChanged();
    }

    public static interface ErrorListener {
        public void errorException(String var1, Variable var2);
    }

    public static interface TraceListener {
        public void trace(String ... var1);
    }

    public static interface ConnectionListener {
        public void connected();

        public void disconnected();
    }

    public static class ActionScriptException
    extends Exception {
        private String errorClass;

        public ActionScriptException(String errorClass, String message) {
            super(message);
            this.errorClass = errorClass;
        }

        public ActionScriptException(String errorClsMessage) {
            this(errorClsMessage.substring(0, errorClsMessage.indexOf(": ")), errorClsMessage.substring(errorClsMessage.indexOf(": ") + 2));
        }

        public String getErrorClass() {
            return this.errorClass;
        }
    }
}

