/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FilesChangedDialog
extends AppDialog {
    private final JButton okButton = new JButton(this.translate("button.ok"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private JList<String> filesList;
    private DefaultListModel<String> listModel;
    private boolean onTopInited = false;

    public FilesChangedDialog(Window parent) {
        super(parent);
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                FilesChangedDialog.this.clearList();
            }
        });
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        JLabel label = new JLabel(this.translate("fileschanged"));
        label.setBorder(new EmptyBorder(10, 10, 10, 10));
        cnt.add((Component)label, "North");
        this.filesList = new JList<String>(this.listModel);
        if (View.isOceanic()) {
            this.filesList.setBackground(Color.white);
        }
        cnt.add((Component)new FasterScrollPane(this.filesList), "Center");
        JPanel panButtons = new JPanel(new FlowLayout());
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        panButtons.add(this.okButton);
        panButtons.add(this.cancelButton);
        this.add((Component)panButtons, "South");
        View.setWindowIcon(this);
        this.setResizable(true);
        this.pack();
        View.centerScreen(this);
    }

    public void addItem(String item) {
        if (this.listModel.contains(item)) {
            return;
        }
        this.listModel.addElement(item);
        this.filesList.setModel(this.listModel);
    }

    @Override
    public void setVisible(boolean b) {
        if (b && !this.onTopInited) {
            Main.getDefaultDialogsOwner().addWindowListener(new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent e) {
                    Window wnd = e.getOppositeWindow();
                    if (wnd != FilesChangedDialog.this) {
                        FilesChangedDialog.this.setAlwaysOnTop(false);
                    }
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    if (!FilesChangedDialog.this.isAlwaysOnTop()) {
                        FilesChangedDialog.this.setAlwaysOnTop(true);
                    }
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent e) {
                    if (e.getOppositeWindow() == null) {
                        FilesChangedDialog.this.setAlwaysOnTop(false);
                    }
                }
            });
            this.onTopInited = true;
        }
        super.setVisible(b);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        View.execInEventDispatchLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < FilesChangedDialog.this.listModel.size(); ++i) {
                    String fileName = (String)FilesChangedDialog.this.listModel.elementAt(i);
                    Main.reloadFile(new File(fileName));
                }
            }
        });
    }

    private void clearList() {
        this.listModel.clear();
        this.filesList.setModel(this.listModel);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.clearList();
        this.setVisible(false);
    }
}

