/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.ui.SubstanceCheckBoxUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class FocusablePanel
extends JPanel {
    private final List<ActionListener> listeners = new ArrayList<ActionListener>();
    private static final Set<Integer> pressedModifiers = new HashSet<Integer>();

    private static void setupGlobalKeyListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (e.getID() == 401) {
                pressedModifiers.add(e.getKeyCode());
            } else if (e.getID() == 402) {
                pressedModifiers.remove(e.getKeyCode());
            }
            return false;
        });
    }

    private static int getCurrentModifiers() {
        int mods = 0;
        if (pressedModifiers.contains(17)) {
            mods |= 0x80;
        }
        if (pressedModifiers.contains(16)) {
            mods |= 0x40;
        }
        if (pressedModifiers.contains(18)) {
            mods |= 0x200;
        }
        return mods;
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    public FocusablePanel() {
        FocusablePanel.setupGlobalKeyListener();
        this.setFocusable(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FocusablePanel.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                FocusablePanel.this.repaint();
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "activate");
        this.getInputMap(0).put(KeyStroke.getKeyStroke("SPACE"), "activate");
        this.getActionMap().put("activate", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FocusablePanel.this.fireAction(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FocusablePanel.this.requestFocusInWindow();
                FocusablePanel.this.fireAction(null);
            }
        });
    }

    private void fireAction(ActionEvent e) {
        if (e == null) {
            e = new ActionEvent(this, 1001, "CLICK", FocusablePanel.getCurrentModifiers());
        }
        for (ActionListener l : this.listeners) {
            l.actionPerformed(e);
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue() && this.isFocusOwner()) {
            SubstanceCoreUtilities.paintFocus((Graphics)g, (Component)this, (Component)this, (TransitionAwareUI)new SubstanceCheckBoxUI((JToggleButton)new JCheckBox()), null, (Rectangle)new Rectangle(), (float)1.0f, (int)SubstanceSizeUtils.getFocusRingPadding((int)SubstanceSizeUtils.getComponentFontSize((Component)this)));
        }
    }
}

