/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.FontFace;
import com.jpexs.decompiler.flash.gui.FontFamily;
import com.jpexs.decompiler.flash.gui.FontPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.font.CharacterRanges;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class FontEmbedDialog
extends AppDialog {
    private static final int SAMPLE_MAX_LENGTH = 50;
    private final JComboBox<FontFamily> familyNamesSelection;
    private final JComboBox<FontFace> faceSelection;
    private final JCheckBox[] rangeCheckboxes;
    private final String[] rangeNames;
    private final JLabel[] rangeSamples;
    private final JTextField individualCharsField;
    private int result = -1;
    private JLabel individualSample;
    private Font customFont;
    private final JCheckBox allCheckbox;
    private final JCheckBox importAscentDescentLeadingCheckBox;
    private final JTextField fontNameTextField;
    private JRadioButton ttfFileRadio;
    private JRadioButton installedRadio;

    public String getCreateFontName() {
        return this.fontNameTextField.getText();
    }

    public Font getSelectedFont() {
        if (this.ttfFileRadio.isSelected() && this.customFont != null) {
            return this.customFont;
        }
        return ((FontFace)this.faceSelection.getSelectedItem()).font;
    }

    public boolean isBold() {
        if (this.ttfFileRadio.isSelected() && this.customFont != null) {
            return this.customFont.isBold();
        }
        return ((FontFace)this.faceSelection.getSelectedItem()).isBold();
    }

    public boolean isItalic() {
        if (this.ttfFileRadio.isSelected() && this.customFont != null) {
            return this.customFont.isItalic();
        }
        return ((FontFace)this.faceSelection.getSelectedItem()).isItalic();
    }

    public boolean isImportAscentDescentLeading() {
        return this.importAscentDescentLeadingCheckBox.isSelected();
    }

    public Set<Integer> getSelectedChars() {
        TreeSet<Integer> chars = new TreeSet<Integer>();
        Font f = this.getSelectedFont();
        if (this.allCheckbox.isSelected()) {
            for (int i = 0; i < this.rangeCheckboxes.length; ++i) {
                int[] codes;
                for (int c : codes = CharacterRanges.rangeCodes((int)i)) {
                    if (!f.canDisplay(c)) continue;
                    chars.add(c);
                }
            }
        } else {
            for (int i = 0; i < this.rangeCheckboxes.length; ++i) {
                int[] codes;
                if (!this.rangeCheckboxes[i].isSelected()) continue;
                for (int c : codes = CharacterRanges.rangeCodes((int)i)) {
                    if (!f.canDisplay(c)) continue;
                    chars.add(c);
                }
            }
            String indStr = this.individualCharsField.getText();
            for (int i = 0; i < indStr.length(); ++i) {
                if (!f.canDisplay(indStr.codePointAt(i))) continue;
                chars.add(indStr.codePointAt(i));
            }
        }
        return chars;
    }

    private void updateFaceSelection() {
        this.faceSelection.setModel(FontPanel.getFaceModel((FontFamily)this.familyNamesSelection.getSelectedItem()));
    }

    public FontEmbedDialog(Window owner, boolean hasLayout, FontFace selectedFace, String selectedChars, boolean create) {
        super(owner);
        this.setSize(900, 600);
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title"));
        Container cnt = this.getContentPane();
        cnt.setLayout(new BoxLayout(cnt, 1));
        this.fontNameTextField = new JTextField(30);
        this.fontNameTextField.setText(this.translate("font.name.default"));
        this.fontNameTextField.selectAll();
        if (create) {
            JPanel fontNamePanel = new JPanel(new FlowLayout());
            fontNamePanel.add(new JLabel(this.translate("font.name")));
            fontNamePanel.add(this.fontNameTextField);
            cnt.add(fontNamePanel);
        }
        JPanel selFontPanel = new JPanel(new FlowLayout());
        this.installedRadio = new JRadioButton(this.translate("installed"));
        this.ttfFileRadio = new JRadioButton(this.translate("ttffile.noselection"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.installedRadio);
        bg.add(this.ttfFileRadio);
        this.installedRadio.setSelected(true);
        this.individualSample = new JLabel();
        this.familyNamesSelection = new JComboBox<FontFamily>(FontPanel.getFamilyModel());
        this.familyNamesSelection.setSelectedItem(new FontFamily(selectedFace.font));
        this.faceSelection = new JComboBox();
        this.updateFaceSelection();
        this.faceSelection.setSelectedItem(selectedFace);
        JButton loadFromDiskButton = new JButton(View.getIcon("open16"));
        loadFromDiskButton.setToolTipText(this.translate("button.loadfont"));
        loadFromDiskButton.addActionListener(this::loadFromDiscButtonActionPerformed);
        selFontPanel.add(new JLabel(this.translate("font.source")));
        selFontPanel.add(this.installedRadio);
        selFontPanel.add(this.familyNamesSelection);
        selFontPanel.add(this.faceSelection);
        selFontPanel.add(this.ttfFileRadio);
        selFontPanel.add(loadFromDiskButton);
        this.installedRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FontEmbedDialog.this.updateCheckboxes();
                }
            }
        });
        this.ttfFileRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && FontEmbedDialog.this.ttfFileRadio.isSelected()) {
                    if (FontEmbedDialog.this.customFont == null) {
                        if (FontEmbedDialog.this.loadFromDisk()) {
                            FontEmbedDialog.this.updateCheckboxes();
                        } else {
                            FontEmbedDialog.this.installedRadio.setSelected(true);
                        }
                    } else {
                        FontEmbedDialog.this.updateCheckboxes();
                    }
                }
            }
        });
        cnt.add(selFontPanel);
        JPanel rangesPanel = new JPanel();
        rangesPanel.setLayout(new BoxLayout(rangesPanel, 1));
        final int rc = CharacterRanges.rangeCount();
        this.rangeCheckboxes = new JCheckBox[rc];
        this.rangeSamples = new JLabel[rc];
        this.rangeNames = new String[rc];
        this.allCheckbox = new JCheckBox(this.translate("allcharacters"));
        this.allCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    for (int i = 0; i < rc; ++i) {
                        FontEmbedDialog.this.rangeCheckboxes[i].setEnabled(false);
                    }
                    FontEmbedDialog.this.individualCharsField.setEnabled(false);
                } else if (e.getStateChange() == 2) {
                    for (int i = 0; i < rc; ++i) {
                        FontEmbedDialog.this.rangeCheckboxes[i].setEnabled(true);
                    }
                    FontEmbedDialog.this.individualCharsField.setEnabled(true);
                }
            }
        });
        JPanel rangeRowPanel = new JPanel();
        rangeRowPanel.setLayout(new BorderLayout());
        rangeRowPanel.add((Component)this.allCheckbox, "West");
        rangeRowPanel.setAlignmentX(0.0f);
        rangesPanel.add(rangeRowPanel);
        for (int i = 0; i < rc; ++i) {
            this.rangeNames[i] = CharacterRanges.rangeName((int)i);
            this.rangeSamples[i] = new JLabel("");
            this.rangeCheckboxes[i] = new JCheckBox(this.rangeNames[i]);
            rangeRowPanel = new JPanel();
            rangeRowPanel.setLayout(new BoxLayout(rangeRowPanel, 0));
            rangeRowPanel.add(this.rangeCheckboxes[i]);
            rangeRowPanel.add(Box.createHorizontalGlue());
            rangeRowPanel.add(this.rangeSamples[i]);
            rangeRowPanel.setAlignmentX(0.0f);
            rangesPanel.add(rangeRowPanel);
        }
        cnt.add(new FasterScrollPane(rangesPanel));
        JPanel specialPanel = new JPanel();
        specialPanel.setLayout(new BoxLayout(specialPanel, 0));
        specialPanel.add(new JLabel(this.translate("label.individual")));
        this.individualCharsField = new JTextField();
        this.individualCharsField.setPreferredSize(new Dimension(100, this.individualCharsField.getPreferredSize().height));
        this.individualSample = new JLabel();
        specialPanel.add(this.individualCharsField);
        cnt.add(specialPanel);
        cnt.add(this.individualSample);
        this.importAscentDescentLeadingCheckBox = new JCheckBox(this.translate("ascentdescentleading"));
        this.importAscentDescentLeadingCheckBox.setAlignmentX(0.5f);
        if (hasLayout && !create) {
            cnt.add(this.importAscentDescentLeadingCheckBox);
        }
        if (create) {
            this.importAscentDescentLeadingCheckBox.setSelected(true);
        }
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton okButton = new JButton(AppStrings.translate("button.ok"));
        okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(AppStrings.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        cnt.add(buttonsPanel);
        View.setWindowIcon(this);
        View.centerScreen(this);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.individualCharsField.setText(selectedChars);
        this.getRootPane().setDefaultButton(okButton);
        this.familyNamesSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FontEmbedDialog.this.updateFaceSelection();
                FontEmbedDialog.this.updateCheckboxes();
            }
        });
        this.faceSelection.addItemListener(e -> this.updateCheckboxes());
        this.updateCheckboxes();
        this.individualCharsField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FontEmbedDialog.this.updateIndividual();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FontEmbedDialog.this.updateIndividual();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FontEmbedDialog.this.updateIndividual();
            }
        });
    }

    private void updateIndividual() {
        String chars = this.individualCharsField.getText();
        Font f = this.getSelectedFont();
        StringBuilder visibleChars = new StringBuilder();
        for (int i = 0; i < chars.length(); ++i) {
            if (!f.canDisplay(chars.codePointAt(i))) continue;
            visibleChars.append(chars.charAt(i));
        }
        this.individualSample.setText(visibleChars.toString());
    }

    private void updateCheckboxes() {
        Font f = this.getSelectedFont().deriveFont(12.0f);
        int rc = CharacterRanges.rangeCount();
        HashSet<Integer> allChars = new HashSet<Integer>();
        for (int i = 0; i < rc; ++i) {
            this.rangeNames[i] = CharacterRanges.rangeName((int)i);
            int[] codes = CharacterRanges.rangeCodes((int)i);
            int avail = 0;
            StringBuilder sample = new StringBuilder();
            for (int c = 0; c < codes.length; ++c) {
                if (!f.canDisplay(codes[c])) continue;
                allChars.add(codes[c]);
                if (avail < 50) {
                    sample.append((char)codes[c]);
                }
                ++avail;
            }
            this.rangeSamples[i].setText(sample.toString());
            this.rangeSamples[i].setFont(f);
            this.rangeCheckboxes[i].setText(this.translate("range.description").replace("%available%", Integer.toString(avail)).replace("%name%", this.rangeNames[i]).replace("%total%", Integer.toString(codes.length)));
        }
        this.allCheckbox.setText(this.translate("allcharacters").replace("%available%", Integer.toString(allChars.size())));
        this.individualSample.setFont(f);
        this.updateIndividual();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.result = -1;
        }
        super.setVisible(b);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    private void loadFromDiscButtonActionPerformed(ActionEvent evt) {
        if (this.customFont != null && this.loadFromDisk()) {
            this.updateCheckboxes();
        }
        this.ttfFileRadio.setSelected(true);
    }

    private boolean loadFromDisk() {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File((String)Configuration.lastOpenDir.get()));
        FileFilter ttfFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".ttf") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return FontEmbedDialog.this.translate("filter.ttf");
            }
        };
        fc.setFileFilter(ttfFilter);
        fc.setAcceptAllFileFilterUsed(true);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            Configuration.lastOpenDir.set((Object)Helper.fixDialogFile((File)fc.getSelectedFile()).getParentFile().getAbsolutePath());
            File selfile = Helper.fixDialogFile((File)fc.getSelectedFile());
            try {
                this.customFont = Font.createFont(0, selfile);
                FontTag.addCustomFont((Font)this.customFont, (File)selfile);
                this.ttfFileRadio.setText(this.translate("ttffile.selection").replace("%fontname%", this.customFont.getName()).replace("%filename%", selfile.getName()));
                return true;
            }
            catch (FontFormatException ex) {
                JOptionPane.showMessageDialog(this, this.translate("error.invalidfontfile"), AppStrings.translate("error"), 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, this.translate("error.cannotreadfontfile"), AppStrings.translate("error"), 0);
            }
        }
        return false;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }
}

