/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.enums.GridSnapAccuracy;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ColorSelectionButton;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GridDialog
extends AppDialog {
    private final ColorSelectionButton colorSelection;
    private final JCheckBox showGridCheckBox;
    private final JCheckBox snapToGridCheckBox;
    private final JCheckBox showOverObjectsCheckBox;
    private final JComboBox<AccuracyItem> snapAccuracyComboBox;
    private final JTextField spacingHorizontalTextField;
    private final JTextField spacingVerticalTextField;

    public GridDialog(Window owner) {
        super(owner);
        this.setSize(800, 600);
        this.setTitle(this.translate("dialog.title"));
        Container cnt = this.getContentPane();
        JPanel centralPanel = new JPanel(new GridBagLayout());
        centralPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        JLabel colorLabel = new JLabel(this.translate("color"));
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 22;
        centralPanel.add((Component)colorLabel, c);
        this.colorSelection = new ColorSelectionButton((Color)Configuration.gridColor.get(), null);
        colorLabel.setLabelFor(this.colorSelection);
        c.gridx = 1;
        c.anchor = 21;
        centralPanel.add((Component)this.colorSelection, c);
        this.showGridCheckBox = new JCheckBox(this.translate("show"));
        this.showGridCheckBox.setSelected((Boolean)Configuration.showGrid.get());
        ++c.gridy;
        centralPanel.add((Component)this.showGridCheckBox, c);
        this.snapToGridCheckBox = new JCheckBox(this.translate("snapTo"));
        this.snapToGridCheckBox.setSelected((Boolean)Configuration.snapToGrid.get());
        ++c.gridy;
        centralPanel.add((Component)this.snapToGridCheckBox, c);
        this.showOverObjectsCheckBox = new JCheckBox(this.translate("showOverObjects"));
        this.showOverObjectsCheckBox.setSelected((Boolean)Configuration.gridOverObjects.get());
        ++c.gridy;
        centralPanel.add((Component)this.showOverObjectsCheckBox, c);
        JLabel spacingHorizontalLabel = new JLabel(this.translate("spacing.x"));
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 22;
        centralPanel.add((Component)spacingHorizontalLabel, c);
        this.spacingHorizontalTextField = new JTextField(10);
        spacingHorizontalLabel.setLabelFor(this.spacingHorizontalTextField);
        this.spacingHorizontalTextField.setText("" + Configuration.gridHorizontalSpace.get());
        ++c.gridx;
        c.anchor = 21;
        centralPanel.add((Component)this.spacingHorizontalTextField, c);
        JLabel spacingVerticalLabel = new JLabel(this.translate("spacing.y"));
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 22;
        centralPanel.add((Component)spacingVerticalLabel, c);
        this.spacingVerticalTextField = new JTextField(10);
        spacingVerticalLabel.setLabelFor(this.spacingVerticalTextField);
        this.spacingVerticalTextField.setText("" + Configuration.gridVerticalSpace.get());
        ++c.gridx;
        c.anchor = 21;
        centralPanel.add((Component)this.spacingVerticalTextField, c);
        JLabel snapAccuracyLabel = new JLabel(this.translate("snapAccuracy"));
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 22;
        centralPanel.add((Component)snapAccuracyLabel, c);
        this.snapAccuracyComboBox = new JComboBox<AccuracyItem>(new AccuracyItem[]{new AccuracyItem(GridSnapAccuracy.MUST_BE_CLOSE), new AccuracyItem(GridSnapAccuracy.NORMAL), new AccuracyItem(GridSnapAccuracy.CAN_BE_DISTANT), new AccuracyItem(GridSnapAccuracy.ALWAYS_SNAP)});
        snapAccuracyLabel.setLabelFor(this.snapAccuracyComboBox);
        this.snapAccuracyComboBox.setSelectedItem(new AccuracyItem((GridSnapAccuracy)Configuration.gridSnapAccuracy.get()));
        ++c.gridx;
        c.anchor = 21;
        centralPanel.add(this.snapAccuracyComboBox, c);
        cnt.setLayout(new BorderLayout());
        cnt.add((Component)centralPanel, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 1));
        JButton okButton = new JButton(this.translate("button.ok"));
        okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(okButton);
        buttonsPanel.add(Box.createVerticalStrut(5));
        buttonsPanel.add(cancelButton);
        cnt.add((Component)buttonsPanel, "East");
        this.pack();
        View.setWindowIcon16(this, "grid");
        View.centerScreen(this);
        this.setModal(true);
        this.setResizable(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int verticalSpacing;
        int horizontalSpacing;
        try {
            horizontalSpacing = Integer.parseInt(this.spacingHorizontalTextField.getText());
        }
        catch (NumberFormatException nfe) {
            ViewMessages.showMessageDialog(this, this.translate("error.invalidSpacing"), AppStrings.translate("error"), 0);
            this.spacingHorizontalTextField.requestFocus();
            return;
        }
        try {
            verticalSpacing = Integer.parseInt(this.spacingVerticalTextField.getText());
        }
        catch (NumberFormatException nfe) {
            ViewMessages.showMessageDialog(this, this.translate("error.invalidSpacing"), AppStrings.translate("error"), 0);
            this.spacingVerticalTextField.requestFocus();
            return;
        }
        Configuration.gridHorizontalSpace.set((Object)horizontalSpacing);
        Configuration.gridVerticalSpace.set((Object)verticalSpacing);
        Configuration.gridColor.set((Object)this.colorSelection.getValue());
        Configuration.showGrid.set((Object)this.showGridCheckBox.isSelected());
        Configuration.snapToGrid.set((Object)this.snapToGridCheckBox.isSelected());
        Configuration.gridOverObjects.set((Object)this.showOverObjectsCheckBox.isSelected());
        Configuration.gridSnapAccuracy.set((Object)((AccuracyItem)this.snapAccuracyComboBox.getSelectedItem()).accuracy);
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private class AccuracyItem {
        private GridSnapAccuracy accuracy;

        public AccuracyItem(GridSnapAccuracy accuracy) {
            this.accuracy = accuracy;
        }

        public GridSnapAccuracy getAccuracy() {
            return this.accuracy;
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + Objects.hashCode(this.accuracy);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccuracyItem other = (AccuracyItem)obj;
            return this.accuracy == other.accuracy;
        }

        public String toString() {
            switch (this.accuracy) {
                case MUST_BE_CLOSE: {
                    return GridDialog.this.translate("snapAccuracy.mustBeClose");
                }
                case NORMAL: {
                    return GridDialog.this.translate("snapAccuracy.normal");
                }
                case CAN_BE_DISTANT: {
                    return GridDialog.this.translate("snapAccuracy.canBeDistant");
                }
                case ALWAYS_SNAP: {
                    return GridDialog.this.translate("snapAccuracy.alwaysSnap");
                }
            }
            return "unknown";
        }
    }
}

