/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.enums.GuidesSnapAccuracy;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.ColorSelectionButton;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GuidesDialog
extends AppDialog {
    private final ColorSelectionButton colorSelection;
    private final JCheckBox showGuidesCheckBox;
    private final JCheckBox snapToGuidesCheckBox;
    private final JCheckBox lockGuidesCheckBox;
    private final JComboBox<AccuracyItem> snapAccuracyComboBox;
    private final MediaDisplay mediaDisplay;

    public GuidesDialog(Window owner, MediaDisplay mediaDisplay) {
        super(owner);
        this.setSize(800, 600);
        this.setTitle(this.translate("dialog.title"));
        Container cnt = this.getContentPane();
        JPanel centralPanel = new JPanel(new GridBagLayout());
        centralPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        JLabel colorLabel = new JLabel(this.translate("color"));
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 22;
        centralPanel.add((Component)colorLabel, c);
        this.colorSelection = new ColorSelectionButton((Color)Configuration.guidesColor.get(), null);
        colorLabel.setLabelFor(this.colorSelection);
        c.gridx = 1;
        c.anchor = 21;
        centralPanel.add((Component)this.colorSelection, c);
        this.showGuidesCheckBox = new JCheckBox(this.translate("show"));
        this.showGuidesCheckBox.setSelected((Boolean)Configuration.showGuides.get());
        ++c.gridy;
        centralPanel.add((Component)this.showGuidesCheckBox, c);
        this.snapToGuidesCheckBox = new JCheckBox(this.translate("snapTo"));
        this.snapToGuidesCheckBox.setSelected((Boolean)Configuration.snapToGuides.get());
        ++c.gridy;
        centralPanel.add((Component)this.snapToGuidesCheckBox, c);
        this.lockGuidesCheckBox = new JCheckBox(this.translate("lock"));
        this.lockGuidesCheckBox.setSelected((Boolean)Configuration.lockGuides.get());
        ++c.gridy;
        centralPanel.add((Component)this.lockGuidesCheckBox, c);
        JLabel snapAccuracyLabel = new JLabel(this.translate("snapAccuracy"));
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 22;
        centralPanel.add((Component)snapAccuracyLabel, c);
        this.snapAccuracyComboBox = new JComboBox<AccuracyItem>(new AccuracyItem[]{new AccuracyItem(GuidesSnapAccuracy.MUST_BE_CLOSE), new AccuracyItem(GuidesSnapAccuracy.NORMAL), new AccuracyItem(GuidesSnapAccuracy.CAN_BE_DISTANT)});
        snapAccuracyLabel.setLabelFor(this.snapAccuracyComboBox);
        this.snapAccuracyComboBox.setSelectedItem(new AccuracyItem((GuidesSnapAccuracy)Configuration.guidesSnapAccuracy.get()));
        ++c.gridx;
        c.anchor = 21;
        centralPanel.add(this.snapAccuracyComboBox, c);
        cnt.setLayout(new BorderLayout());
        cnt.add((Component)centralPanel, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 1));
        JButton okButton = new JButton(this.translate("button.ok"));
        okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        JButton clearGuidesButton = new JButton(this.translate("clear"));
        clearGuidesButton.addActionListener(this::clearButtonActionPerformed);
        buttonsPanel.add(okButton);
        buttonsPanel.add(Box.createVerticalStrut(5));
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(Box.createVerticalStrut(5));
        buttonsPanel.add(clearGuidesButton);
        cnt.add((Component)buttonsPanel, "East");
        this.pack();
        View.setWindowIcon16(this, "guides");
        View.centerScreen(this);
        this.setModal(true);
        this.setResizable(false);
        this.mediaDisplay = mediaDisplay;
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.mediaDisplay.clearGuides();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Configuration.guidesColor.set((Object)this.colorSelection.getValue());
        Configuration.showGuides.set((Object)this.showGuidesCheckBox.isSelected());
        Configuration.snapToGuides.set((Object)this.snapToGuidesCheckBox.isSelected());
        Configuration.lockGuides.set((Object)this.lockGuidesCheckBox.isSelected());
        Configuration.guidesSnapAccuracy.set((Object)((AccuracyItem)this.snapAccuracyComboBox.getSelectedItem()).accuracy);
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private class AccuracyItem {
        private GuidesSnapAccuracy accuracy;

        public AccuracyItem(GuidesSnapAccuracy accuracy) {
            this.accuracy = accuracy;
        }

        public GuidesSnapAccuracy getAccuracy() {
            return this.accuracy;
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + Objects.hashCode(this.accuracy);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccuracyItem other = (AccuracyItem)obj;
            return this.accuracy == other.accuracy;
        }

        public String toString() {
            switch (this.accuracy) {
                case MUST_BE_CLOSE: {
                    return GuidesDialog.this.translate("snapAccuracy.mustBeClose");
                }
                case NORMAL: {
                    return GuidesDialog.this.translate("snapAccuracy.normal");
                }
                case CAN_BE_DISTANT: {
                    return GuidesDialog.this.translate("snapAccuracy.canBeDistant");
                }
            }
            return "unknown";
        }
    }
}

