/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppRibbonFrame;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrameMenu;
import com.jpexs.decompiler.flash.gui.MainFrameRibbonMenu;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.BaseTSD;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.Dwmapi;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.NtDll;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.User32;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.WinDef;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.WinNT;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.helpers.Helper;
import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.win32.StdCallLibrary;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.plaf.RootPaneUI;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonRootPaneUI;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;

public final class MainFrameRibbon
extends AppRibbonFrame {
    private final MainPanel panel;
    private final MainFrameMenu mainMenu;

    public MainFrameRibbon() {
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JRibbon ribbon = this.getRibbon();
        cnt.add((Component)ribbon, "North");
        this.mainMenu = new MainFrameRibbonMenu(this, ribbon);
        this.mainMenu.createMenuBar();
        this.panel = new MainPanel(this, this.mainMenu);
        this.panel.setBackground(Color.yellow);
        cnt.add((Component)this.panel, "Center");
        int w = (Integer)Configuration.guiWindowWidth.get();
        int h = (Integer)Configuration.guiWindowHeight.get();
        GraphicsDevice device = View.getMainDefaultScreenDevice();
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(device.getDefaultConfiguration());
        int maxWidth = bounds.width - (insets.left + insets.right);
        int maxHeight = bounds.height - (insets.top + insets.bottom);
        if (w > maxWidth) {
            w = maxWidth;
        }
        if (h > maxHeight) {
            h = maxHeight;
        }
        this.setSize(w, h);
        boolean maximizedHorizontal = (Boolean)Configuration.guiWindowMaximizedHorizontal.get();
        boolean maximizedVertical = (Boolean)Configuration.guiWindowMaximizedVertical.get();
        int state = 0;
        if (maximizedHorizontal) {
            state |= 2;
        }
        if (maximizedVertical) {
            state |= 4;
        }
        this.setExtendedState(state);
        View.setWindowIcon((Window)((Object)this));
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                int state = e.getNewState();
                Configuration.guiWindowMaximizedHorizontal.set((Object)((state & 2) == 2 ? 1 : 0));
                Configuration.guiWindowMaximizedVertical.set((Object)((state & 4) == 4 ? 1 : 0));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int state = MainFrameRibbon.this.getExtendedState();
                if ((state & 2) == 0) {
                    Configuration.guiWindowWidth.set((Object)MainFrameRibbon.this.getWidth());
                }
                if ((state & 4) == 0) {
                    Configuration.guiWindowHeight.set((Object)MainFrameRibbon.this.getHeight());
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                boolean closeResult;
                if (((Boolean)Configuration.saveSessionOnExit.get()).booleanValue()) {
                    String pathTagList;
                    StringBuilder sb = new StringBuilder();
                    StringBuilder sbt = new StringBuilder();
                    boolean first = true;
                    for (OpenableList swf : MainFrameRibbon.this.panel.getSwfs()) {
                        if (!first) {
                            sb.append(File.pathSeparator);
                            sbt.append(File.pathSeparator);
                        }
                        first = false;
                        String file = swf.sourceInfo.getFile();
                        if (file == null) continue;
                        sb.append(file);
                        String t = swf.sourceInfo.getFileTitle();
                        sbt.append(t == null ? "" : t);
                    }
                    Configuration.lastSessionFiles.set((Object)sb.toString());
                    Configuration.lastSessionFileTitles.set((Object)sbt.toString());
                    SWF easySwf = MainFrameRibbon.this.panel.getEasyPanel().getSwf();
                    if (easySwf != null) {
                        Configuration.lastSessionEasySwf.set((Object)(easySwf.getFile() + "|" + easySwf.getFileTitle()));
                    } else {
                        Configuration.lastSessionEasySwf.set((Object)"");
                    }
                    String pathResources = ((MainFrameRibbon)MainFrameRibbon.this).panel.tagTree.getSelectionPathString();
                    if (pathResources != null) {
                        Configuration.lastSessionSelection.set((Object)pathResources);
                    }
                    if ((pathTagList = ((MainFrameRibbon)MainFrameRibbon.this).panel.tagListTree.getSelectionPathString()) != null) {
                        Configuration.lastSessionTagListSelection.set((Object)pathTagList);
                    }
                }
                if (closeResult = MainFrameRibbon.this.panel.closeAll(true, true)) {
                    Main.exit();
                }
            }
        });
        View.centerScreenMain((Window)((Object)this));
        this.enableAeroSnap();
    }

    private boolean isAeroSnapAvailable() {
        if (!Platform.isWindows()) {
            return false;
        }
        WinNT.OSVERSIONINFOEX version = new WinNT.OSVERSIONINFOEX();
        if (NtDll.INSTANCE.RtlGetVersion(version) != 0) {
            return false;
        }
        int major = version.dwMajorVersion.intValue();
        if (major < 6) {
            return false;
        }
        try {
            WinDef.BOOLbyReference enabled = new WinDef.BOOLbyReference();
            if (Dwmapi.INSTANCE.DwmIsCompositionEnabled(enabled).intValue() == 0 && enabled.getValue().intValue() != 1) {
                return false;
            }
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            return false;
        }
        return true;
    }

    private void enableAeroSnap() {
        if (!this.isAeroSnapAvailable()) {
            return;
        }
        final Point posOnScreen = new Point();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.update();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.update();
            }

            private void update() {
                if (MainFrameRibbon.this.isVisible()) {
                    posOnScreen.x = MainFrameRibbon.this.getLocationOnScreen().x;
                    posOnScreen.y = MainFrameRibbon.this.getLocationOnScreen().y;
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){
            private BaseTSD.LONG_PTR oldWndProc;
            private StdCallLibrary.StdCallCallback newProc;
            private Rectangle dragRect = new Rectangle();
            private Rectangle toggleRect = new Rectangle();
            private AffineTransform trans;

            @Override
            public void windowOpened(WindowEvent e) {
                RootPaneUI ui = MainFrameRibbon.this.getRootPane().getUI();
                if (ui instanceof SubstanceRibbonRootPaneUI) {
                    SubstanceRibbonRootPaneUI sui = (SubstanceRibbonRootPaneUI)ui;
                    final JComponent titlePane = sui.getTitlePane();
                    MainFrameRibbon window = MainFrameRibbon.this;
                    this.trans = View.getWindowDevice((Window)((Object)window)).getDefaultConfiguration().getDefaultTransform();
                    if (this.trans == null) {
                        this.trans = new AffineTransform();
                    }
                    ComponentAdapter ad = new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent e) {
                            this.updateRect();
                        }

                        @Override
                        public void componentShown(ComponentEvent e) {
                            this.updateRect();
                        }

                        private void updateRect() {
                            int appButtonSize = (int)Math.round(trans.getScaleX() * (double)Integer.getInteger("peacock.appButtonSize", 24).intValue());
                            SubstanceTitlePane.HeapStatusPanel h = new SubstanceTitlePane.HeapStatusPanel();
                            int heapWidth = (Boolean)Configuration.showHeapStatusWidget.get() != false ? 5 + h.getPreferredWidth() : 0;
                            int titleIconsWidth = 3 + SubstanceSizeUtils.getTitlePaneIconSize() + 10 + SubstanceSizeUtils.getTitlePaneIconSize() + 2 + SubstanceSizeUtils.getTitlePaneIconSize() + 2 + SubstanceSizeUtils.getTitlePaneIconSize() + heapWidth;
                            dragRect = new Rectangle(5 + appButtonSize, 4, titlePane.getWidth() - titleIconsWidth - appButtonSize, titlePane.getHeight());
                            toggleRect = new Rectangle(titlePane.getWidth() - (3 + SubstanceSizeUtils.getTitlePaneIconSize() + 10 + SubstanceSizeUtils.getTitlePaneIconSize()), 4, SubstanceSizeUtils.getTitlePaneIconSize(), SubstanceSizeUtils.getTitlePaneIconSize());
                        }
                    };
                    titlePane.addComponentListener(ad);
                    ad.componentShown(null);
                    final WinDef.HWND hwnd = new WinDef.HWND(Native.getComponentPointer((Component)((Object)window)));
                    this.oldWndProc = User32.INSTANCE.GetWindowLongPtr(hwnd, -4);
                    this.newProc = new StdCallLibrary.StdCallCallback(){

                        public WinDef.LRESULT callback(WinDef.HWND hWnd, int uMsg, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
                            if (!User32.INSTANCE.IsWindow(hwnd)) {
                                return new WinDef.LRESULT(0L);
                            }
                            if (uMsg == 131) {
                                return new WinDef.LRESULT(0L);
                            }
                            if (uMsg == 160 && wParam.intValue() == 9) {
                                User32.INSTANCE.PostMessage(hwnd, 512, new WinDef.WPARAM(0L), lParam);
                                return new WinDef.LRESULT(0L);
                            }
                            if (uMsg == 672 && wParam.intValue() == 9) {
                                User32.INSTANCE.PostMessage(hwnd, 673, new WinDef.WPARAM(0L), lParam);
                                return new WinDef.LRESULT(0L);
                            }
                            if (uMsg == 674 && wParam.intValue() == 9) {
                                User32.INSTANCE.PostMessage(hwnd, 675, new WinDef.WPARAM(0L), lParam);
                                return new WinDef.LRESULT(0L);
                            }
                            if (uMsg == 161 && wParam.intValue() == 9) {
                                User32.INSTANCE.PostMessage(hwnd, 513, new WinDef.WPARAM(1L), lParam);
                                return new WinDef.LRESULT(0L);
                            }
                            if (uMsg == 162 && wParam.intValue() == 9) {
                                User32.INSTANCE.PostMessage(hwnd, 514, new WinDef.WPARAM(1L), lParam);
                                return new WinDef.LRESULT(0L);
                            }
                            if (uMsg == 132) {
                                boolean bottom;
                                short y = (short)(lParam.longValue() >> 16 & 0xFFFFL);
                                short x = (short)(lParam.longValue() & 0xFFFFL);
                                int BORDER_WIDTH = 4;
                                WinDef.RECT winRect = new WinDef.RECT();
                                User32.INSTANCE.GetWindowRect(hWnd, winRect);
                                boolean left = x >= winRect.left - BORDER_WIDTH && x < winRect.left + BORDER_WIDTH;
                                boolean right = x < winRect.right + BORDER_WIDTH && x >= winRect.right - BORDER_WIDTH;
                                boolean top = y >= winRect.top - BORDER_WIDTH && y < winRect.top + BORDER_WIDTH;
                                boolean bl = bottom = y < winRect.bottom + BORDER_WIDTH && y >= winRect.bottom - BORDER_WIDTH;
                                if (left && top) {
                                    return new WinDef.LRESULT(13L);
                                }
                                if (right && top) {
                                    return new WinDef.LRESULT(14L);
                                }
                                if (left && bottom) {
                                    return new WinDef.LRESULT(16L);
                                }
                                if (right && bottom) {
                                    return new WinDef.LRESULT(17L);
                                }
                                if (top) {
                                    return new WinDef.LRESULT(12L);
                                }
                                if (bottom) {
                                    return new WinDef.LRESULT(15L);
                                }
                                if (left) {
                                    return new WinDef.LRESULT(10L);
                                }
                                if (right) {
                                    return new WinDef.LRESULT(11L);
                                }
                                Point p = new Point(x, y);
                                p.x = (int)Math.round((double)p.x / trans.getScaleX());
                                p.y = (int)Math.round((double)p.y / trans.getScaleY());
                                p.x -= posOnScreen.x;
                                p.y -= posOnScreen.y;
                                if (dragRect.contains(p)) {
                                    return new WinDef.LRESULT(2L);
                                }
                                if (toggleRect.contains(p)) {
                                    return new WinDef.LRESULT(9L);
                                }
                            }
                            return User32.INSTANCE.CallWindowProc(oldWndProc.toPointer(), hWnd, uMsg, wParam, lParam);
                        }
                    };
                    User32.INSTANCE.SetWindowLongPtr(hwnd, -4, (Callback)this.newProc);
                    int style = User32.INSTANCE.GetWindowLong(hwnd, -16);
                    User32.INSTANCE.SetWindowLong(hwnd, -16, style |= 0x40000);
                    User32.INSTANCE.SetWindowPos(hwnd, null, 0, 0, 0, 0, 39);
                    Dwmapi.MARGINS margins = new Dwmapi.MARGINS();
                    margins.cxLeftWidth = 0;
                    margins.cxRightWidth = 0;
                    margins.cyTopHeight = 0;
                    margins.cyBottomHeight = 0;
                    Dwmapi.INSTANCE.DwmExtendFrameIntoClientArea(hwnd, margins);
                }
            }
        });
    }

    public void setExtendedState(int state) {
        if ((state & 6) == 6) {
            GraphicsConfiguration gc = View.getWindowDevice(this.getWindow()).getDefaultConfiguration();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            Rectangle screenBounds = gc.getBounds();
            Rectangle maxBounds = new Rectangle(screenBounds.x + screenInsets.left, screenBounds.y + screenInsets.top, screenBounds.width - (screenInsets.left + screenInsets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom));
            this.setMaximizedBounds(maxBounds);
        }
        super.setExtendedState(state);
    }

    private static void getApplicationMenuButtons(Component comp, List<JRibbonApplicationMenuButton> ret) {
        if (comp instanceof JRibbonApplicationMenuButton) {
            ret.add((JRibbonApplicationMenuButton)comp);
            return;
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                MainFrameRibbon.getApplicationMenuButtons(cont.getComponent(i), ret);
            }
        }
    }

    @Override
    public MainPanel getPanel() {
        return this.panel;
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.mainMenu.dispose();
        Helper.emptyObject((Object)this.mainMenu);
        this.panel.dispose();
        Helper.emptyObject((Object)this);
        super.dispose();
    }

    @Override
    public MainFrameMenu getMenu() {
        return this.mainMenu;
    }
}

