/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PathResolvingDialog
extends AppDialog {
    private final JEditorPane editor;
    private final JButton okButton = new JButton(this.translate("button.ok"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private int result = -1;
    private final SWF swf;

    public PathResolvingDialog(SWF swf, Window owner) {
        super(owner);
        this.setTitle(this.translate("dialog.title"));
        this.setDefaultCloseOperation(1);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        cnt.add((Component)new JLabel("<html>" + this.translate("info") + "</html>"), "North");
        this.editor = new JEditorPane();
        cnt.add((Component)new JScrollPane(this.editor), "Center");
        this.editor.setContentType("text/plain");
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        cnt.add((Component)buttonsPanel, "South");
        SwfSpecificCustomConfiguration cc = Configuration.getSwfSpecificCustomConfiguration((String)swf.getShortPathTitle());
        String pathResolving = "";
        if (cc != null) {
            pathResolving = cc.getCustomData("pathResolving", "");
        }
        this.editor.setText(pathResolving);
        this.setSize(800, 600);
        View.centerScreen(this);
        View.setWindowIcon(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setModal(true);
        this.swf = swf;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        SwfSpecificCustomConfiguration cc = Configuration.getOrCreateSwfSpecificCustomConfiguration((String)this.swf.getShortPathTitle());
        String txt = this.editor.getText();
        txt = txt.replace("\r\n", "\n");
        txt = txt.replace("\n", "\r\n");
        cc.setCustomData("pathResolving", txt);
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }
}

