/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.SearchDialog;
import com.jpexs.decompiler.flash.gui.SearchListener;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.search.SearchResult;
import com.jpexs.decompiler.flash.treeitems.Openable;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SearchResultsDialog<E extends SearchResult>
extends AppDialog {
    private final JTree resultsTree;
    private final JList<SearchResult> resultsList;
    private final JPanel resultsPanel;
    private final boolean regExp;
    private final List<SearchListener<E>> listeners;
    private final JButton gotoButton = new JButton(this.translate("button.goto"));
    private final JButton closeButton = new JButton(this.translate("button.close"));
    private String text;
    private final boolean ignoreCase;
    private Map<Openable, List<SearchResult>> openableToResults = new LinkedHashMap<Openable, List<SearchResult>>();

    public SearchResultsDialog(Window owner, String text, boolean ignoreCase, boolean regExp, List<SearchListener<E>> listeners) {
        super(owner);
        this.setTitle(this.translate("dialog.title").replace("%text%", text));
        this.text = text;
        Container cnt = this.getContentPane();
        this.resultsTree = new JTree(new BasicTreeNode("root"));
        this.resultsList = new JList(new DefaultListModel());
        this.regExp = regExp;
        this.listeners = listeners;
        this.gotoButton.addActionListener(this::gotoButtonActionPerformed);
        this.closeButton.addActionListener(this::closeButtonActionPerformed);
        JPanel paramsPanel = new JPanel();
        paramsPanel.setLayout(new FlowLayout());
        JLabel searchTextLabel = new JLabel(AppDialog.translateForDialog("label.searchtext", SearchDialog.class) + text);
        JLabel ignoreCaseLabel = new JLabel(AppDialog.translateForDialog("checkbox.ignorecase", SearchDialog.class) + ": " + (ignoreCase ? AppStrings.translate("yes") : AppStrings.translate("no")));
        JLabel regExpLabel = new JLabel(AppDialog.translateForDialog("checkbox.regexp", SearchDialog.class) + ": " + (regExp ? AppStrings.translate("yes") : AppStrings.translate("no")));
        paramsPanel.add(ignoreCaseLabel);
        paramsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        paramsPanel.add(regExpLabel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(this.gotoButton);
        buttonsPanel.add(this.closeButton);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SearchResultsDialog.this.gotoElement();
                }
            }
        };
        this.resultsTree.addKeyListener(keyListener);
        this.resultsList.addKeyListener(keyListener);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SearchResultsDialog.this.gotoElement();
                }
            }
        };
        this.resultsTree.addMouseListener(mouseListener);
        this.resultsList.addMouseListener(mouseListener);
        this.resultsTree.setRootVisible(false);
        this.resultsTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                throw new ExpandVetoException(event, "Collapsing tree not allowed");
            }
        });
        final ImageIcon flashIcon = View.getIcon("flash16");
        this.resultsTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    BasicTreeNode node = (BasicTreeNode)value;
                    if (node.getData() instanceof SWF) {
                        label.setIcon(flashIcon);
                    } else {
                        label.setIcon(null);
                    }
                }
                return c;
            }
        });
        this.resultsTree.setUI(new BasicTreeUI(){

            @Override
            public void paint(Graphics g, JComponent c) {
                if (this.tree != c) {
                    throw new InternalError("incorrect component");
                }
                if (this.treeState == null) {
                    return;
                }
                Rectangle paintBounds = g.getClipBounds();
                Insets insets = this.tree.getInsets();
                TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
                Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
                int row = this.treeState.getRowForPath(initialPath);
                int endY = paintBounds.y + paintBounds.height;
                this.drawingCache.clear();
                if (initialPath != null && paintingEnumerator != null) {
                    TreePath parentPath = initialPath;
                    for (parentPath = parentPath.getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
                        this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                        this.drawingCache.put(parentPath, Boolean.TRUE);
                    }
                    boolean done = false;
                    Rectangle boundsBuffer = new Rectangle();
                    boolean rootVisible = this.isRootVisible();
                    while (!done && paintingEnumerator.hasMoreElements()) {
                        TreePath path = paintingEnumerator.nextElement();
                        if (path != null) {
                            boolean isExpanded;
                            boolean hasBeenExpanded;
                            boolean isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                            if (isLeaf) {
                                hasBeenExpanded = false;
                                isExpanded = false;
                            } else {
                                isExpanded = this.treeState.getExpandedState(path);
                                hasBeenExpanded = this.tree.hasBeenExpanded(path);
                            }
                            Rectangle bounds = this.getPathBounds(path, insets, boundsBuffer);
                            if (bounds == null) {
                                return;
                            }
                            parentPath = path.getParentPath();
                            if (parentPath != null) {
                                if (this.drawingCache.get(parentPath) == null) {
                                    this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                                    this.drawingCache.put(parentPath, Boolean.TRUE);
                                }
                                this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                            } else if (rootVisible && row == 0) {
                                this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                            }
                            if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                                this.paintExpandControl(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                            }
                            this.paintRow(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                            if (bounds.y + bounds.height >= endY) {
                                done = true;
                            }
                        } else {
                            done = true;
                        }
                        ++row;
                    }
                }
                this.paintDropLine(g);
                this.rendererPane.removeAll();
                this.drawingCache.clear();
            }

            @Override
            public Rectangle getPathBounds(JTree tree, TreePath path) {
                if (tree != null && this.treeState != null) {
                    return this.getPathBounds(path, tree.getInsets(), new Rectangle());
                }
                return null;
            }

            private Rectangle getPathBounds(TreePath path, Insets insets, Rectangle bounds) {
                if ((bounds = this.treeState.getBounds(path, bounds)) != null) {
                    bounds.width = this.tree.getWidth();
                    bounds.y += insets.top;
                }
                return bounds;
            }
        });
        cnt.setLayout(new BorderLayout());
        this.resultsPanel = new JPanel(new CardLayout());
        this.resultsPanel.add((Component)this.resultsTree, "tree");
        this.resultsPanel.add(this.resultsList, "list");
        FasterScrollPane sp = new FasterScrollPane(this.resultsPanel);
        sp.setPreferredSize(new Dimension(300, 300));
        cnt.add((Component)sp, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        JPanel searchTextPanel = new JPanel(new FlowLayout(1));
        searchTextPanel.add(searchTextLabel);
        if (((Boolean)Configuration.parametersPanelInSearchResults.get()).booleanValue()) {
            bottomPanel.add(searchTextPanel);
            bottomPanel.add(paramsPanel);
            bottomPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        bottomPanel.add(buttonsPanel);
        cnt.add((Component)bottomPanel, "South");
        this.pack();
        View.centerScreen(this);
        View.setWindowIcon(this, "searchresults");
        this.ignoreCase = ignoreCase;
    }

    public void setResults(List<E> results) {
        this.openableToResults.clear();
        for (SearchResult e : results) {
            if (!this.openableToResults.containsKey(e.getOpenable())) {
                this.openableToResults.put(e.getOpenable(), new ArrayList());
            }
            this.openableToResults.get(e.getOpenable()).add(e);
        }
        this.updateModel();
    }

    private void updateModel() {
        boolean showSwfTitles;
        boolean bl = showSwfTitles = this.openableToResults.size() > 1;
        if (showSwfTitles) {
            BasicTreeNode rootNode = new BasicTreeNode("root");
            ArrayList<BasicTreeNode> swfNodes = new ArrayList<BasicTreeNode>();
            for (Openable openable : this.openableToResults.keySet()) {
                BasicTreeNode swfNode = new BasicTreeNode(openable);
                if (showSwfTitles) {
                    rootNode.addChild(swfNode);
                    swfNode.setParent(rootNode);
                    swfNodes.add(swfNode);
                }
                for (SearchResult r : this.openableToResults.get(openable)) {
                    BasicTreeNode rNode = new BasicTreeNode(r);
                    if (showSwfTitles) {
                        swfNode.addChild(rNode);
                        rNode.setParent(swfNode);
                        continue;
                    }
                    rootNode.addChild(rNode);
                    rNode.setParent(rootNode);
                }
            }
            this.resultsTree.setModel(new DefaultTreeModel(rootNode, false));
            for (TreeNode treeNode : swfNodes) {
                TreePath tp = new TreePath(new Object[]{rootNode, treeNode});
                this.resultsTree.expandPath(tp);
            }
        } else {
            DefaultListModel model = (DefaultListModel)this.resultsList.getModel();
            model.clear();
            if (!this.openableToResults.isEmpty()) {
                List<SearchResult> elements = this.openableToResults.get(this.openableToResults.keySet().iterator().next());
                for (SearchResult searchResult : elements) {
                    model.addElement(searchResult);
                }
            }
        }
        ((CardLayout)this.resultsPanel.getLayout()).show(this.resultsPanel, showSwfTitles ? "tree" : "list");
    }

    public void removeSwf(SWF swf) {
        this.openableToResults.remove(swf);
        this.updateModel();
    }

    public boolean isEmpty() {
        return this.openableToResults.isEmpty();
    }

    private void gotoButtonActionPerformed(ActionEvent evt) {
        this.gotoElement();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void gotoElement() {
        block4: {
            block3: {
                if (Main.getMainFrame().getPanel().checkEdited()) {
                    return;
                }
                if (this.openableToResults.size() <= 1) break block3;
                BasicTreeNode selection = (BasicTreeNode)this.resultsTree.getLastSelectedPathComponent();
                if (!(selection.getData() instanceof SearchResult)) break block4;
                for (SearchListener<SearchResult> searchListener : this.listeners) {
                    searchListener.updateSearchPos(this.text, this.ignoreCase, this.regExp, (SearchResult)selection.getData());
                }
                break block4;
            }
            for (SearchListener<SearchResult> searchListener : this.listeners) {
                searchListener.updateSearchPos(this.text, this.ignoreCase, this.regExp, this.resultsList.getSelectedValue());
            }
        }
    }

    private static class BasicTreeNode
    implements TreeNode {
        private final List<TreeNode> children = new ArrayList<TreeNode>();
        private TreeNode parent;
        private final Object data;

        public BasicTreeNode(Object data) {
            this.data = data;
        }

        public String toString() {
            return this.data.toString();
        }

        public Object getData() {
            return this.data;
        }

        public void addChild(TreeNode node) {
            this.children.add(node);
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.children.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        @Override
        public Enumeration<? extends TreeNode> children() {
            return Collections.enumeration(this.children);
        }
    }
}

