/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.PreviewPanel;
import com.jpexs.decompiler.flash.gui.TreeNodeType;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.FrameLabelTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SelectFramePositionDialog
extends AppDialog {
    private final JButton okButton = new JButton(this.translate("button.ok"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private JTree positionTree;
    private PreviewPanel previewPanel;
    private final SWF swf;
    private int result = -1;
    private int selectedFrame = -1;
    private Timelined selectedTimelined = null;
    private boolean selectNext;

    private void populateSprites(MyTreeNode root, Timelined tim) {
        for (Tag t : tim.getTags()) {
            if (!(t instanceof DefineSpriteTag)) continue;
            MyTreeNode node = new MyTreeNode();
            node.setData(t);
            root.addChild(node);
            this.populateSprites(root, (Timelined)((DefineSpriteTag)t));
            DefineSpriteTag sprite = (DefineSpriteTag)t;
            this.populateFrames(node, (Timelined)sprite);
        }
    }

    private void populateFrames(MyTreeNode parent, Timelined tim) {
        MyTreeNode frameNode = new MyTreeNode();
        ArrayList<String> labels = new ArrayList<String>();
        frameNode.setData(new MyFrame(1, labels));
        frameNode.setParent(parent);
        int f = 1;
        parent.addChild(frameNode);
        int numtags = 0;
        for (Tag t : tim.getTags()) {
            if (t instanceof FrameLabelTag) {
                labels.add(((FrameLabelTag)t).name);
            }
            ++numtags;
            if (!(t instanceof ShowFrameTag)) continue;
            frameNode = new MyTreeNode();
            labels = new ArrayList();
            frameNode.setData(new MyFrame(++f, labels));
            frameNode.setParent(parent);
            parent.addChild(frameNode);
            numtags = 0;
        }
        if (numtags == 0) {
            parent.children.remove(parent.children.size() - 1);
        }
        MyTimelineEnd end = new MyTimelineEnd();
        MyTreeNode endNode = new MyTreeNode();
        endNode.setData(end);
        parent.addChild(endNode);
    }

    private void populateNodes(MyTreeNode root, Timelined tim) {
        MyTreeNode spritesNode = new MyTreeNode();
        spritesNode.setData(new MySprites());
        root.addChild(spritesNode);
        this.populateSprites(spritesNode, tim);
        this.populateFrames(root, tim);
    }

    private void selectPath(List<Object> path) {
        Object[] pathArray = path.toArray(new Object[path.size()]);
        TreePath tpath = new TreePath(pathArray);
        this.positionTree.setSelectionPath(tpath);
        int row = this.positionTree.getRowForPath(tpath);
        if (row != -1) {
            Rectangle rect = this.positionTree.getRowBounds(row);
            rect.width += rect.x;
            rect.x = 0;
            this.positionTree.scrollRectToVisible(rect);
        }
    }

    private void selectCurrent(MyTreeNode root, Timelined timelined, List<Object> path) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            MyTreeNode node = (MyTreeNode)root.getChildAt(i);
            ArrayList<Object> subPath = new ArrayList<Object>(path);
            subPath.add(node);
            ArrayList<Object> nextPath = new ArrayList<Object>(path);
            if (i + 1 < root.getChildCount()) {
                nextPath.add(root.getChildAt(i + 1));
            }
            if (timelined == this.selectedTimelined && node.getData() instanceof MyFrame && ((MyFrame)node.getData()).frame == this.selectedFrame) {
                this.selectPath(this.selectNext ? nextPath : subPath);
                return;
            }
            if (timelined == this.selectedTimelined && node.getData() instanceof MyTimelineEnd && this.selectedFrame == -1) {
                this.selectPath(subPath);
                return;
            }
            if (node.getData() instanceof DefineSpriteTag) {
                this.selectCurrent(node, (Timelined)((DefineSpriteTag)node.getData()), subPath);
                continue;
            }
            this.selectCurrent(node, timelined, subPath);
        }
    }

    public SelectFramePositionDialog(Window parent, SWF swf) {
        this(parent, swf, -1, null, false);
    }

    public SelectFramePositionDialog(Window parent, SWF swf, int selectedFrame, Timelined selectedTimelined, boolean selectNext) {
        super(parent);
        this.swf = swf;
        this.selectedFrame = selectedFrame;
        this.selectedTimelined = selectedTimelined;
        this.selectNext = selectNext;
        this.setTitle(this.translate("dialog.title").replace("%filetitle%", swf.getShortPathTitle()));
        this.setDefaultCloseOperation(1);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        cnt.add((Component)buttonsPanel, "South");
        MyTreeNode root = new MyTreeNode();
        root.setData("root");
        this.populateNodes(root, (Timelined)swf);
        this.positionTree = new JTree(root){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int[] rows = this.getSelectionRows();
                if (rows.length == 1) {
                    int row = rows[0];
                    Object selection = this.getLastSelectedPathComponent();
                    if (selection != null && ((MyTreeNode)selection).getData() instanceof DefineSpriteTag || ((MyTreeNode)selection).getData() instanceof MySprites) {
                        return;
                    }
                    Rectangle rect = this.getRowBounds(row);
                    int sideWidth = 6;
                    int sideHeight = 6;
                    int offsetX = -5;
                    int lineStartX = offsetX + rect.x;
                    int backStartX = this.getWidth() + offsetX;
                    g.fillRect(lineStartX, rect.y, this.getWidth() - lineStartX, 1);
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setPaint(this.getForeground());
                    GeneralPath path = new GeneralPath();
                    path.moveTo(lineStartX - 6, rect.y + 6);
                    path.lineTo(lineStartX, rect.y);
                    path.lineTo(lineStartX + 6, rect.y + 6);
                    path.closePath();
                    g2d.fill(path);
                }
            }
        };
        if (View.isOceanic()) {
            this.positionTree.setBackground(Color.white);
            this.positionTree.setUI(new BasicTreeUI(){
                {
                    this.setHashColor(Color.gray);
                }
            });
        }
        this.positionTree.setCellRenderer(new PositionTreeCellRenderer());
        this.positionTree.setRootVisible(false);
        this.positionTree.setShowsRootHandles(true);
        this.positionTree.addTreeSelectionListener(this::spriteValueChanged);
        this.positionTree.addTreeSelectionListener(this::positionTreeValueChanged);
        this.positionTree.getSelectionModel().setSelectionMode(1);
        this.previewPanel = new PreviewPanel(Main.getMainFrame().getPanel());
        this.previewPanel.setReadOnly(true);
        this.previewPanel.setPreferredSize(new Dimension(300, 1));
        this.previewPanel.showEmpty();
        this.previewPanel.setParametersPanelVisible(false);
        FasterScrollPane positionTreeScrollPane = new FasterScrollPane(this.positionTree);
        JSplitPane splitPane = new JSplitPane(1, positionTreeScrollPane, this.previewPanel);
        splitPane.setDividerLocation(400);
        cnt.add((Component)splitPane, "Center");
        ArrayList<Object> path = new ArrayList<Object>();
        path.add(root);
        this.selectCurrent(root, (Timelined)swf, path);
        this.setSize(1024, 600);
        this.setModal(true);
        this.setResizable(true);
        View.centerScreen(this);
        View.setWindowIcon(this);
        this.calculateEnabled();
    }

    public void positionTreeValueChanged(TreeSelectionEvent e) {
        this.calculateEnabled();
    }

    private void calculateEnabled() {
        MyTreeNode node = (MyTreeNode)this.positionTree.getLastSelectedPathComponent();
        boolean enabled = node != null && (node.getData() instanceof MyFrame || node.getData() instanceof MyTimelineEnd);
        this.okButton.setEnabled(enabled);
    }

    private int getCurrentSelectedFrame() {
        TreePath path = this.positionTree.getSelectionPath();
        for (int i = path.getPathCount() - 1; i >= 0; --i) {
            MyTreeNode node = (MyTreeNode)path.getPathComponent(i);
            if (!(node.getData() instanceof MyFrame)) continue;
            MyFrame frame = (MyFrame)node.getData();
            return frame.frame;
        }
        return -1;
    }

    private Timelined getCurrentSelectedTimelined() {
        TreePath path = this.positionTree.getSelectionPath();
        for (int i = path.getPathCount() - 1 - 1; i >= 0; --i) {
            MyTreeNode node = (MyTreeNode)path.getPathComponent(i);
            if ("root".equals(node.getData())) {
                return this.swf;
            }
            if (!(node.getData() instanceof DefineSpriteTag)) continue;
            return (Timelined)node.getData();
        }
        return null;
    }

    private void spriteValueChanged(TreeSelectionEvent e) {
        TreePath selection = this.positionTree.getSelectionPath();
        if (selection == null) {
            this.previewPanel.showEmpty();
            return;
        }
        MyTreeNode tnode = (MyTreeNode)selection.getLastPathComponent();
        if (tnode.getData() instanceof Tag) {
            MainPanel.showPreview((TreeItem)tnode.getData(), this.previewPanel, this.getCurrentSelectedFrame() - 1, this.getCurrentSelectedTimelined());
        } else if (tnode.getData() instanceof MyFrame) {
            int f = ((MyFrame)tnode.getData()).frame;
            Object parent = ((MyTreeNode)tnode.getParent()).getData();
            if (parent instanceof DefineSpriteTag) {
                this.previewPanel.showImagePanel((Timelined)((DefineSpriteTag)parent), this.swf, f - 1, true, true, (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
            } else {
                this.previewPanel.showImagePanel((Timelined)this.swf, this.swf, f - 1, true, true, (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
            }
        } else {
            this.previewPanel.showEmpty();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.previewPanel.clear();
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.selectedTimelined = this.getCurrentSelectedTimelined();
        MyTreeNode node = (MyTreeNode)this.positionTree.getLastSelectedPathComponent();
        if (node.getData() instanceof MyFrame) {
            this.selectedFrame = ((MyFrame)node.getData()).frame;
        } else if (node.getData() instanceof MyTimelineEnd) {
            this.selectedFrame = this.selectedTimelined.getFrameCount() + 1;
        } else {
            return;
        }
        this.result = 0;
        this.previewPanel.clear();
        this.setVisible(false);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }

    public int getSelectedFrame() {
        return this.selectedFrame;
    }

    public Timelined getSelectedTimelined() {
        return this.selectedTimelined;
    }

    private static class PositionTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private boolean selected;

        public PositionTreeCellRenderer() {
            if (View.isOceanic()) {
                this.setUI(new BasicLabelUI());
                this.setOpaque(false);
                this.setBackgroundNonSelectionColor(Color.white);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component renderer = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.selected = sel;
            if (renderer instanceof JLabel) {
                JLabel lab = (JLabel)renderer;
                Object subValue = value;
                if (value instanceof MyTreeNode) {
                    subValue = ((MyTreeNode)value).getData();
                }
                if (subValue instanceof MyTimelineEnd) {
                    lab.setIcon(TagTree.getIconForType(TreeNodeType.END));
                }
                if (subValue instanceof MySprites) {
                    lab.setIcon(View.getIcon("foldersprites16"));
                }
                if (subValue instanceof MyFrame) {
                    lab.setIcon(TagTree.getIconForType(TreeNodeType.FRAME));
                }
                if (subValue instanceof TreeItem) {
                    lab.setIcon(TagTree.getIconForType(TagTree.getTreeNodeType((TreeItem)subValue)));
                }
            }
            return renderer;
        }
    }

    private static class MyFrame {
        private final int frame;
        private boolean invalid;
        private List<String> labels;

        public MyFrame(int frame, List<String> labels) {
            this.frame = frame;
            this.labels = labels;
        }

        public int getFrame() {
            return this.frame;
        }

        public void setInvalid(boolean invalid) {
            this.invalid = invalid;
        }

        public boolean isInvalid() {
            return this.invalid;
        }

        public String toString() {
            String name = "frame " + this.frame;
            if (!this.labels.isEmpty()) {
                name = name + " (" + String.join((CharSequence)", ", this.labels) + ")";
            }
            return name;
        }
    }

    private static class MySprites {
        private MySprites() {
        }

        public String toString() {
            return AppStrings.translate("node.sprites");
        }
    }

    private static class MyTimelineEnd {
        private MyTimelineEnd() {
        }

        public String toString() {
            return AppDialog.translateForDialog("timeline.end", SelectFramePositionDialog.class);
        }
    }

    private static class MyTreeNode
    implements TreeNode {
        private final List<TreeNode> children = new ArrayList<TreeNode>();
        private TreeNode parent;
        private Object data;

        private MyTreeNode() {
        }

        public String toString() {
            DoInitActionTag doinit;
            String exportName;
            if (this.data instanceof DoInitActionTag && (exportName = (doinit = (DoInitActionTag)this.data).getSwf().getExportName(doinit.spriteId)) != null && !exportName.isEmpty()) {
                return "DoInitAction (" + doinit.spriteId + ") : " + exportName;
            }
            return this.data.toString();
        }

        public void setData(Object data) {
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public void addChild(TreeNode node) {
            this.children.add(node);
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.children.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        @Override
        public Enumeration<? extends TreeNode> children() {
            return Collections.enumeration(this.children);
        }
    }
}

