/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SnappingDialog
extends AppDialog {
    private final JCheckBox snapAlignCheckBox;
    private final JCheckBox snapToGridCheckBox;
    private final JCheckBox snapToGuidesCheckBox;
    private final JCheckBox snapToPixelsCheckBox;
    private final JCheckBox snapToObjectsCheckBox;
    private final JTextField stageBorderTextField;
    private final JTextField objectHorizontalSpacingTextField;
    private final JTextField objectVerticalSpacingTextField;
    private final JCheckBox centerAlignmentHorizontalCheckBox;
    private final JCheckBox centerAlignmentVerticalCheckBox;

    public SnappingDialog(Window owner) {
        super(owner);
        this.setSize(800, 600);
        this.setTitle(this.translate("dialog.title"));
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel snapPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        this.snapAlignCheckBox = new JCheckBox(this.translate("snapAlign"));
        this.snapAlignCheckBox.setSelected((Boolean)Configuration.snapAlign.get());
        snapPanel.add((Component)this.snapAlignCheckBox, c);
        this.snapToGridCheckBox = new JCheckBox(this.translate("snapToGrid"));
        this.snapToGridCheckBox.setSelected((Boolean)Configuration.snapToGrid.get());
        ++c.gridy;
        snapPanel.add((Component)this.snapToGridCheckBox, c);
        this.snapToGuidesCheckBox = new JCheckBox(this.translate("snapToGuides"));
        this.snapToGuidesCheckBox.setSelected((Boolean)Configuration.snapToGuides.get());
        ++c.gridy;
        snapPanel.add((Component)this.snapToGuidesCheckBox, c);
        this.snapToPixelsCheckBox = new JCheckBox(this.translate("snapToPixels"));
        this.snapToPixelsCheckBox.setSelected((Boolean)Configuration.snapToPixels.get());
        ++c.gridy;
        snapPanel.add((Component)this.snapToPixelsCheckBox, c);
        this.snapToObjectsCheckBox = new JCheckBox(this.translate("snapToObjects"));
        this.snapToObjectsCheckBox.setSelected((Boolean)Configuration.snapToObjects.get());
        ++c.gridy;
        snapPanel.add((Component)this.snapToObjectsCheckBox, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 5;
        c.fill = 2;
        c.weightx = 1.0;
        snapPanel.add((Component)new JPanel(), c);
        JPanel centralPanel = new JPanel();
        centralPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        centralPanel.setLayout(new BoxLayout(centralPanel, 1));
        centralPanel.add(snapPanel);
        centralPanel.add(Box.createVerticalStrut(10));
        JPanel snapAlignPanel = new JPanel(new GridBagLayout());
        snapAlignPanel.setBorder(BorderFactory.createTitledBorder(this.translate("snapAlign.settings")));
        c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        JLabel objectSpacingLabel = new JLabel(this.translate("snapAlign.objectSpacing"));
        JLabel objectHorizontalSpacingLabel = new JLabel(this.translate("snapAlign.objectSpacing.horizontal"));
        JLabel objectVerticalSpacingLabel = new JLabel(this.translate("snapAlign.objectSpacing.vertical"));
        JLabel centerAlignmentLabel = new JLabel(this.translate("snapAlign.centerAlignment"));
        JLabel stageBorderLabel = new JLabel(this.translate("snapAlign.stageBorder"));
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 22;
        snapAlignPanel.add((Component)stageBorderLabel, c);
        this.stageBorderTextField = new JTextField(10);
        stageBorderLabel.setLabelFor(this.stageBorderTextField);
        this.stageBorderTextField.setText("" + Configuration.snapAlignStageBorder.get());
        ++c.gridx;
        c.anchor = 21;
        snapAlignPanel.add((Component)this.stageBorderTextField, c);
        c.gridx = 0;
        ++c.gridy;
        snapAlignPanel.add((Component)objectSpacingLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 22;
        snapAlignPanel.add((Component)objectHorizontalSpacingLabel, c);
        this.objectHorizontalSpacingTextField = new JTextField(10);
        objectHorizontalSpacingLabel.setLabelFor(this.objectHorizontalSpacingTextField);
        this.objectHorizontalSpacingTextField.setText("" + Configuration.snapAlignObjectHorizontalSpace.get());
        ++c.gridx;
        c.anchor = 21;
        snapAlignPanel.add((Component)this.objectHorizontalSpacingTextField, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 22;
        snapAlignPanel.add((Component)objectVerticalSpacingLabel, c);
        this.objectVerticalSpacingTextField = new JTextField(10);
        objectVerticalSpacingLabel.setLabelFor(this.objectVerticalSpacingTextField);
        this.objectVerticalSpacingTextField.setText("" + Configuration.snapAlignObjectVerticalSpace.get());
        ++c.gridx;
        c.anchor = 21;
        snapAlignPanel.add((Component)this.objectVerticalSpacingTextField, c);
        c.anchor = 21;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        snapAlignPanel.add((Component)centerAlignmentLabel, c);
        this.centerAlignmentHorizontalCheckBox = new JCheckBox(this.translate("snapAlign.centerAlignment.horizontal"));
        this.centerAlignmentHorizontalCheckBox.setSelected((Boolean)Configuration.snapAlignCenterAlignmentHorizontal.get());
        ++c.gridy;
        snapAlignPanel.add((Component)this.centerAlignmentHorizontalCheckBox, c);
        this.centerAlignmentVerticalCheckBox = new JCheckBox(this.translate("snapAlign.centerAlignment.vertical"));
        this.centerAlignmentVerticalCheckBox.setSelected((Boolean)Configuration.snapAlignCenterAlignmentVertical.get());
        ++c.gridy;
        snapAlignPanel.add((Component)this.centerAlignmentVerticalCheckBox, c);
        centralPanel.add(snapAlignPanel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 1));
        JButton okButton = new JButton(this.translate("button.ok"));
        okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(okButton);
        buttonsPanel.add(Box.createVerticalStrut(5));
        buttonsPanel.add(cancelButton);
        cnt.add((Component)centralPanel, "Center");
        cnt.add((Component)buttonsPanel, "East");
        this.pack();
        View.setWindowIcon16(this, "snap");
        View.centerScreen(this);
        this.setModal(true);
        this.setResizable(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int stageBorder;
        int spacingY;
        int spacingX;
        try {
            spacingX = Integer.parseInt(this.objectHorizontalSpacingTextField.getText());
        }
        catch (NumberFormatException nfe) {
            ViewMessages.showMessageDialog(this, this.translate("error.invalidSpacing"), AppStrings.translate("error"), 0);
            this.objectHorizontalSpacingTextField.requestFocus();
            return;
        }
        try {
            spacingY = Integer.parseInt(this.objectVerticalSpacingTextField.getText());
        }
        catch (NumberFormatException nfe) {
            ViewMessages.showMessageDialog(this, this.translate("error.invalidSpacing"), AppStrings.translate("error"), 0);
            this.objectVerticalSpacingTextField.requestFocus();
            return;
        }
        try {
            stageBorder = Integer.parseInt(this.stageBorderTextField.getText());
        }
        catch (NumberFormatException nfe) {
            ViewMessages.showMessageDialog(this, this.translate("error.invalidBorder"), AppStrings.translate("error"), 0);
            this.stageBorderTextField.requestFocus();
            return;
        }
        Configuration.snapAlign.set((Object)this.snapAlignCheckBox.isSelected());
        Configuration.snapToGrid.set((Object)this.snapToGridCheckBox.isSelected());
        Configuration.snapToGuides.set((Object)this.snapToGuidesCheckBox.isSelected());
        Configuration.snapToPixels.set((Object)this.snapToPixelsCheckBox.isSelected());
        Configuration.snapToObjects.set((Object)this.snapToObjectsCheckBox.isSelected());
        Configuration.snapAlignObjectHorizontalSpace.set((Object)spacingX);
        Configuration.snapAlignObjectVerticalSpace.set((Object)spacingY);
        Configuration.snapAlignStageBorder.set((Object)stageBorder);
        Configuration.snapAlignCenterAlignmentHorizontal.set((Object)this.centerAlignmentHorizontalCheckBox.isSelected());
        Configuration.snapAlignCenterAlignmentVertical.set((Object)this.centerAlignmentVerticalCheckBox.isSelected());
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

