/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.gui.PreviewPanel;
import com.jpexs.decompiler.flash.tags.DefineBitsTag;
import com.jpexs.decompiler.flash.tags.DefineShape2Tag;
import com.jpexs.decompiler.flash.tags.EndTag;
import com.jpexs.decompiler.flash.tags.JPEGTablesTag;
import com.jpexs.decompiler.flash.tags.PlaceObjectTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalImage2;
import com.jpexs.decompiler.flash.tags.gfx.DefineSubImage;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class TimelinedMaker {
    public static SWF makeTimelinedImage(ImageTag imageTag) {
        SWF swf = new SWF();
        swf.gfx = imageTag.getSwf().gfx;
        swf.version = imageTag.getSwf().version;
        int w = (int)(imageTag.getImageDimension().getWidth() * 20.0);
        int h = (int)(imageTag.getImageDimension().getHeight() * 20.0);
        swf.displayRect = new RECT(0, w, 0, h);
        swf.frameCount = 1;
        swf.frameRate = 1.0f;
        swf.setFile(imageTag.getSwf().getFile());
        try {
            int shapeCharId;
            DefineExternalImage2 dei2;
            JPEGTablesTag jpegTablesTag = null;
            if (imageTag instanceof DefineBitsTag) {
                jpegTablesTag = imageTag.getSwf().getJtt();
            }
            LinkedHashSet needed = new LinkedHashSet();
            LinkedHashSet neededClasses = new LinkedHashSet();
            imageTag.getNeededCharacters(needed, neededClasses, swf);
            ArrayList<Object> neededCopies = new ArrayList<Object>();
            Iterator iterator = needed.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                CharacterTag ct = imageTag.getSwf().getCharacter(n);
                if (ct == null) continue;
                ct = (CharacterTag)ct.cloneTag();
                ct.setSwf(swf);
                neededCopies.add(ct);
            }
            if (imageTag instanceof DefineSubImage && (dei2 = imageTag.getSwf().getExternalImage2(((DefineSubImage)imageTag).imageId)) != null) {
                dei2 = (DefineExternalImage2)dei2.cloneTag();
                dei2.setSwf(swf);
                neededCopies.add(dei2);
            }
            ImageTag imageTagCopy = (ImageTag)imageTag.cloneTag();
            imageTagCopy.setSwf(swf);
            int imageCharId = imageTag.getCharacterId();
            if (imageTag instanceof DefineExternalImage2 && ((DefineExternalImage2)imageTag).idType != 0) {
                imageTagCopy.characterID = imageCharId = swf.getNextCharacterId();
            }
            DefineShape2Tag shapeTag = new DefineShape2Tag(swf);
            shapeTag.shapeId = shapeCharId = imageCharId + 1;
            shapeTag.shapeBounds = new RECT(swf.displayRect);
            SHAPEWITHSTYLE shapeData = new SHAPEWITHSTYLE();
            FILLSTYLEARRAY fillStyleArray = new FILLSTYLEARRAY();
            FILLSTYLE[] fillStyles = new FILLSTYLE[1];
            FILLSTYLE fillStyle = new FILLSTYLE();
            fillStyle.bitmapId = imageCharId;
            fillStyle.inShape3 = false;
            fillStyle.fillStyleType = 65;
            fillStyle.bitmapMatrix = Matrix.getScaleInstance((double)20.0).toMATRIX();
            fillStyles[0] = fillStyle;
            fillStyleArray.fillStyles = fillStyles;
            shapeData.fillStyles = fillStyleArray;
            shapeData.lineStyles = new LINESTYLEARRAY();
            ArrayList<Object> shapeRecords = new ArrayList<Object>();
            StyleChangeRecord scr = new StyleChangeRecord();
            scr.stateFillStyle0 = true;
            scr.fillStyle0 = 1;
            shapeRecords.add(scr);
            StyleChangeRecord scr2 = new StyleChangeRecord();
            scr2.stateMoveTo = true;
            scr2.moveDeltaX = 0;
            scr2.moveDeltaY = 0;
            scr2.calculateBits();
            shapeRecords.add(scr2);
            StraightEdgeRecord ser1 = new StraightEdgeRecord();
            ser1.vertLineFlag = true;
            ser1.deltaY = h;
            ser1.calculateBits();
            shapeRecords.add(ser1);
            StraightEdgeRecord ser2 = new StraightEdgeRecord();
            ser2.deltaX = w;
            shapeRecords.add(ser2);
            StraightEdgeRecord ser3 = new StraightEdgeRecord();
            ser3.vertLineFlag = true;
            ser3.deltaY = -h;
            shapeRecords.add(ser3);
            StraightEdgeRecord ser4 = new StraightEdgeRecord();
            ser4.deltaX = -w;
            shapeRecords.add(ser4);
            shapeRecords.add(new EndShapeRecord());
            shapeData.shapeRecords = shapeRecords;
            shapeData.numFillBits = 1;
            shapeData.numLineBits = 0;
            shapeTag.shapes = shapeData;
            PlaceObjectTag placeTag = new PlaceObjectTag(swf, shapeCharId, 1, new Matrix().toMATRIX(), null);
            ShowFrameTag showFrameTag = new ShowFrameTag(swf);
            EndTag endTag = new EndTag(swf);
            if (jpegTablesTag != null) {
                swf.addTag((Tag)jpegTablesTag);
            }
            for (CharacterTag characterTag : neededCopies) {
                swf.addTag((Tag)characterTag);
            }
            swf.addTag((Tag)imageTagCopy);
            swf.addTag((Tag)shapeTag);
            swf.addTag((Tag)placeTag);
            swf.addTag((Tag)showFrameTag);
            swf.addTag((Tag)endTag);
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return swf;
    }

    public static Timelined makeTimelined(Tag tag) {
        if (tag instanceof ImageTag) {
            return TimelinedMaker.makeTimelinedImage((ImageTag)tag);
        }
        return TimelinedMaker.makeTimelined(tag, -1);
    }

    public static Timelined makeTimelined(final Tag tag, final int fontFrameNum) {
        int chId = ((CharacterIdTag)tag).getCharacterId();
        if (chId == -1) {
            chId = 0;
        }
        final int fChId = chId;
        return new Timelined(){
            private Timeline tim;

            public Timeline getTimeline() {
                if (this.tim == null) {
                    Timeline timeline = new Timeline(tag.getSwf(), (Timelined)this, fChId, this.getRect(), this.getFilterDimensions());
                    this.initTimeline(timeline);
                    this.tim = timeline;
                }
                return this.tim;
            }

            public void resetTimeline() {
                if (this.tim != null) {
                    this.tim.reset(tag.getSwf(), (Timelined)this, ((CharacterTag)tag).getCharacterId(), this.getRect());
                    this.initTimeline(this.tim);
                }
            }

            private void initTimeline(Timeline timeline) {
                if (tag instanceof MorphShapeTag) {
                    timeline.frameRate = 30.0f;
                    int framesCnt = (int)((double)timeline.frameRate * 2.0);
                    for (int i = 0; i < framesCnt; ++i) {
                        Frame f = new Frame(timeline, i);
                        DepthState ds = new DepthState(tag.getSwf(), f, f);
                        ds.characterId = fChId;
                        ds.matrix = new MATRIX();
                        ds.ratio = i * 65535 / framesCnt;
                        f.layers.put(1, ds);
                        f.layersChanged = true;
                        timeline.addFrame(f);
                    }
                    Frame f = new Frame(timeline, framesCnt);
                    DepthState ds = new DepthState(tag.getSwf(), f, f);
                    ds.depth = 1;
                    ds.characterId = fChId;
                    ds.matrix = new MATRIX();
                    ds.ratio = 65535;
                    f.layers.put(1, ds);
                    f.layersChanged = true;
                    timeline.addFrame(f);
                } else if (tag instanceof FontTag) {
                    int pageCount = PreviewPanel.getFontPageCount((FontTag)tag);
                    int frame = fontFrameNum;
                    if (frame < 0 || frame >= pageCount) {
                        frame = 0;
                    }
                    Frame f = new Frame(timeline, 0);
                    DepthState ds = new DepthState(tag.getSwf(), f, f);
                    ds.depth = 1;
                    ds.characterId = fChId;
                    ds.matrix = new MATRIX();
                    f.layers.put(1, ds);
                    f.layersChanged = true;
                    timeline.addFrame(f);
                    timeline.fontFrameNum = frame;
                } else if (!(tag instanceof SoundTag)) {
                    Frame f = new Frame(timeline, 0);
                    DepthState ds = new DepthState(tag.getSwf(), f, f);
                    ds.depth = 1;
                    ds.characterId = fChId;
                    ds.matrix = new MATRIX();
                    f.layers.put(1, ds);
                    timeline.addFrame(f);
                }
                timeline.displayRect = this.getRect();
            }

            public RECT getRect() {
                return this.getRect(new HashSet<BoundedTag>());
            }

            public RECT getRect(Set<BoundedTag> added) {
                if (!(tag instanceof BoundedTag)) {
                    return new RECT(0, 1, 0, 1);
                }
                BoundedTag bt = (BoundedTag)tag;
                if (!added.contains(bt)) {
                    return bt.getRect(added);
                }
                return new RECT(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE);
            }

            public int hashCode() {
                return tag.hashCode();
            }

            public void setModified(boolean value) {
            }

            public boolean isModified() {
                return false;
            }

            public ReadOnlyTagList getTags() {
                return ReadOnlyTagList.EMPTY;
            }

            public void removeTag(int index) {
            }

            public void removeTag(Tag tag2) {
            }

            public void addTag(Tag tag2) {
            }

            public void addTag(int index, Tag tag2) {
            }

            public void replaceTag(int index, Tag newTag) {
            }

            public void replaceTag(Tag oldTag, Tag newTag) {
            }

            public int indexOfTag(Tag tag2) {
                return -1;
            }

            public RECT getRectWithStrokes() {
                return this.getRect();
            }

            public void setFrameCount(int frameCount) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int getFrameCount() {
                return this.getTimeline().getFrameCount();
            }

            public SWF getSwf() {
                return tag.getSwf();
            }

            public Dimension getFilterDimensions() {
                return new Dimension(0, 0);
            }

            public RECT getRectWithFilters() {
                return this.getRect();
            }
        };
    }
}

