/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.colordialog.MyColorChooserDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ViewMessages {
    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        int[] ret = new int[1];
        View.execInEventDispatch(() -> {
            ret[0] = JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue);
        });
        return ret[0];
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        return ViewMessages.showConfirmDialog(parentComponent, message, title, optionType, -1);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageTyp) {
        int[] ret = new int[1];
        View.execInEventDispatch(() -> {
            ret[0] = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageTyp);
        });
        return ret[0];
    }

    public static int showConfirmDialog(Component parentComponent, String message, String title, int optionType, ConfigurationItem<Boolean> showAgainConfig, int defaultOption) {
        return ViewMessages.showConfirmDialog(parentComponent, message, title, optionType, -1, showAgainConfig, defaultOption);
    }

    public static int showConfirmDialog(Component parentComponent, String message, String title, int optionType, int messageType, ConfigurationItem<Boolean> showAgainConfig, int defaultOption) {
        AbstractButton donotShowAgainCheckBox = null;
        JPanel warPanel = null;
        if (showAgainConfig != null) {
            if (!((Boolean)showAgainConfig.get()).booleanValue()) {
                return defaultOption;
            }
            JLabel warLabel = new JLabel("<html>" + message.replace("\r\n", "<br>") + "</html>");
            warPanel = new JPanel(new BorderLayout());
            warPanel.add((Component)warLabel, "Center");
            donotShowAgainCheckBox = new JCheckBox(AppStrings.translate("message.confirm.donotshowagain"));
            warPanel.add((Component)donotShowAgainCheckBox, "South");
        }
        int[] ret = new int[1];
        String messageObj = warPanel == null ? message : warPanel;
        View.execInEventDispatch(() -> {
            ret[0] = JOptionPane.showConfirmDialog(parentComponent, messageObj, title, optionType, messageType);
        });
        if (donotShowAgainCheckBox != null) {
            showAgainConfig.set((Object)(!donotShowAgainCheckBox.isSelected() ? 1 : 0));
        }
        return ret[0];
    }

    public static void showMessageDialog(Component parentComponent, String message, String title, int messageType) {
        ViewMessages.showMessageDialog(parentComponent, message, title, messageType, null);
    }

    public static void showMessageDialog(Component parentComponent, String message, String title, int messageType, ConfigurationItem<Boolean> showAgainConfig) {
        View.execInEventDispatch(() -> {
            Object msg = message;
            AbstractButton donotShowAgainCheckBox = null;
            if (showAgainConfig != null) {
                if (!((Boolean)showAgainConfig.get()).booleanValue()) {
                    return;
                }
                JLabel warLabel = new JLabel("<html><center>" + message.replace("\r\n", "<br>") + "</center></html>");
                JPanel warPanel = new JPanel(new BorderLayout());
                warPanel.add((Component)warLabel, "Center");
                donotShowAgainCheckBox = new JCheckBox(AppStrings.translate("message.confirm.donotshowagain"));
                warPanel.add((Component)donotShowAgainCheckBox, "South");
                msg = warPanel;
            }
            String fmsg = msg;
            JOptionPane.showMessageDialog(parentComponent, fmsg, title, messageType);
            if (donotShowAgainCheckBox != null) {
                showAgainConfig.set((Object)(!donotShowAgainCheckBox.isSelected() ? 1 : 0));
            }
        });
    }

    public static void showMessageDialog(Component parentComponent, Object message) {
        View.execInEventDispatch(() -> JOptionPane.showMessageDialog(parentComponent, message));
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelection) {
        String[] ret = new String[1];
        View.execInEventDispatch(() -> {
            ret[0] = JOptionPane.showInputDialog(parentComponent, message, initialSelection);
        });
        return ret[0];
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, Object initialSelection) {
        String[] ret = new String[1];
        View.execInEventDispatch(() -> {
            ret[0] = (String)JOptionPane.showInputDialog(parentComponent, message, title, 3, null, null, initialSelection);
        });
        return ret[0];
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, Icon icon, Object initialSelection) {
        String[] ret = new String[1];
        View.execInEventDispatch(() -> {
            ret[0] = (String)JOptionPane.showInputDialog(parentComponent, message, title, 3, icon, null, initialSelection);
        });
        return ret[0];
    }

    public static Color showColorDialog(Component parentComponent, Color initialColor, boolean withTransparency) {
        MyColorChooserDialog colorDialog = new MyColorChooserDialog(parentComponent, initialColor, withTransparency);
        colorDialog.setVisible(true);
        return colorDialog.getColor();
    }
}

