/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.SelectTagOfTypeDialog;
import com.jpexs.decompiler.flash.gui.SelectTagPositionDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.Openable;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddClassDialog
extends AppDialog {
    private final JButton proceedButton = new JButton(this.translate("button.proceed"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private final JTextField classNameTextField = new JTextField(30);
    private String selectedClass = null;
    private ABCContainerTag selectedAbcContainer;
    private Tag selectedPosition;
    private Timelined selectedTimelined;
    private int result = -1;
    private Openable openable;
    private int abcCount = 0;
    private ABCContainerTag preselectedAbcContainer;
    private JRadioButton existingAbcTagRadioButton = new JRadioButton(this.translate("abc.where.existing"));
    private JRadioButton newAbcTagRadioButton = new JRadioButton(this.translate("abc.where.new"));

    public AddClassDialog(Window owner, Openable openable, ABCContainerTag abcContainer) {
        super(owner);
        this.openable = openable;
        this.abcCount = 0;
        this.preselectedAbcContainer = abcContainer;
        if (abcContainer != null) {
            this.abcCount = 1;
        } else if (openable instanceof SWF) {
            SWF swf = (SWF)openable;
            for (Tag t : swf.getTags()) {
                if (!(t instanceof ABCContainerTag)) continue;
                ++this.abcCount;
            }
        } else {
            this.abcCount = 1;
        }
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title"));
        Container cnt = this.getContentPane();
        cnt.setLayout(new BoxLayout(cnt, 1));
        JPanel abcTargetPanel = new JPanel();
        abcTargetPanel.setLayout(new BoxLayout(abcTargetPanel, 1));
        abcTargetPanel.add(new JLabel(this.translate("abc.where")));
        this.existingAbcTagRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AddClassDialog.this.checkEnabled();
            }
        });
        this.newAbcTagRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AddClassDialog.this.checkEnabled();
            }
        });
        ButtonGroup abcTargetButtonGroup = new ButtonGroup();
        abcTargetButtonGroup.add(this.existingAbcTagRadioButton);
        abcTargetButtonGroup.add(this.newAbcTagRadioButton);
        this.existingAbcTagRadioButton.setSelected(true);
        abcTargetPanel.add(this.existingAbcTagRadioButton);
        abcTargetPanel.add(this.newAbcTagRadioButton);
        if (this.abcCount == 0) {
            this.newAbcTagRadioButton.setSelected(true);
            abcTargetPanel.setVisible(false);
        }
        if (this.preselectedAbcContainer != null) {
            this.existingAbcTagRadioButton.setSelected(true);
            abcTargetPanel.setVisible(false);
        }
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.proceedButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(this.proceedButton);
        buttonsPanel.add(this.cancelButton);
        JLabel classNameLabel = new JLabel(this.translate("classname"));
        classNameLabel.setAlignmentX(0.0f);
        cnt.add(classNameLabel);
        cnt.add(this.classNameTextField);
        cnt.add(abcTargetPanel);
        cnt.add(buttonsPanel);
        this.classNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddClassDialog.this.checkEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddClassDialog.this.checkEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddClassDialog.this.checkEnabled();
            }
        });
        this.classNameTextField.addActionListener(this::okButtonActionPerformed);
        this.pack();
        this.setModal(true);
        this.setResizable(false);
        View.setWindowIcon(this);
        View.centerScreen(this);
        this.checkEnabled();
    }

    private void checkEnabled() {
        if (this.existingAbcTagRadioButton.isSelected() && this.abcCount == 1) {
            this.proceedButton.setText(this.translate("button.ok"));
        } else {
            this.proceedButton.setText(this.translate("button.proceed"));
        }
        boolean ok = true;
        if (this.classNameTextField.getText().isEmpty()) {
            ok = false;
        }
        if (this.classNameTextField.getText().endsWith(".")) {
            ok = false;
        }
        if (ok) {
            List scriptPacks;
            if (this.openable instanceof SWF) {
                SWF swf = (SWF)this.openable;
                ArrayList<String> classNames = new ArrayList<String>();
                classNames.add(this.classNameTextField.getText());
                try {
                    scriptPacks = swf.getScriptPacksByClassNames(classNames);
                    if (!scriptPacks.isEmpty()) {
                        ok = false;
                    }
                }
                catch (Exception ex) {
                    ok = false;
                }
            }
            if (this.openable instanceof ABC) {
                ABC abc = (ABC)this.openable;
                ArrayList<ABC> allAbcs = new ArrayList<ABC>();
                allAbcs.add(abc);
                try {
                    scriptPacks = abc.findScriptPacksByPath(this.classNameTextField.getText(), allAbcs);
                    if (!scriptPacks.isEmpty()) {
                        ok = false;
                    }
                }
                catch (Exception ex) {
                    ok = false;
                }
            }
        }
        this.proceedButton.setEnabled(ok);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!this.proceedButton.isEnabled()) {
            return;
        }
        this.setVisible(false);
        if (this.preselectedAbcContainer != null) {
            this.selectedAbcContainer = this.preselectedAbcContainer;
        } else {
            if (this.existingAbcTagRadioButton.isSelected()) {
                SelectTagOfTypeDialog selectDoABCDialog = new SelectTagOfTypeDialog(this.owner, (SWF)this.openable, ABCContainerTag.class, "DoABC", 1);
                this.selectedAbcContainer = (ABCContainerTag)selectDoABCDialog.showDialog();
                if (this.selectedAbcContainer == null) {
                    this.cancelButtonActionPerformed(evt);
                    return;
                }
            }
            if (this.newAbcTagRadioButton.isSelected()) {
                SelectTagPositionDialog selectTagPositionDialog = new SelectTagPositionDialog(this.owner, (SWF)this.openable, true);
                if (selectTagPositionDialog.showDialog() != 0) {
                    this.cancelButtonActionPerformed(evt);
                    return;
                }
                this.selectedPosition = selectTagPositionDialog.getSelectedTag();
                this.selectedTimelined = selectTagPositionDialog.getSelectedTimelined();
            }
        }
        this.result = 0;
        this.selectedClass = this.classNameTextField.getText();
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.selectedClass = null;
        this.selectedAbcContainer = null;
        this.selectedPosition = null;
        this.selectedTimelined = null;
        this.result = 1;
        this.setVisible(false);
    }

    public int showDialog() {
        return this.showDialog("");
    }

    public int showDialog(String pkg) {
        this.classNameTextField.setText(pkg);
        this.selectedClass = null;
        this.selectedAbcContainer = null;
        this.selectedPosition = null;
        this.selectedTimelined = null;
        this.setVisible(true);
        return this.result;
    }

    public Tag getSelectedPosition() {
        return this.selectedPosition;
    }

    public String getSelectedClass() {
        return this.selectedClass;
    }

    public Timelined getSelectedTimelined() {
        return this.selectedTimelined;
    }

    public ABCContainerTag getSelectedAbcContainer() {
        return this.selectedAbcContainer;
    }
}

