/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class ConstantsListModel
implements ListModel {
    private final AVM2ConstantPool constants;
    public static final int TYPE_UINT = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_DECIMAL = 3;
    public static final int TYPE_STRING = 4;
    public static final int TYPE_NAMESPACE = 5;
    public static final int TYPE_NAMESPACESET = 6;
    public static final int TYPE_MULTINAME = 7;
    private int type = 1;

    public ConstantsListModel(AVM2ConstantPool constants, int type) {
        this.type = type;
        this.constants = constants;
    }

    private int makeUp(int i) {
        if (i < 0) {
            return 0;
        }
        return i;
    }

    @Override
    public int getSize() {
        switch (this.type) {
            case 0: {
                return this.makeUp(this.constants.getUIntCount() - 1);
            }
            case 1: {
                return this.makeUp(this.constants.getIntCount() - 1);
            }
            case 2: {
                return this.makeUp(this.constants.getDoubleCount() - 1);
            }
            case 3: {
                return this.makeUp(this.constants.getDecimalCount() - 1);
            }
            case 4: {
                return this.makeUp(this.constants.getStringCount() - 1);
            }
            case 5: {
                return this.makeUp(this.constants.getNamespaceCount() - 1);
            }
            case 6: {
                return this.makeUp(this.constants.getNamespaceSetCount() - 1);
            }
            case 7: {
                return this.makeUp(this.constants.getMultinameCount() - 1);
            }
        }
        return 0;
    }

    public Object getElementAt(int index) {
        switch (this.type) {
            case 0: {
                return index + 1 + ":" + this.constants.getUInt(index + 1);
            }
            case 1: {
                return index + 1 + ":" + this.constants.getInt(index + 1);
            }
            case 2: {
                return index + 1 + ":" + this.constants.getDouble(index + 1);
            }
            case 3: {
                return index + 1 + ":" + this.constants.getDecimal(index + 1);
            }
            case 4: {
                return index + 1 + ":" + Helper.escapePCodeString((String)this.constants.getString(index + 1));
            }
            case 5: {
                return index + 1 + ":" + this.constants.getNamespace(index + 1).getNameWithKind(this.constants);
            }
            case 6: {
                return index + 1 + ":" + this.constants.getNamespaceSet(index + 1).toString(this.constants);
            }
            case 7: {
                return index + 1 + ":" + this.constants.getMultiname(index + 1).toString(this.constants, new ArrayList());
            }
        }
        return null;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }
}

