/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.colordialog;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.colordialog.MySwatchPanel;
import com.jpexs.decompiler.flash.types.RGBA;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;

class MyRecentSwatchPanel
extends MySwatchPanel {
    MyRecentSwatchPanel() {
    }

    @Override
    protected void initValues() {
        this.swatchSize = UIManager.getDimension("ColorChooser.swatchesRecentSwatchSize", this.getLocale());
        this.numSwatches = new Dimension(5, 7);
        this.gap = new Dimension(1, 1);
    }

    @Override
    protected void initColors() {
        Color defaultRecentColor = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor", this.getLocale());
        int numColors = this.numSwatches.width * this.numSwatches.height;
        this.colors = new Color[numColors];
        String recentColorsStr = (String)Configuration.recentColors.get();
        for (int i = 0; i < numColors; ++i) {
            this.colors[i] = defaultRecentColor;
        }
        Pattern hexColorPattern = Pattern.compile("^#(?<a>[a-fA-F0-9]{2})(?<r>[a-fA-F0-9]{2})(?<g>[a-fA-F0-9]{2})(?<b>[a-fA-F0-9]{2})$");
        if (!recentColorsStr.isEmpty()) {
            String[] colorsHex = recentColorsStr.split(",", -1);
            for (int i = 0; i < colorsHex.length; ++i) {
                Matcher m = hexColorPattern.matcher(colorsHex[i]);
                if (!m.matches()) continue;
                this.colors[i] = new Color(Integer.parseInt(m.group("r"), 16), Integer.parseInt(m.group("g"), 16), Integer.parseInt(m.group("b"), 16), Integer.parseInt(m.group("a"), 16));
            }
        }
    }

    public void setMostRecentColor(Color c) {
        if (this.colors[0].equals(c)) {
            return;
        }
        System.arraycopy(this.colors, 0, this.colors, 1, this.colors.length - 1);
        this.colors[0] = c;
        ArrayList<String> colorsAsStr = new ArrayList<String>();
        for (int i = 0; i < this.colors.length; ++i) {
            colorsAsStr.add(new RGBA(this.colors[i]).toHexARGB());
        }
        Configuration.recentColors.set((Object)String.join((CharSequence)",", colorsAsStr));
        this.repaint();
    }
}

