/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.debugger;

import com.jpexs.decompiler.flash.gui.debugger.DebugListener;
import com.jpexs.decompiler.flash.gui.debugger.DebugLoaderDataModified;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debugger {
    public static final int MSG_STRING = 0;
    public static final int MSG_LOADER_URL = 1;
    public static final int MSG_LOADER_BYTES = 2;
    public static final int MSG_DUMP_BYTEARRAY = 3;
    public static final int MSG_REQUEST_BYTEARRAY = 4;
    public static final int MSG_LOADER_URL_INFO = 5;
    public static final int MSG_LOADER_MODIFY_BYTES = 6;
    private static final Set<DebugListener> listeners = new HashSet<DebugListener>();
    private static Logger logger = Logger.getLogger(Debugger.class.getName());
    private static boolean active = false;
    private final int port;
    private DebugServerThread server = null;

    public static boolean isActive() {
        return active;
    }

    public synchronized void addMessageListener(DebugListener l) {
        listeners.add(l);
    }

    public synchronized void removeMessageListener(DebugListener l) {
        listeners.remove(l);
    }

    public Debugger(int port) {
        this.port = port;
    }

    public synchronized void start() {
        if (this.server == null) {
            this.server = new DebugServerThread(this.port);
            this.server.start();
        }
    }

    public synchronized boolean isRunning() {
        return this.server != null;
    }

    public int getPort() {
        return this.port;
    }

    public synchronized void stop() {
        if (this.server != null) {
            try {
                this.server.ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (DebugHandler h : this.server.handlers.values()) {
                h.cancel();
            }
            this.server.handlers.clear();
            this.server = null;
        }
    }

    private static class DebugServerThread
    extends Thread {
        private final int port;
        private ServerSocket ss;
        private final Map<Integer, DebugHandler> handlers = new WeakHashMap<Integer, DebugHandler>();

        public DebugServerThread(int port) {
            this.port = port;
        }

        @Override
        public void run() {
            try {
                this.ss = new ServerSocket(this.port, 50, InetAddress.getByName("localhost"));
                this.ss.setReuseAddress(true);
                while (true) {
                    Socket s = this.ss.accept();
                    DebugHandler h = new DebugHandler(this.port, s);
                    this.handlers.put(h.id, h);
                    h.start();
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private static class DebugHandler
    extends Thread {
        private final Socket s;
        private final int serverPort;
        private static int maxid = 0;
        private final int id;
        public boolean finished = false;
        private final Map<String, String> parameters = new HashMap<String, String>();

        public String getParameter(String name, String defValue) {
            if (this.parameters.containsKey(name)) {
                return this.parameters.get(name);
            }
            return defValue;
        }

        public int getVersionMajor() {
            return Integer.parseInt(this.getParameter("debug.version.major", "1"));
        }

        public int getVersionMinor() {
            return Integer.parseInt(this.getParameter("debug.version.major", "0"));
        }

        public boolean hasMsgType() {
            return this.getVersionMajor() > 1 || this.getVersionMinor() > 0;
        }

        public DebugHandler(int serverPort, Socket s) {
            this.s = s;
            this.id = maxid++;
            this.serverPort = serverPort;
        }

        public void cancel() {
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private int readType(InputStream is) throws IOException {
            int type = is.read();
            if (type == -1) {
                throw new EOFException();
            }
            return type;
        }

        private void writeBytes(OutputStream os, byte[] data) throws IOException {
            os.write(data.length >> 24 & 0xFF);
            os.write(data.length >> 16 & 0xFF);
            os.write(data.length >> 8 & 0xFF);
            os.write(data.length & 0xFF);
            os.write(data);
        }

        private byte[] readBytes(InputStream is) throws IOException {
            int cnt;
            int len = is.read();
            if (len == -1) {
                throw new EOFException();
            }
            int len2 = is.read();
            if (len2 == -1) {
                throw new EOFException();
            }
            int len3 = is.read();
            if (len3 == -1) {
                throw new EOFException();
            }
            int len4 = is.read();
            if (len4 == -1) {
                throw new EOFException();
            }
            len = (len << 24) + (len2 << 16) + (len3 << 8) + len4;
            byte[] data = new byte[len];
            int off = 0;
            while (len > 0 && (cnt = is.read(data, off, len)) > 0) {
                len -= cnt;
                off += cnt;
            }
            return data;
        }

        private String readString(InputStream is) throws IOException {
            int len = is.read();
            if (len == -1) {
                throw new EOFException();
            }
            int len2 = is.read();
            if (len2 == -1) {
                throw new EOFException();
            }
            len = (len << 8) + len2;
            byte[] buf = new byte[len];
            for (int i = 0; i < len; ++i) {
                int rd = is.read();
                if (rd == -1) {
                    throw new EOFException();
                }
                buf[i] = (byte)rd;
            }
            return new String(buf, Utf8Helper.charset);
        }

        @Override
        public void run() {
            String clientName;
            block57: {
                clientName = Integer.toString(this.id);
                try (InputStream is = this.s.getInputStream();
                     final OutputStream os = this.s.getOutputStream();){
                    int c;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    do {
                        if ((c = is.read()) == 0) continue;
                        baos.write(c);
                    } while (c > 0);
                    String ret = baos.toString("UTF-8");
                    if (ret.equals("<policy-file-request/>")) {
                        os.write("<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" secure=\"false\" /></cross-domain-policy>".getBytes("UTF-8"));
                        break block57;
                    }
                    if (!ret.isEmpty()) {
                        String[] param;
                        String[] stringArray;
                        logger.log(Level.FINER, "Connected. Header: {0}", ret);
                        if (ret.contains(";")) {
                            stringArray = ret.split(";");
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = ret;
                        }
                        for (String p : param = stringArray) {
                            if (p.contains("=")) {
                                String key = p.substring(0, p.indexOf(61));
                                String val = p.substring(p.indexOf(61) + 1);
                                this.parameters.put(key, val);
                                continue;
                            }
                            this.parameters.put(p, "true");
                        }
                        active = true;
                    }
                    boolean hasType = this.hasMsgType();
                    logger.log(Level.FINER, "reading name...");
                    String name = this.readString(is);
                    logger.log(Level.FINER, "name = {0}", name);
                    if (!name.isEmpty()) {
                        clientName = name;
                    }
                    while (true) {
                        int type = 0;
                        logger.finer("reading type...");
                        if (hasType) {
                            type = this.readType(is);
                        }
                        logger.log(Level.FINE, "received type {0}", type);
                        switch (type) {
                            case 0: {
                                logger.finer("reading string...");
                                ret = this.readString(is);
                                logger.finer("informing listeners...");
                                for (Object l : listeners) {
                                    l.onMessage(clientName, ret);
                                }
                                logger.finer("listeners informed");
                                break;
                            }
                            case 1: {
                                logger.finer("reading string...");
                                ret = this.readString(is);
                                logger.finer("informing listeners...");
                                for (Object l : listeners) {
                                    l.onLoaderURL(clientName, ret);
                                }
                                logger.finer("listeners informed");
                                break;
                            }
                            case 2: {
                                Object l;
                                logger.finer("reading bytes...");
                                byte[] retB = this.readBytes(is);
                                logger.finer("informing listeners...");
                                l = listeners.iterator();
                                while (l.hasNext()) {
                                    DebugListener l2 = (DebugListener)l.next();
                                    l2.onLoaderBytes(clientName, retB);
                                }
                                logger.finer("listeners informed");
                                break;
                            }
                            case 3: {
                                Object l3;
                                logger.finer("reading bytes...");
                                byte[] retBa = this.readBytes(is);
                                logger.finer("informing listeners...");
                                for (Object l3 : listeners) {
                                    l3.onDumpByteArray(clientName, retBa);
                                }
                                logger.finer("listeners informed");
                                break;
                            }
                            case 4: {
                                DebugListener l;
                                logger.finer("checking listeners for data...");
                                boolean dataFound = false;
                                Object l3 = listeners.iterator();
                                while (l3.hasNext()) {
                                    l = (DebugListener)l3.next();
                                    byte[] data = l.onRequestBytes(clientName);
                                    if (data == null) continue;
                                    logger.finer("found listener with data");
                                    logger.log(Level.FINER, "writing data.length = {0}", data.length);
                                    this.writeBytes(os, data);
                                    logger.finer("data written");
                                    dataFound = true;
                                    break;
                                }
                                if (!dataFound) {
                                    logger.finer("listener not found, writing empty array");
                                    this.writeBytes(os, new byte[0]);
                                }
                                os.flush();
                                logger.finer("listeners checked");
                                break;
                            }
                            case 5: {
                                DebugListener l;
                                logger.finer("reading string...");
                                ret = this.readString(is);
                                logger.finer("informing listeners...");
                                Object l3 = listeners.iterator();
                                while (l3.hasNext()) {
                                    l = (DebugListener)l3.next();
                                    l.onLoaderURLInfo(clientName, ret);
                                }
                                logger.finer("listeners informed");
                                break;
                            }
                            case 6: {
                                logger.finer("reading url(string)...");
                                String url = this.readString(is);
                                logger.finer("reading bytes...");
                                final byte[] inputBytes = this.readBytes(is);
                                logger.finer("checking listeners for data...");
                                boolean modifyDataFound = false;
                                for (DebugListener l : listeners) {
                                    if (!l.isModifyBytesSupported()) continue;
                                    l.onLoaderModifyBytes(clientName, inputBytes, url, new DebugLoaderDataModified(){

                                        @Override
                                        public void dataModified(byte[] data) {
                                            if (data != null) {
                                                logger.finer("got modified data");
                                                logger.log(Level.FINER, "writing data.length = {0}", data.length);
                                                try {
                                                    this.writeBytes(os, data);
                                                    os.flush();
                                                }
                                                catch (IOException ex) {
                                                    Logger.getLogger(Debugger.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                                logger.finer("data written");
                                            } else {
                                                logger.finer("got empty modified data, writing original array");
                                                try {
                                                    this.writeBytes(os, inputBytes);
                                                }
                                                catch (IOException ex) {
                                                    Logger.getLogger(Debugger.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                                logger.finer("data written");
                                            }
                                        }
                                    });
                                    modifyDataFound = true;
                                    break;
                                }
                                if (!modifyDataFound) {
                                    logger.finer("listener not found, writing original array");
                                    this.writeBytes(os, inputBytes);
                                    logger.finer("data written");
                                }
                                os.flush();
                                logger.finer("listeners checked");
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.FINER, "IOException in injected debugger thread: {0}", ex.getMessage());
                }
            }
            try {
                this.s.close();
            }
            catch (IOException ex) {
                logger.log(Level.FINER, "Socked close exception in injected debugger thread: {0}", ex.getMessage());
            }
            this.finished = true;
            active = false;
            logger.log(Level.FINER, "Calling onFinish");
            for (DebugListener l : listeners) {
                l.onFinish(clientName);
            }
            logger.log(Level.FINER, "Injected debugger finished");
        }
    }
}

