/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.editor;

import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;
import java.util.Set;
import javax.swing.UIManager;
import jsyntaxpane.components.BreakPointListener;
import jsyntaxpane.components.LineMarkerPainter;
import jsyntaxpane.components.LineNumbersBreakpointsRuler;

public class DebuggableEditorPane
extends LineMarkedEditorPane
implements BreakPointListener,
LineMarkerPainter {
    private static final Color BG_CURRENT_COLOR = new Color(214, 232, 226);
    private static final Color BG_RULER_COLOR = new Color(233, 232, 226);
    private static Color BG_BREAKPOINT_COLOR = new Color(252, 157, 159);
    private static final Color BG_STACK_COLOR = new Color(231, 225, 239);
    private static final Color FG_BREAKPOINT_COLOR = null;
    private static final int PRIORITY_BREAKPOINT = 20;
    private static final Color BG_IP_COLOR = new Color(189, 230, 170);
    private static final Color FG_IP_COLOR = null;
    private static final Color FG_STACK_COLOR = null;
    private static final int PRIORITY_STACK = 30;
    private static final int PRIORITY_IP = 0;
    private static final Color BG_INVALID_BREAKPOINT_COLOR = new Color(220, 220, 216);
    private static final Color FG_INVALID_BREAKPOINT_COLOR = null;
    private static final int PRIORITY_INVALID_BREAKPOINT = 10;
    public static LineMarkedEditorPane.LineMarker BREAKPOINT_MARKER = new LineMarkedEditorPane.LineMarker(FG_BREAKPOINT_COLOR, BG_BREAKPOINT_COLOR, 20);
    public static final LineMarkedEditorPane.LineMarker IP_MARKER = new LineMarkedEditorPane.LineMarker(FG_IP_COLOR, BG_IP_COLOR, 0);
    public static final LineMarkedEditorPane.LineMarker INVALID_BREAKPOINT_MARKER = new LineMarkedEditorPane.LineMarker(FG_INVALID_BREAKPOINT_COLOR, BG_INVALID_BREAKPOINT_COLOR, 10);
    public static final LineMarkedEditorPane.LineMarker STACK_MARKER = new LineMarkedEditorPane.LineMarker(FG_STACK_COLOR, BG_STACK_COLOR, 30);
    protected String scriptName = null;
    protected String breakPointScriptName = null;
    private LineNumbersBreakpointsRuler ruler;
    private boolean showMarkers = true;

    public DebuggableEditorPane() {
        Color editorBackground = UIManager.getColor("EditorPane.background");
        int light = (editorBackground.getRed() + editorBackground.getGreen() + editorBackground.getBlue()) / 3;
        if (light < 128) {
            BG_BREAKPOINT_COLOR = new Color(136, 0, 0);
            BREAKPOINT_MARKER = new LineMarkedEditorPane.LineMarker(FG_BREAKPOINT_COLOR, BG_BREAKPOINT_COLOR, 20);
        }
    }

    public synchronized void setScriptName(String scriptName, String breakPointScriptName) {
        this.scriptName = scriptName;
        this.breakPointScriptName = breakPointScriptName;
    }

    public synchronized void toggled(int line) {
        if (this.breakPointScriptName == null) {
            return;
        }
        boolean on = Main.toggleBreakPoint(this.breakPointScriptName, line - this.firstLineOffset());
        this.removeColorMarker(line, INVALID_BREAKPOINT_MARKER);
        if (on) {
            if (Main.isBreakPointValid(this.breakPointScriptName, line - this.firstLineOffset())) {
                this.addColorMarker(line, BREAKPOINT_MARKER);
            } else {
                this.addColorMarker(line, INVALID_BREAKPOINT_MARKER);
            }
        } else {
            this.removeColorMarker(line, BREAKPOINT_MARKER);
            this.removeColorMarker(line, INVALID_BREAKPOINT_MARKER);
        }
    }

    public synchronized void refreshMarkers() {
        this.removeColorMarkerOnAllLines(BREAKPOINT_MARKER);
        this.removeColorMarkerOnAllLines(INVALID_BREAKPOINT_MARKER);
        this.removeColorMarkerOnAllLines(IP_MARKER);
        this.removeColorMarkerOnAllLines(STACK_MARKER);
        if (this.breakPointScriptName == null) {
            return;
        }
        if (!this.showMarkers) {
            return;
        }
        Set<Integer> bkptLines = Main.getScriptBreakPoints(this.breakPointScriptName, false);
        for (int line : bkptLines) {
            if (Main.isBreakPointValid(this.breakPointScriptName, line)) {
                this.addColorMarker(line + this.firstLineOffset(), BREAKPOINT_MARKER);
                continue;
            }
            this.addColorMarker(line + this.firstLineOffset(), INVALID_BREAKPOINT_MARKER);
        }
        int ip = Main.getIp(this.breakPointScriptName);
        String ipPath = Main.getIpClass();
        String ipHash = "main";
        if (ipPath != null && ipPath.contains(":")) {
            ipHash = ipPath.substring(0, ipPath.indexOf(":"));
            ipPath = ipPath.substring(ipPath.indexOf(":") + 1);
        }
        String myhash = Main.getSwfHash(Main.getMainFrame().getPanel().getCurrentSwf());
        if (ip > 0 && ipPath != null && ipHash.equals(myhash) && ipPath.equals(this.breakPointScriptName)) {
            this.addColorMarker(ip + this.firstLineOffset(), IP_MARKER);
        }
        List<Integer> stackLines = Main.getStackLines();
        List<String> stackClasses = Main.getStackClasses();
        for (int i = 1; i < stackClasses.size(); ++i) {
            String cls = stackClasses.get(i);
            String clsHash = "main";
            if (cls.contains(":")) {
                clsHash = cls.substring(0, cls.indexOf(":"));
                cls = cls.substring(cls.indexOf(":") + 1);
            }
            int line = stackLines.get(i);
            if (!clsHash.equals(myhash) || !cls.equals(this.breakPointScriptName)) continue;
            this.addColorMarker(line + this.firstLineOffset(), STACK_MARKER);
        }
    }

    public void setShowMarkers(boolean showMarkers) {
        this.showMarkers = showMarkers;
    }

    public boolean isShowMarkers() {
        return this.showMarkers;
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.refreshMarkers();
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getBreakPointScriptName() {
        return this.breakPointScriptName;
    }

    public void paintLineMarker(Graphics g, int line, int x, int lineY, int textY, int lineHeight, boolean currentLine, int maxLines) {
        if (currentLine) {
            g.setColor(UIManager.getColor("List.selectionBackground"));
        } else {
            g.setColor(UIManager.getColor("Panel.background"));
        }
        int h = lineHeight;
        if (line == 1) {
            h += lineY;
        }
        g.fillRect(0, line == 1 ? 0 : lineY, this.getWidth(), h);
        if (line == maxLines) {
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRect(0, line == 1 ? 0 : lineY + h, this.getWidth(), this.getHeight() - lineY - lineHeight);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setStroke(new BasicStroke(0.5f));
        if (this.hasColorMarker(line, STACK_MARKER)) {
            g.setColor(BG_STACK_COLOR);
            g.fillPolygon(new int[]{x + 5, x + 15, x + 15}, new int[]{textY, textY, textY - 10}, 3);
            g.setColor(Color.black);
            g.drawPolygon(new int[]{x + 5, x + 15, x + 15}, new int[]{textY, textY, textY - 10}, 3);
        }
        if (this.hasColorMarker(line, INVALID_BREAKPOINT_MARKER)) {
            g.setColor(BG_INVALID_BREAKPOINT_COLOR);
            g.fillOval(x + 5, textY - 10, 10, 10);
            g.setColor(Color.black);
            g.drawOval(x + 5, textY - 10, 10, 10);
        } else if (this.hasColorMarker(line, BREAKPOINT_MARKER)) {
            g.setColor(BG_BREAKPOINT_COLOR);
            g.fillOval(x + 5, textY - 10, 10, 10);
            g.setColor(Color.black);
            g.drawOval(x + 5, textY - 10, 10, 10);
        }
        if (this.hasColorMarker(line, IP_MARKER)) {
            int mx = x + 10;
            g.setColor(BG_IP_COLOR);
            g.fillPolygon(new int[]{mx, mx + 10, mx}, new int[]{textY - 10, textY - 5, textY}, 3);
            g.setColor(Color.black);
            g.drawPolygon(new int[]{mx, mx + 10, mx}, new int[]{textY - 10, textY - 5, textY}, 3);
        }
        if (currentLine) {
            g.setColor(UIManager.getColor("List.selectionForeground"));
        } else {
            g.setColor(UIManager.getColor("Panel.foreground"));
        }
        g.drawString("" + line, x + 16 + 5, textY);
    }

    public void installLineMarker(LineNumbersBreakpointsRuler ruler) {
        this.ruler = ruler;
    }

    @Override
    public void addColorMarker(int line, LineMarkedEditorPane.LineMarker lm) {
        super.addColorMarker(line, lm);
        this.ruler.repaint();
    }

    @Override
    public void removeColorMarker(int line, LineMarkedEditorPane.LineMarker lm) {
        super.removeColorMarker(line, lm);
        this.ruler.repaint();
    }
}

