/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.editor;

import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.editor.HighlightsPanel;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import com.jpexs.decompiler.flash.gui.editor.MyMarkers;
import com.jpexs.decompiler.flash.gui.editor.OccurrencesMarker;
import com.jpexs.decompiler.flash.gui.editor.TrackRectSubstanceScrollbarUI;
import com.jpexs.decompiler.flash.gui.editor.UnderlinePainter;
import com.jpexs.decompiler.flash.gui.editor.WavyUnderLinePainter;
import com.jpexs.decompiler.flash.simpleparser.LinkType;
import com.jpexs.decompiler.flash.simpleparser.Path;
import com.jpexs.decompiler.flash.simpleparser.SimpleParseException;
import com.jpexs.decompiler.flash.simpleparser.SimpleParser;
import com.jpexs.decompiler.flash.simpleparser.Variable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.components.Markers;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;
import natorder.NaturalOrderComparator;
import org.pushingpixels.substance.internal.ui.SubstanceScrollBarUI;

public class VariableMarker
implements SyntaxComponent,
CaretListener,
PropertyChangeListener,
DocumentListener {
    public static final String DEFAULT_TOKEN_TYPES = "IDENTIFIER, KEYWORD, REGEX";
    public static final String PROPERTY_COLOR = "ActionVariableMarker.Color";
    public static final String PROPERTY_ERROR_COLOR = "ActionVariableMarker.ErrorColor";
    public static final String PROPERTY_TOKEN_TYPES = "ActionVariableMarker.TokenTypes";
    private static final Color DEFAULT_COLOR = new Color(0xFFEEDD);
    private static final Color DEFAULT_ERROR_COLOR = new Color(0xFF0000);
    private JEditorPane pane;
    private final Set<TokenType> tokenTypes = new HashSet<TokenType>();
    private OccurrencesMarker marker;
    private Markers.SimpleMarker errorMarker;
    private SyntaxComponent.Status status;
    private Map<Integer, String> errors = new LinkedHashMap<Integer, String>();
    public static final long ERROR_DELAY = 2000L;
    private Timer errorsTimer;
    private Timer parseTimer;
    private Map<Integer, List<Integer>> definitionPosToReferences = new LinkedHashMap<Integer, List<Integer>>();
    private Map<Integer, Integer> referenceToDefinition = new LinkedHashMap<Integer, Integer>();
    private List<Path> externalTypes = new ArrayList<Path>();
    private Map<Integer, Integer> referenceToExternalTypeIndex = new LinkedHashMap<Integer, Integer>();
    private Map<Integer, List<Integer>> externalTypeIndexToReference = new LinkedHashMap<Integer, List<Integer>>();
    private Map<Path, Path> simpleExternalClassNameToFullClassName = new LinkedHashMap<Path, Path>();
    private Map<Integer, Path> referenceToExternalTraitKey = new LinkedHashMap<Integer, Path>();
    private Map<Path, List<Integer>> externalTraitKeyToReference = new LinkedHashMap<Path, List<Integer>>();
    private Map<Integer, Path> separatorPosToType = new LinkedHashMap<Integer, Path>();
    private Map<Path, List<Variable>> localTypeTraits = new LinkedHashMap<Path, List<Variable>>();
    private Map<Integer, Path> definitionToType = new LinkedHashMap<Integer, Path>();
    private Map<Integer, Path> definitionToCallType = new LinkedHashMap<Integer, Path>();
    private Map<Integer, Boolean> separatorIsStatic = new LinkedHashMap<Integer, Boolean>();
    private List<Variable> variableSuggestions = new ArrayList<Variable>();
    private MouseMotionAdapter mouseMotionAdapter;
    private KeyAdapter keyAdapter;
    private HighlightsPanel highlightsPanel;
    private ScrollPaneUI originalScrollPaneUI;
    private ScrollBarUI originalScrollBarUI;
    private LinkAdapter linkAdapter;
    private KeyEventPostProcessor kevEventPostProcessor;
    private Set<Integer> occurrencesPositions = new HashSet<Integer>();
    private Color basicUnderlineColor = new Color(0, 0, 255);
    private Color otherScriptUnderlineColor = new Color(0, 255, 0);
    private Color otherFileUnderlineColor = new Color(255, 0, 255);
    private UnderlinePainter underLinePainter = new UnderlinePainter(this.basicUnderlineColor, null);
    private UnderlinePainter underLineMarkOccurrencesPainter = new UnderlinePainter(this.basicUnderlineColor, DEFAULT_COLOR);
    private UnderlinePainter underLineOtherScriptPainter = new UnderlinePainter(this.otherScriptUnderlineColor, null);
    private UnderlinePainter underLineOtherScriptMarkOccurrencesPainter = new UnderlinePainter(this.otherScriptUnderlineColor, DEFAULT_COLOR);
    private UnderlinePainter underLineOtherFilePainter = new UnderlinePainter(this.otherFileUnderlineColor, null);
    private UnderlinePainter underLineOtherFileMarkOccurrencesPainter = new UnderlinePainter(this.otherFileUnderlineColor, DEFAULT_COLOR);
    private Token lastUnderlined;
    private LinkType lastUnderlinedLinkType = LinkType.NO_LINK;
    private boolean goingOut = false;
    private JList<VariableListItem> codeCompletionList;
    private DefaultListModel<VariableListItem> codeCompletionListModel = new DefaultListModel();
    private JPopupMenu codeCompletionPopup;
    private static final Logger LOG = Logger.getLogger(VariableMarker.class.getName());

    public VariableMarker() {
        this.codeCompletionList = new JList();
        this.codeCompletionList.setModel(this.codeCompletionListModel);
        this.codeCompletionList.setSelectionMode(0);
        this.codeCompletionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VariableListItem selected = (VariableListItem)VariableMarker.this.codeCompletionList.getSelectedValue();
                    if (selected != null) {
                        VariableMarker.this.completeCode(((VariableListItem)selected).variable.name.getLast().toString());
                    }
                    VariableMarker.this.codeCompletionPopup.setVisible(false);
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.codeCompletionList);
        this.codeCompletionPopup = new JPopupMenu();
        this.codeCompletionPopup.setLayout(new BorderLayout());
        this.codeCompletionPopup.add((Component)scroll, "Center");
        this.codeCompletionPopup.setPopupSize(200, 100);
        this.codeCompletionList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VariableListItem selected = (VariableListItem)VariableMarker.this.codeCompletionList.getSelectedValue();
                    if (selected != null) {
                        VariableMarker.this.completeCode(((VariableListItem)selected).variable.name.getLast().toString());
                    }
                    VariableMarker.this.codeCompletionPopup.setVisible(false);
                    if (selected == null) {
                        VariableMarker.this.pane.dispatchEvent(e);
                    }
                    return;
                }
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38 || e.getKeyCode() == 34 || e.getKeyCode() == 33) {
                    return;
                }
                VariableMarker.this.pane.dispatchEvent(e);
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38 || e.getKeyCode() == 34 || e.getKeyCode() == 33) {
                    return;
                }
                VariableMarker.this.pane.dispatchEvent(e);
                e.consume();
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38 || e.getKeyCode() == 34 || e.getKeyCode() == 33) {
                    return;
                }
                VariableMarker.this.pane.dispatchEvent(e);
                e.consume();
            }
        });
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.markTokenAt(e.getDot());
        if (this.codeCompletionPopup.isVisible()) {
            this.showCodeCompletion();
        }
    }

    public void markTokenAt(int pos) {
        SyntaxDocument doc = ActionUtils.getSyntaxDocument((JTextComponent)this.pane);
        if (doc != null) {
            Token token = VariableMarker.getIdentifierTokenAt(doc, pos);
            this.removeMarkers();
            if (token != null && this.tokenTypes.contains(token.type)) {
                this.addMarkers(token);
            }
            this.highlightsPanel.repaint();
        }
    }

    public void removeMarkers() {
        Markers.removeMarkers((JTextComponent)this.pane, (Markers.SimpleMarker)this.marker);
        Markers.removeMarkers((JTextComponent)this.pane, (Markers.SimpleMarker)this.underLinePainter);
        Markers.removeMarkers((JTextComponent)this.pane, (Markers.SimpleMarker)this.underLineMarkOccurrencesPainter);
        Markers.removeMarkers((JTextComponent)this.pane, (Markers.SimpleMarker)this.underLineOtherScriptPainter);
        Markers.removeMarkers((JTextComponent)this.pane, (Markers.SimpleMarker)this.underLineOtherScriptMarkOccurrencesPainter);
        Markers.removeMarkers((JTextComponent)this.pane, (Markers.SimpleMarker)this.underLineOtherFilePainter);
        Markers.removeMarkers((JTextComponent)this.pane, (Markers.SimpleMarker)this.underLineOtherFileMarkOccurrencesPainter);
        this.occurrencesPositions.clear();
    }

    public void removeErrorMarkers() {
        Markers.removeMarkers((JTextComponent)this.pane, (Markers.SimpleMarker)this.errorMarker);
    }

    public static Token getIdentifierTokenAt(SyntaxDocument sDoc, int pos) {
        Token thisToken = sDoc.getTokenAt(pos);
        if (thisToken != null && (thisToken.type == TokenType.IDENTIFIER || thisToken.type == TokenType.REGEX || thisToken.type == TokenType.KEYWORD)) {
            return thisToken;
        }
        Token token = sDoc.getTokenAt(pos - 1);
        if (token != null && (token.type == TokenType.IDENTIFIER || token.type == TokenType.REGEX || token.type == TokenType.KEYWORD) && token.start + token.length == pos) {
            return token;
        }
        token = sDoc.getTokenAt(pos + 1);
        if (token != null && (token.type == TokenType.IDENTIFIER || token.type == TokenType.REGEX || token.type == TokenType.KEYWORD) && token.start == pos) {
            return token;
        }
        return VariableMarker.getNearestTokenAt(sDoc, pos);
    }

    private static Token getNearestTokenAt(SyntaxDocument sDoc, int pos) {
        Token thisToken = sDoc.getTokenAt(pos);
        if (thisToken != null) {
            Token nextToken;
            if (thisToken.length == 1 && (nextToken = sDoc.getTokenAt(pos + 1)) != null && nextToken.start == pos && nextToken.length > 1) {
                return nextToken;
            }
            return thisToken;
        }
        Token token = sDoc.getTokenAt(pos - 1);
        if (token != null && token.start + token.length == pos) {
            return token;
        }
        token = sDoc.getTokenAt(pos + 1);
        if (token != null && token.start == pos) {
            return token;
        }
        return null;
    }

    void addErrorMarkers() {
        this.highlightsPanel.setErrors(this.errors);
        SyntaxDocument doc = ActionUtils.getSyntaxDocument((JTextComponent)this.pane);
        if (doc == null) {
            return;
        }
        doc.readLock();
        for (int position : this.errors.keySet()) {
            Token token = VariableMarker.getNearestTokenAt(doc, position);
            if (token == null) continue;
            Markers.markToken((JTextComponent)this.pane, (Token)token, (Markers.SimpleMarker)this.errorMarker);
        }
        this.highlightsPanel.repaint();
        doc.readUnlock();
    }

    void addMarkers(Token tok) {
        SyntaxDocument sDoc = (SyntaxDocument)this.pane.getDocument();
        sDoc.readLock();
        if (this.separatorPosToType.containsKey(tok.start)) {
            sDoc.readUnlock();
            return;
        }
        int definitionPos = tok.start;
        if (this.referenceToDefinition.containsKey(tok.start)) {
            definitionPos = this.referenceToDefinition.get(tok.start);
        } else {
            if (this.referenceToExternalTypeIndex.containsKey(tok.start)) {
                int typeIndex = this.referenceToExternalTypeIndex.get(tok.start);
                for (int i : this.externalTypeIndexToReference.get(typeIndex)) {
                    Token referenceToken;
                    if (this.separatorPosToType.containsKey(i) || (referenceToken = VariableMarker.getIdentifierTokenAt(sDoc, i)) == null) continue;
                    OccurrencesMarker markerKind = this.marker;
                    if (this.lastUnderlined == referenceToken) {
                        markerKind = this.lastUnderlinedLinkType == LinkType.LINK_OTHER_SCRIPT ? this.underLineOtherScriptMarkOccurrencesPainter : (this.lastUnderlinedLinkType == LinkType.LINK_OTHER_FILE ? this.underLineOtherFileMarkOccurrencesPainter : this.underLineMarkOccurrencesPainter);
                    }
                    Markers.markToken((JTextComponent)this.pane, (Token)referenceToken, (Markers.SimpleMarker)markerKind);
                    this.occurrencesPositions.add(referenceToken.start);
                }
                sDoc.readUnlock();
                return;
            }
            if (this.referenceToExternalTraitKey.containsKey(tok.start)) {
                Path traitKey = this.referenceToExternalTraitKey.get(tok.start);
                for (int i : this.externalTraitKeyToReference.get(traitKey)) {
                    Token referenceToken;
                    if (this.separatorPosToType.containsKey(i) || (referenceToken = VariableMarker.getIdentifierTokenAt(sDoc, i)) == null) continue;
                    OccurrencesMarker markerKind = this.marker;
                    if (this.lastUnderlined == referenceToken) {
                        markerKind = this.lastUnderlinedLinkType == LinkType.LINK_OTHER_SCRIPT ? this.underLineOtherScriptMarkOccurrencesPainter : (this.lastUnderlinedLinkType == LinkType.LINK_OTHER_FILE ? this.underLineOtherFileMarkOccurrencesPainter : this.underLineMarkOccurrencesPainter);
                    }
                    Markers.markToken((JTextComponent)this.pane, (Token)referenceToken, (Markers.SimpleMarker)markerKind);
                    this.occurrencesPositions.add(referenceToken.start);
                }
            }
        }
        Token definitionToken = VariableMarker.getIdentifierTokenAt(sDoc, definitionPos < 0 ? -(definitionPos + 1) : definitionPos);
        if (definitionToken != null && this.definitionPosToReferences.containsKey(definitionPos)) {
            OccurrencesMarker markerKind = this.marker;
            if (this.lastUnderlined == definitionToken) {
                markerKind = this.lastUnderlinedLinkType == LinkType.LINK_OTHER_SCRIPT ? this.underLineOtherScriptMarkOccurrencesPainter : (this.lastUnderlinedLinkType == LinkType.LINK_OTHER_FILE ? this.underLineOtherFileMarkOccurrencesPainter : this.underLineMarkOccurrencesPainter);
            }
            if (this.tokenTypes.contains(definitionToken.type)) {
                Markers.markToken((JTextComponent)this.pane, (Token)definitionToken, (Markers.SimpleMarker)markerKind);
            }
            this.occurrencesPositions.add(definitionToken.start);
            for (int i : this.definitionPosToReferences.get(definitionPos)) {
                Token referenceToken;
                if (this.separatorPosToType.containsKey(i) || (referenceToken = VariableMarker.getIdentifierTokenAt(sDoc, i)) == null) continue;
                markerKind = this.marker;
                if (this.lastUnderlined == referenceToken) {
                    markerKind = this.lastUnderlinedLinkType == LinkType.LINK_OTHER_SCRIPT ? this.underLineOtherScriptMarkOccurrencesPainter : (this.lastUnderlinedLinkType == LinkType.LINK_OTHER_FILE ? this.underLineOtherFileMarkOccurrencesPainter : this.underLineMarkOccurrencesPainter);
                }
                Markers.markToken((JTextComponent)this.pane, (Token)referenceToken, (Markers.SimpleMarker)markerKind);
                this.occurrencesPositions.add(referenceToken.start);
            }
        }
        sDoc.readUnlock();
    }

    public void config(Configuration config) {
        Color markerColor = config.getColor(PROPERTY_COLOR, DEFAULT_COLOR);
        Color errorColor = config.getColor(PROPERTY_ERROR_COLOR, DEFAULT_ERROR_COLOR);
        Color editorBackground = UIManager.getColor("EditorPane.background");
        int light = (editorBackground.getRed() + editorBackground.getGreen() + editorBackground.getBlue()) / 3;
        if (light < 128) {
            markerColor = new Color(0x443322);
        }
        this.marker = new OccurrencesMarker(markerColor);
        this.errorMarker = new WavyUnderLinePainter(errorColor);
        String types = config.getString(PROPERTY_TOKEN_TYPES, DEFAULT_TOKEN_TYPES);
        for (String type : types.split("\\s*,\\s*")) {
            try {
                TokenType tt = TokenType.valueOf((String)type);
                this.tokenTypes.add(tt);
            }
            catch (IllegalArgumentException e) {
                LOG.warning("Error in setting up TokenMarker  - Invalid TokenType: " + type);
            }
        }
    }

    private void completeCode(String suggestion) {
        try {
            SyntaxDocument sDoc = (SyntaxDocument)this.pane.getDocument();
            sDoc.readLock();
            int pos = this.pane.getCaretPosition();
            Token tokenAt = VariableMarker.getNearestTokenAt(sDoc, pos);
            String identText = "";
            if (tokenAt != null && tokenAt.type == TokenType.IDENTIFIER) {
                identText = sDoc.getText(tokenAt.start, pos - tokenAt.start);
                tokenAt = sDoc.getPrevToken(tokenAt);
            } else if (tokenAt != null && tokenAt.start >= pos) {
                if ((tokenAt = sDoc.getPrevToken(tokenAt)) != null && tokenAt.type == TokenType.IDENTIFIER) {
                    identText = sDoc.getText(tokenAt.start, pos - tokenAt.start);
                    tokenAt = sDoc.getPrevToken(tokenAt);
                }
            } else if (tokenAt == null) {
                while (tokenAt == null && pos >= 0) {
                    tokenAt = VariableMarker.getNearestTokenAt(sDoc, --pos);
                }
                if (tokenAt != null && tokenAt.type == TokenType.IDENTIFIER) {
                    identText = sDoc.getText(tokenAt.start, pos - tokenAt.start);
                    tokenAt = sDoc.getPrevToken(tokenAt);
                }
            }
            boolean isDot = tokenAt != null && tokenAt.type == TokenType.OPERATOR ? ".".equals(sDoc.getText(tokenAt.start, tokenAt.length)) : false;
            sDoc.readUnlock();
            if (isDot) {
                int afterDot = tokenAt.start + 1;
                this.pane.getDocument().remove(afterDot, this.pane.getCaretPosition() - afterDot);
                this.pane.getDocument().insertString(afterDot, suggestion, null);
            } else {
                this.pane.getDocument().remove(this.pane.getCaretPosition() - identText.length(), identText.length());
                this.pane.getDocument().insertString(this.pane.getCaretPosition(), suggestion, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCodeCompletion() {
        SyntaxDocument sDoc = (SyntaxDocument)this.pane.getDocument();
        sDoc.readLock();
        try {
            int pos = this.pane.getCaretPosition();
            Token tokenAt = VariableMarker.getNearestTokenAt(sDoc, pos);
            String identText = "";
            if (tokenAt != null && tokenAt.type == TokenType.IDENTIFIER) {
                identText = sDoc.getText(tokenAt.start, pos - tokenAt.start);
                tokenAt = sDoc.getPrevToken(tokenAt);
            } else if (tokenAt != null && tokenAt.start >= pos) {
                if ((tokenAt = sDoc.getPrevToken(tokenAt)) != null && tokenAt.type == TokenType.IDENTIFIER) {
                    identText = sDoc.getText(tokenAt.start, pos - tokenAt.start);
                    tokenAt = sDoc.getPrevToken(tokenAt);
                }
            } else if (tokenAt == null) {
                while (tokenAt == null && pos >= 0) {
                    tokenAt = VariableMarker.getNearestTokenAt(sDoc, --pos);
                }
                if (tokenAt != null && tokenAt.type == TokenType.IDENTIFIER) {
                    identText = sDoc.getText(tokenAt.start, pos - tokenAt.start);
                    tokenAt = sDoc.getPrevToken(tokenAt);
                }
            }
            boolean isDot = tokenAt != null && tokenAt.type == TokenType.OPERATOR ? ".".equals(sDoc.getText(tokenAt.start, tokenAt.length)) : false;
            ArrayList<Variable> suggestions = new ArrayList<Variable>();
            if (isDot) {
                Token prevToken = sDoc.getPrevToken(tokenAt);
                boolean isCall = prevToken.pairValue == -1;
                pos = tokenAt.start;
                if (!this.separatorPosToType.containsKey(pos)) {
                    return;
                }
                if (this.separatorPosToType.containsKey(pos)) {
                    Path type = this.separatorPosToType.get(pos);
                    boolean isStatic = false;
                    if (this.separatorIsStatic.containsKey(pos) && this.separatorIsStatic.get(pos).booleanValue()) {
                        isStatic = true;
                    }
                    if (this.localTypeTraits.containsKey(type)) {
                        for (Variable traitName : this.localTypeTraits.get(type)) {
                            if (isStatic && !traitName.isStatic.booleanValue() || traitName.name.toString().equals(type.getLast().toString())) continue;
                            suggestions.add(traitName);
                        }
                    } else {
                        if (this.simpleExternalClassNameToFullClassName.containsKey(type)) {
                            type = this.simpleExternalClassNameToFullClassName.get(type);
                        }
                        List traitNames = ((LineMarkedEditorPane)this.pane).getLinkHandler().getClassTraits(type, true, true, true);
                        for (Variable traitName : traitNames) {
                            if (isStatic && !traitName.isStatic.booleanValue() || traitName.name.toString().equals(type.getLast().toString())) continue;
                            suggestions.add(traitName);
                        }
                    }
                }
            } else {
                suggestions.addAll(this.variableSuggestions);
            }
            if (suggestions.isEmpty()) {
                this.codeCompletionPopup.setVisible(false);
                return;
            }
            final NaturalOrderComparator noc = new NaturalOrderComparator();
            Collections.sort(suggestions, new Comparator<Variable>(){

                @Override
                public int compare(Variable o1, Variable o2) {
                    return noc.compare((Object)o1.name.getLast().toString(), (Object)o2.name.getLast().toString());
                }
            });
            if (!identText.isEmpty()) {
                for (int i = suggestions.size() - 1; i >= 0; --i) {
                    String suggestion = ((Variable)suggestions.get((int)i)).name.getLast().toString();
                    if (suggestion.startsWith(identText)) continue;
                    suggestions.remove(i);
                }
            }
            this.codeCompletionList.setSelectedIndex(-1);
            this.codeCompletionListModel.clear();
            for (Variable s : suggestions) {
                this.codeCompletionListModel.addElement(new VariableListItem(s));
            }
            if (!this.codeCompletionPopup.isVisible() && !suggestions.isEmpty()) {
                Rectangle2D caretCoords = View.textComponentModelToView(this.pane, this.pane.getCaretPosition());
                this.codeCompletionPopup.show(this.pane, (int)caretCoords.getX(), (int)(caretCoords.getY() + caretCoords.getHeight()));
            }
            this.codeCompletionPopup.setPopupSize(this.codeCompletionList.getPreferredSize().width + 32, 200);
            this.codeCompletionList.setSize(this.codeCompletionList.getPreferredSize().width, 200);
            this.pane.requestFocusInWindow();
            this.pane.getCaret().setVisible(true);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            sDoc.readUnlock();
        }
    }

    public void install(final JEditorPane editor) {
        this.pane = editor;
        editor.addCaretListener(this);
        editor.addPropertyChangeListener(this);
        editor.getDocument().addDocumentListener(this);
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                VariableMarker.this.editorMouseMoved(e);
            }
        };
        editor.addMouseMotionListener(this.mouseMotionAdapter);
        JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, editor);
        this.originalScrollPaneUI = scrollPane.getUI();
        scrollPane.setUI(new BasicScrollPaneUI());
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        this.originalScrollBarUI = verticalScrollBar.getUI();
        if (this.originalScrollBarUI instanceof SubstanceScrollBarUI) {
            verticalScrollBar.setUI((ScrollBarUI)((Object)new TrackRectSubstanceScrollbarUI(verticalScrollBar)));
        }
        this.highlightsPanel = new HighlightsPanel((LineMarkedEditorPane)this.pane);
        JPanel panel = (JPanel)SwingUtilities.getAncestorOfClass(JPanel.class, scrollPane);
        panel.add((Component)this.highlightsPanel, "East");
        this.linkAdapter = new LinkAdapter();
        this.keyAdapter = new KeyAdapter(){
            Timer tim = null;

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.tim != null) {
                    this.tim.cancel();
                    this.tim = null;
                }
                if (e.getKeyChar() == '.' && ((Boolean)com.jpexs.decompiler.flash.configuration.Configuration.showCodeCompletionOnDot.get()).booleanValue()) {
                    if (!editor.isEditable()) {
                        return;
                    }
                    this.tim = new Timer();
                    this.tim.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            View.execInEventDispatch(new Runnable(){

                                @Override
                                public void run() {
                                    VariableMarker.this.reParse();
                                    VariableMarker.this.showCodeCompletion();
                                }
                            });
                        }
                    }, 100L);
                }
            }
        };
        this.pane.addMouseListener(this.linkAdapter);
        this.pane.addMouseMotionListener(this.linkAdapter);
        this.pane.addKeyListener(this.keyAdapter);
        this.kevEventPostProcessor = new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent e) {
                if (e.getID() == 401) {
                    VariableMarker.this.linkAdapter.keyPressed(e);
                }
                if (e.getID() == 402) {
                    VariableMarker.this.linkAdapter.keyReleased(e);
                }
                if (e.getID() == 400) {
                    VariableMarker.this.linkAdapter.keyTyped(e);
                }
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.kevEventPostProcessor);
        View.addEditorAction(this.pane, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyntaxDocument doc = ActionUtils.getSyntaxDocument((JTextComponent)VariableMarker.this.pane);
                int pos = VariableMarker.this.pane.getCaretPosition();
                Token token = VariableMarker.getIdentifierTokenAt(doc, pos);
                VariableMarker.this.handleLink(token);
            }
        }, "find-declaration", AppStrings.translate("abc.action.find-declaration"), "control B");
        View.addEditorAction(this.pane, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VariableMarker.this.pane.isEditable()) {
                    return;
                }
                VariableMarker.this.documentUpdated();
                VariableMarker.this.showCodeCompletion();
            }
        }, "code-completion", AppStrings.translate("action.code-completion"), "control SPACE");
        this.documentUpdated();
        this.markTokenAt(editor.getCaretPosition());
        this.status = SyntaxComponent.Status.INSTALLING;
    }

    private void editorMouseMoved(MouseEvent e) {
        if (this.pane instanceof LineMarkedEditorPane) {
            Token token = ((LineMarkedEditorPane)this.pane).tokenAtPos(e.getPoint());
            if (token == null) {
                this.pane.setToolTipText(null);
                return;
            }
            String err = this.errors.get(token.start);
            if (err != null) {
                this.pane.setToolTipText(err);
                return;
            }
            this.pane.setToolTipText(null);
        }
    }

    public void deinstall(JEditorPane editor) {
        this.status = SyntaxComponent.Status.DEINSTALLING;
        this.removeMarkers();
        this.removeErrorMarkers();
        Timer tim = this.errorsTimer;
        if (tim != null) {
            tim.cancel();
            this.errorsTimer = null;
        }
        View.removeEditorAction(this.pane, "find-declaration");
        View.removeEditorAction(this.pane, "code-completion");
        this.pane.removePropertyChangeListener(this);
        this.pane.getDocument().removeDocumentListener(this);
        this.pane.removeCaretListener(this);
        this.pane.removeMouseMotionListener(this.mouseMotionAdapter);
        this.pane.removeMouseMotionListener(this.linkAdapter);
        this.pane.removeMouseListener(this.linkAdapter);
        this.pane.removeKeyListener(this.keyAdapter);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.kevEventPostProcessor);
        this.mouseMotionAdapter = null;
        JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, editor);
        JPanel panel = (JPanel)SwingUtilities.getAncestorOfClass(JPanel.class, scrollPane);
        panel.remove(this.highlightsPanel);
        panel.revalidate();
        panel.repaint();
        scrollPane.setUI(this.originalScrollPaneUI);
        scrollPane.getVerticalScrollBar().setUI(this.originalScrollBarUI);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("document")) {
            this.goingOut = false;
            this.pane.removeCaretListener(this);
            this.pane.getDocument().removeDocumentListener(this);
            if (this.status.equals((Object)SyntaxComponent.Status.INSTALLING)) {
                this.pane.addCaretListener(this);
                this.pane.getDocument().addDocumentListener(this);
                this.removeMarkers();
                this.documentUpdated();
            }
        }
    }

    private synchronized void reParse() {
        Timer tim;
        this.errors.clear();
        this.removeErrorMarkers();
        this.highlightsPanel.repaint();
        boolean doClear = false;
        try {
            SyntaxDocument sDoc = (SyntaxDocument)this.pane.getDocument();
            sDoc.readLock();
            int pos = this.pane.getCaretPosition();
            String fullText = sDoc.getText(0, sDoc.getLength());
            sDoc.readUnlock();
            if (!(this.pane instanceof LineMarkedEditorPane)) {
                return;
            }
            SimpleParser parser = ((LineMarkedEditorPane)this.pane).getParser();
            if (parser == null) {
                return;
            }
            LinkedHashMap<Integer, List<Integer>> newDefinitionPosToReferences = new LinkedHashMap<Integer, List<Integer>>();
            LinkedHashMap<Integer, Integer> newReferenceToDefinition = new LinkedHashMap<Integer, Integer>();
            ArrayList newErrors = new ArrayList();
            ArrayList<Path> newExternalTypes = new ArrayList<Path>();
            LinkedHashMap<Integer, Integer> newReferenceToExternalTypeIndex = new LinkedHashMap<Integer, Integer>();
            LinkedHashMap<Integer, List<Integer>> newExternalTypeIndexToReference = new LinkedHashMap<Integer, List<Integer>>();
            LinkedHashMap<Integer, Path> newReferenceToExternalTraitKey = new LinkedHashMap<Integer, Path>();
            LinkedHashMap<Path, List<Integer>> newExternalTraitKeyToReference = new LinkedHashMap<Path, List<Integer>>();
            LinkedHashMap<Integer, Path> newSeparatorPosToType = new LinkedHashMap<Integer, Path>();
            LinkedHashMap<Path, List<Variable>> newLocalTypeTraits = new LinkedHashMap<Path, List<Variable>>();
            LinkedHashMap<Integer, Path> newDefinitionToType = new LinkedHashMap<Integer, Path>();
            LinkedHashMap<Integer, Path> newDefinitionToCallType = new LinkedHashMap<Integer, Path>();
            LinkedHashMap<Integer, Boolean> newSeparatorIsStatic = new LinkedHashMap<Integer, Boolean>();
            ArrayList<Variable> newVariableSuggestions = new ArrayList<Variable>();
            parser.parse(fullText, newDefinitionPosToReferences, newReferenceToDefinition, newErrors, newExternalTypes, newReferenceToExternalTypeIndex, newExternalTypeIndexToReference, ((LineMarkedEditorPane)this.pane).getLinkHandler(), newReferenceToExternalTraitKey, newExternalTraitKeyToReference, newSeparatorPosToType, newSeparatorIsStatic, newLocalTypeTraits, newDefinitionToType, newDefinitionToCallType, Integer.valueOf(pos), newVariableSuggestions);
            LinkedHashMap<Path, Path> newSimpleExternalClassNameToFullClassName = new LinkedHashMap<Path, Path>();
            for (int i = 0; i < newExternalTypes.size(); ++i) {
                Path type = (Path)newExternalTypes.get(i);
                newSimpleExternalClassNameToFullClassName.put(type.getLast(), type);
            }
            this.definitionPosToReferences.clear();
            this.referenceToDefinition.clear();
            this.externalTypes.clear();
            this.referenceToExternalTypeIndex.clear();
            this.externalTypeIndexToReference.clear();
            this.simpleExternalClassNameToFullClassName.clear();
            this.referenceToExternalTraitKey.clear();
            this.externalTraitKeyToReference.clear();
            this.separatorPosToType.clear();
            this.localTypeTraits.clear();
            this.definitionToType.clear();
            this.definitionToCallType.clear();
            this.separatorIsStatic.clear();
            this.variableSuggestions.clear();
            this.definitionPosToReferences = newDefinitionPosToReferences;
            this.referenceToDefinition = newReferenceToDefinition;
            this.externalTypes = newExternalTypes;
            this.referenceToExternalTypeIndex = newReferenceToExternalTypeIndex;
            this.externalTypeIndexToReference = newExternalTypeIndexToReference;
            this.simpleExternalClassNameToFullClassName = newSimpleExternalClassNameToFullClassName;
            this.referenceToExternalTraitKey = newReferenceToExternalTraitKey;
            this.externalTraitKeyToReference = newExternalTraitKeyToReference;
            this.separatorPosToType = newSeparatorPosToType;
            this.localTypeTraits = newLocalTypeTraits;
            this.definitionToType = newDefinitionToType;
            this.definitionToCallType = newDefinitionToCallType;
            this.separatorIsStatic = newSeparatorIsStatic;
            this.variableSuggestions = newVariableSuggestions;
            for (SimpleParseException ex : newErrors) {
                this.errors.put((int)ex.position, ex.getMessage());
            }
        }
        catch (IOException | InterruptedException | BadLocationException ex) {
            this.definitionPosToReferences.clear();
            this.referenceToDefinition.clear();
            doClear = true;
        }
        catch (SimpleParseException ex) {
            doClear = true;
            this.errors.put((int)ex.position, ex.getMessage());
        }
        if (doClear) {
            this.definitionPosToReferences.clear();
            this.referenceToDefinition.clear();
            this.definitionPosToReferences.clear();
            this.referenceToDefinition.clear();
            this.externalTypes.clear();
            this.referenceToExternalTypeIndex.clear();
            this.externalTypeIndexToReference.clear();
            this.simpleExternalClassNameToFullClassName.clear();
            this.referenceToExternalTraitKey.clear();
            this.externalTraitKeyToReference.clear();
            this.separatorPosToType.clear();
            this.localTypeTraits.clear();
            this.definitionToType.clear();
            this.definitionToCallType.clear();
            this.separatorIsStatic.clear();
            this.variableSuggestions.clear();
        }
        if ((tim = this.errorsTimer) != null) {
            tim.cancel();
            this.errorsTimer = null;
        }
        tim = new Timer();
        tim.schedule(new TimerTask(){

            @Override
            public void run() {
                VariableMarker.this.removeErrorMarkers();
                VariableMarker.this.addErrorMarkers();
            }
        }, 2000L);
        this.errorsTimer = tim;
        this.markTokenAt(this.pane.getCaretPosition());
    }

    private void documentUpdated() {
        Timer pTimer = this.parseTimer;
        if (pTimer != null) {
            pTimer.cancel();
        }
        pTimer = new Timer();
        pTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                VariableMarker.this.reParse();
            }
        }, 100L);
        this.parseTimer = pTimer;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentUpdated();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentUpdated();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentUpdated();
    }

    private LinkType getLinkType(Token token) {
        boolean linkThisScript;
        if (this.separatorPosToType.containsKey(token.start)) {
            return LinkType.NO_LINK;
        }
        if (this.definitionPosToReferences.containsKey(token.start)) {
            return LinkType.NO_LINK;
        }
        boolean bl = linkThisScript = this.referenceToDefinition.containsKey(token.start) && this.referenceToDefinition.get(token.start) >= 0;
        if (linkThisScript) {
            return LinkType.LINK_THIS_SCRIPT;
        }
        if (this.pane.isEditable()) {
            return LinkType.NO_LINK;
        }
        if (this.referenceToExternalTypeIndex.containsKey(token.start)) {
            Path externalType = this.externalTypes.get(this.referenceToExternalTypeIndex.get(token.start));
            return ((LineMarkedEditorPane)this.pane).getLinkHandler().getClassLinkType(externalType);
        }
        if (this.referenceToExternalTraitKey.containsKey(token.start)) {
            Path traitKey = this.referenceToExternalTraitKey.get(token.start);
            Path className = traitKey.getParent();
            if (this.simpleExternalClassNameToFullClassName.containsKey(className)) {
                className = this.simpleExternalClassNameToFullClassName.get(className);
            }
            return ((LineMarkedEditorPane)this.pane).getLinkHandler().getClassLinkType(className);
        }
        return LinkType.NO_LINK;
    }

    public void handleLink(Token token) {
        Integer definition = this.referenceToDefinition.get(token.start);
        if (definition != null && definition >= 0) {
            this.pane.setCaretPosition(definition);
        } else if (!this.pane.isEditable()) {
            Path externalType;
            if (this.referenceToExternalTypeIndex.containsKey(token.start) && ((Boolean)com.jpexs.decompiler.flash.configuration.Configuration.warningLinkTypes.get()).booleanValue()) {
                externalType = this.externalTypes.get(this.referenceToExternalTypeIndex.get(token.start));
                LinkType lt = ((LineMarkedEditorPane)this.pane).getLinkHandler().getClassLinkType(externalType);
                if (lt == LinkType.LINK_OTHER_FILE) {
                    JPanel msgPanel = new JPanel();
                    msgPanel.setLayout(new BoxLayout(msgPanel, 1));
                    JLabel bewareLabel = new JLabel(AppStrings.translate("message.link.clicked"));
                    bewareLabel.setAlignmentX(0.5f);
                    msgPanel.add(bewareLabel);
                    JLabel beware2Label = new JLabel(AppStrings.translate("message.link.bewareTypes"));
                    beware2Label.setAlignmentX(0.5f);
                    msgPanel.add(beware2Label);
                    JPanel linksPanel = new JPanel(new GridBagLayout());
                    linksPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                    linksPanel.setBackground(Color.white);
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.anchor = 23;
                    gbc.insets = new Insets(2, 2, 2, 2);
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    linksPanel.add((Component)new UnderlinedLabel(AppStrings.translate("message.link.type.currentScript.sample"), this.basicUnderlineColor), gbc);
                    ++gbc.gridx;
                    linksPanel.add((Component)new CommentLabel("//" + AppStrings.translate("message.link.type.currentScript")), gbc);
                    gbc.gridx = 0;
                    ++gbc.gridy;
                    linksPanel.add((Component)new UnderlinedLabel(AppStrings.translate("message.link.type.otherScript.sample"), this.otherScriptUnderlineColor), gbc);
                    ++gbc.gridx;
                    linksPanel.add((Component)new CommentLabel("//" + AppStrings.translate("message.link.type.otherScript")), gbc);
                    gbc.gridx = 0;
                    ++gbc.gridy;
                    linksPanel.add((Component)new UnderlinedLabel(AppStrings.translate("message.link.type.otherFile.sample"), this.otherFileUnderlineColor), gbc);
                    ++gbc.gridx;
                    linksPanel.add((Component)new CommentLabel("//" + AppStrings.translate("message.link.type.otherFile")), gbc);
                    gbc.gridx = 2;
                    gbc.gridy = 0;
                    gbc.gridheight = 3;
                    gbc.weightx = 1.0;
                    gbc.weighty = 1.0;
                    JPanel finalPanel = new JPanel();
                    finalPanel.setOpaque(false);
                    linksPanel.add(finalPanel);
                    linksPanel.setAlignmentX(0.5f);
                    msgPanel.add(linksPanel);
                    JLabel reallyLabel = new JLabel(AppStrings.translate("message.link.reallyGo"));
                    reallyLabel.setAlignmentX(0.5f);
                    msgPanel.add(reallyLabel);
                    JCheckBox doNotShowAgainCheckbox = new JCheckBox(AppStrings.translate("message.confirm.donotshowagain"));
                    doNotShowAgainCheckbox.setAlignmentX(0.5f);
                    msgPanel.add(doNotShowAgainCheckbox);
                    int result = ViewMessages.showOptionDialog(Main.getDefaultMessagesComponent(), msgPanel, AppStrings.translate("message.warning"), 2, 2, null, null, null);
                    if (doNotShowAgainCheckbox.isSelected()) {
                        com.jpexs.decompiler.flash.configuration.Configuration.warningLinkTypes.set((Object)false);
                    }
                    if (result != 0) {
                        return;
                    }
                }
            }
            this.lastUnderlined = null;
            this.removeErrorMarkers();
            this.removeMarkers();
            this.pane.repaint();
            if (this.referenceToExternalTypeIndex.containsKey(token.start)) {
                this.goingOut = true;
                this.pane.setCursor(Cursor.getDefaultCursor());
                externalType = this.externalTypes.get(this.referenceToExternalTypeIndex.get(token.start));
                ((LineMarkedEditorPane)this.pane).getLinkHandler().handleClassLink(externalType);
                return;
            }
            if (this.referenceToExternalTraitKey.containsKey(token.start)) {
                Path traitKey = this.referenceToExternalTraitKey.get(token.start);
                String traitName = traitKey.getLast().toString();
                Path className = traitKey.getParent();
                if (this.simpleExternalClassNameToFullClassName.containsKey(className)) {
                    className = this.simpleExternalClassNameToFullClassName.get(className);
                }
                ((LineMarkedEditorPane)this.pane).getLinkHandler().handleTraitLink(className, traitName);
            }
        }
    }

    private class VariableListItem {
        private Variable variable;

        public VariableListItem(Variable variable) {
            this.variable = variable;
        }

        public Variable getVariable() {
            return this.variable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.variable.name.getLast().toString());
            if (this.variable.callType != null) {
                sb.append("() : ");
                sb.append(this.variable.callType.getLast().toString());
            } else if (this.variable.type != null) {
                sb.append(" : ");
                sb.append(this.variable.type.getLast().toString());
            }
            return sb.toString();
        }
    }

    private class CommentLabel
    extends JLabel {
        public CommentLabel(String text) {
            super(text);
            this.setForeground(new Color(0x339933));
        }
    }

    private class UnderlinedLabel
    extends JLabel {
        private final Color underlineColor;

        public UnderlinedLabel(String text, Color underlineColor) {
            super(text);
            this.underlineColor = underlineColor;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.underlineColor);
            g.drawLine(0, fm.getHeight() - 3, fm.stringWidth(this.getText()), fm.getHeight() - 3);
        }
    }

    private class LinkAdapter
    extends MouseAdapter
    implements KeyListener {
        private boolean ctrlDown = false;
        private Point lastCursorPos;

        private LinkAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                this.ctrlDown = true;
                this.update();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                this.ctrlDown = false;
                this.update();
            }
        }

        private void update() {
            if (VariableMarker.this.goingOut) {
                return;
            }
            if (this.lastCursorPos == null) {
                return;
            }
            if (this.ctrlDown) {
                Token t = ((LineMarkedEditorPane)VariableMarker.this.pane).tokenAtPos(this.lastCursorPos);
                if (t != VariableMarker.this.lastUnderlined) {
                    if (t == null || VariableMarker.this.lastUnderlined == null || !t.equals((Object)VariableMarker.this.lastUnderlined)) {
                        MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLinePainter));
                        MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLineMarkOccurrencesPainter));
                        MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLineOtherScriptPainter));
                        MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLineOtherScriptMarkOccurrencesPainter));
                        MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLineOtherFilePainter));
                        MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLineOtherFileMarkOccurrencesPainter));
                        VariableMarker.this.lastUnderlinedLinkType = t == null ? LinkType.NO_LINK : VariableMarker.this.getLinkType(t);
                        if (t != null && VariableMarker.this.lastUnderlinedLinkType != LinkType.NO_LINK) {
                            VariableMarker.this.lastUnderlined = t;
                            VariableMarker.this.pane.setCursor(Cursor.getPredefinedCursor(12));
                        } else {
                            VariableMarker.this.lastUnderlined = null;
                            VariableMarker.this.removeMarkers();
                            VariableMarker.this.markTokenAt(VariableMarker.this.pane.getCaretPosition());
                        }
                    } else {
                        VariableMarker.this.lastUnderlined = null;
                        VariableMarker.this.lastUnderlinedLinkType = LinkType.NO_LINK;
                    }
                }
                if (VariableMarker.this.lastUnderlined != null) {
                    UnderlinePainter painter = VariableMarker.this.underLinePainter;
                    if (VariableMarker.this.occurrencesPositions.contains(((VariableMarker)VariableMarker.this).lastUnderlined.start)) {
                        painter = VariableMarker.this.lastUnderlinedLinkType == LinkType.LINK_OTHER_SCRIPT ? VariableMarker.this.underLineOtherScriptMarkOccurrencesPainter : (VariableMarker.this.lastUnderlinedLinkType == LinkType.LINK_OTHER_FILE ? VariableMarker.this.underLineOtherFileMarkOccurrencesPainter : VariableMarker.this.underLineMarkOccurrencesPainter);
                        VariableMarker.this.removeMarkers();
                        VariableMarker.this.markTokenAt(VariableMarker.this.pane.getCaretPosition());
                    } else {
                        if (VariableMarker.this.lastUnderlinedLinkType == LinkType.LINK_OTHER_SCRIPT) {
                            painter = VariableMarker.this.underLineOtherScriptPainter;
                        } else if (VariableMarker.this.lastUnderlinedLinkType == LinkType.LINK_OTHER_FILE) {
                            painter = VariableMarker.this.underLineOtherFilePainter;
                        }
                        MyMarkers.markToken(VariableMarker.this.pane, VariableMarker.this.lastUnderlined, (Highlighter.HighlightPainter)((Object)painter));
                    }
                } else {
                    VariableMarker.this.pane.setCursor(Cursor.getDefaultCursor());
                }
                VariableMarker.this.highlightsPanel.repaint();
            } else {
                if (VariableMarker.this.lastUnderlined != null) {
                    VariableMarker.this.lastUnderlined = null;
                    MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLinePainter));
                    MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLineMarkOccurrencesPainter));
                    MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLineOtherScriptPainter));
                    MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLineOtherScriptMarkOccurrencesPainter));
                    MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLineOtherFilePainter));
                    MyMarkers.removeMarkers(VariableMarker.this.pane, (Highlighter.HighlightPainter)((Object)VariableMarker.this.underLineOtherFileMarkOccurrencesPainter));
                    VariableMarker.this.removeMarkers();
                    VariableMarker.this.markTokenAt(VariableMarker.this.pane.getCaretPosition());
                }
                VariableMarker.this.pane.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Token t;
            if (this.lastCursorPos == null) {
                return;
            }
            if (this.ctrlDown && (t = ((LineMarkedEditorPane)VariableMarker.this.pane).tokenAtPos(this.lastCursorPos)) != null && VariableMarker.this.getLinkType(t) != LinkType.NO_LINK) {
                e.consume();
                VariableMarker.this.handleLink(t);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.ctrlDown = (e.getModifiersEx() & 0x80) != 0;
            this.lastCursorPos = e.getPoint();
            this.update();
        }
    }
}

