/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.helpers;

import com.jpexs.decompiler.flash.gui.AboutDialog;
import com.jpexs.decompiler.flash.gui.AdvancedSettingsDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.AsLinkageDialog;
import com.jpexs.decompiler.flash.gui.DebugLogDialog;
import com.jpexs.decompiler.flash.gui.ErrorLogFrame;
import com.jpexs.decompiler.flash.gui.ExportDialog;
import com.jpexs.decompiler.flash.gui.FilesChangedDialog;
import com.jpexs.decompiler.flash.gui.FontEmbedDialog;
import com.jpexs.decompiler.flash.gui.FontPreviewDialog;
import com.jpexs.decompiler.flash.gui.GraphDialog;
import com.jpexs.decompiler.flash.gui.LoadFromMemoryFrame;
import com.jpexs.decompiler.flash.gui.LoadingDialog;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.NewFileDialog;
import com.jpexs.decompiler.flash.gui.NewVersionDialog;
import com.jpexs.decompiler.flash.gui.PathResolvingDialog;
import com.jpexs.decompiler.flash.gui.RenameDialog;
import com.jpexs.decompiler.flash.gui.ReplaceCharacterDialog;
import com.jpexs.decompiler.flash.gui.ReplaceTraceDialog;
import com.jpexs.decompiler.flash.gui.SearchDialog;
import com.jpexs.decompiler.flash.gui.SearchResultsDialog;
import com.jpexs.decompiler.flash.gui.SelectFramePositionDialog;
import com.jpexs.decompiler.flash.gui.SelectLanguageDialog;
import com.jpexs.decompiler.flash.gui.SelectTagOfTypeDialog;
import com.jpexs.decompiler.flash.gui.SelectTagPositionDialog;
import com.jpexs.decompiler.flash.gui.abc.ABCExplorerDialog;
import com.jpexs.decompiler.flash.gui.abc.AddClassDialog;
import com.jpexs.decompiler.flash.gui.abc.As3ClassLinkageDialog;
import com.jpexs.decompiler.flash.gui.abc.DeobfuscationDialog;
import com.jpexs.decompiler.flash.gui.abc.NewTraitDialog;
import com.jpexs.decompiler.flash.gui.abc.UsageFrame;
import com.jpexs.decompiler.flash.gui.action.AddScriptDialog;
import com.jpexs.helpers.Helper;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckResources {
    public static void checkResources(PrintStream stream, String selectedLanguage) {
        Class[] classes = CheckResources.getClasses();
        try {
            String[] languages = SelectLanguageDialog.getAvailableLanguages();
            HashMap<Class, LinkedProperties> properties = new HashMap<Class, LinkedProperties>();
            for (Class clazz : classes) {
                String resourcePath = CheckResources.getResourcePath(clazz, null);
                InputStream is = CheckResources.class.getResourceAsStream(resourcePath);
                if (is == null) {
                    stream.println("Resource file not found: " + resourcePath);
                    return;
                }
                LinkedProperties prop = new LinkedProperties();
                prop.load(is);
                properties.put(clazz, prop);
            }
            for (String lang : languages) {
                if (lang.equals("en") || selectedLanguage != null && !lang.equals(selectedLanguage)) continue;
                boolean firstMissing = true;
                for (Class clazz : classes) {
                    Properties prop = (Properties)properties.get(clazz);
                    LinkedProperties prop2 = new LinkedProperties();
                    String resourcePath = CheckResources.getResourcePath(clazz, lang);
                    InputStream is = CheckResources.class.getResourceAsStream(resourcePath);
                    if (is == null) {
                        stream.println((String)lang + ": Resource file not found: " + resourcePath);
                        continue;
                    }
                    try {
                        prop2.load(is);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(CheckResources.class.getName()).log(Level.SEVERE, "Cannot load resource:" + clazz.getSimpleName() + " " + (String)lang, ex);
                    }
                    boolean firstMissing2 = true;
                    for (Object key : prop.keySet()) {
                        String keyStr = (String)key;
                        String value = prop2.getProperty(keyStr);
                        if (value != null) continue;
                        if (firstMissing) {
                            stream.println(lang);
                            stream.println("-----------------------------");
                            firstMissing = false;
                        }
                        if (firstMissing2) {
                            stream.println(clazz.getSimpleName() + ":");
                            firstMissing2 = false;
                        }
                        stream.println(key + " = " + prop.getProperty(keyStr));
                    }
                }
                if (firstMissing) continue;
                stream.println();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(CheckResources.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(CheckResources.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void checkTranslationDate(PrintStream stream) {
        for (String code : SelectLanguageDialog.getAvailableLanguages()) {
            String lang = code.equals("en") ? "" : "_" + code.replace("-", "_");
            String url = "https://api.github.com/repos/jindrapetrik/jpexs-decompiler/commits?path=/src/com/jpexs/decompiler/flash/gui/locales/MainFrame" + lang + ".properties";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sdf2 = new SimpleDateFormat("dd/MM/yyyy");
            Date now = new Date();
            Calendar c = Calendar.getInstance();
            c.setTime(now);
            c.add(1, -1);
            Date oldLimit = c.getTime();
            try {
                String text = Helper.downloadUrlString((String)url);
                text = text.substring(text.indexOf("\"date\":\"") + 8);
                text = text.substring(0, text.indexOf(84));
                Date date = now;
                try {
                    date = sdf.parse(text);
                }
                catch (ParseException ex) {
                    Logger.getLogger(CheckResources.class.getName()).log(Level.SEVERE, null, ex);
                }
                Locale l = Locale.forLanguageTag(code.equals("en") ? "" : code);
                ResourceBundle b = ResourceBundle.getBundle(AppStrings.getResourcePath(AboutDialog.class), l);
                String translator = b.getString("translation.author");
                boolean old = date.before(oldLimit);
                stream.println(Locale.forLanguageTag(code).getDisplayName() + ": " + translator + " - " + sdf2.format(date) + (old ? " translation too old" : ""));
            }
            catch (IOException ex) {
                Logger.getLogger(CheckResources.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void compareResources(PrintStream stream, String revision, String revision2) {
        Class[] classes;
        String rootUrl = "https://raw.githubusercontent.com/jindrapetrik/jpexs-decompiler/";
        for (Class clazz : classes = CheckResources.getClasses()) {
            try {
                String value;
                String keyStr;
                URLConnection uc;
                String resPath = "/src" + CheckResources.getResourcePath(clazz, null);
                URL latestUrl = URI.create(rootUrl + (revision2 == null ? "master" : revision2) + resPath).toURL();
                URL prevUrl = URI.create(rootUrl + revision + resPath).toURL();
                LinkedProperties latestProp = new LinkedProperties();
                try {
                    uc = latestUrl.openConnection();
                    latestProp.load(new BufferedReader(new InputStreamReader(uc.getInputStream())));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LinkedProperties prevProp = new LinkedProperties();
                try {
                    uc = prevUrl.openConnection();
                    prevProp.load(new BufferedReader(new InputStreamReader(uc.getInputStream())));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                boolean firstMissing2 = true;
                for (Object key : ((Properties)latestProp).keySet()) {
                    keyStr = (String)key;
                    value = prevProp.getProperty(keyStr);
                    if (value != null) continue;
                    if (firstMissing2) {
                        stream.println(clazz.getSimpleName());
                        firstMissing2 = false;
                    }
                    stream.println(key + " = " + latestProp.getProperty(keyStr));
                }
                for (Object key : ((Properties)prevProp).keySet()) {
                    keyStr = (String)key;
                    value = latestProp.getProperty(keyStr);
                    if (value != null) continue;
                    if (firstMissing2) {
                        stream.println(clazz.getSimpleName());
                        firstMissing2 = false;
                    }
                    stream.println(key + " was removed. Last value: " + prevProp.getProperty(keyStr));
                }
            }
            catch (MalformedURLException ex) {
                throw new Error(ex);
            }
        }
    }

    private static Class[] getClasses() {
        Class[] classes = new Class[]{AboutDialog.class, AdvancedSettingsDialog.class, AsLinkageDialog.class, DebugLogDialog.class, ErrorLogFrame.class, ExportDialog.class, FilesChangedDialog.class, FontEmbedDialog.class, FontPreviewDialog.class, GraphDialog.class, LoadFromMemoryFrame.class, LoadingDialog.class, MainFrame.class, NewFileDialog.class, NewVersionDialog.class, PathResolvingDialog.class, RenameDialog.class, ReplaceCharacterDialog.class, ReplaceTraceDialog.class, SearchDialog.class, SearchResultsDialog.class, SelectFramePositionDialog.class, SelectLanguageDialog.class, SelectTagOfTypeDialog.class, SelectTagPositionDialog.class, ABCExplorerDialog.class, AddClassDialog.class, As3ClassLinkageDialog.class, DeobfuscationDialog.class, NewTraitDialog.class, UsageFrame.class, AddScriptDialog.class};
        return classes;
    }

    private static String getResourcePath(Class cls, String lang) {
        String name = cls.getName();
        if (name.startsWith("com.jpexs.decompiler.flash.gui.")) {
            name = name.substring("com.jpexs.decompiler.flash.gui.".length());
            name = "/com/jpexs/decompiler/flash/gui/locales/" + name.replace(".", "/");
            if (lang != null) {
                name = name + "_" + lang.replace("-", "_");
            }
            name = name + ".properties";
        }
        return name;
    }

    private static class LinkedProperties
    extends Properties {
        private final HashSet<Object> keys = new LinkedHashSet<Object>();

        public Iterable<Object> orderedKeys() {
            return Collections.list(this.keys());
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public Set<Object> keySet() {
            return this.keys;
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }
    }
}

