/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.player;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItemChangeListener;
import com.jpexs.decompiler.flash.ecma.EcmaNumberToString;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.GridDialog;
import com.jpexs.decompiler.flash.gui.GuidesDialog;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.PopupButton;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.MediaDisplayListener;
import com.jpexs.decompiler.flash.gui.player.PlayerControls;
import com.jpexs.decompiler.flash.gui.player.SnapOptionsButton;
import com.jpexs.decompiler.flash.gui.player.Zoom;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;

public class ZoomPanel
extends JPanel
implements MediaDisplayListener {
    private MediaDisplay display;
    private final JButton zoomFitButton;
    private final SnapOptionsButton snapOptionsButton;
    private PopupButton guidesOptionsButton;
    private JToggleButton rulerButton;
    private final JLabel percentLabel = new JLabel("100%");
    private boolean zoomToFit = false;
    private double realZoom = 1.0;
    private final double MAX_ZOOM = 1000000.0;

    public ZoomPanel(MediaDisplay display) {
        this.display = display;
        JButton zoomInButton = new JButton(View.getIcon("zoomin16"));
        zoomInButton.addActionListener(this::zoomInButtonActionPerformed);
        zoomInButton.setToolTipText(AppStrings.translate("button.zoomin.hint"));
        JButton zoomOutButton = new JButton(View.getIcon("zoomout16"));
        zoomOutButton.addActionListener(this::zoomOutButtonActionPerformed);
        zoomOutButton.setToolTipText(AppStrings.translate("button.zoomout.hint"));
        this.zoomFitButton = new JButton(View.getIcon("zoomfit16"));
        this.zoomFitButton.addActionListener(this::zoomFitButtonActionPerformed);
        this.zoomFitButton.setToolTipText(AppStrings.translate("button.zoomfit.hint"));
        JButton zoomNoneButton = new JButton(View.getIcon("zoomnone16"));
        zoomNoneButton.addActionListener(this::zoomNoneButtonActionPerformed);
        zoomNoneButton.setToolTipText(AppStrings.translate("button.zoomnone.hint"));
        this.rulerButton = new JToggleButton(View.getIcon("ruler16"));
        this.rulerButton.addActionListener(this::rulerActionPerformed);
        this.rulerButton.setToolTipText(AppStrings.translate("button.ruler.hint"));
        this.rulerButton.setSelected((Boolean)Configuration.showRuler.get());
        Configuration.showRuler.addListener((ConfigurationItemChangeListener)new ConfigurationItemChangeListener<Boolean>(){

            public void configurationItemChanged(Boolean newValue) {
                ZoomPanel.this.rulerButton.setSelected(newValue);
            }
        });
        this.guidesOptionsButton = new PopupButton((Icon)View.getIcon("guides16")){

            @Override
            protected JPopupMenu getPopupMenu() {
                JPopupMenu menu = new JPopupMenu();
                JCheckBoxMenuItem showGuidesMenuItem = new JCheckBoxMenuItem(AppStrings.translate("guides_options.show"));
                showGuidesMenuItem.setSelected((Boolean)Configuration.showGuides.get());
                showGuidesMenuItem.addActionListener(x$0 -> ZoomPanel.this.guidesShowActionPerformed(x$0));
                JCheckBoxMenuItem lockGuidesMenuItem = new JCheckBoxMenuItem(AppStrings.translate("guides_options.lock"));
                lockGuidesMenuItem.setSelected((Boolean)Configuration.lockGuides.get());
                lockGuidesMenuItem.addActionListener(x$0 -> ZoomPanel.this.guidesLockActionPerformed(x$0));
                JMenuItem clearGuidesMenuItem = new JMenuItem(AppStrings.translate("guides_options.clear"));
                clearGuidesMenuItem.addActionListener(x$0 -> ZoomPanel.this.guidesClearActionPerformed(x$0));
                JMenuItem editGuidesMenuItem = new JMenuItem(AppStrings.translate("guides_options.edit"));
                editGuidesMenuItem.addActionListener(x$0 -> ZoomPanel.this.guidesEditActionPerformed(x$0));
                menu.add(showGuidesMenuItem);
                menu.add(lockGuidesMenuItem);
                menu.add(clearGuidesMenuItem);
                menu.add(editGuidesMenuItem);
                return menu;
            }
        };
        this.guidesOptionsButton.setToolTipText(AppStrings.translate("button.guides_options"));
        this.snapOptionsButton = new SnapOptionsButton();
        PopupButton gridButton = new PopupButton((Icon)View.getIcon("grid16")){

            @Override
            protected JPopupMenu getPopupMenu() {
                JPopupMenu menu = new JPopupMenu();
                JCheckBoxMenuItem showGridCheckBoxMenuItem = new JCheckBoxMenuItem(AppStrings.translate("grid_options.show_grid"));
                showGridCheckBoxMenuItem.addActionListener(x$0 -> ZoomPanel.this.showGridCheckBoxMenuItemActionPerformed(x$0));
                showGridCheckBoxMenuItem.setSelected((Boolean)Configuration.showGrid.get());
                menu.add(showGridCheckBoxMenuItem);
                JMenuItem editGridMenuItem = new JMenuItem(AppStrings.translate("grid_options.edit"));
                editGridMenuItem.addActionListener(x$0 -> ZoomPanel.this.editGridMenuItemActionPerformed(x$0));
                menu.add(editGridMenuItem);
                return menu;
            }
        };
        gridButton.setToolTipText(AppStrings.translate("button.grid_options"));
        this.percentLabel.setToolTipText(AppStrings.translate("zoom.hint"));
        this.percentLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                double currentZoom = ZoomPanel.roundZoom(ZoomPanel.this.getRealZoom() * 100.0, 3);
                String newZoomStr = ViewMessages.showInputDialog(ZoomPanel.this, AppStrings.translate("zoom.enter"), AppStrings.translate("zoom"), View.getIcon("zoom32"), EcmaNumberToString.stringFor((double)currentZoom));
                if (newZoomStr != null) {
                    try {
                        double newZoom = Double.parseDouble(newZoomStr) / 100.0;
                        if (newZoom <= 0.0) {
                            return;
                        }
                        ZoomPanel.this.realZoom = newZoom;
                        ZoomPanel.this.zoomToFit = false;
                        ZoomPanel.this.updateZoom();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        this.setLayout(new FlowLayout());
        this.add(this.percentLabel);
        this.add(zoomInButton);
        this.add(zoomOutButton);
        this.add(zoomNoneButton);
        this.add(this.zoomFitButton);
        this.add(this.rulerButton);
        this.add(gridButton);
        this.add(this.guidesOptionsButton);
        this.add(this.snapOptionsButton);
        display.addEventListener(this);
    }

    private void editGridMenuItemActionPerformed(ActionEvent evt) {
        new GridDialog(Main.getDefaultDialogsOwner()).setVisible(true);
    }

    private void showGridCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        JCheckBoxMenuItem source = (JCheckBoxMenuItem)evt.getSource();
        Configuration.showGrid.set((Object)source.isSelected());
    }

    private void guidesShowActionPerformed(ActionEvent evt) {
        JCheckBoxMenuItem source = (JCheckBoxMenuItem)evt.getSource();
        Configuration.showGuides.set((Object)source.isSelected());
    }

    private void guidesLockActionPerformed(ActionEvent evt) {
        JCheckBoxMenuItem source = (JCheckBoxMenuItem)evt.getSource();
        Configuration.lockGuides.set((Object)source.isSelected());
    }

    private void guidesEditActionPerformed(ActionEvent evt) {
        new GuidesDialog(Main.getDefaultDialogsOwner(), this.display).setVisible(true);
    }

    private void guidesClearActionPerformed(ActionEvent evt) {
        this.display.clearGuides();
    }

    private void rulerActionPerformed(ActionEvent evt) {
        JToggleButton toggleButton = (JToggleButton)evt.getSource();
        Configuration.showRuler.set((Object)toggleButton.isSelected());
    }

    private void zoomInButtonActionPerformed(ActionEvent evt) {
        double currentRealZoom = this.getRealZoom();
        if (currentRealZoom >= 1000000.0) {
            return;
        }
        this.realZoom = currentRealZoom * PlayerControls.ZOOM_MULTIPLIER;
        this.zoomToFit = false;
        this.updateZoom();
    }

    private void zoomOutButtonActionPerformed(ActionEvent evt) {
        this.realZoom = this.getRealZoom() / PlayerControls.ZOOM_MULTIPLIER;
        this.zoomToFit = false;
        this.updateZoom();
    }

    private void zoomNoneButtonActionPerformed(ActionEvent evt) {
        this.realZoom = 1.0;
        this.zoomToFit = false;
        this.updateZoom();
    }

    private void zoomFitButtonActionPerformed(ActionEvent evt) {
        this.realZoom = 1.0;
        this.zoomToFit = true;
        this.updateZoom();
    }

    private double getRealZoom() {
        if (this.zoomToFit) {
            return this.display.getZoomToFit();
        }
        return this.realZoom;
    }

    private void updateZoom() {
        this.updateZoomDisplay();
        double pctzoom = ZoomPanel.roundZoom(this.getRealZoom() * 100.0, 3);
        double zoom = pctzoom / 100.0;
        Zoom zoomObj = new Zoom();
        zoomObj.value = zoom;
        zoomObj.fit = this.zoomToFit;
        this.display.zoom(zoomObj);
    }

    private void updateZoomDisplay() {
        double pctzoom = ZoomPanel.roundZoom(this.getRealZoom() * 100.0, 3);
        String r = Double.toString(pctzoom);
        if (r.endsWith(".0")) {
            r = r.substring(0, r.length() - 2);
        }
        r = r + "%";
        if (this.zoomToFit) {
            this.percentLabel.setText(AppStrings.translate("fit") + " (" + r + ")");
        } else {
            this.percentLabel.setText(r);
        }
    }

    private static double roundZoom(double realZoom, int mantissa) {
        double l10 = Math.log10(realZoom);
        int lg = (int)(-Math.floor(l10) + (double)mantissa - 1.0);
        if (lg < 0) {
            lg = 0;
        }
        BigDecimal bd = new BigDecimal(String.valueOf(realZoom)).setScale(lg, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public void update() {
        if (!this.display.isLoaded()) {
            return;
        }
        View.execInEventDispatchLater(() -> {
            Zoom zoom = this.display.getZoom();
            this.zoomFitButton.setVisible(zoom != null);
            this.percentLabel.setVisible(zoom != null);
            this.snapOptionsButton.setVisible(this.display.canUseSnapping());
            this.rulerButton.setVisible(this.display.canHaveRuler());
            this.guidesOptionsButton.setVisible(this.display.canHaveRuler());
            Zoom currentZoom = new Zoom();
            currentZoom.fit = this.zoomToFit;
            currentZoom.value = this.realZoom;
            if (zoom != null && !Objects.equals(zoom, currentZoom)) {
                this.zoomToFit = zoom.fit;
                this.realZoom = zoom.value;
                this.updateZoomDisplay();
            }
        });
    }

    public void setMedia(MediaDisplay media) {
        if (this.display != null) {
            this.display.removeEventListener(this);
        }
        this.display = media;
        this.display.addEventListener(this);
        this.update();
    }

    @Override
    public void mediaDisplayStateChanged(MediaDisplay source) {
        if (this.display != source) {
            return;
        }
        this.update();
    }

    @Override
    public void playingFinished(MediaDisplay source) {
    }

    @Override
    public void statusChanged(String status) {
    }
}

