/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.tagtree;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.helpers.CollectionChangedEvent;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTagTreeModel
implements TreeModel {
    protected final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private Map<TreeItem, Integer> indices = new WeakHashMap<TreeItem, Integer>();
    protected Map<TreeItem, TreeItem> itemToParentCache = new WeakHashMap<TreeItem, TreeItem>();

    public abstract void updateSwfs(CollectionChangedEvent var1);

    protected void uncacheSwf(SWF swf) {
        HashSet<TreeItem> tSet = new HashSet<TreeItem>(this.itemToParentCache.keySet());
        for (TreeItem item : tSet) {
            if (item.getOpenable() != swf) continue;
            this.itemToParentCache.remove(item);
        }
    }

    public final void calculateCollisions() {
        WeakHashMap<TreeItem, Integer> indices = new WeakHashMap<TreeItem, Integer>();
        this.calculateCollisions(this.getRoot(), indices);
        this.indices = indices;
    }

    private void calculateCollisions(Object parent, Map<TreeItem, Integer> indices) {
        List<? extends TreeItem> items = this.getAllChildren(parent);
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (TreeItem treeItem : items) {
            String str = treeItem.toString();
            int count = counts.containsKey(str) ? (Integer)counts.get(str) : 0;
            counts.put(str, ++count);
            if (count > 1) {
                indices.put(treeItem, count);
                if (treeItem instanceof TagScript) {
                    Tag tag = ((TagScript)treeItem).getTag();
                    indices.put((TreeItem)tag, count);
                }
            }
            this.calculateCollisions(treeItem, indices);
        }
    }

    public final int getItemIndex(TreeItem item) {
        if (item instanceof TagScript) {
            item = ((TagScript)item).getTag();
        }
        if (this.indices.containsKey(item)) {
            return this.indices.get(item);
        }
        return 1;
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(e);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(e);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(e);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public boolean treePathExists(TreePath treePath) {
        TreeItem current = null;
        for (Object o : treePath.getPath()) {
            TreeItem item = (TreeItem)o;
            if (current == null) {
                if (item != this.getRoot()) {
                    return false;
                }
                current = item;
                continue;
            }
            int idx = this.getIndexOfChild(current, item);
            if (idx == -1) {
                return false;
            }
            current = item;
        }
        return true;
    }

    public abstract Frame getFrame(SWF var1, Timelined var2, int var3);

    public abstract TreeItem getChild(Object var1, int var2);

    public abstract List<? extends TreeItem> getAllChildren(Object var1);

    public abstract TreeItem getRoot();

    protected abstract List<TreeItem> searchTreeItem(TreeItem var1, TreeItem var2, List<TreeItem> var3);

    protected abstract void searchTreeItemMulti(List<TreeItem> var1, TreeItem var2, List<TreeItem> var3, Map<TreeItem, List<TreeItem>> var4);

    protected abstract void searchTreeItemParentMulti(List<TreeItem> var1, TreeItem var2, Map<TreeItem, TreeItem> var3);

    public Map<TreeItem, TreeItem> getTreePathParentMulti(List<TreeItem> objs) {
        IdentityHashMap<TreeItem, TreeItem> result = new IdentityHashMap<TreeItem, TreeItem>();
        for (TreeItem item : objs) {
            if (!this.itemToParentCache.containsKey(item)) break;
            result.put(item, this.itemToParentCache.get(item));
        }
        if (result.size() == objs.size()) {
            return result;
        }
        TreeItem root = this.getRoot();
        this.searchTreeItemParentMulti(objs, root, result);
        return result;
    }

    public Map<TreeItem, TreePath> getTreePathMulti(List<TreeItem> objs) {
        TreeItem root = this.getRoot();
        ArrayList<TreeItem> path = new ArrayList<TreeItem>();
        path.add(root);
        IdentityHashMap<TreeItem, List<TreeItem>> paths = new IdentityHashMap<TreeItem, List<TreeItem>>();
        this.searchTreeItemMulti(objs, root, path, paths);
        IdentityHashMap<TreeItem, TreePath> result = new IdentityHashMap<TreeItem, TreePath>();
        for (TreeItem item : paths.keySet()) {
            List p = (List)paths.get(item);
            TreePath tp = new TreePath(p.toArray(new Object[p.size()]));
            result.put(item, tp);
        }
        return result;
    }

    public TreePath getTreePath(TreeItem obj) {
        List<TreeItem> path = new ArrayList<TreeItem>();
        TreeItem root = this.getRoot();
        path.add(root);
        if (obj != root) {
            path = this.searchTreeItem(obj, root, path);
        }
        if (path == null) {
            return null;
        }
        TreePath tp = new TreePath(path.toArray(new Object[path.size()]));
        return tp;
    }

    public void updateNode(TreeItem treeItem) {
        TreePath changedPath = this.getTreePath(treeItem);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, changedPath));
    }

    public void updateNode(TreePath changedPath) {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, changedPath.getParentPath()));
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public abstract void updateOpenable(Openable var1);

    public TreeItem getParent(TreeItem obj) {
        return (TreeItem)this.getTreePath(obj).getParentPath().getLastPathComponent();
    }
}

