/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.tagtree;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.TreeNodeType;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTree;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeModel;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.helpers.Helper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TagTree
extends AbstractTagTree {
    public TagTree(TagTreeModel treeModel, MainPanel mainPanel) {
        super(treeModel, mainPanel);
        this.setCellRenderer(new TagTreeCellRenderer());
    }

    public static List<Integer> getSwfFolderItemNestedTagIds(String folderName, boolean gfx) {
        List<Integer> ret = new ArrayList<Integer>();
        switch (folderName) {
            case "shapes": {
                ret = Arrays.asList(2, 22, 32, 83);
                break;
            }
            case "morphshapes": {
                ret = Arrays.asList(46, 84);
                break;
            }
            case "sprites": {
                ret = Arrays.asList(39);
                break;
            }
            case "texts": {
                ret = Arrays.asList(11, 33, 37);
                break;
            }
            case "images": {
                ret = Arrays.asList(6, 21, 35, 90, 20, 36);
                if (!gfx) break;
                ret = new ArrayList<Integer>(ret);
                ret.addAll(Arrays.asList(1001, 1009, 1008));
                break;
            }
            case "movies": {
                ret = Arrays.asList(60, 38);
                break;
            }
            case "sounds": {
                ret = Arrays.asList(14);
                if (!gfx) break;
                ret = new ArrayList<Integer>(ret);
                ret.add(1006);
                break;
            }
            case "buttons": {
                ret = Arrays.asList(7, 34);
                break;
            }
            case "fonts": {
                if (gfx) {
                    ret = Arrays.asList(10, 48, 75, 91, 1005);
                    break;
                }
                ret = Arrays.asList(10, 48, 75, 91, 52);
                break;
            }
            case "binaryData": {
                ret = Arrays.asList(87);
                break;
            }
            case "frames": {
                ret = Arrays.asList(4, 26, 70, 94, 5, 28, 1, 43, 15, 89, 61, 19, 18, 45, 66, 85, 49, 3, 29);
                if (!gfx) break;
                ret = new ArrayList<Integer>(ret);
                ret.add(1007);
                break;
            }
            case "others": {
                ret = Arrays.asList(63, 86, 82, 72, 12, 59, 58, 64, 93, 56, 69, 57, 71, 8, 77, 41, 24, 65, 9, 76, 51);
                if (!gfx) break;
                ret = new ArrayList<Integer>(ret);
                ret.addAll(Arrays.asList(1003, 1004, 1000, 1002));
            }
        }
        return ret;
    }

    @Override
    public List<TreeItem> getSelection(Openable openable) {
        List<TreeItem> sel;
        if (!this.mainPanel.folderPreviewCard.isVisible() || !this.mainPanel.folderPreviewPanel.isSomethingSelected()) {
            sel = this.getAllSelected();
        } else {
            sel = new ArrayList<TreeItem>();
            List<TreeItem> siSorted = this.mainPanel.folderPreviewPanel.getSelectedItemsSorted();
            for (TreeItem treeItem : siSorted) {
                sel.add(treeItem);
                this.getAllSubs(treeItem, sel);
            }
        }
        return TagTree.getSelection(openable, sel);
    }

    public List<AS3ClassTreeItem> getTagsWithType(List<AS3ClassTreeItem> list, TreeNodeType type) {
        ArrayList<AS3ClassTreeItem> ret = new ArrayList<AS3ClassTreeItem>();
        for (AS3ClassTreeItem item : list) {
            TreeNodeType ttype = TagTree.getTreeNodeType((TreeItem)item);
            if (type != ttype) continue;
            ret.add(item);
        }
        return ret;
    }

    @Override
    public TagTreeModel getFullModel() {
        return (TagTreeModel)super.getFullModel();
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String sValue;
        DoInitActionTag tag;
        String expName;
        if (value instanceof DoInitActionTag && (expName = (tag = (DoInitActionTag)value).getSwf().getExportName(tag.getCharacterId())) != null && !expName.isEmpty()) {
            String[] stringArray;
            if (expName.contains(".")) {
                stringArray = expName.split("\\.");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = expName;
            }
            String[] pathParts = stringArray;
            if (expName.startsWith("__Packages.")) {
                return IdentifiersDeobfuscation.printIdentifier((SWF)tag.getSwf(), new LinkedHashSet(), (boolean)false, (String)pathParts[pathParts.length - 1], (String[])new String[0]);
            }
            return Helper.escapeExportname((SWF)tag.getSwf(), (String)expName, (boolean)false);
        }
        if (value != null && (sValue = value.toString()) != null) {
            return sValue;
        }
        return "";
    }

    public static class TagTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Font plainFont;
        private Font boldFont;
        private boolean semiTransparent = false;

        public TagTreeCellRenderer() {
            this.setUI(new BasicLabelUI());
            this.setOpaque(false);
            if (View.isOceanic()) {
                this.setBackgroundNonSelectionColor(Color.white);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.semiTransparent && this.getIcon() != null) {
                Color color = this.getBackground();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() / 2));
                g2d.setComposite(AlphaComposite.SrcOver);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ScriptPack sp;
            Set<Integer> missingNeededCharacters;
            Font font;
            TreeItem val = (TreeItem)value;
            if (val != null && !(val instanceof OpenableList) && val.getOpenable() == null) {
                value = null;
            }
            JLabel origLabel = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (val == null) {
                return this;
            }
            this.setIcon(AbstractTagTree.getIconFor(val, expanded));
            boolean isReadOnly = false;
            if (val instanceof Tag) {
                isReadOnly = ((Tag)val).isReadOnly();
            }
            boolean isModified = val.isModified();
            if (isReadOnly) {
                isModified = false;
            }
            if (isModified) {
                if (this.boldFont == null) {
                    font = this.getFont();
                    this.boldFont = font.deriveFont(1);
                }
            } else if (this.plainFont == null) {
                font = this.getFont();
                this.plainFont = font.deriveFont(0);
            }
            this.setFont(isModified ? this.boldFont : this.plainFont);
            if (View.isOceanic()) {
                if (isReadOnly) {
                    this.setForeground(new Color(204, 204, 204));
                } else {
                    this.setForeground(Color.BLACK);
                }
            }
            this.setToolTipText(null);
            AbstractTagTree aTree = (AbstractTagTree)tree;
            Map<TreeItem, Set<Integer>> allMissingNeededCharacters = aTree.getMissingNeededCharacters();
            if (allMissingNeededCharacters.containsKey((TreeItem)value) && !(missingNeededCharacters = allMissingNeededCharacters.get(value)).isEmpty()) {
                ArrayList<String> missingAsStr = new ArrayList<String>();
                for (int v : missingNeededCharacters) {
                    missingAsStr.add("" + v);
                }
                if (missingAsStr.size() == 1) {
                    this.setToolTipText(AppStrings.translate("error.missing.characterTag.single").replace("%tag%", (CharSequence)missingAsStr.get(0)));
                } else {
                    this.setToolTipText(AppStrings.translate("error.missing.characterTag.multi").replace("%tags%", String.join((CharSequence)", ", missingAsStr)));
                }
                this.setForeground(Color.red);
            }
            this.semiTransparent = false;
            if (aTree.getMainPanel().isClipboardCut() && aTree.getMainPanel().clipboardContains(val)) {
                this.semiTransparent = true;
            }
            int itemIndex = aTree.getFullModel().getItemIndex(val);
            String txt = origLabel.getText();
            if (itemIndex > 1) {
                txt = txt + " [" + itemIndex + "]";
            }
            if (val instanceof ScriptPack && (sp = (ScriptPack)val).isDocumentClass()) {
                txt = "<html><u>" + txt.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;") + "</u></html>";
            }
            this.setText(txt);
            return this;
        }
    }
}

