/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ImageWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryFooter;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntrySecondary;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;

public class RibbonFactory {
    private JRibbon ribbon;
    private LinkedList<JRibbonBand> bands;
    private LinkedList<JCommandButton> commandButtons;
    private Map<JCommandButton, RibbonElementPriority> commandButtonsPriority;
    private String nextSubMenuTitle;
    private LinkedList<RibbonApplicationMenuEntrySecondary> subMenuItems;
    private RibbonApplicationMenu applicationMenu;
    private LinkedList<RibbonTask> contextualTasks;

    public RibbonFactory() {
        this(new JRibbon());
    }

    public RibbonFactory(JRibbon ribbon) {
        this.ribbon = ribbon;
        this.bands = new LinkedList();
        this.commandButtons = new LinkedList();
        this.commandButtonsPriority = new HashMap<JCommandButton, RibbonElementPriority>();
        this.subMenuItems = new LinkedList();
        if (ribbon.getApplicationMenu() == null) {
            this.applicationMenu = new RibbonApplicationMenu();
        }
        this.contextualTasks = new LinkedList();
    }

    public RibbonFactory addContextualTaskGroup(String title) {
        return this.addContextualTaskGroup(title, Color.BLUE);
    }

    public RibbonFactory addContextualTaskGroup(String title, Color color) {
        if (this.contextualTasks.size() > 0) {
            RibbonTask[] _tasks = new RibbonTask[this.contextualTasks.size()];
            RibbonContextualTaskGroup group = new RibbonContextualTaskGroup(title, color, this.contextualTasks.toArray(_tasks));
            this.ribbon.addContextualTaskGroup(group);
            this.clearContextualTaskGroupsQueue();
        }
        return this;
    }

    public RibbonFactory addContextualTaskGroup(RibbonContextualTaskGroup group) {
        this.ribbon.addContextualTaskGroup(group);
        return this;
    }

    public RibbonContextualTaskGroup getContextualTaskGroup(String title, Color color) {
        RibbonContextualTaskGroup group = null;
        if (this.contextualTasks.size() > 0) {
            RibbonTask[] _tasks = new RibbonTask[this.contextualTasks.size()];
            group = new RibbonContextualTaskGroup(title, color, this.contextualTasks.toArray(_tasks));
        }
        return group;
    }

    public void clearContextualTaskGroupsQueue() {
        this.contextualTasks.clear();
    }

    public RibbonFactory addContextualTask(String title) {
        JRibbonBand[] _bands = new JRibbonBand[this.bands.size()];
        RibbonTask task = new RibbonTask(title, this.bands.toArray(_bands));
        this.contextualTasks.add(task);
        this.clearRibbonBandsQueue();
        return this;
    }

    public RibbonFactory addContextualTask(RibbonTask task) {
        this.contextualTasks.add(task);
        return this;
    }

    public RibbonFactory addFooterMenuItem(String text, ActionListener actionListener) {
        return this.addFooterMenuItem(text, null, actionListener);
    }

    public RibbonFactory addFooterMenuItem(ResizableIcon icon, ActionListener actionListener) {
        return this.addFooterMenuItem("", icon, actionListener);
    }

    public RibbonFactory addFooterMenuItem(String text, ResizableIcon icon) {
        return this.addFooterMenuItem(text, icon, null);
    }

    public RibbonFactory addFooterMenuItem(String text, ResizableIcon icon, ActionListener actionListener) {
        RibbonApplicationMenuEntryFooter item = new RibbonApplicationMenuEntryFooter(icon, text, actionListener);
        return this.addFooterMenuItem(item);
    }

    public RibbonFactory addFooterMenuItem(RibbonApplicationMenuEntryFooter item) {
        this.applicationMenu.addFooterEntry(item);
        return this;
    }

    public RibbonFactory addSubMenuItem(String text) {
        return this.addSubMenuItem(text, RibbonFactory.getResizableIconFromResource(this.getClass().getResource("/res/images/blank.png")), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
    }

    public RibbonFactory addSubMenuItem(String text, ResizableIcon icon) {
        return this.addSubMenuItem(text, icon, null, JCommandButton.CommandButtonKind.ACTION_ONLY);
    }

    public RibbonFactory addSubMenuItem(String text, ResizableIcon icon, ActionListener actionListener) {
        return this.addSubMenuItem(text, icon, actionListener, JCommandButton.CommandButtonKind.ACTION_ONLY);
    }

    public RibbonFactory addSubMenuItem(String text, ResizableIcon icon, ActionListener actionListener, JCommandButton.CommandButtonKind kind) {
        RibbonApplicationMenuEntrySecondary item = new RibbonApplicationMenuEntrySecondary(icon, text, actionListener, kind);
        return this.addSubMenuItem(item);
    }

    public RibbonFactory addSubMenuItem(RibbonApplicationMenuEntrySecondary item) {
        this.subMenuItems.add(item);
        return this;
    }

    public RibbonFactory newSubMenuGroup() {
        return this.newSubMenuGroup("");
    }

    public RibbonFactory newSubMenuGroup(String title) {
        this.nextSubMenuTitle = title;
        return this;
    }

    public RibbonFactory addSpacerMenuItem() {
        return this.addMenuItem("", null, null, JCommandButton.CommandButtonKind.ACTION_ONLY);
    }

    public RibbonFactory addMenuItem(String text) {
        return this.addMenuItem(text, RibbonFactory.getResizableIconFromResource(RibbonFactory.class.getClassLoader().getResource("example/resources/blank.png")), null, JCommandButton.CommandButtonKind.POPUP_ONLY);
    }

    public RibbonFactory addMenuItem(String text, ResizableIcon icon) {
        return this.addMenuItem(text, icon, null, JCommandButton.CommandButtonKind.POPUP_ONLY);
    }

    public RibbonFactory addMenuItem(String text, ResizableIcon icon, ActionListener actionListener) {
        return this.addMenuItem(text, icon, actionListener, JCommandButton.CommandButtonKind.ACTION_ONLY);
    }

    public RibbonFactory addMenuItem(String text, ResizableIcon icon, ActionListener actionListener, JCommandButton.CommandButtonKind kind) {
        RibbonApplicationMenuEntryPrimary item = new RibbonApplicationMenuEntryPrimary(icon, text, actionListener, kind);
        return this.addMenuItem(item);
    }

    public RibbonFactory addMenuItem(RibbonApplicationMenuEntryPrimary item) {
        if (this.nextSubMenuTitle != null) {
            RibbonApplicationMenuEntrySecondary[] subItems = new RibbonApplicationMenuEntrySecondary[this.subMenuItems.size()];
            item.addSecondaryMenuGroup(this.nextSubMenuTitle, this.subMenuItems.toArray(subItems));
        }
        this.applicationMenu.addMenuEntry(item);
        this.clearSubMenuItemsQueue();
        return this;
    }

    public List<RibbonApplicationMenuEntrySecondary> getSubMenuItemsQueue() {
        return this.subMenuItems;
    }

    public void clearSubMenuItemsQueue() {
        this.subMenuItems.clear();
    }

    public RibbonFactory withMenu() {
        if (this.ribbon.getApplicationMenu() == null) {
            this.ribbon.setApplicationMenu(this.applicationMenu);
        }
        return this;
    }

    public RibbonFactory withMenu(ResizableIcon icon) {
        if (this.ribbon.getApplicationMenu() == null) {
            this.ribbon.setApplicationMenu(this.applicationMenu);
        }
        return this;
    }

    public RibbonFactory withHelp() {
        return this.withHelp(RibbonFactory.getResizableIconFromResource(RibbonFactory.class.getClassLoader().getResource("example/resources/help.png")), null);
    }

    public RibbonFactory withHelp(ResizableIcon icon) {
        return this.withHelp(icon, null);
    }

    public RibbonFactory withHelp(ActionListener actionListener) {
        return this.withHelp(RibbonFactory.getResizableIconFromResource(this.getClass().getResource("/res/images/help.png")), actionListener);
    }

    public RibbonFactory withHelp(ResizableIcon icon, ActionListener actionListener) {
        this.ribbon.configureHelp(icon, null);
        return this;
    }

    public RibbonFactory hasPriority(RibbonElementPriority priority) {
        this.commandButtonsPriority.put(this.commandButtons.getLast(), priority);
        return this;
    }

    public RibbonFactory addButton(String name) {
        return this.addButton(name, null);
    }

    public RibbonFactory addButton(ResizableIcon icon) {
        return this.addButton("", icon);
    }

    public RibbonFactory addButton(String name, ResizableIcon icon) {
        return this.addButton(name, icon, null);
    }

    public RibbonFactory addButton(String name, ResizableIcon icon, ActionListener actionListener) {
        JCommandButton button = new JCommandButton(name, icon);
        button.setFlat(false);
        if (actionListener != null) {
            button.addActionListener(actionListener);
        }
        return this.addButton(button);
    }

    public RibbonFactory addButton(String name, ResizableIcon icon, ActionListener actionListener, JCommandButton.CommandButtonKind kind) {
        return this.addButton(name, icon, actionListener, kind, null, null, null, false);
    }

    public RibbonFactory addButton(String name, ResizableIcon icon, ActionListener actionListener, boolean isFlat) {
        return this.addButton(name, icon, actionListener, JCommandButton.CommandButtonKind.ACTION_ONLY, null, null, null, isFlat);
    }

    public RibbonFactory addButton(String name, ResizableIcon icon, ActionListener actionListener, JCommandButton.CommandButtonKind kind, boolean isFlat) {
        return this.addButton(name, icon, actionListener, kind, null, null, null, isFlat);
    }

    public RibbonFactory addButton(String name, ResizableIcon icon, ActionListener actionListener, JCommandButton.CommandButtonKind kind, RichTooltip actionTooltip, RichTooltip popupTooltip, PopupPanelCallback popupCallback, boolean isFlat) {
        JCommandButton button = new JCommandButton(name, icon);
        button.setFlat(isFlat);
        if (actionListener != null) {
            button.addActionListener(actionListener);
        }
        button.setCommandButtonKind(kind);
        button.setActionRichTooltip(actionTooltip);
        button.setPopupRichTooltip(popupTooltip);
        button.setPopupCallback(popupCallback);
        return this.addButton(button);
    }

    public RibbonFactory addButton(JCommandButton button) {
        this.commandButtons.add(button);
        return this;
    }

    public List<JCommandButton> getButtonsQueue() {
        return this.commandButtons;
    }

    public void clearButtonsQueue() {
        this.commandButtons.clear();
    }

    public RibbonFactory addTask(String name) {
        JRibbonBand[] _bands = new JRibbonBand[this.bands.size()];
        RibbonTask task = new RibbonTask(name, this.bands.toArray(_bands));
        this.ribbon.addTask(task);
        this.clearRibbonBandsQueue();
        return this;
    }

    public RibbonFactory addBand(ResizableIcon icon) {
        return this.addBand("", icon, null);
    }

    public RibbonFactory addBand(String title) {
        return this.addBand(title, null, null);
    }

    public RibbonFactory addBand(String title, ResizableIcon icon) {
        return this.addBand(title, icon, null);
    }

    public RibbonFactory addBand(String title, ResizableIcon icon, ActionListener actionListener) {
        JRibbonBand band = new JRibbonBand(title, icon, actionListener);
        band.setResizePolicies(this.getDefaultPoliciesFor(band));
        return this.addBand(band);
    }

    public RibbonFactory addBand(JRibbonBand band) {
        for (JCommandButton b : this.commandButtons) {
            RibbonElementPriority priority = this.commandButtonsPriority.get(b);
            priority = priority != null ? priority : RibbonElementPriority.TOP;
            band.addCommandButton(b, priority);
        }
        this.bands.add(band);
        this.clearButtonsQueue();
        return this;
    }

    public List<JRibbonBand> getRibbonBandsQueue() {
        return this.bands;
    }

    public void clearRibbonBandsQueue() {
        this.bands.clear();
    }

    public JRibbon getRibbon() {
        return this.ribbon;
    }

    public List<RibbonBandResizePolicy> getDefaultPoliciesFor(JRibbonBand band) {
        CoreRibbonResizePolicies.Mirror r1 = new CoreRibbonResizePolicies.Mirror((JBandControlPanel)band.getControlPanel());
        CoreRibbonResizePolicies.Mid2Low r2 = new CoreRibbonResizePolicies.Mid2Low((JBandControlPanel)band.getControlPanel());
        return new Vector<RibbonBandResizePolicy>(Arrays.asList(r1, r2));
    }

    public static ResizableIcon getResizableIconFromResource(URL resource) {
        return RibbonFactory.getResizableIconFromResource(resource, new Dimension(48, 48));
    }

    public static ResizableIcon getResizableIconFromResource(String resource) {
        return RibbonFactory.getResizableIconFromResource(RibbonFactory.class.getClassLoader().getResource(resource), new Dimension(48, 48));
    }

    public static ResizableIcon getResizableIconFromResource(URL resource, Dimension size) {
        return ImageWrapperResizableIcon.getIcon(resource, size);
    }
}

