/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon.appmenu;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class BasicRibbonApplicationMenuButtonUI
extends BasicCommandButtonUI {
    protected JRibbonApplicationMenuButton applicationMenuButton;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonApplicationMenuButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.applicationMenuButton = (JRibbonApplicationMenuButton)c;
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Border border = this.commandButton.getBorder();
        if (border == null || border instanceof UIResource) {
            Border toInstall = UIManager.getBorder("RibbonApplicationMenuButton.border");
            if (toInstall == null) {
                toInstall = new BorderUIResource.EmptyBorderUIResource(4, 4, 4, 4);
            }
            this.commandButton.setBorder(toInstall);
        }
        this.commandButton.setOpaque(false);
    }

    @Override
    protected void configureRenderer() {
        this.buttonRendererPane = new CellRendererPane();
        this.commandButton.add(this.buttonRendererPane);
        this.rendererButton = new JButton("");
    }

    @Override
    protected void unconfigureRenderer() {
        this.commandButton.remove(this.buttonRendererPane);
        this.buttonRendererPane = null;
        this.rendererButton = null;
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        final JRibbonApplicationMenuButton appMenuButton = (JRibbonApplicationMenuButton)this.commandButton;
        appMenuButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(final JCommandButton commandButton) {
                JRibbonFrame ribbonFrame = (JRibbonFrame)SwingUtilities.getWindowAncestor(commandButton);
                final JRibbon ribbon = ribbonFrame.getRibbon();
                RibbonApplicationMenu ribbonMenu = ribbon.getApplicationMenu();
                final JRibbonApplicationMenuPopupPanel menuPopupPanel = new JRibbonApplicationMenuPopupPanel(appMenuButton, ribbonMenu);
                menuPopupPanel.applyComponentOrientation(appMenuButton.getComponentOrientation());
                menuPopupPanel.setCustomizer(new JPopupPanel.PopupPanelCustomizer(){

                    @Override
                    public Rectangle getScreenBounds() {
                        int ph;
                        boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
                        int pw = menuPopupPanel.getPreferredSize().width;
                        int x = ltr ? ribbon.getLocationOnScreen().x : ribbon.getLocationOnScreen().x + ribbon.getWidth() - pw;
                        int y = commandButton.getLocationOnScreen().y + commandButton.getSize().height / 2 + 2;
                        Rectangle scrBounds = commandButton.getGraphicsConfiguration().getBounds();
                        if (x + pw > scrBounds.x + scrBounds.width) {
                            x = scrBounds.x + scrBounds.width - pw;
                        }
                        if (y + (ph = menuPopupPanel.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                            y = scrBounds.y + scrBounds.height - ph;
                        }
                        return new Rectangle(x, y, menuPopupPanel.getPreferredSize().width, menuPopupPanel.getPreferredSize().height);
                    }
                });
                return menuPopupPanel;
            }
        });
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        Insets ins = c.getInsets();
        this.paintButtonBackground(g2d, new Rectangle(ins.left, ins.top, c.getWidth() - ins.left - ins.right, c.getHeight() - ins.top - ins.bottom));
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, g);
        this.commandButton.putClientProperty("icon.bounds", this.layoutInfo.iconRect);
        this.paintButtonIcon(g2d, this.layoutInfo.iconRect);
        g2d.dispose();
    }

    @Override
    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        this.buttonRendererPane.setBounds(toFill.x, toFill.y, toFill.width, toFill.height);
        ButtonModel model = this.rendererButton.getModel();
        model.setEnabled(true);
        model.setSelected(this.applicationMenuButton.getPopupModel().isSelected());
        model.setRollover(this.applicationMenuButton.getPopupModel().isRollover());
        model.setPressed(this.applicationMenuButton.getPopupModel().isPressed() || this.applicationMenuButton.getPopupModel().isPopupShowing());
        model.setArmed(this.applicationMenuButton.getActionModel().isArmed());
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(toFill.x, toFill.y);
        Shape clip = g2d.getClip();
        g2d.clip(new Ellipse2D.Double(0.0, 0.0, toFill.width, toFill.height));
        this.rendererButton.setBorderPainted(false);
        this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.applicationMenuButton, -toFill.width / 2, -toFill.height / 2, 2 * toFill.width, 2 * toFill.height, true);
        g2d.setColor(FlamingoUtilities.getBorderColor().darker());
        g2d.setClip(clip);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.draw(new Ellipse2D.Double(0.0, 0.0, toFill.width, toFill.height));
        g2d.dispose();
    }
}

