/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.component;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import uk.co.caprica.vlcj.binding.RuntimeUtil;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.component.EmbeddedMediaPlayerComponentBase;
import uk.co.caprica.vlcj.player.component.InputEvents;
import uk.co.caprica.vlcj.player.component.MediaPlayerComponent;
import uk.co.caprica.vlcj.player.component.MediaPlayerComponentDefaults;
import uk.co.caprica.vlcj.player.component.MediaPlayerSpecs;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.fullscreen.FullScreenStrategy;

public class EmbeddedMediaPlayerComponent
extends EmbeddedMediaPlayerComponentBase
implements MediaPlayerComponent {
    static final String[] DEFAULT_FACTORY_ARGUMENTS = MediaPlayerComponentDefaults.EMBEDDED_MEDIA_PLAYER_ARGS;
    private final boolean ownFactory;
    protected final MediaPlayerFactory mediaPlayerFactory;
    private final Component videoSurfaceComponent;
    private final EmbeddedMediaPlayer mediaPlayer;

    public EmbeddedMediaPlayerComponent(MediaPlayerFactory mediaPlayerFactory, Component videoSurfaceComponent, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, Window overlay) {
        this.ownFactory = mediaPlayerFactory == null;
        this.mediaPlayerFactory = this.initMediaPlayerFactory(mediaPlayerFactory);
        this.videoSurfaceComponent = this.initVideoSurfaceComponent(videoSurfaceComponent);
        this.mediaPlayer = this.onCreateMediaPlayer();
        this.mediaPlayer.videoSurface().set(this.mediaPlayerFactory.videoSurfaces().newVideoSurface(this.videoSurfaceComponent));
        this.mediaPlayer.fullScreen().strategy(fullScreenStrategy);
        this.mediaPlayer.overlay().set(overlay);
        this.mediaPlayer.events().addMediaPlayerEventListener(this);
        this.mediaPlayer.events().addMediaEventListener(this);
        this.setBackground(Color.black);
        this.setLayout(new BorderLayout());
        this.add(this.videoSurfaceComponent, "Center");
        this.initInputEvents(inputEvents);
        this.onAfterConstruct();
    }

    public EmbeddedMediaPlayerComponent(MediaPlayerSpecs.EmbeddedMediaPlayerSpec spec) {
        this(spec.factory, spec.videoSurfaceComponent, spec.fullScreenStrategy, spec.inputEvents, spec.overlay);
    }

    public EmbeddedMediaPlayerComponent(String ... libvlcArgs) {
        this(new MediaPlayerFactory(libvlcArgs), null, null, null, null);
    }

    public EmbeddedMediaPlayerComponent() {
        this((MediaPlayerFactory)null, (Component)null, (FullScreenStrategy)null, (InputEvents)null, (Window)null);
    }

    private MediaPlayerFactory initMediaPlayerFactory(MediaPlayerFactory mediaPlayerFactory) {
        if (mediaPlayerFactory == null) {
            mediaPlayerFactory = new MediaPlayerFactory(DEFAULT_FACTORY_ARGUMENTS);
        }
        return mediaPlayerFactory;
    }

    private Component initVideoSurfaceComponent(Component videoSurfaceComponent) {
        if (videoSurfaceComponent == null) {
            videoSurfaceComponent = new Canvas();
            videoSurfaceComponent.setBackground(Color.black);
        }
        return videoSurfaceComponent;
    }

    private void initInputEvents(InputEvents inputEvents) {
        if (inputEvents == null) {
            inputEvents = RuntimeUtil.isNix() || RuntimeUtil.isMac() ? InputEvents.DEFAULT : InputEvents.DISABLE_NATIVE;
        }
        switch (inputEvents) {
            case NONE: {
                break;
            }
            case DISABLE_NATIVE: {
                this.mediaPlayer.input().enableKeyInputHandling(false);
                this.mediaPlayer.input().enableMouseInputHandling(false);
            }
            case DEFAULT: {
                this.videoSurfaceComponent.addMouseListener(this);
                this.videoSurfaceComponent.addMouseMotionListener(this);
                this.videoSurfaceComponent.addMouseWheelListener(this);
                this.videoSurfaceComponent.addKeyListener(this);
            }
        }
    }

    public final EmbeddedMediaPlayer mediaPlayer() {
        return this.mediaPlayer;
    }

    public final Component videoSurfaceComponent() {
        return this.videoSurfaceComponent;
    }

    public final void release() {
        this.onBeforeRelease();
        this.videoSurfaceComponent.removeMouseListener(this);
        this.videoSurfaceComponent.removeMouseMotionListener(this);
        this.videoSurfaceComponent.removeMouseWheelListener(this);
        this.videoSurfaceComponent.removeKeyListener(this);
        this.mediaPlayer.release();
        if (this.ownFactory) {
            this.mediaPlayerFactory.release();
        }
        this.onAfterRelease();
    }

    @Override
    public final MediaPlayerFactory mediaPlayerFactory() {
        return this.mediaPlayerFactory;
    }

    protected EmbeddedMediaPlayer onCreateMediaPlayer() {
        return this.mediaPlayerFactory.mediaPlayers().newEmbeddedMediaPlayer();
    }
}

