/*
 * Decompiled with CFR 0.152.
 */
package com.realityinteractive.imageio.tga;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class TGAHeader {
    private int idLength;
    private byte[] id;
    private boolean hasColorMap;
    private int imageType;
    private boolean isCompressed;
    private int firstColorMapEntryIndex;
    private int numberColorMapEntries;
    private int bitsPerColorMapEntry;
    private int colorMapEntrySize;
    private int colorMapSize;
    private int xOrigin;
    private int yOrigin;
    private int width;
    private int height;
    private int bitsPerPixel;
    private int imageDescriptor;
    private boolean leftToRight;
    private boolean bottomToTop;
    private int colorMapDataOffset;
    private int pixelDataOffset;

    public TGAHeader() {
    }

    public TGAHeader(ImageInputStream inputStream) throws IOException {
        this.readHeader(inputStream);
    }

    public void readHeader(ImageInputStream inputStream) throws IOException {
        this.idLength = inputStream.readUnsignedByte();
        this.hasColorMap = inputStream.readUnsignedByte() == 1;
        this.imageType = inputStream.readUnsignedByte();
        this.firstColorMapEntryIndex = inputStream.readUnsignedShort();
        this.numberColorMapEntries = inputStream.readUnsignedShort();
        this.bitsPerColorMapEntry = inputStream.readByte();
        this.xOrigin = inputStream.readUnsignedShort();
        this.yOrigin = inputStream.readUnsignedShort();
        this.width = inputStream.readUnsignedShort();
        this.height = inputStream.readUnsignedShort();
        this.bitsPerPixel = inputStream.readByte();
        this.imageDescriptor = inputStream.readByte();
        this.isCompressed = this.imageType == 9 || this.imageType == 10 || this.imageType == 11;
        switch (this.bitsPerColorMapEntry) {
            default: {
                this.colorMapEntrySize = 1;
                break;
            }
            case 15: 
            case 16: {
                this.colorMapEntrySize = 2;
                break;
            }
            case 24: 
            case 32: {
                this.colorMapEntrySize = 3;
            }
        }
        this.colorMapSize = this.colorMapEntrySize * this.numberColorMapEntries;
        this.leftToRight = (this.imageDescriptor & 0x10) == 0;
        boolean bl = this.bottomToTop = (this.imageDescriptor & 0x20) == 0;
        if (this.idLength > 0) {
            this.id = new byte[this.idLength];
            inputStream.read(this.id, 0, this.idLength);
        }
        long currentOffset = inputStream.getStreamPosition();
        this.colorMapDataOffset = (int)currentOffset;
        this.pixelDataOffset = this.hasColorMap ? this.colorMapDataOffset + this.colorMapSize : (int)currentOffset;
    }

    public int getIdLength() {
        return this.idLength;
    }

    public boolean hasColorMap() {
        return this.hasColorMap;
    }

    public int getImageType() {
        return this.imageType;
    }

    public String getImageTypeString() {
        switch (this.imageType) {
            case 0: {
                return "NO IMAGE";
            }
            case 1: {
                return "COLOR MAP";
            }
            case 2: {
                return "TRUE COLOR";
            }
            case 3: {
                return "MONOCHROME";
            }
            case 9: {
                return "RLE COMPRESSED COLOR MAP";
            }
            case 10: {
                return "RLE COMPRESSED TRUE COLOR";
            }
            case 11: {
                return "RLE COMPRESSED MONOCHROME";
            }
        }
        return "UNKNOWN";
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public int getFirstColorMapEntryIndex() {
        return this.firstColorMapEntryIndex;
    }

    public int getColorMapLength() {
        return this.numberColorMapEntries;
    }

    public int getBitsPerColorMapEntry() {
        return this.bitsPerColorMapEntry;
    }

    public int getXOrigin() {
        return this.xOrigin;
    }

    public int getYOrigin() {
        return this.yOrigin;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getSamplesPerPixel() {
        return this.bitsPerPixel == 32 ? 4 : 3;
    }

    public int getImageDescriptor() {
        return this.imageDescriptor;
    }

    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public boolean isBottomToTop() {
        return this.bottomToTop;
    }

    public int getColorMapDataOffset() {
        return this.colorMapDataOffset;
    }

    public int getPixelDataOffset() {
        return this.pixelDataOffset;
    }

    public String debugString() {
        return "TGAHeader[type=" + this.getImageTypeString() + ", " + (this.hasColorMap ? "firstColorMapEntryIndex=" + this.firstColorMapEntryIndex + ", numberColorMapEntries=" + this.numberColorMapEntries + ", bitsPerColorMapEntry=" + this.bitsPerColorMapEntry + ", totalColorMapEntrySize=" + this.colorMapSize + ", " : "") + "isCompressed=" + this.isCompressed + ", xOrigin=" + this.xOrigin + ", yOrigin=" + this.yOrigin + ", width=" + this.width + ", height=" + this.height + ", bitsPerPixel=" + this.bitsPerPixel + ", samplesPerPixel=" + this.getSamplesPerPixel() + "]";
    }
}

