/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.truetype;

import java.io.IOException;
import org.doubletype.ossa.truetype.FontFormatWriter;
import org.doubletype.ossa.truetype.HeadWriter;

public class OS2Writer
extends FontFormatWriter {
    final int FW_THIN = 100;
    final int FW_EXTRALIGHT = 200;
    final int FW_LIGHT = 300;
    final int FW_NORMAL = 400;
    final int FW_MEDIUM = 500;
    final int FW_SEMIBOLD = 600;
    final int FW_BOLD = 700;
    final int FW_EXTRABOLD = 800;
    final int FW_BLACK = 900;
    final int FWIDTH_NORMAL = 5;
    final int k_editableEmbedding = 8;
    final int k_sansSerif = 2048;
    final int k_basicLatin = 1;
    final int k_latin1Supplement = 2;
    final int k_regular = 64;
    final int k_basicLatinStart = 32;
    final int k_basciLatinEnd = 126;
    private HeadWriter m_head;
    int m_xAvgCharWidth = 512;
    int m_usWeightClass = 400;
    int m_usWidthClass = 5;
    int m_fsType = 0;
    int m_ySubscriptXSize = 128;
    int m_ySubscriptYSize = 128;
    int m_ySubscriptXOffset = 0;
    int m_ySubscriptYOffset = -64;
    int m_ySuperscriptXSize = 128;
    int m_ySuperscriptYSize = 128;
    int m_ySuperscriptXOffset = 0;
    int m_ySuperscriptYOffset = 64;
    int m_yStrikeoutSize = 51;
    int m_yStrikeoutPosition = 512;
    int m_sFamilyClass = 2048;
    long m_ulUnicodeRange1 = 3L;
    long m_ulUnicodeRange2 = 0L;
    long m_ulUnicodeRange3 = 0L;
    long m_ulUnicodeRange4 = 0L;
    String m_vendId = "dtyp";
    int m_fsSelection = 64;
    int m_usFirstCharIndex = 32;
    int m_usLastCharIndex = 126;
    private int m_sTypoAscender = 1024;
    private int m_sTypoDescender = 0;
    private int m_sTypoLineGap = 0;
    private int m_usWinAscent = 1024;
    private int m_usWinDescent = 0;
    long m_ulCodePageRange1 = 0L;
    long m_ulCodePageRange2 = 0L;
    private int m_sxHeight = 512;
    private int m_sCapHeight = 1024;
    int m_usDefaultChar = 0;
    int m_usBreakChar = 32;
    int m_usMaxContext = 1;

    public OS2Writer(HeadWriter a_head) {
        this.m_head = a_head;
    }

    public void setCapHeight(int a_value) {
        this.m_sCapHeight = a_value;
    }

    public void setXHeight(int a_value) {
        this.m_sxHeight = a_value;
    }

    public void setTypoAscender(int a_value) {
        this.m_sTypoAscender = a_value;
    }

    public void setTypoDescender(int a_value) {
        this.m_sTypoDescender = a_value;
    }

    public void setTypoLineGap(int a_value) {
        this.m_sTypoLineGap = a_value;
    }

    public void setUnicodeRangeFlag(int a_pos) {
        int which = a_pos / 32;
        int where = a_pos % 32;
        long what = 1 << where;
        switch (which) {
            case 0: {
                this.m_ulUnicodeRange1 |= what;
                break;
            }
            case 1: {
                this.m_ulUnicodeRange2 |= what;
                break;
            }
            case 2: {
                this.m_ulUnicodeRange3 |= what;
                break;
            }
            case 3: {
                this.m_ulUnicodeRange4 |= what;
            }
        }
    }

    public void setCodePageRangeFlag(int a_pos) {
        int which = a_pos / 32;
        int where = a_pos % 32;
        long what = 1 << where;
        switch (which) {
            case 0: {
                this.m_ulCodePageRange1 |= what;
                break;
            }
            case 1: {
                this.m_ulCodePageRange2 |= what;
            }
        }
    }

    @Override
    public void write() throws IOException {
        this.m_usWinAscent = this.m_head.getMax().y;
        this.m_usWinDescent = 0;
        if (this.m_head.getMin().y < 0) {
            this.m_usWinDescent = -this.m_head.getMin().y;
        }
        this.writeUInt16(2);
        this.writeInt16(this.m_xAvgCharWidth);
        this.writeUInt16(this.m_usWeightClass);
        this.writeUInt16(this.m_usWidthClass);
        this.writeInt16(this.m_fsType);
        this.writeInt16(this.m_ySubscriptXSize);
        this.writeInt16(this.m_ySubscriptYSize);
        this.writeInt16(this.m_ySubscriptXOffset);
        this.writeInt16(this.m_ySubscriptYOffset);
        this.writeInt16(this.m_ySuperscriptXSize);
        this.writeInt16(this.m_ySuperscriptYSize);
        this.writeInt16(this.m_ySuperscriptXOffset);
        this.writeInt16(this.m_ySuperscriptYOffset);
        this.writeInt16(this.m_yStrikeoutSize);
        this.writeInt16(this.m_yStrikeoutPosition);
        this.writeInt16(this.m_sFamilyClass);
        this.writePanose();
        this.writeUInt32(this.m_ulUnicodeRange1);
        this.writeUInt32(this.m_ulUnicodeRange2);
        this.writeUInt32(this.m_ulUnicodeRange3);
        this.writeUInt32(this.m_ulUnicodeRange4);
        this.writeTag(this.m_vendId);
        this.writeUInt16(this.m_fsSelection);
        this.writeUInt16(this.m_usFirstCharIndex);
        this.writeUInt16(this.m_usLastCharIndex);
        this.writeUInt16(this.m_sTypoAscender);
        this.writeUInt16(this.m_sTypoDescender);
        this.writeUInt16(this.m_sTypoLineGap);
        this.writeUInt16(this.m_usWinAscent);
        this.writeUInt16(this.m_usWinDescent);
        this.writeUInt32(this.m_ulCodePageRange1);
        this.writeUInt32(this.m_ulCodePageRange2);
        this.writeInt16(this.m_sxHeight);
        this.writeInt16(this.m_sCapHeight);
        this.writeUInt16(this.m_usDefaultChar);
        this.writeUInt16(this.m_usBreakChar);
        this.writeUInt16(this.m_usMaxContext);
        this.pad();
    }

    private void writePanose() throws IOException {
        this.writeUInt8(0);
        this.writeUInt8(0);
        this.writeUInt8(0);
        this.writeUInt8(0);
        this.writeUInt8(0);
        this.writeUInt8(0);
        this.writeUInt8(0);
        this.writeUInt8(0);
        this.writeUInt8(0);
        this.writeUInt8(0);
    }

    @Override
    protected String getTag() {
        return "OS/2 ";
    }
}

