/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.StringTooLongException;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoundingBox
extends Rectangle {
    public static final int LINE_SPACING_PERCENTAGE = 20;
    public static final int VERT_ALIGN_CENTER = 0;
    public static final int VERT_ALIGN_TOP = 1;
    public static final int VERT_ALIGN_BOTTOM = 2;
    public static final int HORIZ_ALIGN_CENTER = 3;
    public static final int HORIZ_ALIGN_LEFT = 4;
    public static final int HORIZ_ALIGN_RIGHT = 5;
    public static final int SUBTRACT_FROM_TOP = 6;
    public static final int SUBTRACT_FROM_BOTTOM = 7;
    public static final int SUBTRACT_FROM_LEFT = 8;
    public static final int SUBTRACT_FROM_RIGHT = 9;
    private static final int[] VERT_ALIGNS = new int[]{0, 1, 2};
    private static final int[] HORIZ_ALIGNS = new int[]{3, 4, 5};
    private static final int[] SUBTRACTS = new int[]{6, 7, 8, 9};
    private Point drawingPoint;
    private Point absoluteLocation;
    private BoundingBox parent;
    private String[] stringArray;
    private String fullString;

    public BoundingBox(Point p, Dimension d) {
        super(p, d);
        this.drawingPoint = this.getLocation();
        this.absoluteLocation = this.getLocation();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public BoundingBox getParent() {
        return this.parent;
    }

    public void add(BoundingBox child) {
        child.setParent(this);
    }

    public void setParent(BoundingBox parent) {
        if (this == parent) {
            return;
        }
        this.parent = parent;
        if (this.getLocation().equals(this.getAbsoluteLocation())) {
            int ancestorTranslateX = 0;
            int ancestorTranslateY = 0;
            BoundingBox ancestor = this;
            while (ancestor.hasParent()) {
                BoundingBox oldRef = ancestor;
                if ((ancestor = ancestor.getParent()) == oldRef) break;
                ancestorTranslateX += (int)ancestor.getLocation().getX();
                ancestorTranslateY += (int)ancestor.getLocation().getY();
            }
            this.getAbsoluteLocation().translate(ancestorTranslateX, ancestorTranslateY);
        }
    }

    public String[] getStringArray() {
        return this.stringArray;
    }

    public void setStringArray(String[] strArray) {
        this.stringArray = strArray;
    }

    public void setAbsoluteLocation(Point point) {
        this.absoluteLocation = point;
    }

    public boolean boxExists() {
        return this.getHeight() > 0.0 && this.getWidth() > 0.0;
    }

    public Point getAbsoluteLocation() {
        return this.absoluteLocation;
    }

    public String getFullString() {
        return this.fullString;
    }

    public void setFullString(String string) {
        this.fullString = string;
    }

    public BoundingBox getStringBounds(String string, int hAlign, int vAlign, FontMetrics fm, int padding, boolean enforce) throws IllegalArgumentException, StringTooLongException {
        if (!this.checkHAlign(hAlign)) {
            throw new IllegalArgumentException("BoundingBox.getStringBounds, hAlign invalid : " + hAlign);
        }
        if (!this.checkVAlign(vAlign)) {
            throw new IllegalArgumentException("BoundingBox.getStringBounds, vAlign invalid : " + hAlign);
        }
        if (fm == null) {
            throw new IllegalArgumentException("BoundingBox.getStringBounds, FontMetrics null");
        }
        if (string == null) {
            throw new IllegalArgumentException("BoundingBox.getStringBounds, String null");
        }
        Dimension parentSize = this.getSize();
        int sa = fm.getMaxAscent();
        int sw = fm.stringWidth(string);
        int sh = sa + fm.getMaxDescent();
        int pw = (int)parentSize.getWidth();
        int ph = (int)parentSize.getHeight();
        if (pw < 0) {
            throw new StringTooLongException("The parent box has a negative width  (" + pw + ")");
        }
        if (ph < 0) {
            throw new StringTooLongException("The parent box has a negative height (" + ph + ")");
        }
        int cw = sw + padding * 2;
        int ch = sh + padding * 2;
        int px = (int)this.getX();
        int py = (int)this.getY();
        String[] childStrArray = null;
        if (cw > pw || string.indexOf("\n") != -1) {
            cw = pw - padding * 2;
            childStrArray = this.createStringArray(string, fm, padding, pw);
            ch = this.getWrappedHeight(childStrArray, fm, padding);
            if (ch > ph && enforce) {
                throw new StringTooLongException("The wrapped strings do not fit into the parent box, pw=" + pw + ", ph=" + ph + ", ch=" + ch + ", cw=" + cw + ", string: " + string);
            }
        }
        int cy = vAlign == 1 ? 0 : (vAlign == 0 ? ph / 2 - ch / 2 : ph - ch);
        int cx = hAlign == 4 ? 0 : (hAlign == 3 ? pw / 2 - cw / 2 : pw - cw);
        Point childLocation = new Point(cx, cy);
        Dimension childSize = new Dimension(cw, ch);
        int ancestorTranslateX = 0;
        int ancestorTranslateY = 0;
        BoundingBox ancestor = this;
        while (ancestor.hasParent()) {
            BoundingBox oldRef = ancestor;
            if ((ancestor = ancestor.getParent()) == oldRef) break;
            ancestorTranslateX += (int)ancestor.getLocation().getX();
            ancestorTranslateY += (int)ancestor.getLocation().getY();
        }
        int abx = px + cx + ancestorTranslateX;
        int aby = py + cy + ancestorTranslateY;
        int dpx = abx + padding;
        int dpy = aby + padding + sa;
        Point drawingPoint = new Point(dpx, dpy);
        BoundingBox returnChild = new BoundingBox(childLocation, childSize, drawingPoint, new Point(abx, aby));
        this.add(returnChild);
        returnChild.setFullString(string);
        returnChild.setStringArray(childStrArray);
        return returnChild;
    }

    public BoundingBox getStringBounds(String string, int hAlign, int vAlign, FontMetrics fm, int padding) throws StringTooLongException, IllegalArgumentException {
        return this.getStringBounds(string, hAlign, vAlign, fm, padding, true);
    }

    public void drawWrappedString(Graphics g, FontMetrics fm, int padding, int hAlign) throws IllegalArgumentException, StringTooLongException {
        if (this.getStringArray() == null) {
            Point p = this.getDrawingPoint();
            int xx = (int)p.getX();
            int yy = (int)p.getY();
            g.drawString(this.getFullString(), xx, yy);
        } else {
            int len = this.stringArray.length;
            for (int i = 0; i < len; ++i) {
                BoundingBox wrappedBox = null;
                wrappedBox = this.getStringBounds(this.stringArray[i], hAlign, 1, fm, 0);
                Point pp = wrappedBox.getDrawingPoint();
                int xx = (int)pp.getX();
                if (hAlign == 5) {
                    xx -= padding;
                }
                if (hAlign == 4) {
                    xx += padding;
                }
                int yy = (int)pp.getY() + padding;
                g.drawString(this.stringArray[i], xx, yy);
                this.subtract(wrappedBox, 7);
            }
        }
    }

    public void drawWrappedStringTruncate(Graphics g, FontMetrics fm, int padding, int hAlign) {
        if (this.getStringArray() == null) {
            Point p = this.getDrawingPoint();
            int xx = (int)p.getX();
            int yy = (int)p.getY();
            if (this.getFullString() != null) {
                g.drawString(this.getFullString(), xx, yy);
            } else {
                System.err.println("getStringArray and getFullString are null");
            }
        } else {
            int totalHeight = 0;
            int len = this.stringArray.length;
            for (int i = 0; i < len; ++i) {
                BoundingBox wrappedBox = null;
                try {
                    wrappedBox = this.getStringBounds(this.stringArray[i], hAlign, 1, fm, 0, false);
                    if (this.getParent() != null && (totalHeight += (int)wrappedBox.getHeight()) > (int)this.getParent().getHeight()) {
                        return;
                    }
                }
                catch (StringTooLongException stle) {
                    stle.printStackTrace();
                    return;
                }
                wrappedBox.drawChoppedString(g, fm, padding, hAlign);
                this.subtract(wrappedBox, 7);
            }
        }
    }

    public void drawChoppedString(Graphics g, FontMetrics fm, int padding, int hAlign) {
        String string = "";
        string = this.getStringArray() != null ? new String(this.getStringArray()[0]) : new String(this.getFullString());
        BoundingBox choppedBox = null;
        try {
            choppedBox = this.getStringBounds(string, hAlign, 1, fm, padding);
            Point p = choppedBox.getDrawingPoint();
            int x = (int)p.getX();
            int y = (int)p.getY();
            g.drawString(string, x, y);
        }
        catch (StringTooLongException stle) {
            StringBuffer buf = new StringBuffer().append(string);
            if (buf.length() == 0) {
                System.out.println("BoundingBox.drawChoppedString, buf len 0 ??");
                throw new RuntimeException();
            }
            buf.deleteCharAt(buf.length() - 1);
            while (fm.stringWidth(buf.toString()) > (int)this.getWidth() && buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            try {
                choppedBox = this.getStringBounds(buf.toString(), hAlign, 1, fm, padding);
                Point pp = choppedBox.getDrawingPoint();
                int xx = (int)pp.getX();
                int yy = (int)pp.getY();
                g.drawString(string, xx, yy);
            }
            catch (StringTooLongException sstle) {
                sstle.printStackTrace();
            }
        }
    }

    private int getWrappedHeight(String[] strings, FontMetrics fm, int padding) {
        int ma = fm.getMaxAscent();
        int md = fm.getMaxDescent();
        int sh = ma + md;
        int hPad = sh / 20;
        int total = (sh += hPad) * strings.length;
        return total + padding * 2;
    }

    private String[] createStringArray(String string, FontMetrics fm, int padding, int pw) {
        if (string == null) {
            System.err.println("Tried createStringArray with null String");
            return null;
        }
        if (fm == null) {
            System.err.println("Tried createStringArray with null FontMetrics");
        }
        int lw = pw - padding * 2;
        Vector<String> returnVector = new Vector<String>();
        StringTokenizer st = new StringTokenizer(string, " \t\n\r\f", true);
        StringBuffer tempBuffer = new StringBuffer();
        StringBuffer finalBuffer = new StringBuffer();
        while (st.hasMoreTokens()) {
            String tempString = st.nextToken();
            tempBuffer.append(tempString);
            if (fm.stringWidth(tempBuffer.toString()) < lw && tempBuffer.toString().charAt(tempBuffer.toString().length() - 1) != '\n' && tempBuffer.toString().charAt(tempBuffer.toString().length() - 1) != '\r') {
                finalBuffer.append(tempString);
                continue;
            }
            returnVector.addElement(finalBuffer.toString());
            finalBuffer.delete(0, finalBuffer.length());
            tempBuffer.delete(0, tempBuffer.length());
            if (tempString.charAt(0) == '\n' || tempString.charAt(0) == '\r') continue;
            tempBuffer.append(tempString);
            finalBuffer.append(tempString);
        }
        returnVector.addElement(finalBuffer.toString());
        int len = returnVector.size();
        String[] childStrArray = new String[len];
        for (int i = 0; i < len; ++i) {
            String curStr;
            childStrArray[i] = curStr = (String)returnVector.get(i);
        }
        return childStrArray;
    }

    public BoundingBox subtract(BoundingBox child, int subtractFrom) {
        if (child == null) {
            throw new IllegalArgumentException("BoundingBox.subtract, BoundingBox child is null");
        }
        if (!child.hasParent()) {
            throw new IllegalArgumentException("BoundingBox.subtract, BoundingBox child has no parent");
        }
        if (child.getParent() != this) {
            throw new IllegalArgumentException("BoundingBox.subtract, this is not BoundingBox child's parent");
        }
        int len = SUBTRACTS.length;
        boolean valid = false;
        for (int i = 0; i < len; ++i) {
            if (subtractFrom != SUBTRACTS[i]) continue;
            valid = true;
        }
        if (!valid) {
            throw new IllegalArgumentException("BoundingBox.subtract, subtractFrom invalid: " + subtractFrom);
        }
        child.setParent(null);
        int cx = (int)child.getLocation().getX();
        int cy = (int)child.getLocation().getY();
        int cw = (int)child.getSize().getWidth();
        int ch = (int)child.getSize().getHeight();
        int px = (int)this.getLocation().getX();
        int py = (int)this.getLocation().getY();
        int pw = (int)this.getSize().getWidth();
        int ph = (int)this.getSize().getHeight();
        switch (subtractFrom) {
            case 8: {
                pw = cx;
                this.setSize(new Dimension(pw, ph));
                return this;
            }
            case 9: {
                px = px + cw + cx;
                pw = pw - cw - cx;
                this.setLocation(new Point(px, py));
                this.setSize(new Dimension(pw, ph));
                return this;
            }
            case 7: {
                py = py + ch + cy;
                ph = ph - ch - cy;
                this.setLocation(new Point(px, py));
                this.setSize(new Dimension(pw, ph));
                return this;
            }
            case 6: {
                ph = cy;
                this.setSize(new Dimension(pw, ph));
                return this;
            }
        }
        return this;
    }

    public Point getDrawingPoint() {
        return this.drawingPoint;
    }

    public static void main(String[] args) {
        Point upperLeft = new Point(5, 5);
        Dimension bounds = new Dimension(100, 100);
        BoundingBox parent = new BoundingBox(upperLeft, bounds);
        String string = "Hello World!";
        Font font = new Font("SansSerif", 0, 12);
        Frame frame = new Frame();
        frame.addNotify();
        try {
            Image image = frame.createImage(100, 100);
            if (image == null) {
                System.err.println("image is null");
            }
            Graphics graphics = image.getGraphics();
            FontMetrics fm = graphics.getFontMetrics(font);
            BoundingBox child = parent.getStringBounds(string, 4, 1, fm, 5);
            System.out.println("Drawing Point: " + child.getDrawingPoint().toString());
            System.out.println("Now testing subtract() method...");
            parent = new BoundingBox(new Point(10, 10), new Dimension(300, 300));
            System.out.println("parent: " + parent.toString());
            child = new BoundingBox(new Point(90, 110), new Dimension(100, 100));
            parent.add(child);
            System.out.println("child: " + child.toString());
            System.out.println();
            System.out.println("subtracting the child from the parent");
            System.out.println("SUBTRACT_FROM_TOP: ");
            parent = parent.subtract(child, 6);
            System.out.println("new parent: " + parent.toString());
            System.out.println();
            System.out.println("Resetting parent");
            parent = new BoundingBox(new Point(10, 10), new Dimension(300, 300));
            parent.add(child);
            System.out.println("SUBTRACT_FROM_BOTTOM");
            parent.subtract(child, 7);
            System.out.println("new parent: " + parent.toString());
            System.out.println();
            System.out.println("Resetting parent");
            parent = new BoundingBox(new Point(10, 10), new Dimension(300, 300));
            parent.add(child);
            System.out.println("SUBTRACT_FROM_LEFT");
            parent.subtract(child, 8);
            System.out.println("new parent: " + parent.toString());
            System.out.println();
            System.out.println("Resetting parent");
            parent = new BoundingBox(new Point(10, 10), new Dimension(300, 300));
            parent.add(child);
            System.out.println("SUBTRACT_FROM_RIGHT");
            parent.subtract(child, 9);
            System.out.println("new parent: " + parent.toString());
            System.out.println();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private BoundingBox(Point p, Dimension d, Point drawingPoint, Point absolute) {
        super(p, d);
        this.drawingPoint = drawingPoint;
        this.absoluteLocation = absolute;
    }

    private boolean checkHAlign(int hAlign) {
        int len = HORIZ_ALIGNS.length;
        for (int i = 0; i < len; ++i) {
            if (hAlign != HORIZ_ALIGNS[i]) continue;
            return true;
        }
        return false;
    }

    private boolean checkVAlign(int vAlign) {
        int len = VERT_ALIGNS.length;
        for (int i = 0; i < len; ++i) {
            if (vAlign != VERT_ALIGNS[i]) continue;
            return true;
        }
        return false;
    }
}

