/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.ImageInterpolate;
import gnu.jpdf.PDFEmbeddedFont;
import gnu.jpdf.PDFFont;
import gnu.jpdf.PDFGradientFunction3;
import gnu.jpdf.PDFImage;
import gnu.jpdf.PDFMask;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFPage;
import gnu.jpdf.PDFStream;
import gnu.jpdf.PDFStringHelper;
import gnu.jpdf.PdfGradientShading;
import gnu.jpdf.RawPrintWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDFGraphics
extends Graphics2D
implements Serializable {
    private static final double degrees_to_radians = Math.PI / 180;
    private static final int FILL = 1;
    private static final int STROKE = 2;
    private static final int CLIP = 3;
    private static final AffineTransform IDENTITY = new AffineTransform();
    private static final Stroke DEF_STROKE = new BasicStroke();
    private static final DecimalFormat df = new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final DecimalFormat matDf = new DecimalFormat("0", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final DecimalFormat colorDf = new DecimalFormat("#.#####", new DecimalFormatSymbols(Locale.ENGLISH));
    private Set<ImageInterpolate> usedImagesUseMainResources = new HashSet<ImageInterpolate>();
    private Color background;
    private boolean child;
    private Area clip;
    private AffineTransform clipTransform;
    protected Rectangle clipRectangle;
    private Color clipColor = null;
    private int clipAlpha = 255;
    private Composite composite;
    private Graphics2D dg2 = new BufferedImage(2, 2, 1).createGraphics();
    private Font font;
    private boolean inStroke;
    private boolean inText;
    private int lineCap = 0;
    private int lineJoin = 0;
    private float lineWidth = 1.0f;
    private float lx;
    private float ly;
    private float miterLimit = 10.0f;
    private boolean newFont;
    private PDFPage page;
    private Paint paint;
    private AffineTransform paintTransform;
    private PDFFont pdffont;
    private String pre_np;
    private AffineTransform pTransform;
    private RawPrintWriter pw;
    private RenderingHints rhints = new RenderingHints(null);
    private Stroke stroke;
    private AffineTransform transform;
    private float tx;
    private float ty;
    private String shading = null;
    private String pattern = null;
    private Set<Integer> usedAlphas = new HashSet<Integer>();
    private Set<String> gsBlendModes = new HashSet<String>();
    private int currentAlpha = 255;
    private Color currentColor = null;
    private String blendMode;
    private int shadingCount = 0;
    private int objId = 0;
    private boolean usePTransform = true;
    private static int[] srgbToLinear;
    private static int[] linearToSrgb;

    private static int convertSRGBtoLinearRGB(int color) {
        float input = (float)color / 255.0f;
        float output = input <= 0.04045f ? input / 12.92f : (float)Math.pow(((double)input + 0.055) / 1.055, 2.4);
        return Math.round(output * 255.0f);
    }

    private static int convertLinearRGBtoSRGB(int color) {
        float input = (float)color / 255.0f;
        float output = (double)input <= 0.0031308 ? input * 12.92f : 1.055f * (float)Math.pow(input, 0.4166666666666667) - 0.055f;
        return Math.round(output * 255.0f);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.rhints.putAll(hints);
    }

    public void arc(double axc, double ayc, double width, double height, double ang1, double ang2, boolean clockwise) {
        double w;
        double adiff;
        boolean first = true;
        double ang1r = ang1 % 360.0 * (Math.PI / 180);
        double sin0 = Math.sin(ang1r);
        double cos0 = Math.cos(ang1r);
        double x0 = axc + width * cos0;
        double y0 = ayc + height * sin0;
        if (!clockwise) {
            while (ang1 < ang2) {
                ang2 -= 360.0;
            }
            while (true) {
                double d;
                adiff = ang2 - ang1;
                if (d < -90.0) {
                    w = sin0;
                    sin0 = -cos0;
                    cos0 = w;
                    double x3r = axc + width * cos0;
                    double y3r = ayc + height * sin0;
                    this.arc_add(first, width, height, x0, y0, x3r, y3r, x0 + width * cos0, y0 + height * sin0);
                    x0 = x3r;
                    y0 = y3r;
                    ang1 -= 90.0;
                    first = false;
                    continue;
                }
                break;
            }
        } else {
            while (ang2 < ang1) {
                ang2 += 360.0;
            }
            while (true) {
                double d;
                adiff = ang2 - ang1;
                if (!(d > 90.0)) break;
                w = cos0;
                cos0 = -sin0;
                sin0 = w;
                double x3r = axc + width * cos0;
                double y3r = ayc + height * sin0;
                this.arc_add(first, width, height, x0, y0, x3r, y3r, x0 + width * cos0, y0 + height * sin0);
                x0 = x3r;
                y0 = y3r;
                ang1 += 90.0;
                first = false;
            }
        }
        double trad = Math.tan(adiff * (Math.PI / 360));
        double ang2r = ang2 * (Math.PI / 180);
        double xt = x0 - trad * width * sin0;
        double yt = y0 + trad * height * cos0;
        this.arc_add(first, width, height, x0, y0, axc + width * Math.cos(ang2r), ayc + height * Math.sin(ang2r), xt, yt);
    }

    private void arc_add(boolean first, double w, double h, double x0, double y0, double x3, double y3, double xt, double yt) {
        double dx = xt - x0;
        double dy = yt - y0;
        double dist = dx * dx + dy * dy;
        double w2 = w * w;
        double h2 = h * h;
        double r2 = w2 + h2;
        double fw = 0.0;
        double fh = 0.0;
        if (dist < r2 * 1.0E8) {
            fw = w2 != 0.0 ? 1.3333333333333333 / (1.0 + Math.sqrt(1.0 + dist / w2)) : 0.0;
            double d = fh = h2 != 0.0 ? 1.3333333333333333 / (1.0 + Math.sqrt(1.0 + dist / h2)) : 0.0;
        }
        if (first) {
            this.moveto(x0, y0);
        }
        double x = x0 + (xt - x0) * fw;
        double y = y0 + (yt - y0) * fh;
        x0 = x3 + (xt - x3) * fw;
        y0 = y3 + (yt - y3) * fh;
        this.curveto(x, y, x0, y0, x3, y3);
    }

    @Override
    public void clearRect(int x, int y, int w, int h) {
        this.closeBlock();
        this.pw.print("q 1 1 1 RG ");
        this.drawRect(x, y, w, h);
        this.closeBlock("B Q");
    }

    @Override
    public void clip(Shape s) {
        Area newClip;
        if (s == null) {
            this.setClip(null);
            return;
        }
        if (this.clip == null) {
            newClip = new Area(s);
        } else {
            newClip = (Area)this.clip.clone();
            newClip.intersect(new Area(s));
        }
        this.setClip(newClip);
    }

    public void clipPolygon(Polygon p) {
        this.closeBlock();
        this.polygon(p.xpoints, p.ypoints, p.npoints);
        this.closeBlock("W");
        this.clipRectangle = p.getBounds();
    }

    @Override
    public void clipRect(int x, int y, int w, int h) {
        this.setClip(x, y, w, h);
    }

    void closeBlock() {
        this.closeBlock("S");
    }

    void closeBlock(String code) {
        if (this.inText) {
            this.pw.println("ET Q");
        }
        if (this.inStroke) {
            this.pw.println(code);
        }
        this.inText = false;
        this.inStroke = false;
    }

    @Override
    public void copyArea(int x, int y, int w, int h, int dx, int dy) {
    }

    @Override
    public Graphics create() {
        this.closeBlock();
        PDFGraphics g = this.createGraphic(this.page, this.pw);
        g.clipRectangle = new Rectangle(this.clipRectangle);
        return g;
    }

    protected PDFGraphics createGraphic(PDFPage page, RawPrintWriter pw) {
        PDFGraphics g = new PDFGraphics();
        g.init(page, pw);
        return g;
    }

    public void curveto(double x1, double y1, double x2, double y2) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + "v");
        this.lx = (float)x2;
        this.ly = (float)y2;
    }

    public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + this.cxy(x3, y3) + "c");
        this.lx = (float)x3;
        this.ly = (float)y3;
    }

    public void curveto(int x1, int y1, int x2, int y2) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + "v");
        this.lx = x2;
        this.ly = y2;
    }

    public void curveto(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + this.cxy(x3, y3) + "c");
        this.lx = x3;
        this.ly = y3;
    }

    public void curveto2(double x1, double y1, double x2, double y2) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + "y");
        this.lx = (float)x2;
        this.ly = (float)y2;
    }

    public void curveto2(int x1, int y1, int x2, int y2) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + "y");
        this.lx = x2;
        this.ly = y2;
    }

    private String cwh(double w, double h) {
        return "" + df.format(w) + " " + df.format(h) + " ";
    }

    private String cwh(int w, int h) {
        return this.cwh((double)w, (double)h);
    }

    private String cxy(double x, double y) {
        return "" + df.format(x) + " " + df.format(y) + " ";
    }

    private String cxy(int x, int y) {
        return this.cxy((double)x, (double)y);
    }

    @Override
    public void dispose() {
        this.closeBlock();
        if (this.clip != null) {
            this.restoreState();
        }
        if (this.child) {
            this.pw.println("Q");
        } else {
            this.pw.close();
        }
    }

    @Override
    public void draw(Shape s) {
        this.followPath(s, 2);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
    }

    @Override
    public void drawArc(int x, int y, int w, int h, int sa, int aa) {
        this.arc(x += (w >>= 1), y += (h >>= 1), w, h, -sa, -sa - aa, false);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape s = g.getOutline(x, y);
        this.fill(s);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage result = img;
        if (op != null) {
            result = op.createCompatibleDestImage(img, img.getColorModel());
            result = op.filter(img, result);
        }
        this.drawImage((Image)result, x, y, null);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver obs) {
        return this.drawImage(img, x, y, img.getWidth(obs), img.getHeight(obs), bgcolor, obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver obs) {
        return this.drawImage(img, x, y, img.getWidth(obs), img.getHeight(obs), obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, Color bgcolor, ImageObserver obs) {
        this.closeBlock();
        this.pw.print("q ");
        Color c = this.getColor();
        this.setColor(bgcolor);
        this.drawRect(x, y, w, h);
        this.closeBlock("B Q");
        this.paint = c;
        return this.drawImage(img, x, y, img.getWidth(obs), img.getHeight(obs), obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver obs) {
        AffineTransform newTransform;
        PDFImage image;
        boolean interpolate;
        this.closeBlock();
        Object interpolationHint = this.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        boolean bl = interpolate = interpolationHint == RenderingHints.VALUE_INTERPOLATION_BILINEAR || interpolationHint == RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        if (this.page.getPDFDocument().isImageCached(img, interpolate)) {
            image = this.page.getPDFDocument().getCachedImage(img, interpolate);
            if (!this.usedImagesUseMainResources.contains(new ImageInterpolate(img, interpolate))) {
                this.page.addToProcset("/ImageC");
                this.page.addImageResource(image.getName() + " " + image.getSerialID() + " 0 R");
                this.usedImagesUseMainResources.add(new ImageInterpolate(img, interpolate));
            }
        } else {
            byte[] jpegImageData = this.getImageJpegData(img);
            byte[] alphaChannel = null;
            if (jpegImageData != null) {
                alphaChannel = this.getImageAlphaChannel(img);
            }
            PDFMask mask = alphaChannel == null ? new PDFMask(img) : new PDFMask(alphaChannel, img.getWidth(null), img.getHeight(null));
            this.page.getPDFDocument().add(mask);
            image = jpegImageData != null ? new PDFImage(jpegImageData, x, y, w, h, obs, "" + mask.getSerialID() + " 0 R", interpolate) : new PDFImage(img, x, y, w, h, obs, "" + mask.getSerialID() + " 0 R", interpolate);
            this.page.getPDFDocument().setImageName(image);
            this.page.getPDFDocument().add(image);
            this.page.getPDFDocument().cacheImage(img, image);
            this.page.addToProcset("/ImageC");
            this.page.addImageResource(image.getName() + " " + image.getSerialID() + " 0 R");
            this.usedImagesUseMainResources.add(new ImageInterpolate(img, interpolate));
        }
        this.initAlpha(255);
        AffineTransform transformToSet = newTransform = new AffineTransform(w, 0.0f, 0.0f, -h, x, y + h);
        this.pw.print("q " + matDf.format(transformToSet.getScaleX()) + " " + matDf.format(transformToSet.getShearY()) + " " + matDf.format(transformToSet.getShearX()) + " " + matDf.format(transformToSet.getScaleY()) + " " + matDf.format(transformToSet.getTranslateX()) + " " + matDf.format(transformToSet.getTranslateY()) + " cm \n" + image.getName() + " Do\nQ\n");
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver obs) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver obs) {
        BufferedImage bimg = PDFGraphics.toBufferedImage(img);
        BufferedImage subImg = bimg.getSubimage(sx1, sy1, sx2 - sx1, sy2 - sy1);
        return this.drawImage(subImg, dx1, dy1, dx2 - dx1, dy2 - dy1, null);
    }

    private static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.moveto(x1, y1);
        this.lineto(x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int w, int h) {
        this.drawArc(x, y, w, h, 0, 360);
    }

    @Override
    public void drawPolygon(int[] xp, int[] yp, int np) {
        this.polygon(xp, yp, np);
        this.closeBlock("s");
    }

    @Override
    public void drawPolyline(int[] xp, int[] yp, int np) {
        this.polygon(xp, yp, np);
    }

    @Override
    public void drawRect(int x, int y, int w, int h) {
        this.draw(new Rectangle(x, y, w, h));
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage image = null;
        if (img instanceof BufferedImage) {
            image = (BufferedImage)img;
        } else {
            ColorModel cm = img.getColorModel();
            int width = img.getWidth();
            int height = img.getHeight();
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            String[] keys = img.getPropertyNames();
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    properties.put(keys[i], img.getProperty(keys[i]));
                }
            }
            BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
            img.copyData(raster);
            image = result;
        }
        this.drawImage(image, xform, null);
    }

    @Override
    public void drawRoundRect(int x, int y, int w, int h, int aw, int ah) {
    }

    @Override
    public void drawString(AttributedCharacterIterator aci, float x, float y) {
    }

    @Override
    public void drawString(AttributedCharacterIterator aci, int x, int y) {
    }

    public void drawStringWithMode(String s, float x, float y, int mode) {
        this.newTextBlock(x, y);
        if (mode > -1) {
            this.pw.println("" + mode + " Tr");
        }
        if (this.pdffont instanceof PDFEmbeddedFont) {
            this.pw.print("[(");
            this.pw.printRaw(PDFStringHelper.makeRawPDFString(s));
            this.pw.println(")] TJ");
        } else {
            this.pw.print(PDFStringHelper.makePDFString(s));
            this.pw.println(" Tj");
        }
        this.closeBlock();
    }

    @Override
    public void drawString(String s, float x, float y) {
        this.drawStringWithMode(s, x, y, -1);
    }

    @Override
    public void drawString(String s, int x, int y) {
        this.drawString(s, (float)x, (float)y);
    }

    public void drawTransparentString(String s, float x, float y) {
        this.drawStringWithMode(s, x, y, 3);
    }

    public void drawTransparentString(String s, int x, int y) {
        this.drawTransparentString(s, (float)x, (float)y);
    }

    @Override
    public void fill(Shape s) {
        this.followPath(s, 1);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
    }

    @Override
    public void fillArc(int x, int y, int w, int h, int sa, int aa) {
        this.closeBlock();
        this.patternFill(null);
        this.drawArc(x, y, w, h, sa, aa);
        this.lineto(x + (w >> 1), y + (h >> 1));
        if (this.shadingFill(null)) {
            return;
        }
        this.closeBlock("b");
    }

    @Override
    public void fillOval(int x, int y, int w, int h) {
        this.fillArc(x, y, w, h, 0, 360);
    }

    @Override
    public void fillPolygon(int[] xp, int[] yp, int np) {
        this.closeBlock();
        this.patternFill(null);
        this.polygon(xp, yp, np);
        if (this.shadingFill(null)) {
            return;
        }
        this.closeBlock("b");
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        this.fill(new Rectangle(x, y, w, h));
    }

    private void patternFill(Shape s) {
        if (this.pattern != null) {
            if (this.paint instanceof TexturePaint && (this.pattern.equals("texture") || !this.paintTransform.equals(this.transform))) {
                this.initTexturePaint((TexturePaint)this.paint);
                this.paintTransform = this.transform;
            }
            if (this.paint instanceof MultipleGradientPaint && (this.pattern.equals("gradient") || !this.paintTransform.equals(this.transform))) {
                this.initGradientPaint((MultipleGradientPaint)this.paint, s);
                this.paintTransform = this.transform;
            }
            this.pw.println("/Pattern cs");
            this.pw.println(this.pattern + " scn");
        }
    }

    private boolean shadingFill(Shape s) {
        if (this.pattern == null && this.shading != null) {
            this.saveState();
            this.pw.println("W n");
            if (this.paint instanceof MultipleGradientPaint && (this.shading.equals("gradient") || !this.paintTransform.equals(this.transform))) {
                this.initGradientPaint((MultipleGradientPaint)this.paint, s);
                this.paintTransform = this.transform;
            }
            this.pw.println(this.shading + " sh");
            this.restoreState();
            return true;
        }
        return false;
    }

    @Override
    public void fillRoundRect(int x, int y, int w, int h, int aw, int ah) {
    }

    private void followPath(Shape s, int drawType) {
        if (s == null) {
            return;
        }
        if (drawType == 1) {
            this.patternFill(s);
        }
        if (drawType == 2 && !(this.stroke instanceof BasicStroke)) {
            s = this.stroke.createStrokedShape(s);
            this.followPath(s, 1);
            return;
        }
        PathIterator points = s.getPathIterator(IDENTITY);
        int segments = 0;
        float[] coords = new float[6];
        while (!points.isDone()) {
            ++segments;
            int segtype = points.currentSegment(coords);
            switch (segtype) {
                case 4: {
                    this.pw.print("h ");
                    break;
                }
                case 3: {
                    this.curveto(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    this.lineto(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    this.moveto(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.curveto(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            points.next();
        }
        switch (drawType) {
            case 1: {
                if (segments <= 0) break;
                if (this.pattern == null && this.shading != null) {
                    this.saveState();
                    if (points.getWindingRule() == 0) {
                        this.closeBlock("W*");
                    } else {
                        this.closeBlock("W");
                    }
                    this.pw.println("n");
                    if (this.paint instanceof MultipleGradientPaint && (this.shading.equals("gradient") || !this.paintTransform.equals(this.transform))) {
                        this.initGradientPaint((MultipleGradientPaint)this.paint, s);
                        this.paintTransform = this.transform;
                    }
                    this.pw.println(this.shading + " sh");
                    this.restoreState();
                    return;
                }
                if (points.getWindingRule() == 0) {
                    this.closeBlock("f*");
                    break;
                }
                this.closeBlock("f");
                break;
            }
            case 2: {
                if (segments <= 0) break;
                this.closeBlock("S");
                break;
            }
            default: {
                if (segments == 0) {
                    this.drawRect(0, 0, 0, 0);
                }
                if (points.getWindingRule() == 0) {
                    this.closeBlock("W*");
                    break;
                }
                this.closeBlock("W");
            }
        }
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        return this.clip;
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clipRectangle;
    }

    @Override
    public Color getColor() {
        return this.paint instanceof Color ? (Color)this.paint : Color.black;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.dg2.getDeviceConfiguration();
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.setFont(new Font("SansSerif", 0, 12));
        }
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        Frame dummy = new Frame();
        dummy.addNotify();
        Image image = dummy.createImage(100, 100);
        if (image == null) {
            System.err.println("getFontMetrics: image is null");
        }
        Graphics graphics = image.getGraphics();
        return graphics.getFontMetrics(font);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        boolean antialias = RenderingHints.VALUE_TEXT_ANTIALIAS_ON.equals(this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
        boolean fractions = RenderingHints.VALUE_FRACTIONALMETRICS_ON.equals(this.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
        return new FontRenderContext(new AffineTransform(), antialias, fractions);
    }

    public PDFPage getPage() {
        return this.page;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key arg0) {
        return this.rhints.get(arg0);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.rhints;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public RawPrintWriter getWriter() {
        return this.pw;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            s = this.stroke.createStrokedShape(s);
        }
        Area area = new Area(s);
        if (this.clip != null) {
            area.intersect(this.clip);
        }
        return area.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    private void init() {
        PageFormat pf = this.page.getPageFormat();
        if (this.child) {
            this.pw.print("q ");
        }
        this.paint = Color.black;
        this.pTransform = new AffineTransform();
        this.pTransform.translate(0.0, pf.getHeight());
        this.pTransform.scale(1.0, -1.0);
        this.setNewTranform(new AffineTransform());
        this.setStroke(DEF_STROKE);
    }

    protected void init(PDFPage page) {
        this.page = page;
        this.child = false;
        PDFStream stream = new PDFStream();
        stream.setDeflate(true);
        page.getPDFDocument().add(stream);
        page.add(stream);
        this.pw = new RawPrintWriter(stream.getOutputStream());
        this.clipRectangle = page.getImageableArea();
        this.init();
    }

    protected void init(PDFPage page, RawPrintWriter pw) {
        this.page = page;
        this.pw = pw;
        this.child = true;
        this.init();
    }

    public void lineto(double x, double y) {
        this.newPath();
        this.pw.print(this.cxy(x, y) + "l ");
        this.lx = (float)x;
        this.ly = (float)y;
    }

    public void lineto(int x, int y) {
        this.newPath();
        if (this.lx != (float)x && this.ly != (float)y) {
            this.pw.print(this.cxy(x, y) + "l ");
        }
        this.lx = x;
        this.ly = y;
    }

    public void moveto(double x, double y) {
        this.newPath();
        this.pw.print(this.cxy(x, y) + "m ");
        this.lx = (float)x;
        this.ly = (float)y;
    }

    public void moveto(int x, int y) {
        this.newPath();
        if (this.lx != (float)x || this.ly != (float)y) {
            this.pw.print(this.cxy(x, y) + "m ");
        }
        this.lx = x;
        this.ly = y;
    }

    void newPath() {
        if (this.inText) {
            this.closeBlock();
        }
        if (!this.inStroke) {
            if (this.pre_np != null) {
                this.pw.print(this.pre_np);
                this.pre_np = null;
            }
            this.pw.print("n ");
        }
        this.inText = false;
        this.inStroke = true;
        this.ly = -9999.0f;
        this.lx = -9999.0f;
    }

    void newTextBlock(float x, float y) {
        if (this.inStroke) {
            this.closeBlock();
        }
        if (!this.inText) {
            this.getFont();
            this.pw.print("q BT ");
            this.ty = 0.0f;
            this.tx = 0.0f;
            AffineTransform tm = this.usePTransform ? new AffineTransform(this.pTransform) : new AffineTransform();
            this.pw.println("" + df.format(tm.getScaleX()) + " " + df.format(tm.getShearY()) + " " + df.format(tm.getShearX()) + " " + df.format(tm.getScaleY()) + " " + df.format(tm.getTranslateX()) + " " + df.format(tm.getTranslateY()) + " Tm");
            this.pw.print(this.txy(x, y) + "Td ");
        } else {
            this.pw.print(this.twh(x, y, this.tx, this.ty) + "Td ");
        }
        this.tx = x;
        this.ty = y;
        if (this.newFont || !this.inText) {
            this.pw.print(this.pdffont.getName() + " " + this.font.getSize() + " Tf ");
        }
        this.newFont = false;
        this.inStroke = false;
        this.inText = true;
    }

    public void polygon(int[] xp, int[] yp, int np) {
        this.moveto(xp[0], yp[0]);
        for (int i = 1; i < np; ++i) {
            this.lineto(xp[i], yp[i]);
        }
    }

    @Override
    public void rotate(double theta) {
        AffineTransform newTransform = new AffineTransform(this.transform);
        newTransform.rotate(theta);
        this.setNewTranform(newTransform);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        AffineTransform newTransform = new AffineTransform(this.transform);
        newTransform.rotate(theta, x, y);
        this.setNewTranform(newTransform);
    }

    @Override
    public void scale(double sx, double sy) {
        AffineTransform newTransform = new AffineTransform(this.transform);
        newTransform.scale(sx, sy);
        this.setNewTranform(newTransform);
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.setClip(new Rectangle(x, y, w, h));
    }

    @Override
    public void setClip(Shape s) {
        this.closeBlock();
        if (this.clip != null) {
            this.restoreState();
            AffineTransform currentTransform = this.transform;
            this.transform = this.clipTransform;
            this.currentColor = this.clipColor;
            this.currentAlpha = this.clipAlpha;
            this.setTransform(currentTransform);
        }
        if (s == null) {
            this.clip = null;
            this.clipRectangle = null;
            return;
        }
        this.clipTransform = this.transform;
        this.clip = new Area(s);
        this.clipRectangle = s.getBounds();
        this.clipColor = this.currentColor;
        this.clipAlpha = this.currentAlpha;
        this.saveState();
        this.followPath(s, 3);
        this.pw.println("n");
    }

    @Override
    public void setColor(Color c) {
        this.setPaint(c);
    }

    @Override
    public void setComposite(Composite comp) {
        this.composite = comp;
    }

    public void setDefaultLineWidth() {
        this.closeBlock();
        this.pw.println("1 w");
    }

    @Override
    public void setFont(Font f) {
        if (this.font != f) {
            this.font = f;
            this.pdffont = this.page.getFont("/Type1", f.getName(), f.getStyle());
            this.newFont = true;
        }
    }

    public void setExistingTtfFont(Font f) {
        if (this.font != f) {
            this.font = f;
            this.pdffont = this.page.getFont("/TrueType", f.getName(), f.getStyle());
            this.newFont = true;
        }
    }

    public void setTtfFont(Font f, File file) throws IOException {
        if (this.font != f) {
            this.font = f;
            this.pdffont = this.page.getEmbeddedFont(f.getName(), f.getStyle(), file);
            this.newFont = true;
        }
    }

    private void setLineCap(int cap) {
        int lineCap = 0;
        switch (cap) {
            case 0: {
                lineCap = 0;
                break;
            }
            case 1: {
                lineCap = 1;
                break;
            }
            case 2: {
                lineCap = 2;
            }
        }
        if (this.lineCap != lineCap) {
            this.closeBlock();
            this.lineCap = lineCap;
            this.pw.println("" + lineCap + " J");
        }
    }

    private void setLineJoin(int join) {
        int lineJoin = 0;
        switch (join) {
            case 0: {
                lineJoin = 0;
                break;
            }
            case 1: {
                lineJoin = 1;
                break;
            }
            case 2: {
                lineJoin = 2;
            }
        }
        if (this.lineJoin != lineJoin) {
            this.closeBlock();
            this.lineJoin = lineJoin;
            this.pw.println("" + lineJoin + " j");
        }
    }

    public void setLineWidth(float width) {
        if (width != this.lineWidth) {
            this.closeBlock();
            this.lineWidth = width;
            this.pw.println("" + width + " w");
        }
    }

    private void setMiterLimit(float limit) {
        if (limit != this.miterLimit) {
            this.closeBlock();
            this.miterLimit = limit;
            this.pw.println("" + limit + " M");
        }
    }

    private void initAlpha(int alpha) {
        if (this.currentAlpha != alpha) {
            if (this.blendMode != null) {
                this.setBlendMode(this.blendMode, alpha);
                return;
            }
            String gsId = "/GSAlpha" + alpha;
            this.currentAlpha = alpha;
            if (!this.usedAlphas.contains(alpha)) {
                this.page.addExtGStateResource(gsId + " <</ca " + colorDf.format((double)this.currentAlpha / 255.0) + " /CA " + colorDf.format((double)this.currentAlpha / 255.0) + ">>");
                this.usedAlphas.add(this.currentAlpha);
            }
            this.pw.println(gsId + " gs");
        }
    }

    private void setBlendMode(String mode, int alpha) {
        String gsName;
        if (alpha == this.currentAlpha && mode == this.blendMode) {
            return;
        }
        if (alpha < 0) {
            alpha = 255;
        }
        if (!this.gsBlendModes.contains(gsName = "/GSBlend" + mode + "Alpha" + alpha)) {
            this.page.addExtGStateResource(gsName + " <</BM /" + mode + " /ca " + colorDf.format((double)alpha / 255.0) + " /CA " + colorDf.format((double)alpha / 255.0) + ">>");
        }
        this.pw.println(gsName + " gs");
        this.blendMode = mode;
        this.currentAlpha = alpha;
    }

    public void setBlendMode(String mode) {
        this.setBlendMode(mode, this.currentAlpha);
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        this.shading = null;
        this.pattern = null;
        this.paintTransform = null;
        if (paint instanceof Color) {
            Color c = (Color)paint;
            double r = (double)c.getRed() / 255.0;
            double g = (double)c.getGreen() / 255.0;
            double b = (double)c.getBlue() / 255.0;
            this.closeBlock();
            this.initAlpha(c.getAlpha());
            if (this.currentColor == null || !this.currentColor.equals(c)) {
                this.pw.println("" + colorDf.format(r) + " " + colorDf.format(g) + " " + colorDf.format(b) + " rg " + colorDf.format(r) + " " + colorDf.format(g) + " " + colorDf.format(b) + " RG");
                this.currentColor = c;
            }
        } else {
            this.currentColor = null;
        }
        if (paint instanceof MultipleGradientPaint) {
            this.closeBlock();
            if (paint instanceof RadialGradientPaint || paint instanceof LinearGradientPaint && ((LinearGradientPaint)paint).getCycleMethod() == MultipleGradientPaint.CycleMethod.NO_CYCLE) {
                this.shading = "gradient";
            } else {
                this.pattern = "gradient";
            }
        }
        if (paint instanceof TexturePaint) {
            this.closeBlock();
            this.pattern = "texture";
        }
    }

    private boolean useFunctionShading(MultipleGradientPaint fgrad) {
        return fgrad instanceof RadialGradientPaint && fgrad.getCycleMethod() != MultipleGradientPaint.CycleMethod.NO_CYCLE;
    }

    private Color[] convertColorSpace(Color[] colors, MultipleGradientPaint.ColorSpaceType colorSpaceType) {
        return colors;
    }

    private String generateRadialFunctionBody(RadialGradientPaint radGrad, boolean alpha) {
        int i;
        double a = (radGrad.getCenterPoint().getX() - radGrad.getFocusPoint().getX()) * (radGrad.getCenterPoint().getX() - radGrad.getFocusPoint().getX()) + (radGrad.getCenterPoint().getY() - radGrad.getFocusPoint().getY()) * (radGrad.getCenterPoint().getY() - radGrad.getFocusPoint().getY()) - (double)(radGrad.getRadius() * radGrad.getRadius());
        String functionBody = "{\n" + matDf.format(radGrad.getFocusPoint().getX()) + " 2 index sub\n" + matDf.format(radGrad.getCenterPoint().getX() - radGrad.getFocusPoint().getX()) + " mul 2 mul\n" + matDf.format(radGrad.getFocusPoint().getY()) + " 2 index sub\n" + matDf.format(radGrad.getCenterPoint().getY() - radGrad.getFocusPoint().getY()) + " mul 2 mul\nadd\n" + matDf.format(radGrad.getFocusPoint().getX()) + " 3 index sub\ndup mul\n" + matDf.format(radGrad.getFocusPoint().getY()) + " 3 index sub\ndup mul\nadd\n1 index dup mul 4 " + matDf.format(a) + " mul 2 index mul sub\n0 index 0 lt\n{\n1\n}{0 index 0 gt\n{\n2 index neg 1 index sqrt add 2 " + matDf.format(a) + " mul div\n3 index neg 2 index sqrt sub 2 " + matDf.format(a) + " mul div\n0 index 2 index gt{0 index} {1 index} ifelse\nexch pop exch pop\n}{\n2 index neg 2 " + matDf.format(a) + " mul div\n} ifelse\n} ifelse\nexch pop exch pop exch pop exch pop exch pop\n";
        if (radGrad.getCycleMethod() == MultipleGradientPaint.CycleMethod.REFLECT) {
            functionBody = functionBody + "dup\n";
        }
        functionBody = radGrad.getCycleMethod() == MultipleGradientPaint.CycleMethod.NO_CYCLE ? functionBody + "dup 1 gt {pop 1} if\n" : functionBody + "dup 1 gt {dup floor sub} if\n";
        if (radGrad.getCycleMethod() == MultipleGradientPaint.CycleMethod.REFLECT) {
            functionBody = functionBody + "exch floor 2 mod 1 eq {neg 1 add}\nif\n";
        }
        int num = radGrad.getFractions().length;
        Color[] rcolors = this.convertColorSpace(radGrad.getColors(), radGrad.getColorSpace());
        for (i = 0; i < num - 1; ++i) {
            functionBody = functionBody + "dup " + radGrad.getFractions()[i] + " lt not 1 index " + radGrad.getFractions()[i + 1] + " gt not and\n{\n0 index " + radGrad.getFractions()[i] + " sub " + (radGrad.getFractions()[i + 1] - radGrad.getFractions()[i]) + " div\n";
            if (alpha) {
                functionBody = functionBody + "0 index " + (double)(rcolors[i + 1].getAlpha() - rcolors[i].getAlpha()) / 255.0 + " mul " + (double)rcolors[i].getAlpha() / 255.0 + " add\n";
                functionBody = functionBody + "dup dup\n";
            } else {
                functionBody = radGrad.getColorSpace() == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB ? functionBody + "0 index " + (double)(srgbToLinear[rcolors[i + 1].getRed()] - srgbToLinear[rcolors[i].getRed()]) / 255.0 + " mul " + (double)srgbToLinear[rcolors[i].getRed()] / 255.0 + " add\n0 index 0.0031308 gt not {12.92 mul}{1 2.4 div exp 1.055 mul 0.055 sub}ifelse\n1 index " + (double)(srgbToLinear[rcolors[i + 1].getGreen()] - srgbToLinear[rcolors[i].getGreen()]) / 255.0 + " mul " + (double)srgbToLinear[rcolors[i].getGreen()] / 255.0 + " add\n0 index 0.0031308 gt not {12.92 mul}{1 2.4 div exp 1.055 mul 0.055 sub}ifelse\n2 index " + (double)(srgbToLinear[rcolors[i + 1].getBlue()] - srgbToLinear[rcolors[i].getBlue()]) / 255.0 + " mul " + (double)srgbToLinear[rcolors[i].getBlue()] / 255.0 + " add\n0 index 0.0031308 gt not {12.92 mul}{1 2.4 div exp 1.055 mul 0.055 sub}ifelse\n" : functionBody + "0 index " + (double)(rcolors[i + 1].getRed() - rcolors[i].getRed()) / 255.0 + " mul " + (double)rcolors[i].getRed() / 255.0 + " add\n1 index " + (double)(rcolors[i + 1].getGreen() - rcolors[i].getGreen()) / 255.0 + " mul " + (double)rcolors[i].getGreen() / 255.0 + " add\n2 index " + (double)(rcolors[i + 1].getBlue() - rcolors[i].getBlue()) / 255.0 + " mul " + (double)rcolors[i].getBlue() / 255.0 + " add\n";
            }
            if (i >= num - 2) continue;
            functionBody = functionBody + "}\n{\n";
        }
        functionBody = functionBody + "}if\n";
        for (i = 0; i < num - 2; ++i) {
            functionBody = functionBody + "}ifelse\n";
        }
        functionBody = functionBody + "}\n";
        return functionBody;
    }

    private void initGradientPaint(MultipleGradientPaint grad, Shape fillShape) {
        PDFStream radialAlphaFunction;
        PDFStream radialFunction;
        if (grad instanceof LinearGradientPaint && ((LinearGradientPaint)grad).getCycleMethod() == MultipleGradientPaint.CycleMethod.REFLECT) {
            int i;
            LinearGradientPaint linGrad = (LinearGradientPaint)grad;
            Point2D start = linGrad.getStartPoint();
            Point2D end = linGrad.getEndPoint();
            double deltaX = end.getX() - start.getX();
            double deltaY = end.getY() - start.getY();
            Point2D.Double newEnd = new Point2D.Double(end.getX() + deltaX, end.getY() + deltaY);
            int colorCount = grad.getFractions().length;
            float[] fractions2 = new float[colorCount * 2 - 1];
            Color[] colors2 = new Color[colorCount * 2 - 1];
            float[] fractionsrev = new float[linGrad.getFractions().length];
            Color[] colorsrev = new Color[linGrad.getColors().length];
            for (i = 0; i < fractionsrev.length; ++i) {
                colorsrev[i] = linGrad.getColors()[i];
                fractionsrev[i] = linGrad.getFractions()[i];
            }
            for (i = 0; i < colorCount; ++i) {
                colors2[i] = colorsrev[i];
                fractions2[i] = fractionsrev[i] / 2.0f;
            }
            for (i = 0; i < colorCount; ++i) {
                colors2[colors2.length - i - 1] = colorsrev[i];
                fractions2[colors2.length - i - 1] = 1.0f - fractionsrev[i] / 2.0f;
            }
            LinearGradientPaint linGrad2 = new LinearGradientPaint(start, newEnd, fractions2, colors2, MultipleGradientPaint.CycleMethod.REPEAT);
            grad = linGrad2;
        }
        ArrayList<String> functions2Refs = new ArrayList<String>();
        Color[] colors = this.convertColorSpace(grad.getColors(), grad.getColorSpace());
        for (int i = 1; i < grad.getColors().length; ++i) {
            final Color color1 = colors[i - 1];
            final Color color2 = colors[i];
            MultipleGradientPaint.ColorSpaceType colorSpace = grad.getColorSpace();
            if (colorSpace == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
                PDFStream function4 = new PDFStream(null){

                    @Override
                    public void write(OutputStream os) throws IOException {
                        this.writeStart(os);
                        os.write("/FunctionType 4 /Domain [0 1] /Range [0 1 0 1 0 1]".getBytes("UTF-8"));
                        this.writeStream(os);
                    }
                };
                OutputStream f4Os = function4.getOutputStream();
                int redDelta = srgbToLinear[color2.getRed()] - srgbToLinear[color1.getRed()];
                int greenDelta = srgbToLinear[color2.getGreen()] - srgbToLinear[color1.getGreen()];
                int blueDelta = srgbToLinear[color2.getBlue()] - srgbToLinear[color1.getBlue()];
                String functionBody = "{0 index " + redDelta + " mul " + srgbToLinear[color1.getRed()] + " add 255 div\n0 index 0.0031308 gt not {12.92 mul}{1 2.4 div exp 1.055 mul 0.055 sub}ifelse\n1 index " + greenDelta + " mul " + srgbToLinear[color1.getGreen()] + " add 255 div\n0 index 0.0031308 gt not {12.92 mul}{1 2.4 div exp 1.055 mul 0.055 sub}ifelse\n2 index " + blueDelta + " mul " + srgbToLinear[color1.getBlue()] + " add 255 div\n0 index 0.0031308 gt not {12.92 mul}{1 2.4 div exp 1.055 mul 0.055 sub}ifelse\n}";
                try {
                    f4Os.write(functionBody.getBytes("UTF-8"));
                }
                catch (IOException ex) {
                    Logger.getLogger(PDFGraphics.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.page.getPDFDocument().add(function4);
                functions2Refs.add(function4.getSerialID() + " 0 R");
                continue;
            }
            PDFObject function2 = new PDFObject(this, null){
                final /* synthetic */ PDFGraphics this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void write(OutputStream os) throws IOException {
                    this.writeStart(os);
                    os.write(("/FunctionType 2 /Domain [0 1] /C0 [" + (float)color1.getRed() / 255.0f + " " + (float)color1.getGreen() / 255.0f + " " + (float)color1.getBlue() / 255.0f + "] /C1 [" + (float)color2.getRed() / 255.0f + " " + (float)color2.getGreen() / 255.0f + " " + (float)color2.getBlue() / 255.0f + "] /N 1\n").getBytes("UTF-8"));
                    this.writeEnd(os);
                }
            };
            this.page.getPDFDocument().add(function2);
            functions2Refs.add(function2.getSerialID() + " 0 R");
        }
        ArrayList<String> functions2AlphaRefs = new ArrayList<String>();
        Color[] alphaColors = grad.getColors();
        for (int i = 1; i < grad.getColors().length; ++i) {
            final Color color1 = alphaColors[i - 1];
            final Color color2 = alphaColors[i];
            PDFObject function2 = new PDFObject(this, null){
                final /* synthetic */ PDFGraphics this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void write(OutputStream os) throws IOException {
                    this.writeStart(os);
                    os.write(("/FunctionType 2 /Domain [0 1] /C0 [" + (float)color1.getAlpha() / 255.0f + " " + (float)color1.getAlpha() / 255.0f + " " + (float)color1.getAlpha() / 255.0f + "] /C1 [" + (float)color2.getAlpha() / 255.0f + " " + (float)color2.getAlpha() / 255.0f + " " + (float)color2.getAlpha() / 255.0f + "] /N 1\n").getBytes("UTF-8"));
                    this.writeEnd(os);
                }
            };
            this.page.getPDFDocument().add(function2);
            functions2AlphaRefs.add(function2.getSerialID() + " 0 R");
        }
        MultipleGradientPaint fgrad = grad;
        PDFGradientFunction3 function3 = new PDFGradientFunction3(fgrad, functions2Refs);
        this.page.getPDFDocument().add(function3);
        PDFGradientFunction3 function3Alpha = new PDFGradientFunction3(fgrad, functions2AlphaRefs);
        this.page.getPDFDocument().add(function3Alpha);
        double glen = 0.0;
        double divisor = 1.0;
        double maxlen = 256.0;
        if (fgrad instanceof LinearGradientPaint && fgrad.getCycleMethod() != MultipleGradientPaint.CycleMethod.NO_CYCLE) {
            double deltaY;
            LinearGradientPaint linGrad = (LinearGradientPaint)fgrad;
            Point2D startPoint = new Point2D.Double();
            Point2D endPoint = new Point2D.Double();
            startPoint = linGrad.getStartPoint();
            endPoint = linGrad.getEndPoint();
            double deltaX = endPoint.getX() - startPoint.getX();
            glen = Math.sqrt(deltaX * deltaX + (deltaY = endPoint.getY() - startPoint.getY()) * deltaY);
            if (glen > maxlen) {
                divisor = glen / maxlen;
                glen = maxlen;
            }
        }
        final double flen = glen;
        if (this.useFunctionShading(fgrad)) {
            RadialGradientPaint radGrad = (RadialGradientPaint)fgrad;
            radialFunction = new PDFStream(){

                @Override
                public void write(OutputStream os) throws IOException {
                    this.writeStart(os);
                    os.write("/FunctionType 4\n".getBytes("UTF-8"));
                    os.write("/Domain [-1000000 1000000 -1000000 1000000]\n".getBytes("UTF-8"));
                    os.write("/Range [0 1 0 1 0 1]\n".getBytes("UTF-8"));
                    this.writeStream(os);
                }
            };
            radialAlphaFunction = new PDFStream(){

                @Override
                public void write(OutputStream os) throws IOException {
                    this.writeStart(os);
                    os.write("/FunctionType 4\n".getBytes("UTF-8"));
                    os.write("/Domain [-1000000 1000000 -1000000 1000000]\n".getBytes("UTF-8"));
                    os.write("/Range [0 1 0 1 0 1]\n".getBytes("UTF-8"));
                    this.writeStream(os);
                }
            };
            String functionBody = this.generateRadialFunctionBody(radGrad, false);
            OutputStream funOs = radialFunction.getOutputStream();
            try {
                funOs.write(functionBody.getBytes("UTF-8"));
            }
            catch (IOException ex) {
                Logger.getLogger(PDFGraphics.class.getName()).log(Level.SEVERE, null, ex);
            }
            String alphaFunctionBody = this.generateRadialFunctionBody(radGrad, true);
            funOs = radialAlphaFunction.getOutputStream();
            try {
                funOs.write(alphaFunctionBody.getBytes("UTF-8"));
            }
            catch (IOException ex) {
                Logger.getLogger(PDFGraphics.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.page.getPDFDocument().add(radialFunction);
            this.page.getPDFDocument().add(radialAlphaFunction);
        } else {
            radialFunction = null;
            radialAlphaFunction = null;
        }
        final PdfGradientShading shadingObj = new PdfGradientShading(fgrad, flen, this.useFunctionShading(fgrad), function3, radialFunction);
        this.page.getPDFDocument().add(shadingObj);
        final PdfGradientShading shadingAlphaObj = new PdfGradientShading(fgrad, flen, this.useFunctionShading(fgrad), function3Alpha, radialAlphaFunction);
        this.page.getPDFDocument().add(shadingAlphaObj);
        ++this.shadingCount;
        final int fCurrentShadingCount = this.shadingCount;
        PDFStream alphaObject = new PDFStream(this){
            final /* synthetic */ PDFGraphics this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void write(OutputStream os) throws IOException {
                this.writeStart(os);
                os.write("/Group << /CS /DeviceGray /S /Transparency >>\n".getBytes("UTF-8"));
                os.write("/Type /XObject\n".getBytes("UTF-8"));
                os.write("/Resources <<\n".getBytes("UTF-8"));
                os.write("/Shading <<".getBytes("UTF-8"));
                os.write(("/ShA" + fCurrentShadingCount + " " + shadingAlphaObj.getSerialID() + " 0 R").getBytes("UTF-8"));
                os.write(">>\n".getBytes("UTF-8"));
                os.write(">>\n".getBytes("UTF-8"));
                os.write("/Subtype /Form\n".getBytes("UTF-8"));
                os.write("/BBox [-1000000 -1000000 2000000 2000000]\n".getBytes("UTF-8"));
                this.writeStream(os);
            }
        };
        OutputStream alphaOs = alphaObject.getOutputStream();
        try {
            alphaOs.write(("/ShA" + fCurrentShadingCount + " sh\n").getBytes("UTF-8"));
        }
        catch (IOException ex) {
            Logger.getLogger(PDFGraphics.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.page.getPDFDocument().add(alphaObject);
        final String alphaExtGState = "/GradAlpha" + fCurrentShadingCount + " <</SMask <</Type /Mask\n/S /Luminosity\n/G " + alphaObject.getSerialID() + " 0 R>>>>";
        if (grad instanceof LinearGradientPaint && ((LinearGradientPaint)grad).getCycleMethod() != MultipleGradientPaint.CycleMethod.NO_CYCLE) {
            LinearGradientPaint linGrad = (LinearGradientPaint)grad;
            Point2D startPoint = linGrad.getStartPoint();
            Point2D endPoint = linGrad.getEndPoint();
            Point2D.Double startPointTrans = new Point2D.Double();
            Point2D.Double endPointTrans = new Point2D.Double();
            this.transform.transform(linGrad.getStartPoint(), startPointTrans);
            this.transform.transform(linGrad.getEndPoint(), endPointTrans);
            double deltaX = endPoint.getX() - startPoint.getX();
            double deltaY = endPoint.getY() - startPoint.getY();
            double tana = deltaX / deltaY;
            double alfa = Math.atan(tana);
            AffineTransform m = new AffineTransform();
            if (this.usePTransform) {
                m.concatenate(this.pTransform);
            }
            m.concatenate(this.transform);
            m.concatenate(AffineTransform.getTranslateInstance(startPoint.getX(), endPoint.getY()));
            m.concatenate(AffineTransform.getScaleInstance(divisor, divisor));
            m.concatenate(AffineTransform.getRotateInstance(-alfa));
            final String matrixStr = "" + matDf.format(m.getScaleX()) + " " + matDf.format(m.getShearY()) + " " + matDf.format(m.getShearX()) + " " + matDf.format(m.getScaleY()) + " " + matDf.format(m.getTranslateX()) + " " + matDf.format(m.getTranslateY());
            PDFStream innerPattern = new PDFStream(this, "/Pattern"){
                final /* synthetic */ PDFGraphics this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void write(OutputStream os) throws IOException {
                    this.writeStart(os);
                    double w = 1.0;
                    double h = flen;
                    os.write("/PatternType 1\n".getBytes("UTF-8"));
                    os.write("/PaintType 1\n".getBytes("UTF-8"));
                    os.write("/TilingType 2\n".getBytes("UTF-8"));
                    os.write(("/BBox [0 0 " + w + " " + h + "]\n").getBytes("UTF-8"));
                    os.write(("/XStep " + w + "\n").getBytes("UTF-8"));
                    os.write(("/YStep " + h + "\n").getBytes("UTF-8"));
                    os.write(("/Resources << /Shading << /Shin" + fCurrentShadingCount + " " + shadingObj.getSerialID() + " 0 R >>/ExtGState <<" + alphaExtGState + ">>>>\n").getBytes("UTF-8"));
                    os.write(("/Matrix [" + matrixStr + "]\n").getBytes("UTF-8"));
                    this.writeStream(os);
                }
            };
            OutputStream patOs = innerPattern.getOutputStream();
            try {
                patOs.write(("/GradAlpha" + fCurrentShadingCount + " gs").getBytes("UTF-8"));
                patOs.write(("/Shin" + this.shadingCount + " sh").getBytes("UTF-8"));
            }
            catch (IOException ex) {
                Logger.getLogger(PDFGraphics.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.page.getPDFDocument().add(innerPattern);
            this.page.addPatternResource("/p" + this.shadingCount + " " + innerPattern.getSerialID() + " 0 R");
            this.pattern = "/p" + this.shadingCount;
            return;
        }
        this.currentAlpha = -1;
        this.page.addExtGStateResource(alphaExtGState);
        this.pw.println("/GradAlpha" + fCurrentShadingCount + " gs");
        this.page.addShadingResource("/Sh" + this.shadingCount + " " + shadingObj.getSerialID() + " 0 R ");
        this.shading = "/Sh" + this.shadingCount;
    }

    private byte[] getImageJpegData(Image img) {
        byte[] jpegImageData = null;
        try {
            Method jpegMethod = img.getClass().getDeclaredMethod("isJpeg", new Class[0]);
            boolean isJpeg = (Boolean)jpegMethod.invoke((Object)img, new Object[0]);
            if (isJpeg) {
                Method getImageDataMethod = img.getClass().getDeclaredMethod("getImageData", new Class[0]);
                jpegImageData = (byte[])getImageDataMethod.invoke((Object)img, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return jpegImageData;
    }

    private byte[] getImageAlphaChannel(Image img) {
        try {
            Method getAlphaChannelMethod = img.getClass().getDeclaredMethod("getAlphaChannel", new Class[0]);
            return (byte[])getAlphaChannelMethod.invoke((Object)img, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    private void initTexturePaint(TexturePaint texturePaint) {
        PDFImage image;
        boolean interpolate;
        byte[] jpegImageData = this.getImageJpegData(texturePaint.getImage());
        byte[] alphaChannel = null;
        if (jpegImageData != null) {
            alphaChannel = this.getImageAlphaChannel(texturePaint.getImage());
        }
        BufferedImage img = texturePaint.getImage();
        PDFMask mask = alphaChannel == null ? new PDFMask(img) : new PDFMask(alphaChannel, img.getWidth(), img.getHeight());
        this.page.getPDFDocument().add(mask);
        Rectangle2D anchorRect = texturePaint.getAnchorRect();
        final double w = anchorRect.getWidth();
        final double h = anchorRect.getHeight();
        Object interpolationHint = this.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        boolean bl = interpolate = interpolationHint == RenderingHints.VALUE_INTERPOLATION_BILINEAR || interpolationHint == RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        if (this.page.getPDFDocument().isImageCached(img, interpolate)) {
            image = this.page.getPDFDocument().getCachedImage(img, interpolate);
        } else {
            image = jpegImageData != null ? new PDFImage(jpegImageData, 0, 0, img.getWidth(), img.getHeight(), new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    return true;
                }
            }, "" + mask.getSerialID() + " 0 R", interpolate) : new PDFImage(img, 0, 0, img.getWidth(), img.getHeight(), new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    return true;
                }
            }, "" + mask.getSerialID() + " 0 R", interpolate);
            this.page.getPDFDocument().setImageName(image);
            this.page.getPDFDocument().add(image);
            this.page.getPDFDocument().cacheImage(img, image);
        }
        AffineTransform m = new AffineTransform();
        AffineTransform ptt = new AffineTransform();
        if (this.usePTransform) {
            ptt.concatenate(this.pTransform);
        }
        ptt.concatenate(this.transform);
        m.concatenate(ptt);
        final String matrixStr = "" + matDf.format(m.getScaleX()) + " " + matDf.format(m.getShearY()) + " " + matDf.format(m.getShearX()) + " " + matDf.format(m.getScaleY()) + " " + matDf.format(m.getTranslateX()) + " " + matDf.format(m.getTranslateY());
        PDFStream innerPattern = new PDFStream(this, "/Pattern"){
            final /* synthetic */ PDFGraphics this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void write(OutputStream os) throws IOException {
                this.writeStart(os);
                os.write("/PatternType 1\n".getBytes("UTF-8"));
                os.write("/PaintType 1\n".getBytes("UTF-8"));
                os.write("/TilingType 2\n".getBytes("UTF-8"));
                os.write(("/BBox [0 0 " + matDf.format(w) + " " + matDf.format(h) + "]\n").getBytes("UTF-8"));
                os.write(("/XStep " + matDf.format(w) + "\n").getBytes("UTF-8"));
                os.write(("/YStep " + matDf.format(h) + "\n").getBytes("UTF-8"));
                os.write("/Resources << ".getBytes("UTF-8"));
                os.write("/XObject << ".getBytes("UTF-8"));
                os.write((image.getName() + " " + image.getSerialID() + " 0 R").getBytes("UTF-8"));
                os.write(" >> ".getBytes("UTF-8"));
                os.write(">>\n".getBytes("UTF-8"));
                os.write(("/Matrix [" + matrixStr + "]\n").getBytes("UTF-8"));
                this.writeStream(os);
            }
        };
        OutputStream patOs = innerPattern.getOutputStream();
        PrintWriter patwriter = new PrintWriter(patOs);
        AffineTransform transformToSet = new AffineTransform(w, 0.0, 0.0, -h, 0.0 - anchorRect.getX(), h - anchorRect.getY());
        patwriter.print("q " + matDf.format(transformToSet.getScaleX()) + " " + matDf.format(transformToSet.getShearY()) + " " + matDf.format(transformToSet.getShearX()) + " " + matDf.format(transformToSet.getScaleY()) + " " + matDf.format(transformToSet.getTranslateX()) + " " + matDf.format(transformToSet.getTranslateY()) + " cm \n" + image.getName() + " Do\nQ\n");
        transformToSet = new AffineTransform(w, 0.0, 0.0, -h, w - anchorRect.getX(), h - anchorRect.getY());
        patwriter.print("q " + matDf.format(transformToSet.getScaleX()) + " " + matDf.format(transformToSet.getShearY()) + " " + matDf.format(transformToSet.getShearX()) + " " + matDf.format(transformToSet.getScaleY()) + " " + matDf.format(transformToSet.getTranslateX()) + " " + matDf.format(transformToSet.getTranslateY()) + " cm \n" + image.getName() + " Do\nQ\n");
        transformToSet = new AffineTransform(w, 0.0, 0.0, -h, 0.0 - anchorRect.getX(), 2.0 * h - anchorRect.getY());
        patwriter.print("q " + matDf.format(transformToSet.getScaleX()) + " " + matDf.format(transformToSet.getShearY()) + " " + matDf.format(transformToSet.getShearX()) + " " + matDf.format(transformToSet.getScaleY()) + " " + matDf.format(transformToSet.getTranslateX()) + " " + matDf.format(transformToSet.getTranslateY()) + " cm \n" + image.getName() + " Do\nQ\n");
        transformToSet = new AffineTransform(w, 0.0, 0.0, -h, w - anchorRect.getX(), 2.0 * h - anchorRect.getY());
        patwriter.print("q " + matDf.format(transformToSet.getScaleX()) + " " + matDf.format(transformToSet.getShearY()) + " " + matDf.format(transformToSet.getShearX()) + " " + matDf.format(transformToSet.getScaleY()) + " " + matDf.format(transformToSet.getTranslateX()) + " " + matDf.format(transformToSet.getTranslateY()) + " cm \n" + image.getName() + " Do\nQ\n");
        patwriter.flush();
        this.page.getPDFDocument().add(innerPattern);
        ++this.shadingCount;
        this.page.addPatternResource("/p" + this.shadingCount + " " + innerPattern.getSerialID() + " 0 R");
        this.pattern = "/p" + this.shadingCount;
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key arg0, Object arg1) {
        if (arg1 != null) {
            this.rhints.put(arg0, arg1);
        } else {
            this.rhints.remove(arg0);
        }
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.rhints.clear();
        this.rhints.putAll(hints);
    }

    @Override
    public void setStroke(Stroke s) {
        this.stroke = s;
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            this.setLineCap(bs.getEndCap());
            this.setLineJoin(bs.getLineJoin());
            this.setLineWidth(bs.getLineWidth());
            this.setMiterLimit(bs.getMiterLimit());
        }
    }

    @Override
    public void setTransform(AffineTransform t) {
        this.setNewTranform(new AffineTransform(t));
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public void shear(double shx, double shy) {
        AffineTransform newTransform = new AffineTransform(this.transform);
        newTransform.shear(shx, shy);
        this.setNewTranform(newTransform);
    }

    @Override
    public void transform(AffineTransform tx) {
        AffineTransform newTransform = new AffineTransform(this.transform);
        newTransform.concatenate(tx);
        this.setNewTranform(newTransform);
    }

    @Override
    public void translate(double tx, double ty) {
        AffineTransform newTransform = new AffineTransform(this.transform);
        newTransform.translate(tx, ty);
        this.setNewTranform(newTransform);
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    private String twh(float x, float y, float tx, float ty) {
        float nx = x;
        float ny = y;
        float ntx = tx;
        float nty = ty;
        nx = x - tx;
        ny = y - ty;
        return "" + df.format(nx) + " " + df.format(ny) + " ";
    }

    private String txy(float x, float y) {
        Point2D.Float ptSrc = new Point2D.Float(x, y);
        Point2D.Float ptDst = new Point2D.Float();
        if (this.usePTransform) {
            this.pTransform.transform(ptSrc, ptDst);
        }
        return "" + df.format(((Point2D)ptDst).getX()) + " " + df.format(((Point2D)ptDst).getY()) + " ";
    }

    private void setNewTranform(AffineTransform t) {
        this.closeBlock();
        AffineTransform newTransform = new AffineTransform(t);
        AffineTransform transformToSet = new AffineTransform(newTransform);
        if (this.usePTransform) {
            if (this.transform != null) {
                AffineTransform aInv = new AffineTransform(this.transform);
                try {
                    aInv.invert();
                }
                catch (NoninvertibleTransformException ex) {
                    Logger.getLogger(PDFGraphics.class.getName()).log(Level.SEVERE, null, ex);
                }
                AffineTransform pInv = new AffineTransform(this.pTransform);
                try {
                    pInv.invert();
                }
                catch (NoninvertibleTransformException ex) {
                    Logger.getLogger(PDFGraphics.class.getName()).log(Level.SEVERE, null, ex);
                }
                transformToSet = new AffineTransform();
                transformToSet.concatenate(aInv);
                transformToSet.concatenate(pInv);
                transformToSet.concatenate(this.pTransform);
                transformToSet.concatenate(newTransform);
            } else {
                transformToSet.preConcatenate(this.pTransform);
            }
        }
        if (this.clip != null) {
            AffineTransform inv = new AffineTransform(newTransform);
            try {
                inv.invert();
            }
            catch (NoninvertibleTransformException ex) {
                Logger.getLogger(PDFGraphics.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.clip = new Area(this.transform.createTransformedShape(inv.createTransformedShape(this.clip)));
            this.clipRectangle = this.clip.getBounds();
        }
        this.transform = newTransform;
        this.pw.println("" + matDf.format(transformToSet.getScaleX()) + " " + matDf.format(transformToSet.getShearY()) + " " + matDf.format(transformToSet.getShearX()) + " " + matDf.format(transformToSet.getScaleY()) + " " + matDf.format(transformToSet.getTranslateX()) + " " + matDf.format(transformToSet.getTranslateY()) + " cm");
    }

    private void saveState() {
        this.pw.println("q");
    }

    private void restoreState() {
        this.pw.println("Q");
    }

    public void drawXObject(Graphics g) {
        if (g instanceof PDFGraphics) {
            int objId = ((PDFGraphics)g).objId;
            this.pw.println("/MyObj" + objId + " Do");
        }
    }

    public Graphics2D createXObject() {
        final PDFPage newPage = new PDFPage(this.page.pageFormat){

            @Override
            public void addToProcset(String proc) {
                PDFGraphics.this.page.addToProcset(proc);
            }
        };
        newPage.pdfDocument = this.page.pdfDocument;
        PDFStream retObject = new PDFStream(this){
            final /* synthetic */ PDFGraphics this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void write(OutputStream os) throws IOException {
                this.writeStart(os);
                os.write("/Type /XObject\n".getBytes("UTF-8"));
                newPage.writeResources(os);
                os.write("/Subtype /Form\n".getBytes("UTF-8"));
                os.write("/BBox [-1000000 -1000000 2000000 2000000]\n".getBytes("UTF-8"));
                this.writeStream(os);
            }
        };
        this.page.getPDFDocument().add(retObject);
        OutputStream os = retObject.getOutputStream();
        RawPrintWriter pw2 = new RawPrintWriter(os);
        this.page.addXObject("/MyObj" + retObject.getSerialID() + " " + retObject.getSerialID() + " 0 R");
        PDFGraphics g = new PDFGraphics();
        g.usePTransform = false;
        g.init(newPage, pw2);
        g.objId = retObject.getSerialID();
        return g;
    }

    static {
        matDf.setMaximumFractionDigits(340);
        df.setGroupingUsed(false);
        matDf.setGroupingUsed(false);
        colorDf.setGroupingUsed(false);
        srgbToLinear = new int[256];
        linearToSrgb = new int[256];
        for (int i = 0; i < 256; ++i) {
            PDFGraphics.srgbToLinear[i] = PDFGraphics.convertSRGBtoLinearRGB(i);
            PDFGraphics.linearToSrgb[i] = PDFGraphics.convertLinearRGBtoSRGB(i);
        }
    }
}

