/*
 * Decompiled with CFR 0.152.
 */
package com.jpacker;

import com.jpacker.JPackerEncoding;
import com.jpacker.JPackerParser;
import com.jpacker.JPackerPattern;
import com.jpacker.JPackerWord;
import com.jpacker.JPackerWords;
import com.jpacker.encoders.BasicEncoder;
import com.jpacker.strategies.DefaultReplacementStrategy;
import com.jpacker.strategies.ReplacementStrategy;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JPackerExecuter {
    private JPackerEncoding encoding;
    private static final String UNPACK = "eval(function(p,a,c,k,e,r){e=%5$s;if(!''.replace(/^/,String)){while(c--)r[%6$s]=k[c]||%6$s;k=[function(e){return r[e]}];e=function(){return'\\\\w+'};c=1};while(c--)if(k[c])p=p.replace(new RegExp('\\\\b'+e(c)+'\\\\b','g'),k[c]);return p}('%1$s',%2$s,%3$s,'%4$s'.split('|'),0,{}))";

    public JPackerExecuter(JPackerEncoding encoding) {
        this.setEncoding(encoding);
    }

    public String pack(String script, boolean minifyOnly, boolean shrinkVariables) {
        script = script + "\n";
        script = this.minify(script);
        if (!minifyOnly) {
            if (shrinkVariables) {
                script = this.shrinkVariables(script);
            }
            if (this.encoding != JPackerEncoding.NONE) {
                script = this.encode(script);
            }
        }
        return script;
    }

    private String minify(String script) {
        JPackerParser parser = new JPackerParser();
        DefaultReplacementStrategy defaultStrat = new DefaultReplacementStrategy();
        parser = this.addDataRegEx(parser);
        script = parser.exec(script, defaultStrat);
        parser = this.addWhiteSpaceRegEx(parser);
        script = parser.exec(script, defaultStrat);
        parser = this.addCleanUpRegEx(parser);
        script = parser.exec(script, defaultStrat);
        return script;
    }

    private JPackerParser addDataRegEx(JPackerParser parser) {
        String COMMENT1 = "(\\/\\/|;;;)[^\\n]*";
        String COMMENT2 = "\\/\\*[^*]*\\*+([^\\/][^*]*\\*+)*\\/";
        String REGEX = "\\/(\\\\[\\/\\\\]|[^*\\/])(\\\\.|[^\\/\\n\\\\])*\\/[gim]*";
        parser.remove("\\\\\\r?\\n");
        parser.ignore("'(\\\\.|[^'\\\\])*'");
        parser.ignore("\"(\\\\.|[^\"\\\\])*\"");
        parser.ignore("\\/\\*@|@\\*\\/|\\/\\/@[^\\n]*\\n");
        parser.replace("((\\/\\/|;;;)[^\\n]*)\\n\\s*(\\/(\\\\[\\/\\\\]|[^*\\/])(\\\\.|[^\\/\\n\\\\])*\\/[gim]*)?", "\n$3");
        parser.replace("(\\/\\*[^*]*\\*+([^\\/][^*]*\\*+)*\\/)\\s*(\\/(\\\\[\\/\\\\]|[^*\\/])(\\\\.|[^\\/\\n\\\\])*\\/[gim]*)?", " $3");
        parser.replace("([\\[\\(\\^=,{}:;&|!*?])\\s*(\\/(\\\\[\\/\\\\]|[^*\\/])(\\\\.|[^\\/\\n\\\\])*\\/[gim]*)", "$1$2");
        return parser;
    }

    private JPackerParser addCleanUpRegEx(JPackerParser parser) {
        parser.replace("\\(\\s*;\\s*;\\s*\\)", "(;;)");
        parser.ignore("throw[};]+[};]");
        parser.replace(";+\\s*([};])", "$1");
        parser.remove(";;[^\\n\\r]+[\\n\\r]");
        return parser;
    }

    private JPackerParser addWhiteSpaceRegEx(JPackerParser parser) {
        parser.replace("(\\d)\\s+(\\.\\s*[a-z\\$_\\[\\(])", "$1 $2");
        parser.replace("([+\\-])\\s+([+\\-])", "$1 $2");
        parser.replace("(\\b|\\$)\\s+(\\b|\\$)", "$1 $2");
        parser.replace("\\b\\s+\\$\\s+\\b", " $ ");
        parser.replace("\\$\\s+\\b", "$ ");
        parser.replace("\\b\\s+\\$", " $");
        parser.replace("\\b\\s+\\b", " ");
        parser.remove("\\s+");
        return parser;
    }

    private String shrinkVariables(String script) {
        StringBuffer sb;
        final Pattern pattern = Pattern.compile("^[^'\"]\\/");
        Pattern blockPattern = Pattern.compile("(function\\s*[\\w$]*\\s*\\(\\s*([^\\)]*)\\s*\\)\\s*)?(\\{([^{}]*)\\})");
        ArrayList<String> blocks = new ArrayList<String>();
        final ArrayList data = new ArrayList();
        JPackerParser parser = new JPackerParser();
        parser = this.addDataRegEx(parser);
        script = parser.exec(script, new ReplacementStrategy(){

            @Override
            public String replace(List<JPackerPattern> patterns, Matcher matcher) {
                String replacement = "#" + data.size();
                String string = matcher.group();
                if (pattern.matcher(string).find()) {
                    replacement = string.charAt(0) + replacement;
                    string = string.substring(1);
                }
                data.add(string);
                return replacement;
            }
        });
        do {
            Matcher blockMatcher = blockPattern.matcher(script);
            sb = new StringBuffer();
            while (blockMatcher.find()) {
                blockMatcher.appendReplacement(sb, this.encodeBlock(blockMatcher, blocks));
            }
            blockMatcher.appendTail(sb);
        } while (blockPattern.matcher(script = sb.toString()).find());
        while (Pattern.compile("~(\\d+)~").matcher(script).find()) {
            script = this.decodeBlock(script, blocks);
        }
        Matcher storeMatcher = Pattern.compile("#(\\d+)").matcher(script);
        StringBuffer sb2 = new StringBuffer();
        while (storeMatcher.find()) {
            int num = Integer.parseInt(storeMatcher.group(1));
            storeMatcher.appendReplacement(sb2, Matcher.quoteReplacement((String)data.get(num)));
        }
        storeMatcher.appendTail(sb2);
        return sb2.toString();
    }

    private String encode(String script) {
        JPackerWords words = new JPackerWords(script, this.encoding);
        Pattern wordsPattern = Pattern.compile("\\w+");
        Matcher wordsMatcher = wordsPattern.matcher(script);
        StringBuffer sb = new StringBuffer();
        while (wordsMatcher.find()) {
            JPackerWord tempWord = new JPackerWord(wordsMatcher.group());
            wordsMatcher.appendReplacement(sb, words.find(tempWord).getEncoded());
        }
        wordsMatcher.appendTail(sb);
        int ascii = Math.min(Math.max(words.getWords().size(), 2), this.encoding.getEncodingBase());
        String p = this.escape(sb.toString());
        String a = String.valueOf(ascii);
        String c = String.valueOf(words.getWords().size());
        String k = words.toString();
        String e = this.getEncode(ascii);
        String r = ascii > 10 ? "e(c)" : "c";
        return new Formatter().format(UNPACK, p, a, c, k, e, r).toString();
    }

    private String encodeBlock(Matcher matcher, List<String> blocks) {
        String block = matcher.group();
        String func = matcher.group(1);
        String args = matcher.group(2);
        if (func != null && !func.isEmpty()) {
            while (Pattern.compile("~(\\d+)~").matcher(block).find()) {
                block = this.decodeBlock(block, blocks);
            }
            Pattern varNamePattern = Pattern.compile("var\\s+[\\w$]+");
            Matcher varNameMatcher = varNamePattern.matcher(block);
            StringBuilder sb = new StringBuilder();
            while (varNameMatcher.find()) {
                sb.append(varNameMatcher.group()).append(",");
            }
            String vars = "";
            if (!sb.toString().isEmpty()) {
                vars = sb.deleteCharAt(sb.length() - 1).toString().replaceAll("var\\s+", "");
            }
            String[] ids = this.concat(args.split("\\s*,\\s*"), vars.split("\\s*,\\s*"));
            LinkedHashSet<String> idList = new LinkedHashSet<String>();
            for (String s : ids) {
                if (s.isEmpty()) continue;
                idList.add(s);
            }
            int count = 0;
            for (String id : idList) {
                String shortId;
                if ((id = id.trim()).length() <= 1) continue;
                id = Matcher.quoteReplacement(id);
                BasicEncoder e = new BasicEncoder();
                do {
                    shortId = e.encode(count++);
                } while (Pattern.compile("[^\\w$.]" + shortId + "[^\\w$:]").matcher(block).find());
                while (Pattern.compile("([^\\w$.])" + id + "([^\\w$:])").matcher(block).find()) {
                    block = block.replaceAll("([^\\w$.])" + id + "([^\\w$:])", "$1" + shortId + "$2");
                }
                block = block.replaceAll("([^{,\\w$.])" + id + ":", "$1" + shortId + ":");
            }
        }
        String replacement = "~" + blocks.size() + "~";
        blocks.add(block);
        return replacement;
    }

    private String decodeBlock(String block, List<String> blocks) {
        Matcher encoded = Pattern.compile("~(\\d+)~").matcher(block);
        StringBuffer sbe = new StringBuffer();
        while (encoded.find()) {
            int num = Integer.parseInt(encoded.group(1));
            encoded.appendReplacement(sbe, Matcher.quoteReplacement(blocks.get(num)));
        }
        encoded.appendTail(sbe);
        return sbe.toString();
    }

    private String[] concat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    private String getEncode(int ascii) {
        if (ascii > 96) {
            return JPackerEncoding.HIGH_ASCII.getEncode();
        }
        if (ascii > 36) {
            return JPackerEncoding.NORMAL.getEncode();
        }
        if (ascii > 10) {
            return JPackerEncoding.MID.getEncode();
        }
        return JPackerEncoding.NUMERIC.getEncode();
    }

    private String escape(String input) {
        return input.replaceAll("([\\\\'])", "\\\\$1").replaceAll("[\\r\\n]+", "\\n");
    }

    public JPackerEncoding getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(JPackerEncoding encoding) {
        this.encoding = encoding;
    }
}

