/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxView;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.GotoLineDialog;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;

public class LineNumbersRuler
extends JPanel
implements CaretListener,
DocumentListener,
PropertyChangeListener,
SyntaxComponent {
    public static final String PROPERTY_BACKGROUND = "LineNumbers.Background";
    public static final String PROPERTY_FOREGROUND = "LineNumbers.Foreground";
    public static final String PROPERTY_CURRENT_BACK = "LineNumbers.CurrentBack";
    public static final String PROPERTY_LEFT_MARGIN = "LineNumbers.LeftMargin";
    public static final String PROPERTY_RIGHT_MARGIN = "LineNumbers.RightMargin";
    public static final String PROPERTY_Y_OFFSET = "LineNumbers.YOFFset";
    public static final int DEFAULT_R_MARGIN = 5;
    public static final int DEFAULT_L_MARGIN = 5;
    private SyntaxComponent.Status status;
    protected JEditorPane editor;
    private int minimumDisplayDigits = 2;
    private int lastDigits;
    private int lastHeight;
    private int lastLine;
    protected MouseListener mouseListener = null;
    private String numbersFormat = "%3d";
    protected Color currentLineColor;
    protected Color currentLineForegroundColor;

    public JScrollPane getScrollPane(JTextComponent editorPane) {
        for (Container p = editorPane.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JScrollPane)) continue;
            return (JScrollPane)p;
        }
        return null;
    }

    @Override
    public void config(Configuration config) {
        int right = config.getInteger(PROPERTY_RIGHT_MARGIN, 5);
        int left = config.getInteger(PROPERTY_LEFT_MARGIN, 5);
        Color foreground = config.getColor(PROPERTY_FOREGROUND, Color.BLACK);
        this.setForeground(UIManager.getColor("Panel.foreground"));
        Color back = config.getColor(PROPERTY_BACKGROUND, Color.WHITE);
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setBorder(BorderFactory.createEmptyBorder(0, left, 0, right));
        this.currentLineColor = UIManager.getColor("List.selectionBackground");
        this.currentLineForegroundColor = UIManager.getColor("List.selectionForeground");
    }

    @Override
    public void install(final JEditorPane editor) {
        this.editor = editor;
        this.setFont(editor.getFont());
        editor.getDocument().addDocumentListener(this);
        editor.addCaretListener(this);
        editor.addPropertyChangeListener(this);
        JScrollPane sp = this.getScrollPane(editor);
        sp.setRowHeaderView(this);
        this.mouseListener = new MouseAdapter(this){
            final /* synthetic */ LineNumbersRuler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                GotoLineDialog.showForEditor(editor);
            }
        };
        this.addMouseListener(this.mouseListener);
        this.status = SyntaxComponent.Status.INSTALLING;
    }

    @Override
    public void deinstall(JEditorPane editor) {
        this.removeMouseListener(this.mouseListener);
        this.status = SyntaxComponent.Status.DEINSTALLING;
        editor.getDocument().removeDocumentListener(this);
        editor.removeCaretListener(this);
        editor.removePropertyChangeListener(this);
        JScrollPane sp = this.getScrollPane(editor);
        if (sp != null) {
            sp.setRowHeaderView(null);
        }
    }

    public int getMinimumDisplayDigits() {
        return this.minimumDisplayDigits;
    }

    public void setMinimumDisplayDigits(int minimumDisplayDigits) {
        this.minimumDisplayDigits = minimumDisplayDigits;
        this.setPreferredWidth();
    }

    private void setPreferredWidth() {
        int lines = ActionUtils.getLineCount(this.editor);
        int digits = Math.max(String.valueOf(lines).length(), this.minimumDisplayDigits);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            this.numbersFormat = "%" + digits + "d";
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            d.setSize(preferredWidth, LineNumbersRuler.getMaxHeight(this.editor));
            this.setPreferredSize(d);
            this.setSize(d);
        }
    }

    private static int getMaxHeight(JEditorPane editor) {
        Window window = SwingUtilities.getWindowAncestor(editor);
        AffineTransform transform = null;
        GraphicsConfiguration configuration = window == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : window.getGraphicsConfiguration();
        transform = configuration.getDefaultTransform();
        double scaleY = 1.0;
        if (transform != null) {
            scaleY = transform.getScaleY();
        }
        return (int)Math.floor(2.146483647E9 / scaleY);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
        Insets insets = this.getInsets();
        int currentLine = -1;
        try {
            currentLine = ActionUtils.getLineNumber(this.editor, this.editor.getCaretPosition()) + 1;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        int lh = fontMetrics.getHeight();
        int maxLines = ActionUtils.getLineCount(this.editor);
        SyntaxView.setRenderingHits((Graphics2D)g);
        Rectangle bounds = g.getClipBounds();
        int minY = bounds.y;
        int maxY = minY + bounds.height;
        for (int line = 1; line <= maxLines; ++line) {
            int y = line * lh;
            if (y < minY) continue;
            if (y - lh > maxY) break;
            String lineNumber = String.format(this.numbersFormat, line);
            if (line == currentLine) {
                g.setColor(this.currentLineColor);
                g.fillRect(0, y - lh + fontMetrics.getDescent() - 1, this.getWidth(), lh);
                g.setColor(this.currentLineForegroundColor);
                g.drawString(lineNumber, insets.left, y);
                continue;
            }
            g.setColor(this.getForeground());
            g.drawString(lineNumber, insets.left, y);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int caretPosition = this.editor.getCaretPosition();
        Element root = this.editor.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(caretPosition);
        if (this.lastLine != currentLine) {
            this.repaint();
            this.lastLine = currentLine;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    private void documentChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int preferredHeight = LineNumbersRuler.this.editor.getPreferredSize().height;
                if (LineNumbersRuler.this.lastHeight != preferredHeight) {
                    LineNumbersRuler.this.setPreferredWidth();
                    LineNumbersRuler.this.repaint();
                    LineNumbersRuler.this.lastHeight = preferredHeight;
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("document")) {
            SyntaxDocument syntaxDocument;
            if (evt.getOldValue() instanceof SyntaxDocument) {
                syntaxDocument = (SyntaxDocument)evt.getOldValue();
                syntaxDocument.removeDocumentListener(this);
            }
            if (evt.getNewValue() instanceof SyntaxDocument && this.status.equals((Object)SyntaxComponent.Status.INSTALLING)) {
                syntaxDocument = (SyntaxDocument)evt.getNewValue();
                syntaxDocument.addDocumentListener(this);
                this.setPreferredWidth();
                this.repaint();
            }
        } else if (evt.getNewValue() instanceof Font) {
            this.setPreferredWidth();
            this.repaint();
        }
    }
}

