/*
 * Decompiled with CFR 0.152.
 */
package dev.matrixlab.webp4j;

import dev.matrixlab.webp4j.animation.AnimatedWebPEncoder;
import dev.matrixlab.webp4j.gif.GifToWebPConfig;
import dev.matrixlab.webp4j.gif.GifToWebPConverter;
import dev.matrixlab.webp4j.internal.NativeWebP;
import dev.matrixlab.webp4j.internal.PixelConverter;
import dev.matrixlab.webp4j.model.AnimationInfo;
import dev.matrixlab.webp4j.model.VP8StatusCode;
import dev.matrixlab.webp4j.model.WebPBitstreamFeatures;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class WebPCodec {
    private WebPCodec() {
        throw new AssertionError((Object)"Cannot instantiate utility class.");
    }

    public static boolean isAvailable() {
        return NativeWebP.isAvailable();
    }

    public static int[] getWebPInfo(byte[] webPData) throws IOException {
        int[] dimensions = new int[2];
        boolean success = NativeWebP.getInfo(webPData, dimensions);
        if (!success) {
            throw new IOException("Failed to retrieve WebP image information.");
        }
        return dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encodeImage(BufferedImage bufferedImage, float quality, boolean lossless) throws IOException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("The input BufferedImage cannot be null.");
        }
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        byte[] imageBytes = PixelConverter.toBytes(bufferedImage);
        if (imageBytes.length == 0) {
            throw new IOException("Failed to convert BufferedImage to a byte array.");
        }
        bufferedImage.flush();
        boolean hasAlpha = bufferedImage.getColorModel().hasAlpha();
        int stride = width * (hasAlpha ? 4 : 3);
        try {
            byte[] encodedWebP = WebPCodec.encodeWithNativeLibrary(imageBytes, width, height, stride, quality, lossless, hasAlpha);
            if (encodedWebP == null || encodedWebP.length == 0) {
                String encodingType = lossless ? "Lossless" : "Lossy";
                throw new IOException(encodingType + " WebP encoding failed.");
            }
            byte[] byArray = encodedWebP;
            return byArray;
        }
        finally {
            Arrays.fill(imageBytes, (byte)0);
        }
    }

    public static byte[] encodeImage(BufferedImage bufferedImage, float quality) throws IOException {
        return WebPCodec.encodeImage(bufferedImage, quality, false);
    }

    public static byte[] encodeLosslessImage(BufferedImage bufferedImage) throws IOException {
        return WebPCodec.encodeImage(bufferedImage, 0.0f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage decodeImage(byte[] webPData) throws IOException {
        if (webPData == null || webPData.length == 0) {
            throw new IllegalArgumentException("The input WebP data cannot be null or empty.");
        }
        int[] dimensions = WebPCodec.getWebPInfo(webPData);
        int width = dimensions[0];
        int height = dimensions[1];
        WebPBitstreamFeatures features = new WebPBitstreamFeatures();
        int status = NativeWebP.getFeatures(webPData, webPData.length, features);
        VP8StatusCode code = VP8StatusCode.getStatusCode(status);
        if (code != VP8StatusCode.VP8_STATUS_OK) {
            throw new IOException("Failed to get WebP bitstream features, error code: " + (Object)((Object)code));
        }
        boolean hasAlpha = features.isHasAlpha();
        int outputStride = width * (hasAlpha ? 4 : 3);
        byte[] outputBuffer = new byte[height * outputStride];
        try {
            boolean success;
            boolean bl = success = hasAlpha ? NativeWebP.decodeRGBAInto(webPData, outputBuffer, outputStride) : NativeWebP.decodeRGBInto(webPData, outputBuffer, outputStride);
            if (!success) {
                throw new IOException("Failed to decode WebP data into RGB buffer.");
            }
            BufferedImage bufferedImage = PixelConverter.toBufferedImage(width, height, outputBuffer);
            return bufferedImage;
        }
        finally {
            Arrays.fill(outputBuffer, (byte)0);
        }
    }

    private static byte[] encodeWithNativeLibrary(byte[] imageBytes, int width, int height, int stride, float quality, boolean lossless, boolean hasAlpha) {
        if (lossless) {
            return hasAlpha ? NativeWebP.encodeLosslessRGBA(imageBytes, width, height, stride) : NativeWebP.encodeLosslessRGB(imageBytes, width, height, stride);
        }
        return hasAlpha ? NativeWebP.encodeRGBA(imageBytes, width, height, stride, quality) : NativeWebP.encodeRGB(imageBytes, width, height, stride, quality);
    }

    public static AnimationInfo getGifInfo(byte[] gifData) throws IOException {
        return GifToWebPConverter.getInfo(gifData);
    }

    public static byte[] encodeGifToWebP(byte[] gifData) throws IOException {
        return GifToWebPConverter.convert(gifData);
    }

    public static byte[] encodeGifToWebP(byte[] gifData, GifToWebPConfig config) throws IOException {
        return GifToWebPConverter.convert(gifData, config);
    }

    public static byte[] encodeGifToWebPLossless(byte[] gifData) throws IOException {
        return GifToWebPConverter.convertLossless(gifData);
    }

    public static byte[] createAnimatedWebP(List<BufferedImage> frames, int[] delays, GifToWebPConfig config) throws IOException {
        return AnimatedWebPEncoder.encode(frames, delays, config);
    }
}

