/*
 * Decompiled with CFR 0.152.
 */
package dev.matrixlab.webp4j.gif;

import dev.matrixlab.webp4j.model.AnimationInfo;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class GifDecoderJava {
    private static final String GRAPHIC_CONTROL_EXTENSION = "GraphicControlExtension";

    private GifDecoderJava() {
        throw new AssertionError((Object)"Cannot instantiate utility class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GifData decodeGif(byte[] gifBytes) throws IOException {
        try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(gifBytes));){
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("gif");
            if (!readers.hasNext()) {
                throw new IOException("No GIF image reader found");
            }
            ImageReader reader = readers.next();
            try {
                reader.setInput(stream);
                GifData data = new GifData();
                data.frames = new ArrayList<GifFrame>();
                int numImages = reader.getNumImages(true);
                IIOMetadata streamMetadata = reader.getStreamMetadata();
                data.loopCount = GifDecoderJava.extractLoopCount(streamMetadata);
                for (int i = 0; i < numImages; ++i) {
                    BufferedImage image = reader.read(i);
                    IIOMetadata frameMetadata = reader.getImageMetadata(i);
                    GifFrame frame = new GifFrame();
                    frame.image = image;
                    frame.delayMs = GifDecoderJava.extractFrameDelay(frameMetadata);
                    frame.disposeMethod = GifDecoderJava.extractDisposeMethod(frameMetadata);
                    int[] offsets = GifDecoderJava.extractFramePosition(frameMetadata);
                    frame.leftOffset = offsets[0];
                    frame.topOffset = offsets[1];
                    if (GifDecoderJava.extractTransparencyIndex(frameMetadata) >= 0) {
                        data.hasTransparency = true;
                    }
                    data.frames.add(frame);
                    if (i != 0) continue;
                    data.width = image.getWidth();
                    data.height = image.getHeight();
                }
                GifData gifData = data;
                reader.dispose();
                return gifData;
            }
            catch (Throwable throwable) {
                reader.dispose();
                throw throwable;
            }
        }
    }

    private static int extractLoopCount(IIOMetadata metadata) {
        if (metadata == null) {
            return 0;
        }
        String nativeMetadataFormatName = metadata.getNativeMetadataFormatName();
        Node root = metadata.getAsTree(nativeMetadataFormatName);
        NodeList applicationExtensions = ((IIOMetadataNode)root).getElementsByTagName("ApplicationExtensions");
        if (applicationExtensions.getLength() == 0) {
            return 0;
        }
        IIOMetadataNode appExtNode = (IIOMetadataNode)applicationExtensions.item(0);
        NodeList appExtChildren = appExtNode.getChildNodes();
        for (int i = 0; i < appExtChildren.getLength(); ++i) {
            Node appExt = appExtChildren.item(i);
            int loopCount = GifDecoderJava.extractLoopCountFromExtension(appExt);
            if (loopCount < 0) continue;
            return loopCount;
        }
        return 0;
    }

    private static int extractLoopCountFromExtension(Node appExt) {
        if (!"ApplicationExtension".equals(appExt.getNodeName())) {
            return -1;
        }
        NamedNodeMap attrs = appExt.getAttributes();
        Node appIdNode = attrs.getNamedItem("applicationID");
        Node authCodeNode = attrs.getNamedItem("authenticationCode");
        if (appIdNode == null || authCodeNode == null) {
            return -1;
        }
        String appId = appIdNode.getNodeValue();
        String authCode = authCodeNode.getNodeValue();
        if (!"NETSCAPE".equals(appId) || !"2.0".equals(authCode)) {
            return -1;
        }
        if (!(appExt instanceof IIOMetadataNode)) {
            return -1;
        }
        byte[] appData = (byte[])((IIOMetadataNode)appExt).getUserObject();
        if (appData == null || appData.length < 3 || appData[0] != 1) {
            return -1;
        }
        return appData[1] & 0xFF | (appData[2] & 0xFF) << 8;
    }

    private static int extractFrameDelay(IIOMetadata metadata) {
        IIOMetadataNode gceNode;
        String delayTimeStr;
        if (metadata == null) {
            return 100;
        }
        String nativeMetadataFormatName = metadata.getNativeMetadataFormatName();
        Node root = metadata.getAsTree(nativeMetadataFormatName);
        NodeList graphicControlExtensions = ((IIOMetadataNode)root).getElementsByTagName(GRAPHIC_CONTROL_EXTENSION);
        if (graphicControlExtensions.getLength() > 0 && !(delayTimeStr = (gceNode = (IIOMetadataNode)graphicControlExtensions.item(0)).getAttribute("delayTime")).isEmpty()) {
            try {
                int delayTime = Integer.parseInt(delayTimeStr);
                return delayTime * 10;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 100;
    }

    private static int extractDisposeMethod(IIOMetadata metadata) {
        IIOMetadataNode gceNode;
        String disposalMethodStr;
        if (metadata == null) {
            return 0;
        }
        String nativeMetadataFormatName = metadata.getNativeMetadataFormatName();
        Node root = metadata.getAsTree(nativeMetadataFormatName);
        NodeList graphicControlExtensions = ((IIOMetadataNode)root).getElementsByTagName(GRAPHIC_CONTROL_EXTENSION);
        if (graphicControlExtensions.getLength() > 0 && !(disposalMethodStr = (gceNode = (IIOMetadataNode)graphicControlExtensions.item(0)).getAttribute("disposalMethod")).isEmpty()) {
            try {
                if ("restoreToBackgroundColor".equals(disposalMethodStr)) {
                    return 2;
                }
                if ("restoreToPrevious".equals(disposalMethodStr)) {
                    return 3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private static int extractTransparencyIndex(IIOMetadata metadata) {
        if (metadata == null) {
            return -1;
        }
        String nativeMetadataFormatName = metadata.getNativeMetadataFormatName();
        Node root = metadata.getAsTree(nativeMetadataFormatName);
        NodeList graphicControlExtensions = ((IIOMetadataNode)root).getElementsByTagName(GRAPHIC_CONTROL_EXTENSION);
        if (graphicControlExtensions.getLength() > 0) {
            IIOMetadataNode gceNode = (IIOMetadataNode)graphicControlExtensions.item(0);
            String transparentColorFlagStr = gceNode.getAttribute("transparentColorFlag");
            String transparentColorIndexStr = gceNode.getAttribute("transparentColorIndex");
            if ("true".equals(transparentColorFlagStr) && !transparentColorIndexStr.isEmpty()) {
                try {
                    return Integer.parseInt(transparentColorIndexStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    private static int[] extractFramePosition(IIOMetadata metadata) {
        int[] offsets = new int[]{0, 0};
        if (metadata == null) {
            return offsets;
        }
        String nativeMetadataFormatName = metadata.getNativeMetadataFormatName();
        Node root = metadata.getAsTree(nativeMetadataFormatName);
        NodeList imageDescriptors = ((IIOMetadataNode)root).getElementsByTagName("ImageDescriptor");
        if (imageDescriptors.getLength() > 0) {
            IIOMetadataNode idNode = (IIOMetadataNode)imageDescriptors.item(0);
            String imageLeftPositionStr = idNode.getAttribute("imageLeftPosition");
            String imageTopPositionStr = idNode.getAttribute("imageTopPosition");
            try {
                if (!imageLeftPositionStr.isEmpty()) {
                    offsets[0] = Integer.parseInt(imageLeftPositionStr);
                }
                if (!imageTopPositionStr.isEmpty()) {
                    offsets[1] = Integer.parseInt(imageTopPositionStr);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return offsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean getGifInfo(byte[] gifBytes, AnimationInfo info) {
        try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(gifBytes));){
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("gif");
            if (!readers.hasNext()) {
                boolean bl = false;
                return bl;
            }
            ImageReader reader = readers.next();
            try {
                reader.setInput(stream);
                int numImages = reader.getNumImages(true);
                info.setFrameCount(numImages);
                BufferedImage firstImage = reader.read(0);
                info.setWidth(firstImage.getWidth());
                info.setHeight(firstImage.getHeight());
                IIOMetadata streamMetadata = reader.getStreamMetadata();
                info.setLoopCount(GifDecoderJava.extractLoopCount(streamMetadata));
                boolean hasTransparency = false;
                for (int i = 0; i < numImages && !hasTransparency; ++i) {
                    IIOMetadata frameMetadata = reader.getImageMetadata(i);
                    if (GifDecoderJava.extractTransparencyIndex(frameMetadata) < 0) continue;
                    hasTransparency = true;
                }
                info.setHasTransparency(hasTransparency);
                boolean bl = true;
                reader.dispose();
                return bl;
            }
            catch (Throwable throwable) {
                reader.dispose();
                throw throwable;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class GifData {
        public List<GifFrame> frames;
        public int loopCount;
        public int width;
        public int height;
        public boolean hasTransparency;
    }

    public static class GifFrame {
        public BufferedImage image;
        public int delayMs;
        public int disposeMethod;
        public int leftOffset;
        public int topOffset;
    }
}

