/*
 * Decompiled with CFR 0.152.
 */
package dev.matrixlab.webp4j.gif;

public class GifToWebPConfig {
    private float quality = 75.0f;
    private boolean lossless = false;
    private int compressionMethod = 4;
    private boolean extractFirstFrameOnly = false;
    private int loopCount = -1;
    private int kmin = 9;
    private int kmax = 17;
    private boolean minimizeSize = false;
    private boolean allowMixed = false;

    public float getQuality() {
        return this.quality;
    }

    public GifToWebPConfig setQuality(float quality) {
        if (quality < 0.0f || quality > 100.0f) {
            throw new IllegalArgumentException("Quality must be between 0 and 100");
        }
        this.quality = quality;
        return this;
    }

    public boolean isLossless() {
        return this.lossless;
    }

    public GifToWebPConfig setLossless(boolean lossless) {
        this.lossless = lossless;
        return this;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public GifToWebPConfig setCompressionMethod(int compressionMethod) {
        if (compressionMethod < 0 || compressionMethod > 6) {
            throw new IllegalArgumentException("Compression method must be between 0 and 6");
        }
        this.compressionMethod = compressionMethod;
        return this;
    }

    public boolean isExtractFirstFrameOnly() {
        return this.extractFirstFrameOnly;
    }

    public GifToWebPConfig setExtractFirstFrameOnly(boolean extractFirstFrameOnly) {
        this.extractFirstFrameOnly = extractFirstFrameOnly;
        return this;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public GifToWebPConfig setLoopCount(int loopCount) {
        if (loopCount < -1) {
            throw new IllegalArgumentException("Loop count must be >= -1");
        }
        this.loopCount = loopCount;
        return this;
    }

    public int getKmin() {
        return this.kmin;
    }

    public GifToWebPConfig setKmin(int kmin) {
        if (kmin < 0) {
            throw new IllegalArgumentException("Kmin must be non-negative");
        }
        this.kmin = kmin;
        return this;
    }

    public int getKmax() {
        return this.kmax;
    }

    public GifToWebPConfig setKmax(int kmax) {
        if (kmax < 0) {
            throw new IllegalArgumentException("Kmax must be non-negative");
        }
        this.kmax = kmax;
        return this;
    }

    public boolean isMinimizeSize() {
        return this.minimizeSize;
    }

    public GifToWebPConfig setMinimizeSize(boolean minimizeSize) {
        this.minimizeSize = minimizeSize;
        return this;
    }

    public boolean isAllowMixed() {
        return this.allowMixed;
    }

    public GifToWebPConfig setAllowMixed(boolean allowMixed) {
        this.allowMixed = allowMixed;
        return this;
    }

    public static GifToWebPConfig createLosslessConfig() {
        return new GifToWebPConfig().setLossless(true).setKmin(9).setKmax(17);
    }

    public static GifToWebPConfig createLossyConfig(float quality) {
        return new GifToWebPConfig().setLossless(false).setQuality(quality).setKmin(3).setKmax(5);
    }
}

