/*
 * Decompiled with CFR 0.152.
 */
package dev.matrixlab.webp4j.internal;

import dev.matrixlab.webp4j.exception.NativeLibraryNotFoundException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class NativeLibraryLoader {
    private NativeLibraryLoader() {
        throw new AssertionError((Object)"Cannot instantiate utility class.");
    }

    public static void loadLibrary() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        String libraryFileName = NativeLibraryLoader.getLibraryFileName(os, arch);
        String resourcePath = String.format("/native/%s", libraryFileName);
        try (InputStream in = NativeLibraryLoader.class.getResourceAsStream(resourcePath);){
            File tempLibraryFile;
            if (in == null) {
                throw new NativeLibraryNotFoundException(String.format("Native library not found: %s%nOS: %s, Architecture: %s%nExpected path: %s%nSupported platforms: Linux (x64/aarch64/arm), macOS (x64/arm64), Windows (x64)", libraryFileName, os, arch, resourcePath));
            }
            File fileToDelete = tempLibraryFile = Files.createTempFile("webp4j-", "-" + libraryFileName, new FileAttribute[0]).toFile();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    if (fileToDelete.exists()) {
                        Files.delete(fileToDelete.toPath());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
            try (FileOutputStream out = new FileOutputStream(tempLibraryFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            System.load(tempLibraryFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new NativeLibraryNotFoundException("Could not load native WebP library", e);
        }
    }

    private static String getLibraryFileName(String os, String arch) {
        String extension;
        String prefix;
        String architecture;
        String platform;
        if (os.contains("win")) {
            platform = "windows";
            architecture = NativeLibraryLoader.normalizeArchitecture(arch, false);
            prefix = "";
            extension = "dll";
        } else if (os.contains("nux") || os.contains("linux")) {
            platform = "linux";
            architecture = NativeLibraryLoader.normalizeArchitecture(arch, false);
            prefix = "lib";
            extension = "so";
        } else if (os.contains("mac")) {
            platform = "mac";
            architecture = NativeLibraryLoader.normalizeArchitecture(arch, true);
            prefix = "lib";
            extension = "dylib";
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported os: %s, arch: %s", os, arch));
        }
        return String.format("%swebp4j-%s-%s.%s", prefix, platform, architecture, extension);
    }

    private static String normalizeArchitecture(String arch, boolean isMac) {
        boolean is64BitX86Architecture;
        boolean bl = is64BitX86Architecture = arch.equals("amd64") || arch.equals("x86_64") || arch.equals("x64");
        if (is64BitX86Architecture) {
            return "x64";
        }
        if (arch.contains("aarch64") || arch.equals("arm64")) {
            return isMac ? "arm64" : "aarch64";
        }
        if (arch.contains("arm")) {
            return "arm";
        }
        return arch;
    }
}

