/*
 * Decompiled with CFR 0.152.
 */
package dev.matrixlab.webp4j.internal;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;

public final class PixelConverter {
    private PixelConverter() {
        throw new AssertionError((Object)"Cannot instantiate utility class.");
    }

    public static BufferedImage toBufferedImage(int width, int height, byte[] data) {
        boolean hasAlpha = data.length == width * height * 4;
        int imageType = hasAlpha ? 2 : 1;
        BufferedImage image = new BufferedImage(width, height, imageType);
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int index = 0;
        int pixelIndex = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int r = data[index++] & 0xFF;
                int g = data[index++] & 0xFF;
                int b = data[index++] & 0xFF;
                int a = hasAlpha ? data[index++] & 0xFF : 255;
                pixels[pixelIndex++] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return image;
    }

    public static byte[] toBytes(BufferedImage image) {
        boolean hasAlpha = image.getColorModel().hasAlpha();
        int width = image.getWidth();
        int height = image.getHeight();
        int bytesPerPixel = hasAlpha ? 4 : 3;
        byte[] output = new byte[width * height * bytesPerPixel];
        int imageType = image.getType();
        try {
            switch (imageType) {
                case 1: 
                case 2: 
                case 3: {
                    DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                    if (dataBuffer instanceof DataBufferInt) {
                        boolean isPremultiplied;
                        DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                        int[] intPixels = dataBufferInt.getData();
                        int index = 0;
                        boolean bl = isPremultiplied = imageType == 3;
                        if (hasAlpha) {
                            for (int pixel : intPixels) {
                                int a = pixel >> 24 & 0xFF;
                                int r = pixel >> 16 & 0xFF;
                                int g = pixel >> 8 & 0xFF;
                                int b = pixel & 0xFF;
                                if (isPremultiplied && a > 0 && a < 255) {
                                    r = (r * 255 + (a >> 1)) / a;
                                    g = (g * 255 + (a >> 1)) / a;
                                    b = (b * 255 + (a >> 1)) / a;
                                    r = Math.min(255, r);
                                    g = Math.min(255, g);
                                    b = Math.min(255, b);
                                }
                                output[index++] = (byte)r;
                                output[index++] = (byte)g;
                                output[index++] = (byte)b;
                                output[index++] = (byte)a;
                            }
                        } else {
                            for (int pixel : intPixels) {
                                output[index++] = (byte)(pixel >> 16 & 0xFF);
                                output[index++] = (byte)(pixel >> 8 & 0xFF);
                                output[index++] = (byte)(pixel & 0xFF);
                            }
                        }
                        break;
                    }
                    PixelConverter.processImageByRows(image, output, width, height, hasAlpha);
                    break;
                }
                case 4: {
                    DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                    if (dataBuffer instanceof DataBufferInt) {
                        DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                        int[] bgrIntPixels = dataBufferInt.getData();
                        int index = 0;
                        for (int pixel : bgrIntPixels) {
                            output[index++] = (byte)(pixel & 0xFF);
                            output[index++] = (byte)(pixel >> 8 & 0xFF);
                            output[index++] = (byte)(pixel >> 16 & 0xFF);
                            if (!hasAlpha) continue;
                            output[index++] = (byte)(pixel >> 24 & 0xFF);
                        }
                        break;
                    }
                    PixelConverter.processImageByRows(image, output, width, height, hasAlpha);
                    break;
                }
                case 5: {
                    DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                    if (dataBuffer instanceof DataBufferByte) {
                        int i;
                        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                        byte[] bgrBytes = dataBufferByte.getData();
                        int index = 0;
                        int maxIndex = bgrBytes.length - 2;
                        for (i = 0; i < maxIndex - 8; i += 9) {
                            output[index++] = bgrBytes[i + 2];
                            output[index++] = bgrBytes[i + 1];
                            output[index++] = bgrBytes[i];
                            output[index++] = bgrBytes[i + 5];
                            output[index++] = bgrBytes[i + 4];
                            output[index++] = bgrBytes[i + 3];
                            output[index++] = bgrBytes[i + 8];
                            output[index++] = bgrBytes[i + 7];
                            output[index++] = bgrBytes[i + 6];
                        }
                        while (i < bgrBytes.length) {
                            output[index++] = bgrBytes[i + 2];
                            output[index++] = bgrBytes[i + 1];
                            output[index++] = bgrBytes[i];
                            i += 3;
                        }
                        break;
                    }
                    PixelConverter.processImageByRows(image, output, width, height, hasAlpha);
                    break;
                }
                case 6: 
                case 7: {
                    DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                    if (dataBuffer instanceof DataBufferByte) {
                        boolean isPremultiplied;
                        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                        byte[] abgrBytes = dataBufferByte.getData();
                        int index = 0;
                        boolean bl = isPremultiplied = imageType == 7;
                        if (hasAlpha) {
                            for (int i = 0; i < abgrBytes.length; i += 4) {
                                int a = abgrBytes[i] & 0xFF;
                                int b = abgrBytes[i + 1] & 0xFF;
                                int g = abgrBytes[i + 2] & 0xFF;
                                int r = abgrBytes[i + 3] & 0xFF;
                                if (isPremultiplied && a > 0 && a < 255) {
                                    r = (r * 255 + (a >> 1)) / a;
                                    g = (g * 255 + (a >> 1)) / a;
                                    b = (b * 255 + (a >> 1)) / a;
                                    r = Math.min(255, r);
                                    g = Math.min(255, g);
                                    b = Math.min(255, b);
                                }
                                output[index++] = (byte)r;
                                output[index++] = (byte)g;
                                output[index++] = (byte)b;
                                output[index++] = (byte)a;
                            }
                        } else {
                            for (int i = 0; i < abgrBytes.length; i += 4) {
                                output[index++] = abgrBytes[i + 3];
                                output[index++] = abgrBytes[i + 2];
                                output[index++] = abgrBytes[i + 1];
                            }
                        }
                        break;
                    }
                    PixelConverter.processImageByRows(image, output, width, height, hasAlpha);
                    break;
                }
                default: {
                    PixelConverter.processImageByRows(image, output, width, height, hasAlpha);
                }
            }
        }
        catch (Exception e) {
            PixelConverter.processImageByRows(image, output, width, height, hasAlpha);
        }
        return output;
    }

    private static void processImageByRows(BufferedImage image, byte[] output, int width, int height, boolean hasAlpha) {
        int[] rowBuffer = new int[width];
        int index = 0;
        for (int y = 0; y < height; ++y) {
            int argb;
            int x;
            image.getRGB(0, y, width, 1, rowBuffer, 0, width);
            if (hasAlpha) {
                for (x = 0; x < width; ++x) {
                    argb = rowBuffer[x];
                    output[index++] = (byte)(argb >> 16 & 0xFF);
                    output[index++] = (byte)(argb >> 8 & 0xFF);
                    output[index++] = (byte)(argb & 0xFF);
                    output[index++] = (byte)(argb >> 24 & 0xFF);
                }
                continue;
            }
            for (x = 0; x < width; ++x) {
                argb = rowBuffer[x];
                output[index++] = (byte)(argb >> 16 & 0xFF);
                output[index++] = (byte)(argb >> 8 & 0xFF);
                output[index++] = (byte)(argb & 0xFF);
            }
        }
    }
}

